package com.elitesland.yst.production.inv.application.facade.vo.invwh;

import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.yst.production.inv.utils.TreeNode;
import com.elitesland.yst.production.inv.utils.invwh.TreeModel;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel(value = "inv_wh", description = "仓库")
public class InvWhRespVO extends BaseModelVO implements TreeNode<InvWhRespVO> {
    private static final long serialVersionUID = -84413014701696628L;

    /**
     * 仓库编号
     */
    @ApiModelProperty("仓库编号")
    private String whCode;
    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;
    /**
     * 仓库名称
     */
    @ApiModelProperty("仓库名称")
    private String whName;

    /**
     * 仓库类型 [UDC]INV:WH_TYPE
     */
    @ApiModelProperty("仓库类型 [UDC]INV:WH_TYPE")
    @SysCode(sys = "yst-inv", mod = "WH_TYPE")
    private String whType;

    @ApiModelProperty("仓库类型 [UDC]INV:WH_TYPE")
    private String whTypeName;

    /**
     * 营业厅编码
     */
    @ApiModelProperty("营业厅编码")
    private String businessCode;

    /**
     * 仓库类型2
     */
    @ApiModelProperty("仓库类型2")
    @SysCode(sys = "yst-inv", mod = "WH_TYPE")
    private String whType2;
    @ApiModelProperty("仓库类型 [UDC]INV:WH_TYPE")
    private String whType2Name;
    /**
     * 仓库类型3
     */
    @ApiModelProperty("仓库类型3")
    private String whType3;

    @ApiModelProperty("外部仓库类型")
    private String otherWhType;

    @ApiModelProperty("外部仓库类型编码")
    private String otherWhCode;

    @ApiModelProperty("所属组织类型")
    @SysCode(sys = "ORG", mod = "BU_TYPE")
    private String belongBuType;
    @ApiModelProperty("所属组织类型名称")
    private String belongBuTypeName;
    @ApiModelProperty("所属组织")
    private String belongBuId;
    @ApiModelProperty("所属组织名称")
    private String belongBuName;
    @ApiModelProperty("所属组织编码")
    private String belongBuCode;

    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;
    @ApiModelProperty("公司名称")
    private String ouName;
    @ApiModelProperty("公司编码")
    private String ouCode;
    @ApiModelProperty("公司币种")
    private String ouCurr;

    @ApiModelProperty("公司币种名")
    private String ouCurrName;

    @ApiModelProperty("供应商合作公司")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateOuId;

    @ApiModelProperty("供应商合作公司编码")
    private String relateOuCode;
    /**
     * 仓库状态
     */
    @ApiModelProperty("仓库状态")
    @SysCode(sys = "yst-supp", mod = "STATUS_ACTIVEORNO")
    private String whStatus;

    @ApiModelProperty("仓库状态")
    private String whStatusName;
    /**
     * 仓库状态2
     */
    @ApiModelProperty("仓库状态2")
    private String whStatus2;

    /**
     * BUID
     */
    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    @ApiModelProperty("权限id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long secBuId;

    @ApiModelProperty("数据归属账号id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long secUserId;

    @ApiModelProperty("数据归属公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long secOuId;

    /**
     * 所有者地址号 用于寄售库和VMI库，DCH不用
     */
    @ApiModelProperty("所有者地址号 用于寄售库和VMI库，DCH不用")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ownerAddrNo;


    /**
     * 仓库名称2
     */
    @ApiModelProperty("仓库名称2")
    private String whName2;
    /**
     * 简称
     */
    @ApiModelProperty("简称")
    private String whAbbr;

    /**
     * 是否3PL仓库
     */
    @ApiModelProperty("是否3PL仓库")
    private Integer thirdplFlag;
    /**
     * 物理仓编号
     */
    @ApiModelProperty("物理仓编号")
    private String physicalWhCode;


    /**
     * 联系人邮箱
     */
    @ApiModelProperty("仓库联系人邮箱")
    private String email;

    /**
     * 联系人
     */
    @ApiModelProperty("仓库联系人")
    private String contPerson;

    @ApiModelProperty("联系人电话")
    private String tel;

    /**
     * 地址号 仓库本身的地址号
     */
    @ApiModelProperty("地址号 仓库本身的地址号")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long addrNo;

    /**
     * 地址ID 仓库的物理地址，维护仓库的地址时根据规则回写。指向 addr_address.
     */
    @ApiModelProperty("地址ID 仓库的物理地址，维护仓库的地址时根据规则回写。指向 addr_address.")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long addressId;

    /**
     * 上级ID
     */
    @ApiModelProperty("上级ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long pid;
    /**
     * 路径
     */
    @ApiModelProperty("路径")
    private String whPath;
    /**
     * 区域
     */
    @ApiModelProperty("区域")
    private String region;

    /**
     * 配送方式
     */
    @ApiModelProperty("配送方式")
    private String delivery;

    /**
     * 配送范围
     */
    @ApiModelProperty("配送范围")
    private String deliveryArea;

    /**
     * 配送范围
     */
    @ApiModelProperty("配送范围")
    private List<InvWhDeliveryRespVO> deliveryAreas;

    /**
     * erp仓库编码
     */
    @ApiModelProperty("erp仓库编码")
    private String erpCode;

    /**
     * ES1
     */
    @ApiModelProperty("ES1")
    private String es1;

    @ApiModelProperty("仓库属性")
    private String es1Name;
    /**
     * ES2
     */
    @ApiModelProperty("ES2")
    private String es2;
    /**
     * ES3
     */
    @ApiModelProperty("ES3")
    private String es3;
    /**
     * ES4
     */
    @ApiModelProperty("ES4")
    private String es4;
    /**
     * ES5
     */
    @ApiModelProperty("ES5")
    private String es5;
    /**
     * ES6
     */
    @ApiModelProperty("ES6")
    private String es6;
    /**
     * ES7
     */
    @ApiModelProperty("ES7")
    private String es7;
    /**
     * ES8
     */
    @ApiModelProperty("ES8")
    private String es8;
    /**
     * ES9
     */
    @ApiModelProperty("ES9")
    private String es9;
    /**
     * ES10
     */
    @ApiModelProperty("ES10")
    private String es10;
    /**
     * 采购仓库/销售仓库
     */
    @ApiModelProperty("采购仓库/销售仓库")
    private String ee1;
    /**
     * 是否有WMS
     */
    @ApiModelProperty("是否有WMS")
    private String ee2;
    /**
     * EE3
     */
    @ApiModelProperty("EE3")
    private String ee3;

//    /**
//     * 备注
//     */
//    @ApiModelProperty("备注")
//    private String remark;
    /**
     * 记录创建者ID
     */
    @ApiModelProperty("记录创建者ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long createUserId;
    /**
     * 记录创建时间
     */
    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;
    /**
     * 记录最后更新者ID
     */
    @ApiModelProperty("记录最后更新者ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long modifyUserId;
    /**
     * 记录最后更新时间
     */
    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;
    /**
     * 逻辑删除，0：未删除，1：已删除
     */
    @ApiModelProperty("逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;
    /**
     * 版本信息，前端不用传
     */
    @ApiModelProperty("版本信息，前端不用传")
    private Integer auditDataVersion;

    //↓页面
    @ApiModelProperty("国家")
    @SysCode(sys = "COM", mod = "COUNTRY")
    String country;
    String countryName;

    @ApiModelProperty("省")
    private String province;
    private String provinceName;

    @ApiModelProperty("市")
    private String city;
    private String cityName;

    @ApiModelProperty("区县")
    private String county;
    private String countyName;

    @ApiModelProperty("详细地址")
    private String detailaddr;


    @ApiModelProperty("库区")
    private List<InvWhAreaRespVO> invWhAreaRespVOList;

    @ApiModelProperty("E1仓库编码")
    private String outerCode;

    /**
     * 仓库面积
     */
    @ApiModelProperty("仓库面积")
    private Double area;

    /**
     * 仓库结构
     */
    @ApiModelProperty("仓库结构")
    private String structure;

    /**
     * 是否装卸平台
     */
    @ApiModelProperty("是否装卸平台")
    private Integer plateformFlag;

    /**
     * 仓库固定资产
     */
    @ApiModelProperty("仓库固定资产")
    private String fixedAssets;

    /**
     * 附件标识
     */
    @ApiModelProperty("附件标识fileCode")
    private String fileCode;

    @ApiModelProperty("创建人名")
    private String createUserName;

    @ApiModelProperty("京东仓库关联码")
    private String jdrelateCode;

    @ApiModelProperty("京东事业部编码")
    private String jdsybCode;

    @ApiModelProperty("京云仓编码")
    private String jdwhCode;

    @ApiModelProperty("不良京云仓")
    private Integer jdbadFlag;

    @ApiModelProperty("是否退货仓")
    private Integer tuihuoFlag;

    @ApiModelProperty(value = "发运地id")
    private Long desId;

    @ApiModelProperty(value = "发运地名称")
    private String desName;

    @ApiModelProperty(value = "发运地编码")
    private String desCode;
    @ApiModelProperty("销售组织编码集合")
    private List<String> desCodeList;
    @ApiModelProperty("销售组织名称")
    private String desCodeName;

    /**
     * 排序序号
     */
    @ApiModelProperty(value = "排序序号")
    private Integer sortNo;

    /**
     * 级别
     */
    @ApiModelProperty(value = "级别")
    private Integer level;

    /**
     * 树形结构中，是否是末尾节点
     */
    @ApiModelProperty(value = "是否末尾节点")
    private Boolean isLeaf;

    /**
     * 编号
     */
    @ApiModelProperty(value = "编号")
    private String code;


    /**
     * 路径
     */
    @ApiModelProperty(value = "路径")
    private String path;

    /**
     * 子节点
     */
    @ApiModelProperty(value = "子节点")
    private List<InvWhRespVO> treeNodes;




}
