package com.elitesland.yst.production.inv.application.out;

import com.alibaba.excel.util.CollectionUtils;
import com.elitescloud.cloudt.system.dto.req.SysCurrencyQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.SysCurrencyRespDTO;
import com.elitescloud.cloudt.system.provider.extend.SysCurrencyRpcService;
import com.elitesland.yst.production.inv.application.facade.vo.InvParentParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.OrgRespVO;
import com.elitesland.yst.production.inv.utils.InvPTypeEnum;
import com.elitesland.yst.production.pur.dto.supp.PurSuppBaseRpcDTO;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.support.provider.org.dto.*;
import com.elitesland.yst.production.support.provider.org.param.*;
import com.elitesland.yst.production.support.provider.org.service.OrgAddrRpcService;
import com.elitesland.yst.production.support.provider.org.service.OrgBuRpcService;
import com.elitesland.yst.production.support.provider.org.service.OrgEmpRpcService;
import com.elitesland.yst.production.support.provider.org.service.OrgOuRpcService;
import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Description: TODO
 * @Auther: menghua
 * @Date: 2021/5/11
 */
@Service
@AllArgsConstructor
@Slf4j
public class OrgOutServiceImpl implements OrgOutService {

    private final OrgOuRpcService orgOuRpcService;
    private final OrgEmpRpcService orgEmpRpcService;
    private final OrgBuRpcService orgBuRpcService;
    private final OrgAddrRpcService orgAddrRpcService;

    private final SysCurrencyRpcService sysCurrencyRpcService;

    private final PurDubbleService purDubbleService;

    /**
     * 根据公司ID获取公司信息
     *
     * @param ouId 公司id
     * @return 公司
     */
    @Override
    public OrgOuRpcDTO findOuById(Long ouId) {
        log.info("调用支撑域-根据公司ID获取公司信息，时间：{}，入参：{}", LocalDateTime.now(), ouId);
        OrgOuRpcDtoParam param = new OrgOuRpcDtoParam();
        param.setOuIds(Collections.singletonList(ouId));
        try {
            List<OrgOuRpcDTO> orgOuVOS = orgOuRpcService.findOuDtoByParam(param);
            if (orgOuVOS != null && orgOuVOS.size() > 0) {
                return orgOuVOS.get(0);
            }
        } catch (Exception e) {
            log.error("findOuById error:", e);
        }
        return null;
    }

    /**
     * 根据公司编码获取公司信息
     *
     * @param ouCode 公司编码
     * @return 公司
     */
    @Override
    public OrgOuRpcDTO findOuByOuCode(String ouCode) {
        log.info("调用支撑域-根据公司code获取公司信息，时间：{}，入参：{}", LocalDateTime.now(), ouCode);
        OrgOuRpcDtoParam param = new OrgOuRpcDtoParam();
        param.setOuCodes(Collections.singletonList(ouCode));
        try {
            List<OrgOuRpcDTO> orgOuVOS = orgOuRpcService.findOuDtoByParam(param);
            if (orgOuVOS != null && orgOuVOS.size() > 0) {
                return orgOuVOS.get(0);
            }
        } catch (Exception e) {
            log.error("findOuByOuCode error:", e);
        }
        return null;
    }

    /**
     * 根据员工ID获取员工信息
     *
     * @param empId 员工id
     * @return 员工
     */
    @Override
    public OrgEmpRpcDTO findEmpById(Long empId) {
        log.info("调用支撑域-根据员工ID获取员工信息，时间：{}，入参：{}", LocalDateTime.now(), empId);
        OrgEmpRpcDtoParam param = new OrgEmpRpcDtoParam();
        param.setEmpIds(Collections.singletonList(empId));
        try {
            List<OrgEmpRpcDTO> emps = orgEmpRpcService.findEmpDtoByParam(param);
            if (emps != null && emps.size() > 0) {
                return emps.get(0);
            }
        } catch (Exception e) {
            log.error("findEmpById error:", e);
        }
        return null;
    }

    /**
     * 根据公司ID集合获取公司信息列表
     *
     * @param ouIds 公司id集合
     * @return 公司集
     */
    @Override
    public List<OrgOuRpcDTO> findOuByIds(List<Long> ouIds) {
        log.info("调用支撑域-根据公司ID集合获取公司信息列表，时间：{}，入参：{}", LocalDateTime.now(), ouIds);
        if (CollectionUtils.isEmpty(ouIds)) {
            return Collections.emptyList();
        }
        OrgOuRpcDtoParam param = new OrgOuRpcDtoParam();
        param.setOuIds(ouIds);
        try {
            List<OrgOuRpcDTO> ous = orgOuRpcService.findOuDtoByParam(param);
            if (!CollectionUtils.isEmpty(ous)) {
                return ous;
            }
        } catch (Exception e) {
            log.error("findOuByIds error:", e);
        }
        return Lists.newArrayList();
    }

    /**
     * 根据公司编号集合获取公司信息列表
     *
     * @param ouCodes 公司编号集合
     * @return 公司集
     */
    @Override
    public List<OrgOuRpcDTO> findOuByCodes(List<String> ouCodes) {
        log.info("调用支撑域-根据公司编号集合获取公司信息列表，时间：{}，入参：{}", LocalDateTime.now(), ouCodes);
        OrgOuRpcDtoParam param = new OrgOuRpcDtoParam();
        param.setOuCodes(ouCodes);
        try {
            List<OrgOuRpcDTO> ous = orgOuRpcService.findOuDtoByParam(param);
            if (!CollectionUtils.isEmpty(ous)) {
                return ous;
            }
        } catch (Exception e) {
            log.error("findOuByCodes error:", e);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<OrgOuRpcDTO> selectBaseByOuCodes(List<String> ouCodes){
        log.info("调用支撑域-根据公司编号集合获取公司信息列表，时间：{}，入参：{}", LocalDateTime.now(), ouCodes);
        OrgOuRpcDtoParam param = new OrgOuRpcDtoParam();
        param.setOuCodes(ouCodes);
        try {
            List<OrgOuRpcDTO> ous = orgOuRpcService.findOuDtoByParam(param);
            if (!CollectionUtils.isEmpty(ous)) {
                return ous;
            }
        } catch (Exception e) {
            log.error("selectBaseByOuCodes error:", e);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<OrgOuRpcDTO> findOuDtoByParam(OrgOuRpcDtoParam param) {
        try {
            List<OrgOuRpcDTO> ouDtoByParam = orgOuRpcService.findOuDtoByParam(param);
            if (!CollectionUtils.isEmpty(ouDtoByParam)) {
                return ouDtoByParam;
            }
        } catch (Exception e) {
            log.error("findAllEmpsByIdIn error:", e);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<OrgEmpRpcDTO> findEmpDtoByParam(OrgEmpRpcDtoParam param) {
        log.info("查询员工方法开始：{}", param);
        try {
            List<OrgEmpRpcDTO> empDtoByParam = orgEmpRpcService.findEmpDtoByParam(param);
            if (!CollectionUtils.isEmpty(empDtoByParam)) {
                return empDtoByParam;
            }
        } catch (Exception e) {
            log.error("findAllEmpsByIdIn error:", e);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<Long> findBuIdsByUserId(Long userId) {
        try {
            List<Long> buIdsByUserId = orgBuRpcService.findBuIdsByUserId(userId);
            if (!CollectionUtils.isEmpty(buIdsByUserId)) {
                return buIdsByUserId;
            }
        } catch (Exception e) {
            log.error("findAllEmpsByIdIn error:", e);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<Long> findBuIdsByUsername(String username) {
        try {
            List<Long> buIdsByUserId = orgBuRpcService.findBuIdsByUsername(username);
            if (!CollectionUtils.isEmpty(buIdsByUserId)) {
                return buIdsByUserId;
            }
        } catch (Exception e) {
            log.error("findAllEmpsByIdIn error:", e);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<OrgBuRpcDTO> findBuIdsByUsername(OrgBuRpcDtoParam param) {
        try {
            List<OrgBuRpcDTO> buDtoByParam = orgBuRpcService.findBuDtoByParam(param);
            if (!CollectionUtils.isEmpty(buDtoByParam)) {
                return buDtoByParam;
            }
        } catch (Exception e) {
            throw new BusinessException(ApiCode.FAIL, "系统域部门查询方法服务异常，请检查,错误信息为：" + e.getMessage());
        }
        return Lists.newArrayList();
    }

    @Override
    public OrgBuRpcSaveResult orgBuRpcSaveOrUpdate(OrgBuRpcSaveParam param) {
        log.info("调用系统域-新增/编辑组织信息开始，时间：{}，入参：{}", LocalDateTime.now(), param);
        try {
            ApiResult<OrgBuRpcSaveResult> apiResult = orgBuRpcService.orgBuRpcSaveOrUpdate(param);
            if (apiResult.isSuccess()) {
                return apiResult.getData();
            } else {
                throw new BusinessException("仓库同步支撑域-组织保存/编辑方法失败:" + apiResult.getMsg());
            }
        } catch (Exception e) {
            log.error("调用系统域-新增/编辑组织信息失败：{}", e);
            throw new BusinessException("dubb调用支撑域-组织保存方法服务失败：" + e.getMessage());
        }
    }

    @Override
    public ApiResult<OrgBuDetailsRpcDTO> findDetailDtoById(Long id) {
        return null;
    }

    /**
     * 1
     * 新增或修改地址薄信息
     * <p>
     * 该接口用于创建或者编辑现有的地址薄信息，所有的子信息为全删全插操作
     * 如果使用该接口，则请不要使用创建组织的接口，否则会创建两个地址薄信息
     * 该接口判断传入的ID是否为null来决定是新增还是编辑，返回的结果是地址号 addrNo，而不是ID
     * <p>
     * 如果接口调用失败，ApiResult 中的 data 返回将为 null，success 为 false，错误信息会保存在 message 中
     *
     * @param param 参数
     * @return 调用结果，如果成功，data 中保存的是 addrNo，而不是id
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Long> orgAddrSaveOrUpdateReturnAddrNo(OrgAddrRpcSaveParam param) {
        log.info("调用支撑域-新增或修改地址薄信息，时间：{}，入参：{}", LocalDateTime.now(), param);
        ApiResult<Long> apiResult = null;
        try {
            apiResult = orgAddrRpcService.orgAddrSaveOrUpdateReturnAddrNo(param);
            log.info("调用支撑域-新增或修改地址薄信息，时间：{}，出参：{}", LocalDateTime.now(), apiResult);
            if (apiResult.isSuccess()) {
                return apiResult;
            } else {
                throw new BusinessException(ApiCode.FAIL, "支撑域地址保存方法失败" + apiResult.getMsg());
            }
        } catch (Exception e) {
            log.error("orgAddrSaveOrUpdateReturnAddrNo error:", e);
            throw new BusinessException("新增或修改地址薄信息失败，请检查!" + e.getMessage());
        }
    }

    /**
     * 2
     * 根据地址号获取地址薄详情
     *
     * @param addrNo 地址号
     * @return 地址薄详情
     */
    @Override
    public OrgAddrDetailsRpcDTO findRpcDtoByAddrNo(Long addrNo) {
        log.info("调用支撑域-根据地址号获取地址薄详情，时间：{}，入参：{}", LocalDateTime.now(), addrNo);
        try {
            // ApiResult<OrgAddrDetailsRpcDTO> apiResult = orgAddrRpcService.findRpcDtoByAddrNo(addrNo);
            OrgAddrQueryRpcParam param = new OrgAddrQueryRpcParam();
            param.setAddrNo(addrNo);
            ApiResult<OrgAddrDetailsRpcDTO> apiResult = orgAddrRpcService.findRpcDtoByParam(param);

            if (apiResult.isSuccess()) {
                return apiResult.getData();
            } else {
                throw new BusinessException(ApiCode.FAIL, apiResult.getMsg());
            }
        } catch (Exception e) {
            log.error("findRpcDtoByAddrNo error:", e);
        }
        return null;
    }

    /**
     * 3
     * 软删除地址薄信息
     *
     * @param addrNo 地址号
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void softDeleteOrgAddrByAddrNo(Long addrNo) {
        log.info("调用支撑域-软删除地址薄信息，时间：{}，入参：{}", LocalDateTime.now(), addrNo);
        try {
            orgAddrRpcService.softDeleteOrgAddrByAddrNo(addrNo);
        } catch (Exception e) {
            log.error("softDeleteOrgAddrByAddrNo error:", e);
        }
    }

    @Override
    public List<OrgAddressRpcDTO> findRpcDtoByBatchAddrNos(OrgAddressRpcDtoParam param) {
        log.info("调用支撑域-批量查询地址信息数据，时间：{}，入参：{}", LocalDateTime.now(), param);
        try {
            List<OrgAddressRpcDTO> addressRpcDTOS = orgAddrRpcService.findAddrAddressRpcDtoByParam(param);
            if (!CollectionUtils.isEmpty(addressRpcDTOS)) {
                return addressRpcDTOS;
            }
        } catch (Exception e) {
            log.error("findRpcDtoByBatchAddrNos", e);
        }
        return null;
    }

    @Override
    public List<OrgBuRpcDTO> findBuByIds(List<Long> buIds) {
        log.info("调用支撑域-根据组织ID集合获取组织信息列表，时间：{}，入参：{}", LocalDateTime.now(), buIds);
        if (CollectionUtils.isEmpty(buIds)) {
            return Lists.newArrayList();
        }
        OrgBuRpcDtoParam param = new OrgBuRpcDtoParam();
        param.setBuIds(buIds);
        try {
            List<OrgBuRpcDTO> ous = orgBuRpcService.findBuDtoByParam(param);
            if (!com.alibaba.excel.util.CollectionUtils.isEmpty(ous)) {
                return ous;
            }
        } catch (Exception e) {
            log.error("findOuByIds error:", e);
        }
        return Lists.newArrayList();
    }

    @Override
    public List<OrgBuRpcDTO> findBuByCodes(List<String> buCodes){
        log.info("调用支撑域-根据组织编码集合获取组织信息列表，时间：{}，入参：{}", LocalDateTime.now(), buCodes);
        if (CollectionUtils.isEmpty(buCodes)) {
            return Lists.newArrayList();
        }
        OrgBuRpcDtoParam param = new OrgBuRpcDtoParam();
        param.setBuCodes(buCodes);
        try {
            List<OrgBuRpcDTO> ous = orgBuRpcService.findBuDtoByParam(param);
            if (!com.alibaba.excel.util.CollectionUtils.isEmpty(ous)) {
                return ous;
            }
        } catch (Exception e) {
            log.error("findBuByCodes error:", e);
        }
        return Lists.newArrayList();
    }

    @Override
    public Optional<OrgBuRpcDTO> findBuById(Long buId) {
        log.info("调用支撑域-根据组织ID获取组织信息，时间：{}，入参：{}", LocalDateTime.now(), buId);
        if (StringUtils.isEmpty(buId)) {
            return Optional.empty();
        }
        OrgBuRpcDtoParam param = new OrgBuRpcDtoParam();
        param.setBuIds(Collections.singletonList(buId));
        try {
            List<OrgBuRpcDTO> ous = orgBuRpcService.findBuDtoByParam(param);
            if (!org.springframework.util.CollectionUtils.isEmpty(ous)) {
                return Optional.of(ous.get(0));
            }
        } catch (Exception e) {
            log.error("findBuById error:", e);
        }
        return Optional.empty();
    }

    @Override
    public List<SysCurrencyRespDTO> findRpcDtoByParam(List<String> currCodes) {
        log.info("调用系统币种查询方法开始，时间：{}.参数为：{}", LocalDateTime.now(), currCodes);
        try {
            HashSet<String> set=new HashSet<>(currCodes);
            SysCurrencyQueryDTO currencyQueryDTO = new SysCurrencyQueryDTO();
            currencyQueryDTO.setCurrCodes(set);
            ApiResult<List<SysCurrencyRespDTO>> result = sysCurrencyRpcService.queryList(currencyQueryDTO);
            return result.getData();
        } catch (Exception e) {
            throw new BusinessException("调用系统域币种查询方法服务异常：" + e.getMessage());
        }

    }


    /**
     * 0.00
     * 模糊搜索供应商/客户/员工
     *
     * @param param code=code/name
     * @return 供应商/客户/员工的code和name
     */
    @Override
    public List<OrgRespVO> findcodeAndName(InvParentParamVO param) {
        List<OrgRespVO> orgRespVOList = new ArrayList<>();
        try {
            if (InvPTypeEnum.INV_PARTNER_TYPE_CUST.getPType().equals(param.getType())) {
                //客户数据暂无
            } else if (InvPTypeEnum.INV_PARTNER_TYPE_SUPP.getPType().equals(param.getType())) {
                Optional<PurSuppBaseRpcDTO> suppBaseDTOOptional = purDubbleService.findSuppByCode(param.getCode());
                if (suppBaseDTOOptional.isPresent()) {
                    PurSuppBaseRpcDTO purSuppBaseDTOS = suppBaseDTOOptional.get();
                    if (purSuppBaseDTOS != null) {
                        OrgRespVO respVO = this.convertSuppDTOToOrgRespVO(purSuppBaseDTOS);
                        orgRespVOList.add(respVO);

                    }
                }
            } else if (InvPTypeEnum.INV_PARTNER_TYPE_EMP.getPType().equals(param.getType())) {
                OrgEmpRpcDtoParam empParam = new OrgEmpRpcDtoParam();
                List<String> orgemplist = new ArrayList<>();
                orgemplist.add(param.getCode());
                empParam.setEmpCodes(orgemplist);
                List<OrgEmpRpcDTO> emps = findEmpDtoByParam(empParam);
                for (val emp : emps) {
                    OrgRespVO orgRespVO = new OrgRespVO();
                    orgRespVO.setId(emp.getId());
                    orgRespVO.setCode(emp.getEmpCode());
                    orgRespVO.setName(emp.getEmpName());
                    orgRespVOList.add(orgRespVO);
                }
            }
        } catch (Exception e) {
            log.error("findcodeAndName error:", e);
        }
        return orgRespVOList;
    }

    @Override
    public List<OrgRespVO> findcodeAndNameList(InvPTypeEnum type, List<String> codes) {
        List<OrgRespVO> orgRespVOList = new ArrayList<>();
        try {
            switch (type) {
                case INV_PARTNER_TYPE_CUST:
                    return orgRespVOList;
                case INV_PARTNER_TYPE_EMP:
                    OrgEmpRpcDtoParam empParam = new OrgEmpRpcDtoParam();
                    empParam.setEmpCodes(codes);
                    List<OrgEmpRpcDTO> emps = findEmpDtoByParam(empParam);
                    for (val emp : emps) {
                        OrgRespVO orgRespVO = new OrgRespVO();
                        orgRespVO.setId(emp.getId());
                        orgRespVO.setCode(emp.getEmpCode());
                        orgRespVO.setName(emp.getEmpName());
                        orgRespVOList.add(orgRespVO);
                    }
                    return orgRespVOList;
                case INV_PARTNER_TYPE_SUPP:
                    List<PurSuppBaseRpcDTO> suppBaseDTOS = purDubbleService.findSuppByCodeBatch(codes);
                    if (!org.springframework.util.CollectionUtils.isEmpty(suppBaseDTOS)) {
                        //  List<PurSuppBaseDTO> purSuppBaseDTOS = result.getData();
                        if (!CollectionUtils.isEmpty(suppBaseDTOS)) {
                            orgRespVOList = suppBaseDTOS.stream().map(this::convertSuppDTOToOrgRespVO).collect(Collectors.toList());
                        }
                    }
                    return orgRespVOList;
            }
        } catch (Exception e) {
            log.error("findcodeAndNameList error:", e);
        }
        return orgRespVOList;
    }


    private OrgRespVO convertSuppDTOToOrgRespVO(PurSuppBaseRpcDTO purSuppBaseDTO) {
        if (purSuppBaseDTO == null) {
            return null;
        }
        OrgRespVO orgRespVO = new OrgRespVO();
        orgRespVO.setId(purSuppBaseDTO.getId());
        orgRespVO.setName(purSuppBaseDTO.getSuppName());
        orgRespVO.setCode(purSuppBaseDTO.getSuppCode());
        return orgRespVO;
    }

}
