package com.elitesland.yst.production.inv.application.service.impl;

import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitesland.yst.production.inv.application.facade.vo.InvAjDSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.InvAjSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.InvParentParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.ck.*;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkQueryParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.OrgRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.whAreaSetting.InvWhAreaSettingRespVO;
import com.elitesland.yst.production.inv.application.out.ItmOutService;
import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvAjService;
import com.elitesland.yst.production.inv.application.service.InvCkService;
import com.elitesland.yst.production.inv.application.service.InvWhAreaSettingService;
import com.elitesland.yst.production.inv.domain.convert.ck.InvCkConvert;
import com.elitesland.yst.production.inv.domain.convert.ck.InvCkDConvert;
import com.elitesland.yst.production.inv.domain.entity.ck.InvCk;
import com.elitesland.yst.production.inv.domain.entity.ck.InvCkD;
import com.elitesland.yst.production.inv.domain.entity.invwh.InvWhDO;
import com.elitesland.yst.production.inv.domain.service.*;
import com.elitesland.yst.production.inv.infr.dto.InvStkDTO;
import com.elitesland.yst.production.inv.infr.dto.ck.InvCkDDTO;
import com.elitesland.yst.production.inv.infr.dto.ck.InvCkDTO;
import com.elitesland.yst.production.inv.utils.ConvertUtil;
import com.elitesland.yst.production.inv.utils.NumSendObjectEnum;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitesland.yst.production.inv.enums.ProcDefKey;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.WorkflowConstant;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.WorkflowService;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.cloudt.core.security.util.SecurityUtil;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitescloud.cloudt.system.vo.SysUserVO;
import com.google.common.collect.Maps;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.apache.commons.collections4.MapUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author lvqf
 * @Date 2021/2/18
 * @Description
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class InvCkServiceImpl implements InvCkService {
    private final InvStkDomainService invStkDomainService;
    private final ItmOutService itmOutService;
    private final SystemService systemService;
    private final InvWhDomainService invWhDomainService;
    private final InvWhAreaDomainService invWhAreaDomainService;
    private final OrgOutService outouService;
    private final InvAjService invAjService;

    private final Integer ISAJSTATUSED = 1;

    private final InvCkdDomainService invCkdDomainService;
    private final InvCkDomainService invCkDomainService;

    private final WorkflowService workflowService;

    private final TransactionTemplate transactionTemplate;

    private final RedisUtils redisUtils;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long saveOrSubmitInvCkAndCkD(InvCkAndCkDSaveVO invCkAndCkDSaveVO, boolean isSubmit) {
        if (invCkAndCkDSaveVO.getId() == null) {
            throw new BusinessException(ApiCode.FAIL, "盘点单id不能为空！");
        }
        Optional<InvCkDTO> invCkDOOptional = invCkDomainService.findById(invCkAndCkDSaveVO.getId());

        if (!invCkDOOptional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "盘点单不存在！");
        }
        InvCkDTO invCkDTO = invCkDOOptional.get();
        if (!(UdcEnum.INV_CK_STATUS_DR.getValueCode().equals(invCkDTO.getDocStatus())
                || UdcEnum.INV_CK_STATUS_RJ.getValueCode().equals(invCkDTO.getDocStatus()))) {
            throw new BusinessException(ApiCode.FAIL, "只有草稿、已拒绝状态的才能保存/提交！");
        }
        //数据权限
        try {
            GeneralUserDetails user = SecurityContextUtil.currentUser();
            invCkDTO.setSecBuId(invCkAndCkDSaveVO.getSecBuId() == null ? null : invCkAndCkDSaveVO.getSecBuId());
            invCkDTO.setSecOuId(invCkAndCkDSaveVO.getOuId() == null ? null : invCkAndCkDSaveVO.getOuId());
        } catch (Exception e) {
            log.error("无法获取当前登录人信息，请先登录：{}" + e.getMessage());
        }
        invCkDTO.setRemark(invCkAndCkDSaveVO.getRemark());
        invCkDTO.setOuId(invCkAndCkDSaveVO.getOuId());
        invCkDTO.setDocType(invCkAndCkDSaveVO.getDocType());
        //设置隔离级别
        transactionTemplate.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRES_NEW);
        Long invCkId = transactionTemplate.execute(transactionStatus -> {
            try {
                InvCk invCk = InvCkConvert.INSTANCE.dtoToEn(invCkDTO);
                invCk.setIsAjStatus(0);
                Long id = invCkDomainService.saveInvCk(invCk);
                List<InvCkDSaveVO> invCkDs = invCkAndCkDSaveVO.getInvCkDs();
                List<InvCkDDTO> invCkDDTOList = invCkdDomainService.selectByMasId(id);
                if (!CollectionUtils.isEmpty(invCkDDTOList)) {
                    invCkdDomainService.deleteByMasId(id);
                }
                if (!CollectionUtils.isEmpty(invCkDs)) {
                    List<InvCkD> invCkDList = invCkDs.stream().map(e -> {
                        InvCkD invCkD = InvCkDConvert.INSTANCE.saveVoToEn(e);
                        invCkD.setMasId(id);
                        //数据权限
                        try {
                            invCkD.setSecBuId(invCkAndCkDSaveVO.getSecBuId() == null ? null : invCkAndCkDSaveVO.getSecBuId());
                            invCkD.setSecOuId(invCkAndCkDSaveVO.getOuId() == null ? null : invCkAndCkDSaveVO.getOuId());
                        } catch (Exception w) {
                            log.error("无法获取当前登录人信息，请先登录：{}" + w.getMessage());
                        }
                        return invCkD;
                    }).collect(Collectors.toList());
                    invCkdDomainService.saveInvCkDList(invCkDList);
                }
                return id;
            } catch (Exception e) {
                log.error("create invCk error", e);
                throw new BusinessException(ApiCode.FAIL, e.getMessage());
            }
        });
        //开启审批流，由于之前没有用工作流，是做产品化要求加上最简单的工作流
        /************************************************************************
         *                              工作流开始                                *
         ************************************************************************/
        SysUserDTO user = null;
        var generalUserDetails = SecurityUtil.getUser();
        if (generalUserDetails != null && generalUserDetails.getUser() != null) {
            user = generalUserDetails.getUser();
        } else {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "无法到获取当前用户");
        }
        //InvCkDO invCkDO1 = invCkRepo.findById(invCkId).get();
        InvCkDTO invCkDO1 = invCkDomainService.findById(invCkId).get();
        if ((invCkDO1.getProcInstId() == null
                || WorkflowConstant.CAN_START_PROC_STATUSES.contains(invCkDO1.getProcInstStatus())) && isSubmit
        ) {
            /**
             * 为什么要加上面3个判断，是因为流程已经启动了,就没必要再启动流程(场景:在'审批中'的过程中，做保存操作)
             * 工作流规则:
             *  1,一个业务单据在一个流程没结束前是不能再起的同一个工作流
             *  2,一个业务单据可以同时有2个"不同类型"的流程再跑
             */
            //这里可以自定义
            String procInstName = "库存盘点-" + invCkDO1.getDocNo();
            WorkflowResult<ProcessInfo> processInfoWorkflowResult = workflowService.startProcess(StartProcessPayload.of(ProcDefKey.INV_STOCK_CHECK.name(), procInstName, invCkDO1.getId() + "", null));
            //修改业务审批数据
//            QPurPaDO qPurPaDO = QPurPaDO.purPaDO;
           /* QInvCkDO qInvCkDO = QInvCkDO.invCkDO;
            JPAUpdateClause jpaUpdateClause = jpaQueryFactory.update(qInvCkDO)
                    .set(qInvCkDO.procInstId, processInfo.getProcInstId())
                    .set(qInvCkDO.submitTime, LocalDateTime.now())
                    .where(qInvCkDO.id.eq(invCkDO1.getId()));
            if (!Objects.equals(processInfo.getProcInstStatus(), com.elitesland.workflow.enums.ProcInstStatus.APPROVED)) {
                jpaUpdateClause.set( qInvCkDO.procInstStatus, com.elitesland.workflow.enums.ProcInstStatus.APPROVING );
                jpaUpdateClause.set( qInvCkDO.docStatus, UdcEnum.INV_CK_STATUS_APPING.getValueCode());//单据状态
            }
            jpaUpdateClause.execute();*/

            log.info("库存盘点启动流程返回:" + processInfoWorkflowResult);
            if (!processInfoWorkflowResult.isSuccess() || Objects.isNull(processInfoWorkflowResult.getData())) {
                throw new BusinessException("调用工作流异常，错误信息:" + processInfoWorkflowResult.getMsg());
                }
            if (Objects.nonNull(processInfoWorkflowResult.getData())) {
                invCkDomainService.updateProcInst(processInfoWorkflowResult.getData(), invCkDO1.getId(), UdcEnum.INV_CK_STATUS_APPING.getValueCode());
            }

            /************************************************************************
             *                              工作流结束                                *
             ************************************************************************/
        }
        return invCkAndCkDSaveVO.getId();
    }

    @Override
    public PagingVO<InvCkRespVO> list(InvCkParamVO invCkParamVO) {
        List<InvCkRespVO> invCkRespVOS;
        long total;
        if(StringUtils.hasText(invCkParamVO.getDeter2KeyWord())){
            List<InvCkDDTO> ckDDTOList = invCkdDomainService.selectByDeter2KeyWords(invCkParamVO.getDeter2KeyWord());
            if(!CollectionUtils.isEmpty(ckDDTOList)){
                List<Long> masIds = ckDDTOList.stream().map(InvCkDDTO::getMasId)
                        .filter(Objects::nonNull)
                        .distinct().collect(Collectors.toList());
                invCkParamVO.setMasIds(masIds);
            } else{
                invCkRespVOS = Collections.emptyList();
                total = 0L;
                return PagingVO.<InvCkRespVO>builder()
                        .total(total)
                        .records(invCkRespVOS).build();
            }
        }
        val pagingVo = invCkDomainService.invCkSearch(invCkParamVO);
        val vos = pagingVo.getRecords();
        invCkRespVOS = vos;
        //分页查询数据组装
        searchAssembly(invCkRespVOS);
        total = pagingVo.getTotal();
        return PagingVO.<InvCkRespVO>builder()
                .total(total)
                .records(invCkRespVOS).build();
    }

    /***
     * 分页查询数据组装
     *
     * */
    private void searchAssembly(List<InvCkRespVO> invCkRespVOList) {
        List<Long> ouIdList = invCkRespVOList.stream().map(InvCkRespVO::getOuId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<InvWhAreaRespVO> whAreaRespVOS = new ArrayList<>();
        List<OrgOuRpcDTO> orgOuVOS = outouService.findOuByIds(ouIdList);
        List<Long> createUserIds = invCkRespVOList.stream().map(InvCkRespVO::getCreateUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<SysUserVO> sysUserVOS = systemService.findAllEmpsByIdIn(createUserIds);
        // 盘点状态
        Map<String, String> docStatusMap = systemService.sysUdcGetCodeMap(UdcEnum.INV_CK_STATUS_DR.getModel(), UdcEnum.INV_CK_STATUS_DR.getCode());
        // 盘点类型
        Map<String, String> docTypeMap = systemService.sysUdcGetCodeMap(UdcEnum.INV_CK_STATUS_DR.getModel(), UdcEnum.INV_CK_TYPE_DAY.getCode());
        // 盘点方式
        Map<String, String> docMethodMap = systemService.sysUdcGetCodeMap(UdcEnum.INV_CK_METHOD_BLD.getModel(), UdcEnum.INV_CK_METHOD_BLD.getCode());

        invCkRespVOList.forEach(invCkRespVO -> {
            if (!CollectionUtils.isEmpty(docStatusMap) && docStatusMap.containsKey(invCkRespVO.getDocStatus())) {
                invCkRespVO.setDocStatusName(docStatusMap.get(invCkRespVO.getDocStatus()));
            }
            if (!CollectionUtils.isEmpty(docTypeMap) && docTypeMap.containsKey(invCkRespVO.getDocType())) {
                invCkRespVO.setDocTypeName(docTypeMap.get(invCkRespVO.getDocType()));
            }
            if (!CollectionUtils.isEmpty(docMethodMap) && docMethodMap.containsKey(invCkRespVO.getDocMethod())) {
                invCkRespVO.setDocMethodName(docMethodMap.get(invCkRespVO.getDocMethod()));
            }
            if (!CollectionUtils.isEmpty(sysUserVOS)) {
                sysUserVOS.stream().filter(v -> v.getId().equals(invCkRespVO.getCreateUserId())).findAny().ifPresent(o -> {
                    invCkRespVO.setCreator(o.getUsername());
                });
            }
            if (!CollectionUtils.isEmpty(orgOuVOS)) {
                orgOuVOS.stream().filter(f -> f.getId().equals(invCkRespVO.getOuId())).findFirst().ifPresent(o -> {
                    invCkRespVO.setOuName(o.getOuName());
                    invCkRespVO.setOuCode(o.getOuCode());
                });
            }
        });
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void approval(Long id) {
        // Optional<InvCkDO> invCkDOOptional = invCkRepo.findById(id);
        Optional<InvCkDTO> invCkDTOOptional = invCkDomainService.findById(id);
        if (!invCkDTOOptional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "审批失败,未查到对应盘点单");
        }
        if (!UdcEnum.INV_CK_STATUS_APPING.getValueCode().equals(invCkDTOOptional.get().getDocStatus())) {
            throw new BusinessException(ApiCode.FAIL, "盘点单状态异常");
        }
        // 审批通过
        //invCkRepoProc.updateDocStatus(id,UdcEnum.INV_CK_STATUS_APPED.getValueCode());
        invCkDomainService.updateDocStatus(id, UdcEnum.INV_CK_STATUS_APPED.getValueCode());

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void syncToInvAj(Long id) {
        // Optional<InvCkDO> invCkDOOptional = invCkRepo.findById(id);
        Optional<InvCkDTO> invCkDTOOptional = invCkDomainService.findById(id);
        if (!invCkDTOOptional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "生成失败,未查到对应盘点单");
        }
        if (!UdcEnum.INV_CK_STATUS_APPED.getValueCode().equals(invCkDTOOptional.get().getDocStatus())) {
            throw new BusinessException(ApiCode.FAIL, "盘点单状态异常");
        }
        //根据盘盈盘亏生成调整单
        this.saveOneInvAj(invCkDTOOptional, id);
        //invCkRepoProc.updateIsAjStatus(id,ISAJSTATUSED);
        invCkDomainService.updateIsAjStatus(id, ISAJSTATUSED);

    }


    private void saveOneInvAj(Optional<InvCkDTO> invCkDOOptional, Long id) {
        InvCkDTO invCkDTO = invCkDOOptional.orElseThrow(new BusinessException("库存盘点不存在，请检查!"));
        //根据盈亏情况生成草稿状态的调整单
        //List<InvCkDRespVO> invCkDRespVOS = invCkDRepoProc.selectByMasId(id);
        List<InvCkDDTO> invCkDDTOList = invCkdDomainService.selectByMasId(id);
        // 盘点盈亏数据
        List<InvCkDDTO> invCkDDTOS = invCkDDTOList.stream().filter(c -> c.getFactQty() != null
                && c.getFactQty().subtract(c.getAccQty()).compareTo(BigDecimal.ZERO) != 0).map(e -> {
            e.setDiffQty(e.getFactQty().subtract(e.getAccQty()));
            return e;
        }).collect(Collectors.toList());
        List<InvCkDDTO> invCkDDTOS1 = invCkDDTOS.stream()
                .filter(c -> (c.getDiffQty() == null ? BigDecimal.ZERO : c.getDiffQty())
                        .compareTo(BigDecimal.ZERO) > 0)
                .collect(Collectors.toList());

        List<InvCkDDTO> invCkDDTOS2 = invCkDDTOS.stream()
                .filter(c -> (c.getDiffQty() == null ? BigDecimal.ZERO : c.getDiffQty())
                        .compareTo(BigDecimal.ZERO) < 0)
                .collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(invCkDDTOS1)) {
            Map<String, List<InvCkDDTO>> invCkDMap1 = invCkDDTOS1.stream().collect(Collectors.groupingBy(d -> d.getDeter2()));
            for (Map.Entry<String, List<InvCkDDTO>> i : invCkDMap1.entrySet()) {
                List<InvCkDDTO> invCkDDTOList1 = i.getValue();
                //生成草稿状态调整单
                InvAjSaveVO invAjSaveVO = this.invCkDOToinvAjSaveVO(invCkDTO, i.getKey(), id, true);
                //生成草稿明细
                List<InvAjDSaveVO> invAjDSaveVOList = new ArrayList<>();
                for (InvCkDDTO invCkDDTO : invCkDDTOList1) {
                    invAjDSaveVOList.add(this.invCkDRespVOConvertToinvAjDRespVO(invCkDDTO, invCkDTO, true));
                }
                invAjSaveVO.setInvAjDSaveVOList(invAjDSaveVOList);
                invAjService.saveOneInvAj(invAjSaveVO);
            }
        }
        if (!CollectionUtils.isEmpty(invCkDDTOS2)) {
            Map<String, List<InvCkDDTO>> invCkDMap2 = invCkDDTOS2.stream().collect(Collectors.groupingBy(d -> d.getDeter2()));
            for (Map.Entry<String, List<InvCkDDTO>> i : invCkDMap2.entrySet()) {
                List<InvCkDDTO> invCkDDTOList1 = i.getValue();
                //生成草稿状态调整单
                InvAjSaveVO invAjSaveVO = this.invCkDOToinvAjSaveVO(invCkDTO, i.getKey(), id, false);
                //生成草稿明细
                List<InvAjDSaveVO> invAjDSaveVOList = new ArrayList<>();
                for (InvCkDDTO invCkDDTO : invCkDDTOList1) {
                    invAjDSaveVOList.add(this.invCkDRespVOConvertToinvAjDRespVO(invCkDDTO, invCkDTO, false));
                }
                invAjSaveVO.setInvAjDSaveVOList(invAjDSaveVOList);
                invAjService.saveOneInvAj(invAjSaveVO);
            }
        }

    }


    private InvAjSaveVO invCkDOToinvAjSaveVO(InvCkDTO invCkDTO, String deter2, Long masId, Boolean flag) {
        if (invCkDTO == null) {
            throw new BusinessException("库存盘点为空，请检查！");
        }
        InvAjSaveVO invAjSaveVO = new InvAjSaveVO();
        invAjSaveVO.setCreateTime(LocalDateTime.now());
        invAjSaveVO.setCreateUserId(invCkDTO.getCreateUserId());
        invAjSaveVO.setCreator(invCkDTO.getCreator());
        invAjSaveVO.setSecBuId(invCkDTO.getSecBuId());
        invAjSaveVO.setSecOuId(invCkDTO.getSecOuId());
        invAjSaveVO.setWhId(invCkDTO.getWhId());
        invAjSaveVO.setDeter2(deter2);
        invAjSaveVO.setOuId(invCkDTO.getOuId());
        OrgOuRpcDTO orgOuRpcDTO = outouService.findOuById(invCkDTO.getOuId());
        if (orgOuRpcDTO != null) {
            invAjSaveVO.setOuCode(orgOuRpcDTO.getOuCode());
        } else {
            throw new BusinessException(ApiCode.FAIL, "公司为空，请检查!");
        }

        invAjSaveVO.setApplyEmpId(invCkDTO.getCreateUserId());
        invAjSaveVO.setBuId(null);
        invAjSaveVO.setRelateDocNo(invCkDTO.getDocNo());
        invAjSaveVO.setRelateDocCls(UdcEnum.COM_DOC_CLS_STKCK.getValueCode());
        invAjSaveVO.setRelateDocId(masId);
        invAjSaveVO.setIoDate(LocalDateTime.now());
        invAjSaveVO.setApplyDate(LocalDateTime.now());
        invAjSaveVO.setDocStatus(UdcEnum.INV_AJ_STATUS_DR.getValueCode());
        invAjSaveVO.setCreateUserId(invCkDTO.getCreateUserId());
        invAjSaveVO.setSecOuId(invCkDTO.getSecOuId());
        invAjSaveVO.setSecBuId(invCkDTO.getSecBuId());
        invAjSaveVO.setSecUserId(invCkDTO.getSecUserId());
        if (flag) {
            invAjSaveVO.setDocType(UdcEnum.INV_AJ_TYPE_STKIN.getValueCode());
            invAjSaveVO.setReasonCode(UdcEnum.COM_REASON_CODE_107.getValueCode());
        } else {
            invAjSaveVO.setDocType(UdcEnum.INV_AJ_TYPE_STKOUT.getValueCode());
            invAjSaveVO.setReasonCode(UdcEnum.COM_REASON_CODE_108.getValueCode());
        }
        return invAjSaveVO;

    }


    private InvAjDSaveVO invCkDRespVOConvertToinvAjDRespVO(InvCkDDTO invCkDDTO, InvCkDTO invCkDTO, Boolean flag) {
        if (invCkDDTO == null) {
            return null;
        }
        InvAjDSaveVO invAjDSaveVO = new InvAjDSaveVO();
        invAjDSaveVO.setItemCode(invCkDDTO.getItemCode());
        invAjDSaveVO.setItemId(invCkDDTO.getItemId());
        invAjDSaveVO.setQty((invCkDDTO.getDiffQty() == null ? BigDecimal.ZERO : invCkDDTO.getDiffQty()).abs());
        invAjDSaveVO.setUom(invCkDDTO.getUom());
        invAjDSaveVO.setWhId(invCkDTO.getWhId());
        invAjDSaveVO.setDeter2(invCkDDTO.getDeter2());
        invAjDSaveVO.setRelateDocCls(UdcEnum.COM_DOC_CLS_STKCK.getValueCode());
        invAjDSaveVO.setRelateDocDid(invCkDDTO.getId());
        invAjDSaveVO.setRelateDocId(invCkDTO.getId());
        invAjDSaveVO.setRelateDocNo(invCkDTO.getDocNo());
        invAjDSaveVO.setLotNo(invCkDDTO.getLotNo());
        //TODO
        /*if(!StringUtils.isEmpty(invCkDRespVO.getLotNo())){
            InvLotParam invLotParam = new InvLotParam();
            invLotParam.setItemId(invCkDRespVO.getItemId());
            invLotParam.setLotNo(invCkDRespVO.getLotNo());
            List<InvLotRespVO> invLotVOListByParam = invLotCommonService.getInvLotVOListByParam(invLotParam);
            if(!CollectionUtils.isEmpty(invLotVOListByParam)){
                invAjDSaveVO.setManuDate(invLotVOListByParam.get(0).getManuDate());
                invAjDSaveVO.setExpireDate(invLotVOListByParam.get(0).getExpireDate());
            }
        }*/
        invAjDSaveVO.setToLotNo(invCkDDTO.getLotNo());
        invAjDSaveVO.setPCode(invCkDDTO.getPCode());
        invAjDSaveVO.setPType(invCkDDTO.getPType());
        if (flag) {
            invAjDSaveVO.setReasonCode(UdcEnum.COM_REASON_CODE_107.getValueCode());
        } else {
            invAjDSaveVO.setToLotNo(null);
            invAjDSaveVO.setReasonCode(UdcEnum.COM_REASON_CODE_108.getValueCode());
        }
        return invAjDSaveVO;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void reject(Long id) {
        // Optional<InvCkDO> invCkDOOptional = invCkRepo.findById(id);
        Optional<InvCkDTO> invCkDTOOptional = invCkDomainService.findById(id);
        if (!invCkDTOOptional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "审批失败,未查到对应盘点单");
        }
        // 审批拒绝
        //invCkRepoProc.updateDocStatus(id,UdcEnum.INV_CK_STATUS_RJ.getValueCode());
        invCkDomainService.updateDocStatus(id, UdcEnum.INV_CK_STATUS_RJ.getValueCode());
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void create(InvCkCreateParamVO invCkCreateParamVO) {
        // 仓库id
        List<Long> whIdList = invCkCreateParamVO.getWhIdList();
        // 功能区
        List<String> deter2List = invCkCreateParamVO.getDeter2List();

        if (CollectionUtils.isEmpty(whIdList)) {
            throw new BusinessException(ApiCode.FAIL, "仓库id集合不能为空!");
        }
//        if (CollectionUtils.isEmpty(deter2List)){
//            throw new BusinessException(ApiCode.FAIL,"功能区不能为空!");
//        }

        // 根据仓库id创建盘点单
        Map<Long, Long> whIdMap = createInvCk(whIdList, invCkCreateParamVO);

        // 根据仓库、功能区查找对应商品
        Map<Long, List<InvStkDTO>> invCkMap = getInvCkMap(whIdMap, invCkCreateParamVO);
        if (CollectionUtils.isEmpty(invCkMap)) {
            throw new BusinessException(ApiCode.FAIL, "未查询到对应库存！请检查");
        }
        // 商品明细存入盘点明细表中
        for (Map.Entry<Long, List<InvStkDTO>> m : invCkMap.entrySet()) {
            List<InvStkDTO> invStkDTOS = m.getValue();
            for (InvStkDTO invStkDTO : invStkDTOS) {
                InvCkD invCkD = new InvCkD();
                invCkD.setMasId(m.getKey());
                invCkD.setItemId(invStkDTO.getItemId());
                invCkD.setLotNo(invStkDTO.getLotNo());
                // 温层默认常温
                invCkD.setDeter1(UdcEnum.INV_TEMP_TYPE_RT.getValueCode());
                invCkD.setDeter2(invStkDTO.getDeter2());
                invCkD.setAccQty(invStkDTO.getOhQty());
                invCkD.setUom(invStkDTO.getUom());
                invCkD.setWhId(invStkDTO.getWhId());
                invCkD.setPCode(invStkDTO.getPCode());
                invCkD.setPType(invStkDTO.getPType());
                //数据权限
                try {
                    invCkD.setSecBuId(invStkDTO.getSecBuId() == null ? null : invStkDTO.getSecBuId());
                    invCkD.setSecOuId(invStkDTO.getOuId() == null ? null : invStkDTO.getOuId());
                } catch (Exception e) {
                    log.error("无法获取当前登录人信息，请先登录：{}" + e.getMessage());
                }
                //invCkDRepo.save(invCkDDO);
                invCkdDomainService.saveInvCkD(invCkD);
            }
        }

    }

    @Override
    public InvCkAndCkDRespVO findInvCkAndCkDInfo(Long id) {
        InvCkAndCkDRespVO invCkAndCkDRespVO;
        Optional<InvCkDTO> invCkDTOOptional = invCkDomainService.findById(id);
        if (!invCkDTOOptional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "盘点单不存在");
        }
        InvCkDTO invCkDTO = invCkDTOOptional.get();
        invCkAndCkDRespVO = InvCkConvert.INSTANCE.dtoToInvCkAndCkDRespVO(invCkDTO);
        // 盘点模式
        String docMethod = invCkDTO.getDocMethod();
        invCkAndCkDRespVO.setDocStatusName(getUdcDesc(UdcEnum.INV_CK_STATUS_DR.getModel(), UdcEnum.INV_CK_STATUS_DR.getCode(), invCkAndCkDRespVO.getDocStatus()));
        invCkAndCkDRespVO.setDocTypeName(getUdcDesc(UdcEnum.INV_CK_STATUS_DR.getModel(), UdcEnum.INV_CK_TYPE_DAY.getCode(), invCkAndCkDRespVO.getDocType()));
        invCkAndCkDRespVO.setDocMethodName(getUdcDesc(UdcEnum.INV_CK_METHOD_BLD.getModel(), UdcEnum.INV_CK_METHOD_BLD.getCode(), docMethod));
        if (invCkDTO.getOuId() != null) {
            OrgOuRpcDTO orgOuVO = outouService.findOuById(invCkDTO.getOuId());
            if (orgOuVO != null) {
                invCkAndCkDRespVO.setOuName(orgOuVO.getOuName());
            }
        }
        Optional<InvWhDO> invWhRespVOOptional = invWhDomainService.findById(invCkAndCkDRespVO.getWhId());
        if (invWhRespVOOptional.isPresent()) {
            InvWhDO invWhRespVO = invWhRespVOOptional.get();
            // 仓库编码、名称赋值
            invCkAndCkDRespVO.setWhCode(invWhRespVO.getWhCode());
            invCkAndCkDRespVO.setWhName(invWhRespVO.getWhName());
        }

        //List<InvCkDRespVO> invCkDRespVOS = invCkDRepoProc.selectByMasId(id);
        List<InvCkDDTO> invCkDDTOList = invCkdDomainService.selectByMasId(id);

        fillInvCkDRespVOS(invCkDDTOList);
        if (!CollectionUtils.isEmpty(invCkDDTOList)) {
            // 盘点单明细
            List<InvCkDRespVO> invCkDRespVOList = invCkDDTOList.stream().map(InvCkDConvert.INSTANCE::dtoToRespVo).collect(Collectors.toList());
            invCkAndCkDRespVO.setInvCkDs(invCkDRespVOList);
            // 盘点盈亏数据
            List<InvCkDDTO> diffInvCkDs = invCkDDTOList.stream().filter(f -> f.getFactQty() != null
                    && f.getFactQty().subtract(f.getAccQty()).compareTo(BigDecimal.ZERO) != 0).map(e -> {
                e.setDiffQty(e.getFactQty().subtract(e.getAccQty()));
                return e;
            }).collect(Collectors.toList());
            List<InvCkDRespVO> diffInvCkdRespVOS = diffInvCkDs.stream().map(InvCkDConvert.INSTANCE::dtoToRespVo).collect(Collectors.toList());

            invCkAndCkDRespVO.setDiffInvCkDs(diffInvCkdRespVOS);
        }
        return invCkAndCkDRespVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void cancelInvCk(Long id) {
        //Optional<InvCkDO> invCkDOOptional = invCkRepo.findById(id);
        Optional<InvCkDTO> invCkDTOOptional = invCkDomainService.findById(id);
        if (!invCkDTOOptional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "取消失败！未查到对应盘点单");
        }
        // 取消
        //invCkRepoProc.updateDocStatus(id,UdcEnum.INV_CK_STATUS_CL.getValueCode());
        invCkDomainService.updateDocStatus(id, UdcEnum.INV_CK_STATUS_CL.getValueCode());
    }

   /* @Override
    public List<InvCkDownloadRespVO> findInvCkDownloadVOList(InvCkParamVO invCkParamVO) {

        List<InvCkDownloadRespVO> invCkDownloadRespVOS = new ArrayList<>();
        invCkParamVO.setSize(20000);
        PagingVO<InvCkRespVO> invCkPage = list(invCkParamVO);
        List<InvCkRespVO> invCkRespVOS = invCkPage.getRecords();
        if (!CollectionUtils.isEmpty(invCkRespVOS)){
            invCkDownloadRespVOS = invCkRespVOS.stream().map(e -> {
                InvCkDownloadRespVO invCkDownloadRespVO = InvCkConvert.INSTANCE.invCkRespVOToInvCkDownloadVO(e);
                invCkDownloadRespVO.setCreateDate(e.getCreateTime());
                return invCkDownloadRespVO;
            }).collect(Collectors.toList());
        }
        return invCkDownloadRespVOS;
    }*/

   /* @Override
    public List<InvCkDDownloadRespVO> findInvCkDDownloadVOList(Long masId) {
        InvCkAndCkDRespVO invCkAndCkDInfo = findInvCkAndCkDInfo(masId);
        List<InvCkDRespVO> invCkDs = invCkAndCkDInfo.getInvCkDs();
        List<InvCkDDownloadRespVO> invCkDDownloadRespVOS = new ArrayList<>();
        if (!CollectionUtils.isEmpty(invCkDs)){
            invCkDDownloadRespVOS = invCkDs.stream().map(e -> {
                InvCkDDownloadRespVO invCkDDownloadRespVO = InvCkDConvert.INSTANCE.invCkDRespVOToInvCkDownloadVO(e);;
                invCkDDownloadRespVO.setId(String.valueOf(e.getId()));
                return invCkDDownloadRespVO;
            }).collect(Collectors.toList());
        }
        return invCkDDownloadRespVOS;
    }*/

    /**
     *盘点明细导出
     * @param masId
     * @return
     */
    /*@Override
    public List<InvCkDExcelRespVO> findInvDCkDDownloadVOList2(Long masId) {
        InvCkAndCkDRespVO invCkAndCkDInfo = findInvCkAndCkDInfo(masId);
        //新建返回数据数组
        List<InvCkDExcelRespVO> invCkDExcelRespVOS = new ArrayList<>();
        //查询商品的数量
        int size = invCkAndCkDInfo.getInvCkDs().size();
        //获取商品详情
        List<InvCkDRespVO> diffInvCkDs = invCkAndCkDInfo.getInvCkDs();
        //如果明细数量为0，则抛异常
        if(size == 0) {
            throw new BusinessException(ApiCode.FAIL,"无盘点单明细数据");
        } else {
            //获取商品的id
            List<Long> idList = diffInvCkDs.stream().map(InvCkDRespVO::getItemId).collect(Collectors.toList());
            //开始构建导出RespVO
            for(int i = 0; i < size; i++) {
                InvCkDExcelRespVO invVo = new InvCkDExcelRespVO();
                Long itemId = diffInvCkDs.get(i).getItemId();
                //根据id获取item的规格型号
                ItmItemRpcDtoParam itmItemPartParam = new ItmItemRpcDtoParam();
                itmItemPartParam.setItemIds(Arrays.asList(itemId));
                List<ItmItemRpcDTO> itemRpcDtoByParam = itmOutService.findItemRpcDtoByParam(itmItemPartParam);
                //如果查询商品数量为0，则抛异常
                if(itemRpcDtoByParam.size() == 0) {
                    throw new  BusinessException(ApiCode.FAIL,"查不到商品数据");
                }
                invVo.setSerNum(String.valueOf(i+1));
                invVo.setOuName(invCkAndCkDInfo.getOuName());
                invVo.setWhCode(invCkAndCkDInfo.getWhCode());
                invVo.setWhName(invCkAndCkDInfo.getWhName());
                invVo.setDeter2Code(diffInvCkDs.get(i).getDeter2());
                invVo.setDeter2Name(diffInvCkDs.get(i).getDeter2Name());
                invVo.setItemCode(diffInvCkDs.get(i).getItemCode());
                //拼接品类名称
                List<String> itemCatePathName = itemRpcDtoByParam.get(0).getItemCatePathName();
                String itemCateName = String.join("/",itemCatePathName);
                invVo.setItemCateName(itemCateName);
                invVo.setLotNo(diffInvCkDs.get(i).getLotNo());
                invVo.setBrandName(diffInvCkDs.get(i).getBrandName());
                invVo.setItemName(diffInvCkDs.get(i).getItemName());
                invVo.setSpec(itemRpcDtoByParam.get(0).getSpec());
                invVo.setUomName(diffInvCkDs.get(i).getUomName());
                invVo.setFactQty(diffInvCkDs.get(i).getFactQty());
                invVo.setAccQty(diffInvCkDs.get(i).getAccQty());
                invCkDExcelRespVOS.add(invVo);
            }
        }
        return invCkDExcelRespVOS;
    }*/

    /**
     *功能描述 增加动态表头
     * @author Brian.lai
     * @date 2021/7/6
     * @param
     * @return java.util.List<java.util.List < java.lang.String>>
     */
   /* @Override
    public List<List<String>> head() {
        List<List<String>> headTitles = CollUtil.newArrayList();
        String reDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        String title = "库存产品盘点表(导出时间:" + reDate + ")";
        headTitles.add(CollUtil.newArrayList(title, "序号"));
        headTitles.add(CollUtil.newArrayList(title, "公司名称"));
        headTitles.add(CollUtil.newArrayList(title,  "仓库编号"));
        headTitles.add(CollUtil.newArrayList(title, "仓库名称"));
        headTitles.add(CollUtil.newArrayList(title, "库区编号"));
        headTitles.add(CollUtil.newArrayList(title, "库区名称"));
        headTitles.add(CollUtil.newArrayList(title, "物料编码"));
        headTitles.add(CollUtil.newArrayList(title, "品类名称"));
        headTitles.add(CollUtil.newArrayList(title, "批次"));
        headTitles.add(CollUtil.newArrayList(title, "品牌名称"));
        headTitles.add(CollUtil.newArrayList(title, "规格型号"));
        headTitles.add(CollUtil.newArrayList(title, "物料名称"));
        headTitles.add(CollUtil.newArrayList(title, "单位"));
        headTitles.add(CollUtil.newArrayList(title, "账面数量"));
        headTitles.add(CollUtil.newArrayList(title, "实盘数量"));
        return headTitles;
    }*/


    /**
     * 获取盘点单明细
     *
     * @param whIdMap
     * @param invCkCreateParamVO
     * @return map key(主表id) val(明细集合)
     */
    private Map<Long, List<InvStkDTO>> getInvCkMap(Map<Long, Long> whIdMap, InvCkCreateParamVO invCkCreateParamVO) {
        Map<Long, List<InvStkDTO>> resultMap = Maps.newHashMap();
        // 商品id
        List<Long> itemIdList = invCkCreateParamVO.getItemIdList();
        for (Map.Entry<Long, Long> m : whIdMap.entrySet()) {
            InvStkQueryParamVO invStkQueryParamVO = new InvStkQueryParamVO();
            invStkQueryParamVO.setOuId(invCkCreateParamVO.getOuId());
            invStkQueryParamVO.setWhId(m.getKey());
            invStkQueryParamVO.setDeter2List(invCkCreateParamVO.getDeter2List());
            invStkQueryParamVO.setItemIdList(itemIdList);
            List<InvStkDTO> invStkDTOS = invStkDomainService.findInvStkRespVOs(invStkQueryParamVO);
            if (!CollectionUtils.isEmpty(invStkDTOS)) {
                resultMap.put(m.getValue(), invStkDTOS);
            }
        }
        return resultMap;
    }

    /**
     * 创建盘点单
     *
     * @param whIdList
     * @param invCkCreateParamVO
     * @return map key(仓库id) val(盘点单id)
     */
    private Map<Long, Long> createInvCk(List<Long> whIdList, InvCkCreateParamVO invCkCreateParamVO) {
        Map<Long, Long> whIdMap = Maps.newHashMap();
        for (Long whId : whIdList) {
            InvCk invCk = new InvCk();
            // 草稿
            invCk.setDocStatus(UdcEnum.INV_CK_STATUS_DR.getValueCode());
            invCk.setOuId(invCkCreateParamVO.getOuId());
            String docNo = systemService.sysNumberRuleGenerateCode(NumSendObjectEnum.INV_CK.getCode(), Arrays.asList(invCkCreateParamVO.getOuCode()));
            invCk.setDocNo(docNo);
            invCk.setDocType(invCkCreateParamVO.getDocType());
            if (CollectionUtils.isEmpty(invCkCreateParamVO.getItemIdList())) {
                invCk.setDocMode(UdcEnum.INV_CK_MODE_ALL.getValueCode());
            } else {
                invCk.setDocMode(UdcEnum.INV_CK_MODE_ITEM.getValueCode());
            }
            invCk.setDocMethod(invCkCreateParamVO.getDocMethod());
            invCk.setRemark(invCkCreateParamVO.getRemark());
            invCk.setWhId(whId);
            //数据权限
            try {
                invCk.setSecBuId(invCkCreateParamVO.getSecBuId() == null ? null : invCkCreateParamVO.getSecBuId());
                invCk.setSecOuId(invCkCreateParamVO.getOuId() == null ? null : invCkCreateParamVO.getOuId());
            } catch (Exception e) {
                log.error("无法获取当前登录人信息，请先登录：{}" + e.getMessage());
            }
            //invCkRepo.save(invCkDO);
            invCk.setIsAjStatus(0);
            Long invCkId = invCkDomainService.saveInvCk(invCk);
            whIdMap.put(whId, invCkId);
            //whIdMap.put(whId, invCk.getId());
        }
        return whIdMap;
    }

    private String getUdcDesc(String domain, String udcCode, String udcVal) {
        if (StringUtils.isEmpty(udcVal) || StringUtils.isEmpty(domain) || StringUtils.isEmpty(udcCode)) {
            return null;
        }
        Map<String, String> codeMap = systemService.sysUdcGetCodeMap(domain, udcCode);
        if (CollectionUtils.isEmpty(codeMap)) {
            return null;
        }
        if (codeMap.containsKey(udcVal)) {
            return codeMap.get(udcVal);
        }
        return null;
    }

    private void fillInvCkDRespVOS(List<InvCkDDTO> invCkDDTOList) {
        if (CollectionUtils.isEmpty(invCkDDTOList)) {
            return;
        }
        Map<String, String> udcUom = systemService.sysUdcGetCodeMap(UdcEnum.COM_UOM_BG.getModel(), UdcEnum.COM_UOM_BG.getCode());//单位
        //获取库存合作伙伴UDC
        Map<String, String> pTypeMap = systemService.sysUdcGetCodeMap(UdcEnum.INV_PARTNER_TYPE_EMP.getModel(), UdcEnum.INV_PARTNER_TYPE_EMP.getCode());
        List<String> deter2s = invCkDDTOList.stream().map(InvCkDDTO::getDeter2).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<Long> whIds = invCkDDTOList.stream().map(InvCkDDTO::getWhId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<InvWhAreaRespVO> whAreasList = new ArrayList<>();
        if(! CollectionUtils.isEmpty(deter2s) && ! CollectionUtils.isEmpty(whIds)){
            InvWhAreaParamVO invWhAreaParamVO = new InvWhAreaParamVO();
            invWhAreaParamVO.setWhIds(whIds);
            invWhAreaParamVO.setDeter2s(deter2s);
            whAreasList = invWhAreaDomainService.findWhAreasByParam(invWhAreaParamVO);
        }
        List<Long> itemIds = invCkDDTOList.stream().filter(f -> f.getItemId() != null).map(InvCkDDTO::getItemId).distinct().collect(Collectors.toList());
        ItmItemRpcDtoParam itmItemPartParam = new ItmItemRpcDtoParam();
        itmItemPartParam.setItemIds(itemIds);
        List<ItmItemRpcDTO> itmItemPartDTOS = itmOutService.findItemRpcDtoByParam(itmItemPartParam);
        List<InvWhAreaRespVO> finalWhAreasList = whAreasList;
        invCkDDTOList.stream().map(e -> {
            if(!CollectionUtils.isEmpty(finalWhAreasList)){
                finalWhAreasList.stream()
                        .filter(d -> d.getDeter2().equals(e.getDeter2()) && d.getWhId().equals(e.getWhId()))
                        .findAny().ifPresent(m -> {
                            e.setDeter2Name(m.getDeter2Name());
                });
            }
            //转换单位
            if (!CollectionUtils.isEmpty(udcUom) && udcUom.containsKey(e.getUom())) {
                e.setUomName(udcUom.get(e.getUom()));
            }
            //库存合作伙伴
            if (!StringUtils.isEmpty(e.getPType()) && !StringUtils.isEmpty(e.getPCode())) {
                InvParentParamVO orgQueryParamVO = new InvParentParamVO();
                orgQueryParamVO.setType(e.getPType());
                orgQueryParamVO.setCode(e.getPCode());
                List<OrgRespVO> vos = outouService.findcodeAndName(orgQueryParamVO);
                if(!CollectionUtils.isEmpty(vos)){
                    vos.stream().filter(m->m.getCode().equals(e.getPCode())).findFirst().ifPresent(n->{
                        e.setPName(n.getName());
                    });
                }
                if (MapUtils.isNotEmpty(pTypeMap)) {
                    e.setPTypeName(pTypeMap.get(e.getPType()));
                }
            }
            // 商品名称、编码、品牌转换
            if (!CollectionUtils.isEmpty(itmItemPartDTOS)) {
                itmItemPartDTOS.stream().filter(f -> f.getId().equals(e.getItemId())).findFirst().ifPresent(item -> {
                    e.setItemCode(item.getItemCode());
                    e.setItemName(item.getItemName());
                    e.setBrand(item.getBrand());
                    e.setBrandName(item.getBrandName());
                    e.setLotFlag(item.getLotFlag());
                    e.setSpec(item.getSpec());
                });
            }
            return e;
        }).collect(Collectors.toList());
    }


}
