package com.elitesland.yst.production.inv.application.service.impl;

import com.alibaba.excel.util.CollectionUtils;
import com.alibaba.excel.util.StringUtils;
import com.elitesland.yst.production.inv.application.facade.vo.InvIoSearchBatchParam;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvIoStkAcctRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.OrgRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.ioc.InvIocRespVO;
import com.elitesland.yst.production.inv.application.out.ItmOutService;
import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvIoService;
import com.elitesland.yst.production.inv.application.service.InvIocService;
import com.elitesland.yst.production.inv.domain.entity.invstk.InvIoDO;
import com.elitesland.yst.production.inv.domain.entity.invstk.QInvIoDO;
import com.elitesland.yst.production.inv.domain.service.InvWhAreaDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhDomainService;
import com.elitesland.yst.production.inv.infr.repo.InvIoRepo;
import com.elitesland.yst.production.inv.infr.repo.InvIoRepoProc;
import com.elitesland.yst.production.inv.utils.InvPTypeEnum;
import com.elitesland.yst.production.inv.utils.InvStk28Enum;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysUserVO;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmItemRpcDtoParam;
import lombok.AllArgsConstructor;
import lombok.val;
import org.apache.commons.collections4.MapUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;

@Service("InvIoService")
@AllArgsConstructor
public class InvIoServiceImpl implements InvIoService {

    private final InvIoRepoProc invIoRepoProc;

    private final SystemService systemService;

    private final InvWhDomainService invWhDomainService;
    private final InvWhAreaDomainService invWhAreaDomainService;
    private final InvIoRepo invIoRepo;
    private final ItmOutService itmOutService;
    private final OrgOutService orgOutService;

    private final InvIocService invIocService;

    @Override
    @SysCodeProc
    public PagingVO<InvIoStkAcctRespVO> searchStkAcct(InvIoSearchBatchParam param) {
        //品牌,商品入参查询
        if(param.getBrands()!=null || !StringUtils.isEmpty(param.getItemType()) ) {
            //商品查询
            ItmItemRpcDtoParam itmItemPartParam = new ItmItemRpcDtoParam();
            itmItemPartParam.setBrands(param.getBrands());
            itmItemPartParam.setItemType(param.getItemType());
            List<ItmItemRpcDTO> itmItemRpcDTOS = itmOutService.findItemRpcDtoByParam(itmItemPartParam);
            //当有数据时,放到入参中查询,没有数据直接返回空数据
            if(itmItemRpcDTOS.size()>0){
                List<Long> itemIds = itmItemRpcDTOS.stream().map(ItmItemRpcDTO::getId).distinct().collect(Collectors.toList());
                param.setItemIds(itemIds);
            }else {
                return PagingVO.<InvIoStkAcctRespVO>builder()
                        .total(0L)
                        .records(new ArrayList<>())
                        .build();
            }
        }
        val query=invIoRepoProc.searchStkAcct(param);
        invIoRepoProc.openOrderAndLimit(query,param, QInvIoDO.invIoDO);
        param.setPaging(query);
        val invIoDetailedVOList= query.fetch();
        if (org.springframework.util.CollectionUtils.isEmpty(invIoDetailedVOList)) {
            return PagingVO.<InvIoStkAcctRespVO>builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        List<String> pEmpCodes = invIoDetailedVOList.stream().filter(i -> UdcEnum.INV_PARTNER_TYPE_EMP.getValueCode().equals(i.getPType()))
                .map(InvIoStkAcctRespVO::getPCode).distinct().collect(Collectors.toList());
        List<String> pSuppCodes = invIoDetailedVOList.stream().filter(i -> UdcEnum.INV_PARTNER_TYPE_SUPP.getValueCode().equals(i.getPType()))
                .map(InvIoStkAcctRespVO::getPCode).distinct().collect(Collectors.toList());
        List<OrgRespVO> empList = orgOutService.findcodeAndNameList(InvPTypeEnum.INV_PARTNER_TYPE_EMP, pEmpCodes);
        List<OrgRespVO> suppList = orgOutService.findcodeAndNameList(InvPTypeEnum.INV_PARTNER_TYPE_SUPP, pSuppCodes);
        List<String> ioCodes = invIoDetailedVOList.stream().map(InvIoStkAcctRespVO::getIoCode)
                .filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<InvIocRespVO> invIocRespVOS = invIocService.findByCodeBatch(ioCodes);
        invIoDetailedVOList.forEach(v -> {
            if(!StringUtils.isEmpty(v.getIoDate())){
                v.setSrcDate(formatDateTime(v.getIoDate()));
            }
            if(!CollectionUtils.isEmpty(invIocRespVOS)) {
                invIocRespVOS.stream().filter(io -> io.getIoCode().equals(v.getIoCode()))
                        .findAny().ifPresent(m -> {
                    v.setIoCodeName(m.getIoName());
                });
            }
            // 合作伙伴名称转换
            if(v.getPCode() != null && UdcEnum.INV_PARTNER_TYPE_EMP.getValueCode().equals(v.getPType())){
                empList.stream().filter(s -> s.getCode().equals(v.getPCode())).findAny()
                        .ifPresent(o -> v.setPName(o.getName()));
            }
            if(v.getPCode() != null && UdcEnum.INV_PARTNER_TYPE_SUPP.getValueCode().equals(v.getPType())){
                suppList.stream().filter(s -> s.getCode().equals(v.getPCode())).findAny()
                        .ifPresent(o -> v.setPName(o.getName()));
            }
        });
        //调用商品,仓库,公司接口数据组装
        results(invIoDetailedVOList);
        //UDC转换
        List<InvIoStkAcctRespVO> invIoStkAcctRespVOS = udcChange(invIoDetailedVOList);
        return PagingVO.<InvIoStkAcctRespVO>builder()
                .total(query.fetchCount())
                .records(invIoStkAcctRespVOS)
                .build();
    }

    public static String formatDateTime(LocalDateTime dateTime) {
        if(dateTime == null) {
            return "";
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return dateTime.format(formatter);
    }

    @Override
    @Transactional
    public List<Long> createBatch(List<InvIoDO> list) {
        return invIoRepo.saveAll(list).stream().map(InvIoDO::getId).collect(Collectors.toList());
    }



    /**
     * //调用商品,仓库,公司接口数据组装
     * @param invIoDetailedVOList
     */
    public void results(List<InvIoStkAcctRespVO> invIoDetailedVOList){
        //商品数据查询
        val itemIdList=invIoDetailedVOList.stream().map(InvIoStkAcctRespVO::getItemId).collect(Collectors.toList());
        ItmItemRpcDtoParam itmItemPartParam = new ItmItemRpcDtoParam();
        itmItemPartParam.setItemIds(itemIdList);
        List<ItmItemRpcDTO> itmItemDTOS = itmOutService.findItemRpcDtoByParam(itmItemPartParam);
        val ouIdList=invIoDetailedVOList.stream().map(InvIoStkAcctRespVO::getOuId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        val ouVoList= orgOutService.findOuByIds(ouIdList);
        List<Long> createUserIds = invIoDetailedVOList.stream().map(InvIoStkAcctRespVO::getCreateUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<SysUserVO> empsByIdIn = systemService.findAllEmpsByIdIn(createUserIds);
        Map<String, String> docClsMap = systemService.sysUdcGetCodeMap(UdcEnum.COM_DOC_CLS_STKAJ.getModel(), UdcEnum.COM_DOC_CLS_STKAJ.getCode());
        invIoDetailedVOList.forEach(v ->{
            if(!docClsMap.isEmpty() && docClsMap.containsKey(v.getSrcDocCls())){
                v.setSrcDocClsName(docClsMap.get(v.getSrcDocCls()));
            }
            if(!CollectionUtils.isEmpty(itmItemDTOS)) {
                itmItemDTOS.stream().filter(i -> i.getId().equals(v.getItemId()))
                        .findAny().ifPresent(m -> {
                    v.setItemCode(m.getItemCode());
                    v.setItemName(m.getItemName());
                    v.setPackageSpec(m.getPackageSpec());
                    v.setBrand(m.getBrand());
                    v.setBrandName(m.getBrandName());
                    v.setBarCode(m.getBarCode());
                    v.setBrandName(m.getBrandName());
                    v.setItemType(m.getItemType());
                    v.setGuaranteeDays(m.getGuaranteeDays());
                    v.setGuaranteePeriod(m.getGuaranteePeriod());
                });
            }
            if(!CollectionUtils.isEmpty(ouVoList)) {
                ouVoList.stream().filter(i -> i.getId().equals(v.getOuId()))
                        .findAny().ifPresent(m -> {
                    v.setOuCode(m.getOuCode());
                    v.setOuName(m.getOuName());
                });
            }
            if(!CollectionUtils.isEmpty(empsByIdIn)){
                empsByIdIn.stream().filter(e -> e.getId().equals(v.getCreateUserId())).findAny().ifPresent(m ->{
                    v.setCreator(m.getUsername());
                });
            }
        });

    }


    /**
     * UDC手动转换
     * @param asms
     * @return
     */
    public List<InvIoStkAcctRespVO> udcChange(List<InvIoStkAcctRespVO>  asms){
        //进行UDC转换(udcEnum只使用model，code)
        Map<String, String> udcUom = systemService.sysUdcGetCodeMap(UdcEnum.COM_UOM_BG.getModel(), UdcEnum.COM_UOM_BG.getCode());
        Map<String, String> udcDoccls = systemService.sysUdcGetCodeMap(UdcEnum.COM_DOC_CLS_SPA.getModel(), UdcEnum.COM_DOC_CLS_SPA.getCode());
        asms.stream().forEach(Asm->{
            if(org.apache.commons.lang3.StringUtils.isNotBlank(Asm.getSrcDocCls()) && !MapUtils.isEmpty(udcDoccls)){
                Asm.setSrcDocClsName(udcDoccls.get(Asm.getSrcDocCls()));
            }
            if(org.apache.commons.lang3.StringUtils.isNotBlank(Asm.getUom()) && !MapUtils.isEmpty(udcUom)){
                Asm.setUomName(udcUom.get(Asm.getUom()));
            }
        });
        return asms;
    }
}
