package com.elitesland.yst.production.inv.application.web.controller;

import com.elitesland.yst.production.inv.application.facade.vo.InvAsmAndAsmDSaveVO;
import com.elitesland.yst.production.inv.application.service.InvAsmService;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * @author lu.wang
 * @date 2020-08-11 17:03
 * Desc:
 */
@RestController
@RequestMapping("/inv/invasm")
@Api(value = "库内组装单", tags = {"库内组装单"})
@AllArgsConstructor
public class InvAsmController {

    private final InvAsmService invAsmService;


    /**
     * 通过主键查询单条数据
     * 暂时没有数据，需要仓库，员工接口
     * @param id 主键
     * @return 单条数据
     */
    @GetMapping("/findIdOne/{id}")
    @ApiOperation("通过主键查询详情")
    public ApiResult<?> findIdOne(@PathVariable Long id) {
        return invAsmService.findIdOne(id).map(ApiResult::ok).orElse(ApiResult.fail(ApiCode.NOT_FOUND));
    }


    /**
     * 新增数据
     *
     * @param inv 新增数据头信息
     * @return 新增数据情况
     */
    @PostMapping("/add")
    @ApiOperation("创建组装单，同时保存明细")
    public ApiResult<?> create(@RequestBody InvAsmAndAsmDSaveVO inv) {
        val id = invAsmService.create(inv);
        return ApiResult.ok(String.valueOf(id));
    }

    /**
     * 批量取消组装单
     *
     * @param ids 组装单ids
     * @return 取消单据ids
     */
    @PutMapping("/cancel")
    @ApiOperation("批量取消组装单")
    public ApiResult<?> cancelInBatch(@RequestBody List<Long> ids) {
        val ret = invAsmService.updateStatusInBatch(ids, "CL");
        return ApiResult.ok(ret);
    }

    /**
     * 提交组装单
     *
     * @param id 组装id
     * @return 单据id
     */
    @PostMapping("/submit/{id}")
    @ApiOperation("提交组装单")
    public ApiResult<?> submit(@PathVariable Long id) {
        val ret = invAsmService.submit(id);
        return ApiResult.ok(String.valueOf(ret));
    }

}
