package com.elitesland.yst.production.inv.application.web.controller;


import com.elitesland.yst.production.inv.application.facade.vo.ioc.InvIocParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.ioc.InvIocRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.ioc.InvIocSaveVO;
import com.elitesland.yst.production.inv.application.service.InvIocService;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2022/04/19
 * @Version 1.0
 * @Content:
 */
@RestController
@RequestMapping("/inv/ioc")
@Api(value = "库存操作码", tags = {"库存操作码"})
@AllArgsConstructor
public class InvIocController {

    private final InvIocService invIocService;


    /**
     * 新增库存操作码数据
     *
     * @param saveVo 新增库存操作码数据
     * @return 新增库存操作码ID
     */
    @PostMapping("/createOne")
    @ApiOperation("新增库存操作码数据")
    public ApiResult<Long> createOne(@RequestBody InvIocSaveVO saveVo) {
        return invIocService.createOne(saveVo);
    }

    /**
     * 修改库存操作码数据
     *
     * @param saveVo 修改库存操作码对象
     * @return 库存操作码ID
     */
    @PutMapping("/update")
    @ApiOperation("修改库存操作码数据")
    public ApiResult<Long> update(@RequestBody InvIocSaveVO saveVo) {
        return invIocService.update(saveVo);
    }

    /**
     * 通过库存操作码ID查询单条数据
     *
     * @param id 库存操作码ID
     * @return 单条库存操作码数据
     */
    @GetMapping("/findIdOne/{id}")
    @ApiOperation("通过库存操作码ID查询单条数据")
    public ApiResult<InvIocRespVO> findIdOne(@PathVariable Long id) {
        return invIocService.findIdOne(id);
    }

    /**
     * 分页查询库存操作码
     *
     * @param param 分类查询、分页和排序对象
     * @return 多条库存操作码数据
     */
    @PostMapping("/search")
    @ApiOperation("分页查询库存操作码")
    public ApiResult<PagingVO<InvIocRespVO>> search(@RequestBody InvIocParamVO param) {
        val ret = invIocService.search(param);
        return ApiResult.ok(ret);
    }

    /**
     * 根据入参查询库存操作码
     *
     * @param param 分类查询、分页和排序对象
     * @return 多条库存操作码数据
     */
    @PostMapping("/select")
    @ApiOperation("根据入参查询库存操作码")
    public ApiResult<List<InvIocRespVO>> select(@RequestBody InvIocParamVO param) {
        val ret = invIocService.select(param);
        return ApiResult.ok(ret);
    }

    /**
     * 根据库存操作码ID批量逻辑删除
     *
     * @param ids 库存操作码ID集合
     * @return 库存操作码ID集合
     */
    @DeleteMapping("/deleteBatch")
    @ApiOperation("根据库存操作码ID批量逻辑删除")
    public ApiResult<String> deleteBatch(@RequestBody List<Long> ids) {
        return invIocService.deleteBatch(ids);
    }
}
