package com.elitesland.yst.production.inv.application.web.controller;

import com.elitesland.yst.production.inv.application.facade.export.invstk.InvlotDExcelRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.base.InvBaseModel;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.*;
import com.elitesland.yst.production.inv.application.service.InvStkService;
import com.elitesland.yst.production.inv.domain.convert.invstk.InvStkConvert;
import com.elitesland.yst.production.inv.utils.ExcelWriteUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author ssy
 * @since 2020-08-04 10:58:06
 */
@Validated
@RestController
@RequestMapping("/inv/invStk")
@Api(value = "库存查询", tags = {"库存查询"})
@AllArgsConstructor
public class InvStkController {

    private final InvStkService invStkService;


    @PostMapping("/searchD")
    @ApiOperation("库存查询-库存余额查询（分页）")
    public ApiResult<PagingVO<InvStkGroupRespVO>> searchD(@RequestBody InvStkQueryGroupParamVO param) {
        val ret = invStkService.searchD(param);
        return ApiResult.ok(ret);
    }

    /**
     * 库存明细查询
     *
     * @param param 分类查询、分页和排序对象
     * @return 库存多条数据
     */
    @PostMapping("/fullSearch")
    @ApiOperation("库存明细查询")
    public ApiResult<PagingVO<InvStkGroupRespVO>> fullSearch(@RequestBody InvStkQueryGroupParamVO param) {
        var ret = invStkService.fullSearch(param);
        return ApiResult.ok(ret);
    }


    @ApiOperation("库存查询-库存批次查询")
    @PostMapping("/searchInvLot")
    public ApiResult<?> searchInvLot(@RequestBody InvStkDQueryParamVO param) {
        val ret = invStkService.searchLot(param);
        return ApiResult.ok(ret);
    }

    @PostMapping("/searchInvLot/export")
    @ApiOperation("库存查询-库存批次查询-库存批次查询导出")
    public void lotExport(HttpServletResponse response, @RequestBody InvStkDQueryParamVO param) throws IOException {
        param.setSize(20000);
        val ret = invStkService.searchLot(param).getRecords();
        List<InvlotDExcelRespVO> records = ret.stream().map(v -> {
            InvlotDExcelRespVO newDo = InvStkConvert.INSTANCE.lotRespVOTOExcelVO(v);
            return newDo;
        }).collect(Collectors.toList());
        ExcelWriteUtil.excelWrite(response, records, InvlotDExcelRespVO.class, "库存批次查询", "批次库存查询导出");
    }

    @PostMapping("/searchGroupInvStk")
    @ApiOperation("库存可供量统计查询")
    public ApiResult<?> searchInvStkCollection(@RequestBody InvBaseModel param) {
        val ret = invStkService.getInvStkGroupByParam(param);
        if (ret == null) {
            return ApiResult.builder().success(true).code(0).msg("库存不存在，请检查！").data(null).build();
        }
        return ApiResult.ok(ret);
    }

    @PostMapping("/searchGroupInvStkBatch")
    @ApiOperation("库存可供量批量查询")
    public ApiResult<?> searchInvStkBatch(@RequestBody InvStkGroupBatchParamVO param) {
        val ret = invStkService.getInvStkGroupBatchByParam(param);
        if (ret == null) {
            return ApiResult.builder().success(true).code(0).msg("库存不存在，请检查！").data(null).build();
        }
        return ApiResult.ok(ret);
    }

    @PostMapping("/searchInvStkItems")
    @ApiOperation("在库库存商品查询")
    public ApiResult<PagingVO<ItmInvStkItemRespVO>> searchInvStkItemList(@RequestBody InvStkItemQueryParam param) {
        PagingVO<ItmInvStkItemRespVO> ret = invStkService.searchInvStkItem(param);
        return ApiResult.ok(ret);
    }

    @PostMapping("/getInvStk")
    @ApiOperation("库存查询-商品库存查询")
    public ApiResult<List<ItmInvStkItemRespVO>> getInvStkItem(@RequestBody InvStkItemQueryParam param) {
        val ret = invStkService.getInvStkItemByParam(param);
        return ApiResult.ok(ret);
    }

}
