package com.elitesland.yst.production.inv.domain.entity;

/**
 * INV_AJ_D
 * InvAjDDO
 * 库存调整明细
 *
 * @author lich.chen
 * @date 2020/07/29 14:07:16
 */


import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * 库存调整明细
 */
@Entity
@Table(name = "inv_aj_d")
@org.hibernate.annotations.Table(appliesTo = "inv_aj_d", comment = "库存调整明细")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@ApiModel(value = "INV_AJ_D", description = "库存调整明细")
public class InvAjDDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = 8940425471533003377L;
    @ApiModelProperty("主表ID")
    @Column(name = "mas_id", columnDefinition = "bigint(20)  comment '主表ID'")
    Long masId;

    @ApiModelProperty("行号")
    @Column(columnDefinition = "NUMERIC(20,3)   comment '行号'")
    Double lineNo;

    @ApiModelProperty("行状态")
    @Column(name = "line_status", columnDefinition = "varchar(40)  comment '行状态'")
    String lineStatus;

    @ApiModelProperty("行类型")
    @Column(name = "line_type", columnDefinition = "varchar(40)  comment '行类型'")
    String lineType;

    @ApiModelProperty("仓库ID")
    @Column(name = "wh_id", columnDefinition = "bigint(20)  comment '仓库ID'")
    Long whId;

    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    @Column(name = "deter1", columnDefinition = "varchar(40)  comment '温层 [UDC]INV:TEMP_TYPE'")
    String deter1;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    @Column(name = "deter2", columnDefinition = "varchar(40)  comment '功能区 [UDC]INV:FUNC_TYPE'")
    String deter2;

    @ApiModelProperty("客户标识")
    @Column(name = "deter3", columnDefinition = "varchar(40)  comment '客户标识'")
    String deter3;

    @ApiModelProperty("限定4")
    @Column(name = "deter4", columnDefinition = "varchar(40)  comment '限定4'")
    String deter4;

    @ApiModelProperty("限定5")
    @Column(name = "deter5", columnDefinition = "varchar(40)  comment '限定5'")
    String deter5;

    @ApiModelProperty("限定6")
    @Column(name = "deter6", columnDefinition = "varchar(40)  comment '限定6'")
    String deter6;

    @ApiModelProperty("限定7")
    @Column(name = "deter7", columnDefinition = "varchar(40)  comment '限定7'")
    String deter7;

    @ApiModelProperty("限定8")
    @Column(name = "deter8", columnDefinition = "varchar(40)  comment '限定8'")
    String deter8;

    @ApiModelProperty("品项ID")
    @Column(name = "item_id", columnDefinition = "bigint(20)  comment '品项ID'")
    Long itemId;

    @ApiModelProperty("异构ID")
    @Column(name = "vari_id", columnDefinition = "bigint default 0  comment '异构ID'")
    Long variId;

    @ApiModelProperty("批次")
    @Column(name = "lot_no", columnDefinition = "varchar(40)  comment '批次'")
    String lotNo;

    @ApiModelProperty("新批次号")
    @Column(name = "to_lot_no", columnDefinition = "varchar(40)  comment '新批次号'")
    String toLotNo;

    @ApiModelProperty("序列号")
    @Column(name = "sn_no", columnDefinition = "varchar(40)  comment '序列号'")
    String snNo;

    @ApiModelProperty("调整数量")
    @Column(name = "qty", columnDefinition = "NUMERIC(20,8) comment '调整数量'")
    BigDecimal qty;

    @ApiModelProperty("单位")
    @Column(name = "uom", columnDefinition = "varchar(10)  comment '单位'")
    String uom;

    @ApiModelProperty("调整数量2")
    @Column(name = "qty2", columnDefinition = "NUMERIC(20,8) comment '调整数量2'")
    BigDecimal qty2;

    @ApiModelProperty("单位2")
    @Column(name = "uom2", columnDefinition = "varchar(10)  comment '单位2'")
    String uom2;

    @ApiModelProperty("单位转换率")
    @Column(name = "uom_ratio", columnDefinition = "float(20,8)   comment '单位转换率'")
    Double uomRatio;

    @ApiModelProperty("单位转换率2")
    @Column(name = "uom_ratio2", columnDefinition = "float(20,8)   comment '单位转换率2'")
    Double uomRatio2;

    @ApiModelProperty("生产日期 修改批次信息时，要联动修改批次主档中的信息，可能变批次号，要检查此批次没有过出入记录才行")
    @Column(name = "manu_date")
    @Comment("生产日期")
    LocalDateTime manuDate;

    @ApiModelProperty("生产批次")
    @Column(name = "menu_lot_no", columnDefinition = "varchar(40)  comment '生产批次'")
    String menuLotNo;

    @ApiModelProperty("失效日期")
    @Column()
    @Comment("失效日期")
    LocalDateTime expireDate;

    @ApiModelProperty("实物是否销毁")
    @Column(name = "destroy_flag", columnDefinition = " int(1)   comment '实物是否销毁'")
    Boolean destroyFlag;

    @ApiModelProperty("销毁日期")
    @Column()
    @Comment("销毁日期")
    LocalDateTime destroyDate;

    @ApiModelProperty("销毁登记员工ID")
    @Column(name = "destroy_emp_id", columnDefinition = "bigint(20)  comment '销毁登记员工ID'")
    Long destroyEmpId;

    @ApiModelProperty("承运商供应商ID")
    @Column(name = "carrier_supp_id", columnDefinition = "bigint(20)  comment '承运商供应商ID'")
    Long carrierSuppId;

    @ApiModelProperty("承运商")
    @Column(name = "carrier", columnDefinition = "varchar(40)  comment '承运商'")
    String carrier;

    @ApiModelProperty("含税金额")
    @Column(name = "amt", columnDefinition = "NUMERIC(20,4)   comment '含税金额'")
    BigDecimal amt;

    @ApiModelProperty("销售金额")
    @Column(name = "sell_amt", columnDefinition = "NUMERIC(20,4)   comment '销售金额'")
    BigDecimal sellAmt;

    @ApiModelProperty("销售单价")
    @Column(name = "sell_price", columnDefinition = "NUMERIC(20,4)   comment '销售单价'")
    BigDecimal sellPrice;

    @ApiModelProperty("不含税金额")
    @Column(name = "net_amt", columnDefinition = "NUMERIC(20,4)   comment '不含税金额'")
    BigDecimal netAmt;

    @ApiModelProperty("记账币种")
    @Column(name = "home_curr", columnDefinition = "varchar(10)  comment '记账币种'")
    String homeCurr;

    @ApiModelProperty("交易币种")
    @Column(name = "curr_code", columnDefinition = "varchar(10)  comment '交易币种'")
    String currCode;

    @ApiModelProperty("汇率")
    @Column(name = "curr_rate", columnDefinition = "NUMERIC(20,8)   comment '汇率'")
    Double currRate;

    @ApiModelProperty("外币不含税金额")
    @Column(name = "curr_net_amt", columnDefinition = "NUMERIC(20,4)   comment '外币不含税金额'")
    BigDecimal currNetAmt;

    @ApiModelProperty("外币含税金额")
    @Column(name = "curr_amt", columnDefinition = "NUMERIC(20,4)   comment '外币含税金额'")
    BigDecimal currAmt;

    @ApiModelProperty("单位成本")
    @Column(name = "cost_price", columnDefinition = "NUMERIC(20,4)   comment '单位成本'")
    BigDecimal costPrice;

    @ApiModelProperty("成本金额")
    @Column(name = "cost_amt", columnDefinition = "NUMERIC(20,4)   comment '成本金额'")
    BigDecimal costAmt;

    @ApiModelProperty("关联单据类别 如RMA，盘点单。[UDC]COM:DOC_CLS")
    @Column(name = "relate_doc_cls", columnDefinition = "varchar(40)  comment '关联单据类别 如RMA，盘点单。[UDC]COM:DOC_CLS'")
    String relateDocCls;

    @ApiModelProperty("关联单据类型")
    @Column(name = "relate_doc_type", columnDefinition = "varchar(40)  comment '关联单据类型'")
    String relateDocType;

    @ApiModelProperty("关联单据ID")
    @Column(name = "relate_doc_id", columnDefinition = "bigint(20)  comment '关联单据ID'")
    Long relateDocId;

    @ApiModelProperty("关联单据编号")
    @Column(name = "relate_doc_no", columnDefinition = "varchar(40)  comment '关联单据编号'")
    String relateDocNo;

    @ApiModelProperty("关联单据明细ID")
    @Column(name = "relate_doc_did", columnDefinition = "bigint(20)  comment '关联单据明细ID'")
    Long relateDocDid;

    @ApiModelProperty("关联单据行号")
    @Column(name = "relate_doc_lineno", columnDefinition = "float(20,2)   comment '关联单据行号'")
    Double relateDocLineno;

    @ApiModelProperty("原因码 [UDC]COM:REASON_CODE")
    @Column(name = "reason_code", columnDefinition = "varchar(100)  comment '原因码 [UDC]COM:REASON_CODE'")
    String reasonCode;

    @ApiModelProperty("外部单据公司")
    @Column(name = "outer_ou", columnDefinition = "varchar(40)  comment '外部单据公司'")
    String outerOu;

    @ApiModelProperty("外部单据类型")
    @Column(name = "outer_type", columnDefinition = "varchar(40)  comment '外部单据类型'")
    String outerType;

    @ApiModelProperty("外部单据编号")
    @Column(name = "outer_no", columnDefinition = "varchar(40)  comment '外部单据编号'")
    String outerNo;

    @ApiModelProperty("外部单据行号")
    @Column(name = "outer_lineno", columnDefinition = "varchar(40)  comment '外部单据行号'")
    String outerLineno;

    @ApiModelProperty("WMS单据号")
    @Column(name = "wms_no", columnDefinition = "varchar(40)  comment 'WMS单据号'")
    String wmsNo;

    @ApiModelProperty("WMS单据行号")
    @Column(name = "wms_lineno", columnDefinition = "varchar(40)  comment 'WMS单据行号'")
    String wmsLineno;

    @ApiModelProperty("合作伙伴编码")
    @Column(name = "p_code", columnDefinition = "varchar(20)  comment '合作伙伴编码'")
    String pCode;

    @ApiModelProperty("合作伙伴类型")
    @Column(name = "p_type", columnDefinition = "varchar(100)  comment '合作伙伴类型'")
    String pType;

    @ApiModelProperty("调整金额")
    @Column(name = "aj_amt", columnDefinition = "NUMERIC(20,8)   comment '调整金额'")
    BigDecimal ajAmt;

    @ApiModelProperty("限定字段1")
    @Column(name = "limit1", columnDefinition = "varchar(64) comment '限定字段1'")
    String limit1;

    @ApiModelProperty("限定字段2")
    @Column(name = "limit2", columnDefinition = "varchar(64) comment '限定字段2'")
    String limit2;

    @ApiModelProperty("限定字段3")
    @Column(name = "limit3", columnDefinition = "varchar(64) comment '限定字段3'")
    String limit3;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InvAjDDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InvAjDDO entity = (InvAjDDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }
}


