package com.elitesland.yst.production.inv.domain.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * <p>
 * 系统设置项
 * </p >
 *
 * @author ssy
 * @date 2020/8/19
 */
@Entity
@Table(name = "inv_setting")
@org.hibernate.annotations.Table(appliesTo = "inv_setting", comment = "设置项")
@Data
@Accessors(chain = true)
@ApiModel(value = "INV_SETTING", description = "设置项")
public class InvSettingDO extends BaseModel implements Serializable
{
    @ApiModelProperty("设置编号")
    @Column(name="setting_no" , columnDefinition = "varchar(40)  comment '设置编号'")
    String settingNo;

    @ApiModelProperty("设置名")
    @Column(name="setting_name" , columnDefinition = "varchar(40)  comment '设置名'")
    String settingName;

    @ApiModelProperty("设置类型")
    @Column(name="setting_type" , columnDefinition = "varchar(40)  comment '设置类型'")
    String settingType;

    @ApiModelProperty("设置类型2")
    @Column(name="setting_type2" , columnDefinition = "varchar(40)  comment '设置类型2'")
    String settingType2;

    @ApiModelProperty("设置类型3")
    @Column(name="setting_type3" , columnDefinition = "varchar(40)  comment '设置类型3'")
    String settingType3;

    @ApiModelProperty("设置状态")
    @Column(name="setting_status" , columnDefinition = "varchar(40)  comment '设置状态'")
    String settingStatus;

    @ApiModelProperty("设置描述")
    @Column(name="setting_desc" , columnDefinition = "varchar(500)  comment '设置描述'")
    String settingDesc;

    @ApiModelProperty("设置值")
    @Column(name="setting_val" , columnDefinition = "varchar(500)  comment '设置值'")
    String settingVal;

    @ApiModelProperty("默认值")
    @Column(name="def_val" , columnDefinition = "varchar(100)  comment '默认值'")
    String defVal;

    @ApiModelProperty("排序号")
    @Column(name="sort_no" , columnDefinition = "int(18)  comment '排序号'")
    Integer sortNo;
}