package com.elitesland.yst.production.inv.domain.entity.ck;

import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2022/04/14
 * @Version 1.0
 * @Content:
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class InvCk extends BaseModel implements Serializable {
    private static final long serialVersionUID = -8754643622408878567L;

    @ApiModelProperty("公司ID")
    Long ouId;

    @ApiModelProperty("BUID")
    Long buId;

    @ApiModelProperty("单据编号")
    String docNo;

    @ApiModelProperty("盘点类型 [UDC]INV:CK_TYPE")
    String docType;

    @ApiModelProperty("盘点方式 [UDC]INV:CK_METHOD")
    String docMethod;

    @ApiModelProperty("盘点模式 [UDC]INV:CK_MODE")
    String docMode;

    @ApiModelProperty("盘点单状态 [UDC]INV:CK_STATUS")
    String docStatus;

    @ApiModelProperty("盘点日期")
    LocalDateTime docDate;

    @ApiModelProperty("审批状态 [UDC]COM:APPR_STATUS")
    String apprStatus;

    @ApiModelProperty("审批时间")
    LocalDateTime apprTime;

    @ApiModelProperty("审批人ID")
    Long apprUserId;

    @ApiModelProperty("审批意见")
    String apprComment;

    @ApiModelProperty("申请人员工ID")
    Long applyEmpId;

    @ApiModelProperty("申请日期")
    LocalDateTime applyDate;

    @ApiModelProperty("申请描述")
    String applyDesc;

    @ApiModelProperty("交易日期 实际出入库日期")
    LocalDateTime ioDate;

    @ApiModelProperty("仓库ID")
    Long whId;

    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    String deter1;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    String deter2;

    @ApiModelProperty("客户标识")
    String deter3;

    @ApiModelProperty("限定4")
    String deter4;

    @ApiModelProperty("限定5")
    String deter5;

    @ApiModelProperty("限定6")
    String deter6;

    @ApiModelProperty("限定7")
    String deter7;

    @ApiModelProperty("限定8")
    String deter8;

    @ApiModelProperty("品牌")
    String brand;

    @ApiModelProperty("品项ID")
    Long itemId;

    @ApiModelProperty("批次")
    String lotNo;

    @ApiModelProperty("转调整单状态")
    Integer isAjStatus;

    /**
     * 工作流字段
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程实例状态")
    private ProcInstStatus procInstStatus;

    @ApiModelProperty(value = "提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty(value = "审批通过时间")
    private LocalDateTime approvedTime;

    @ApiModelProperty("单据类别")
    private String docCls;

}
