package com.elitesland.yst.production.inv.domain.entity.ck;

import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * @author lvqf
 * @date 2021-02-10
 */
@Entity
@Table(name = "inv_ck")
@DynamicInsert
@DynamicUpdate
@org.hibernate.annotations.Table(appliesTo = "inv_ck", comment = "库存盘点")
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "INV_CK", description = "库存盘点")
public class InvCkDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = -2929925813068441264L;

    @ApiModelProperty("公司ID")
    @Column(name = "ou_id", columnDefinition = "bigint(20)  comment '公司ID'")
    Long ouId;

    @ApiModelProperty("BUID")
    @Column(name = "bu_id", columnDefinition = "bigint(20)  comment 'BUID'")
    Long buId;

    @ApiModelProperty("单据编号")
    @Column(name = "doc_no", columnDefinition = "varchar(40)  comment '单据编号'")
    String docNo;

    @ApiModelProperty("盘点类型 [UDC]INV:CK_TYPE")
    @Column(name = "doc_type", columnDefinition = "varchar(10)  comment '盘点类型 [UDC]INV:CK_TYPE'")
    String docType;

    @ApiModelProperty("盘点方式 [UDC]INV:CK_METHOD")
    @Column(name = "doc_method", columnDefinition = "varchar(40)  comment '盘点方式 [UDC]INV:CK_METHOD'")
    String docMethod;

    @ApiModelProperty("盘点模式 [UDC]INV:CK_MODE")
    @Column(name = "doc_mode", columnDefinition = "varchar(40)  comment '盘点模式 [UDC]INV:CK_MODE'")
    String docMode;

    @ApiModelProperty("盘点单状态 [UDC]INV:CK_STATUS")
    @Column(name = "doc_status", columnDefinition = "varchar(40)  comment '盘点单状态 [UDC]INV:CK_STATUS'")
    String docStatus;

    @ApiModelProperty("盘点日期")
    @Column()
    @Comment("盘点日期")
    LocalDateTime docDate;

    @ApiModelProperty("审批状态 [UDC]COM:APPR_STATUS")
    @Column(name = "appr_status", columnDefinition = "varchar(40)  comment '审批状态 [UDC]COM:APPR_STATUS'")
    String apprStatus;

    @ApiModelProperty("审批时间")
    @Column()
    @Comment("审批时间")
    LocalDateTime apprTime;

    @ApiModelProperty("审批人ID")
    @Column(name = "appr_user_id", columnDefinition = "bigint(20)  comment '审批人ID'")
    Long apprUserId;

    @ApiModelProperty("审批人名")
    @Column(name = "appr_user_name", columnDefinition = "varchar(64)  comment '审批人名'")
    String apprUserName;

    @ApiModelProperty("审批意见")
    @Column(name = "appr_comment", columnDefinition = "varchar(500)  comment '审批意见'")
    String apprComment;

    @ApiModelProperty("申请人员工ID")
    @Column(name = "apply_emp_id", columnDefinition = "bigint(20)  comment '申请人员工ID'")
    Long applyEmpId;

    @ApiModelProperty("申请日期")
    @Column()
    @Comment("申请日期")
    LocalDateTime applyDate;

    @ApiModelProperty("申请描述")
    @Column(name = "apply_desc", columnDefinition = "varchar(100)  comment '申请描述'")
    String applyDesc;

    @ApiModelProperty("交易日期 实际出入库日期")
    @Column()
    @Comment("交易日期")
    LocalDateTime ioDate;

    @ApiModelProperty("仓库ID")
    @Column(name = "wh_id", columnDefinition = "bigint(20)  comment '仓库ID'")
    Long whId;

    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    @Column(name = "deter1", columnDefinition = "varchar(40)  comment '温层 [UDC]INV:TEMP_TYPE'")
    String deter1;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    @Column(name = "deter2", columnDefinition = "varchar(40)  comment '功能区 [UDC]INV:FUNC_TYPE'")
    String deter2;

    @ApiModelProperty("客户标识")
    @Column(name = "deter3", columnDefinition = "varchar(40)  comment '客户标识'")
    String deter3;

    @ApiModelProperty("限定4")
    @Column(name = "deter4", columnDefinition = "varchar(40)  comment '限定4'")
    String deter4;

    @ApiModelProperty("限定5")
    @Column(name = "deter5", columnDefinition = "varchar(40)  comment '限定5'")
    String deter5;

    @ApiModelProperty("限定6")
    @Column(name = "deter6", columnDefinition = "varchar(40)  comment '限定6'")
    String deter6;

    @ApiModelProperty("限定7")
    @Column(name = "deter7", columnDefinition = "varchar(40)  comment '限定7'")
    String deter7;

    @ApiModelProperty("限定8")
    @Column(name = "deter8", columnDefinition = "varchar(40)  comment '限定8'")
    String deter8;

    @ApiModelProperty("品牌")
    @Column(name = "brand", columnDefinition = "varchar(40)  comment '品牌'")
    String brand;

    @ApiModelProperty("品项ID")
    @Column(name = "item_id", columnDefinition = "bigint(20)  comment '品项ID'")
    Long itemId;

    @ApiModelProperty("批次")
    @Column(name = "lot_no", columnDefinition = "varchar(40)  comment '批次'")
    String lotNo;

    @ApiModelProperty("转调整单状态")
    @Column(name = "is_aj_status", columnDefinition = "int(11) default 0 comment '转调整单状态0：否，1是'")
    Integer isAjStatus;

    /**
     * 工作流字段
     */
    @ApiModelProperty("流程实例ID")
    @Column
    @Comment("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程实例状态")
    @Column
    @Comment("流程实例状态")
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;

    @ApiModelProperty(value = "提交时间")
    @Comment("提交时间")
    @Column
    private LocalDateTime submitTime;

    @ApiModelProperty(value = "审批通过时间")
    @Comment("审批通过时间")
    @Column
    private LocalDateTime approvedTime;

    @ApiModelProperty("单据类别")
    @Column(name = "doc_cls", columnDefinition = "varchar(40)  comment '单据类别'")
    String docCls;
   /* @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InvCkDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InvCkDO entity = (InvCkDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }*/
}
