package com.elitesland.yst.production.inv.domain.entity.invstk;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * <p>
 * 功能说明:库存结存明细
 * </p >
 *
 * @author yangzhibin
 * @date 2020/7/27
 */
@Entity
@Table(name = "inv_stk")
@org.hibernate.annotations.Table(appliesTo = "inv_stk", comment = "库存结存明细")
@Data
@DynamicInsert
@DynamicUpdate
@Where(clause="delete_flag=0")
@ApiModel(value = "INV_STK", description = "库存结存明细")
public class InvStkDO extends BaseModel implements Serializable {
    @ApiModelProperty("公司ID")
    @Column(name = "ou_id", columnDefinition = "bigint(20)  comment '公司ID'")
    Long ouId;

    @ApiModelProperty("BUID")
    @Column(name = "bu_id", columnDefinition = "bigint(20)  comment 'BUID'")
    Long buId;

    @ApiModelProperty("品项ID")
    @Column(name = "item_id", columnDefinition = "bigint(20)  comment '品项ID'")
    Long itemId;

    @ApiModelProperty("异构ID")
    @Column(name = "vari_id", columnDefinition = "bigint default 0 comment '异构ID'")
    Long variId;

    @ApiModelProperty("品项编号")
    @Column(name = "item_code", columnDefinition = "varchar(40)  comment '品项编号'")
    String itemCode;

    @ApiModelProperty("品项名称")
    @Column(name = "item_name", columnDefinition = "varchar(255)  comment '品项名'")
    String itemName;

    @ApiModelProperty("商品SKU品类编号")
    @Column(name = "item_cate_code", columnDefinition = "varchar(255)  comment '商品品类'")
    String itemCateCode;

    @ApiModelProperty("品牌")
    @Column(name = "brand", columnDefinition = "varchar(255)  comment '品牌'")
    String brand;

    @ApiModelProperty("仓库ID")
    @Column(name = "wh_id", columnDefinition = "bigint(20)  comment '仓库ID'")
    Long whId;

    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    @Column(name = "deter1", columnDefinition = "varchar(40)  comment '温层 [UDC]INV:TEMP_TYPE'")
    String deter1;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    @Column(name = "deter2", columnDefinition = "varchar(40)  comment '功能区 [UDC]INV:FUNC_TYPE'")
    String deter2;

    @ApiModelProperty("客户标识")
    @Column(name = "deter3", columnDefinition = "varchar(40)  comment '客户标识'")
    String deter3;

    @ApiModelProperty("限定4")
    @Column(name = "deter4", columnDefinition = "varchar(40)  comment '限定4'")
    String deter4;

    @ApiModelProperty("限定5")
    @Column(name = "deter5", columnDefinition = "varchar(40)  comment '限定5'")
    String deter5;

    @ApiModelProperty("限定6")
    @Column(name = "deter6", columnDefinition = "varchar(40)  comment '限定6'")
    String deter6;

    @ApiModelProperty("限定7")
    @Column(name = "deter7", columnDefinition = "varchar(40)  comment '限定7'")
    String deter7;

    @ApiModelProperty("限定8")
    @Column(name = "deter8", columnDefinition = "varchar(40)  comment '限定8'")
    String deter8;

    @ApiModelProperty("库位")
    @Column(name = "wh_loc", columnDefinition = "varchar(40)  comment '库位'")
    String whLoc;

    @ApiModelProperty("货位")
    @Column(name = "wh_posi", columnDefinition = "varchar(40)  comment '货位'")
    String whPosi;

    @ApiModelProperty("批次号")
    @Column(name = "lot_no", columnDefinition = "varchar(40)  comment '批次号'")
    String lotNo;

    @ApiModelProperty("序列号")
    @Column(name = "sn_no", columnDefinition = "varchar(40)  comment '序列号'")
    String snNo;

    @ApiModelProperty("入库日期")
    @Column()
    @Comment("入库日期")
    LocalDateTime inDate;

    @ApiModelProperty("剩余效期天数 每天自动计算")
    @Column(name = "until_expire_days", columnDefinition = "int(18)  comment '剩余效期天数 每天自动计算'")
    Integer untilExpireDays;

    @ApiModelProperty("新鲜度 每天自动计算。[UDC]COM:FRESS_TYPE")
    @Column(name = "fress_type", columnDefinition = "varchar(40)  comment '新鲜度 每天自动计算。[UDC]COM:FRESS_TYPE'")
    String fressType;

    @ApiModelProperty("单位")
    @Column(name = "uom", columnDefinition = "varchar(10)  comment '单位'")
    String uom;

    @ApiModelProperty("单位2")
    @Column(name = "uom2", columnDefinition = "varchar(10)  comment '单位2'")
    String uom2;

    @ApiModelProperty("单位转换率")
    @Column(name = "uom_ratio", columnDefinition = "NUMERIC(20,8)   comment '单位转换率'")
    BigDecimal uomRatio;

    @ApiModelProperty("单位转换率2")
    @Column(name = "uom_ratio2", columnDefinition = "float(20,8)   comment '单位转换率2'")
    Double uomRatio2;

    @ApiModelProperty("现有量")
    @Column(name = "oh_qty", columnDefinition = "NUMERIC(20,8) comment '现有量'")
    BigDecimal ohQty;

    @ApiModelProperty("现有量2")
    @Column(name = "oh_qty2", columnDefinition = "NUMERIC(20,8) comment '现有量2'")
    BigDecimal ohQty2;

    @ApiModelProperty("SO硬承诺量 SO已配货")
    @Column(name = "rsv_qty", columnDefinition = "NUMERIC(20,8) comment 'SO硬承诺量 SO已配货'")
    BigDecimal rsvQty;

    @ApiModelProperty("RO预留量 未配货的可用预留量")
    @Column(name = "rsv_qty2", columnDefinition = "NUMERIC(20,8) comment 'RO预留量 未配货的可用预留量'")
    BigDecimal rsvQty2;

    @ApiModelProperty("预留量3")
    @Column(name = "rsv_qty3", columnDefinition = "NUMERIC(20,8) comment '预留量3'")
    BigDecimal rsvQty3;

    @ApiModelProperty("预留量4")
    @Column(name = "rsv_qty4", columnDefinition = "NUMERIC(20,8) comment '预留量4'")
    BigDecimal rsvQty4;

    @ApiModelProperty("锁定量 因各种原因锁定的量，如低于成本时防止过量销售，或是调拨中，或是做为活动预留，或是因不良、损坏")
    @Column(name = "lock_qty", columnDefinition = "NUMERIC(20,8) comment '锁定量 因各种原因锁定的量，如低于成本时防止过量销售，或是调拨中，或是做为活动预留，或是因不良、损坏'")
    BigDecimal lockQty;

    @ApiModelProperty("锁定量2")
    @Column(name = "lock_qty2", columnDefinition = "NUMERIC(20,8) comment '锁定量2'")
    BigDecimal lockQty2;

    @ApiModelProperty("锁定量3")
    @Column(name = "lock_qty3", columnDefinition = "NUMERIC(20,8) comment '锁定量3'")
    BigDecimal lockQty3;

    @ApiModelProperty("锁定量4")
    @Column(name = "lock_qty4", columnDefinition = "NUMERIC(20,8) comment '锁定量4'")
    BigDecimal lockQty4;

    @ApiModelProperty("在途量")
    @Column(name = "ow_qty", columnDefinition = "NUMERIC(20,8) comment '在途量'")
    BigDecimal owQty;

    @ApiModelProperty("在途量2")
    @Column(name = "ow_qty2", columnDefinition = "NUMERIC(20,8) comment '在途量2'")
    BigDecimal owQty2;

    @ApiModelProperty("在途量3")
    @Column(name = "ow_qty3", columnDefinition = "NUMERIC(20,8) comment '在途量3'")
    BigDecimal owQty3;

    @ApiModelProperty("在途量4")
    @Column(name = "ow_qty4", columnDefinition = "NUMERIC(20,8) comment '在途量4'")
    BigDecimal owQty4;

    @ApiModelProperty("可用量 根据本行适用策略计算的速取数，策略如现有量-预留量-锁定量+在途量=可用量")
    @Column(name = "aval_qty", columnDefinition = "NUMERIC(20,8) comment '可用量 根据本行适用策略计算的速取数，策略如现有量-预留量-锁定量+在途量=可用量'")
    BigDecimal avalQty;

    @ApiModelProperty("可用量2")
    @Column(name = "aval_qty2", columnDefinition = "NUMERIC(20,8) comment '可用量2'")
    BigDecimal avalQty2;

    @ApiModelProperty("体积")
    @Column(name = "volume", columnDefinition = "NUMERIC(20,8)   comment '体积'")
    BigDecimal volume;

    @ApiModelProperty("净重")
    @Column(name = "net_weight", columnDefinition = "NUMERIC(20,8)   comment '净重'")
    BigDecimal netWeight;

    @ApiModelProperty("毛重")
    @Column(name = "gross_weight", columnDefinition = "NUMERIC(20,8)   comment '毛重'")
    BigDecimal grossWeight;

    @ApiModelProperty("重量")
    @Column(name = "weight", columnDefinition = "NUMERIC(20,8)   comment '重量'")
    BigDecimal weight;

    @ApiModelProperty("重量单位")
    @Column(name = "weight_uom_code", columnDefinition = "varchar(40)  comment '重量单位'")
    String weightUomCode;

    @ApiModelProperty("重量转换率")
    @Column(name = "weight_ratio", columnDefinition = "float(20,8)   comment '重量转换率'")
    Double weightRatio;

    @ApiModelProperty("金额")
    @Column(name = "amt", columnDefinition = "NUMERIC(20,4)   comment '金额'")
    BigDecimal amt;

    @ApiModelProperty("库存描述")
    @Column(name = "stk_desc", columnDefinition = "varchar(40)  comment '库存描述'")
    String stkDesc;

    @ApiModelProperty("库存描述2")
    @Column(name = "stk_desc2", columnDefinition = "varchar(40)  comment '库存描述2'")
    String stkDesc2;

    @ApiModelProperty("来源单据类别")
    @Column(name = "src_doc_cls", columnDefinition = "varchar(40)  comment '来源单据类别'")
    String srcDocCls;

    @ApiModelProperty("来源单据ID")
    @Column(name = "src_doc_id", columnDefinition = "bigint(20)  comment '来源单据ID'")
    Long srcDocId;

    @ApiModelProperty("来源单据明细ID")
    @Column(name = "src_doc_did", columnDefinition = "bigint(20)  comment '来源单据明细ID'")
    Long srcDocDid;

    @ApiModelProperty("来源单据类别2")
    @Column(name = "src_doc_cls2", columnDefinition = "varchar(40)  comment '来源单据类别2'")
    String srcDocCls2;

    @ApiModelProperty("来源单据ID2")
    @Column(name = "src_doc_id2", columnDefinition = "bigint(20)  comment '来源单据ID2'")
    Long srcDocId2;

    @ApiModelProperty("来源单据明细ID2")
    @Column(name = "src_doc_did2", columnDefinition = "bigint(20)  comment '来源单据明细ID'")
    Long srcDocDid2;

    @ApiModelProperty("ES1")
    @Column(name = "es1", columnDefinition = "varchar(40)  comment 'ES1'")
    String es1;

    @ApiModelProperty("ES2")
    @Column(name = "es2", columnDefinition = "varchar(40)  comment 'ES2'")
    String es2;

    @ApiModelProperty("ES3")
    @Column(name = "es3", columnDefinition = "varchar(40)  comment 'ES3'")
    String es3;

    @ApiModelProperty("ES4")
    @Column(name = "es4", columnDefinition = "varchar(40)  comment 'ES4'")
    String es4;

    @ApiModelProperty("ES5")
    @Column(name = "es5", columnDefinition = "varchar(40)  comment 'ES5'")
    String es5;

    @ApiModelProperty("库存合作伙伴编码")
    @Column(name = "p_code", columnDefinition = "varchar(40)  comment '库存合作伙伴编码'")
    private String pCode;

    @ApiModelProperty("库存合作伙伴类型")
    @Column(name = "p_type", columnDefinition = "varchar(40)  comment '库存合作伙伴类型'")
    private String pType;

    @ApiModelProperty("货架")
    @Column(name = "good_shelve", columnDefinition = "varchar(40)  comment '货架'")
    private String goodShelve;

    @ApiModelProperty("limit1")
    @Column(name = "limit1", columnDefinition = "varchar(40)  comment 'limit1'")
    private String limit1;

    @ApiModelProperty("limit2")
    @Column(name = "limit2", columnDefinition = "varchar(40)  comment 'limit2'")
    private String limit2;

    @ApiModelProperty("limit3")
    @Column(name = "limit3", columnDefinition = "varchar(40)  comment 'limit3'")
    private String limit3;

    @ApiModelProperty("仓库编码")
    @Column(name = "wh_code", columnDefinition = "varchar(64)  comment '仓库编码'")
    private String whCode;

    @ApiModelProperty("公司编码")
    @Column(name = "ou_code", columnDefinition = "varchar(64)  comment '公司编码'")
    private String ouCode;

    @ApiModelProperty("公司编码")
    @Column(name = "ou_name", columnDefinition = "varchar(64)  comment '公司名称'")
    private String ouName;

    @ApiModelProperty("发运基地ID")
    @Column(name = "des_id", columnDefinition = "bigint(20)  comment '发运基地ID'")
    Long desId;

    @ApiModelProperty("itemType2")
    @Column(name = "item_type2", columnDefinition = "varchar(64)  comment '商品类型'")
    String itemType2;





    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InvStkDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InvStkDO entity = (InvStkDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }

    @Override
    public String toString() {
        return "InvStkDO{" +
                "id=" + this.getId() +
                "ouId=" + ouId +
                ", buId=" + buId +
                ", itemId=" + itemId +
                ", variId=" + variId +
                ", itemCode='" + itemCode + '\'' +
                ", itemName='" + itemName + '\'' +
                ", itemCateCode='" + itemCateCode + '\'' +
                ", brand='" + brand + '\'' +
                ", whId=" + whId +
                ", deter1='" + deter1 + '\'' +
                ", deter2='" + deter2 + '\'' +
                ", deter3='" + deter3 + '\'' +
                ", deter4='" + deter4 + '\'' +
                ", deter5='" + deter5 + '\'' +
                ", deter6='" + deter6 + '\'' +
                ", deter7='" + deter7 + '\'' +
                ", deter8='" + deter8 + '\'' +
                ", whLoc='" + whLoc + '\'' +
                ", whPosi='" + whPosi + '\'' +
                ", lotNo='" + lotNo + '\'' +
                ", snNo='" + snNo + '\'' +
                ", inDate=" + inDate +
                ", untilExpireDays=" + untilExpireDays +
                ", fressType='" + fressType + '\'' +
                ", uom='" + uom + '\'' +
                ", uom2='" + uom2 + '\'' +
                ", uomRatio=" + uomRatio +
                ", uomRatio2=" + uomRatio2 +
                ", ohQty=" + ohQty +
                ", ohQty2=" + ohQty2 +
                ", rsvQty=" + rsvQty +
                ", rsvQty2=" + rsvQty2 +
                ", rsvQty3=" + rsvQty3 +
                ", rsvQty4=" + rsvQty4 +
                ", lockQty=" + lockQty +
                ", lockQty2=" + lockQty2 +
                ", lockQty3=" + lockQty3 +
                ", lockQty4=" + lockQty4 +
                ", owQty=" + owQty +
                ", owQty2=" + owQty2 +
                ", owQty3=" + owQty3 +
                ", owQty4=" + owQty4 +
                ", avalQty=" + avalQty +
                ", avalQty2=" + avalQty2 +
                ", volume=" + volume +
                ", netWeight=" + netWeight +
                ", grossWeight=" + grossWeight +
                ", weight=" + weight +
                ", weightUomCode='" + weightUomCode + '\'' +
                ", weightRatio=" + weightRatio +
                ", amt=" + amt +
                ", stkDesc='" + stkDesc + '\'' +
                ", stkDesc2='" + stkDesc2 + '\'' +
                ", srcDocCls='" + srcDocCls + '\'' +
                ", srcDocId=" + srcDocId +
                ", srcDocDid=" + srcDocDid +
                ", srcDocCls2='" + srcDocCls2 + '\'' +
                ", srcDocId2=" + srcDocId2 +
                ", srcDocDid2=" + srcDocDid2 +
                ", es1='" + es1 + '\'' +
                ", es2='" + es2 + '\'' +
                ", es3='" + es3 + '\'' +
                ", es4='" + es4 + '\'' +
                ", es5='" + es5 + '\'' +
                ", pCode='" + pCode + '\'' +
                ", pType='" + pType + '\'' +
                ", goodShelve='" + goodShelve + '\'' +
                '}';
    }
}
