package com.elitesland.yst.production.inv.domain.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.inv.domain.convert.InvAjConvert;
import com.elitesland.yst.production.inv.domain.convert.InvAsmDConvert;
import com.elitesland.yst.production.inv.domain.entity.InvAj;
import com.elitesland.yst.production.inv.domain.entity.InvAjDO;
import com.elitesland.yst.production.inv.domain.service.InvAjDomainService;
import com.elitesland.yst.production.inv.infr.dto.InvAjDTO;
import com.elitesland.yst.production.inv.infr.repo.InvAjRepo;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @author lvqf
 * @date 2021-02-1 11:36
 * Desc:
 */
@Slf4j
@Service
@AllArgsConstructor
public class InvAjDomainServiceImpl implements InvAjDomainService {

    private final InvAjRepo invAjRepo;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long createInvAj(InvAj invAj) {
        //实体转换
        InvAjDO invAjDO = InvAjConvert.INSTANCE.invAjSaveVOToInvAjDO(invAj);
        Long id = invAjRepo.save(invAjDO).getId();
        return id;
    }

    @Override
    public InvAjDTO findById(Long id) {
        Optional<InvAjDTO> optional = invAjRepo.findById(id)
                .map(invAjDO -> BeanUtil.copyProperties(invAjDO, InvAjDTO.class));
        if(optional.isPresent()){
            return optional.get();
        } else{
            throw new BusinessException(ApiCode.FAIL,"数据不存在");
        }

    }

    @Override
    public List<InvAjDTO> findIdBatch(List<Long> ids) {
        List<InvAjDO> invAjDOS = invAjRepo.findAllById(ids);
        return invAjDOS.stream()
                .map(InvAjConvert.INSTANCE::invAjDoToInvAjDTO)
                .collect(Collectors.toList());

    }

}
