package com.elitesland.yst.production.inv.infr.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.List;

/**
 * @author Tom.su
 * @program yst-inv
 * @description
 * @date 2022/04/24 10:46
 */
@Data
@ApiModel(value = "库存操作公共入参", description = "库存操作公共入参")
public class InvStkCommonOperateDTO implements Serializable {

    private static final long serialVersionUID = 748300395583796411L;

    @ApiModelProperty("唯一请求ID")
    @NotBlank(message = "唯一请求ID不能为空")
    private String requestId;

    @ApiModelProperty("来源系统")
    @NotBlank(message = "来源系统不能为空")
    private String source;

    @ApiModelProperty("库存场景码")
    @NotBlank(message = "库存场景码不能为空")
    private String sceneCode;

    @ApiModelProperty("原库存操作明细体")
    private List<InvStkCommonOperateBodyDTO> sourceBodyList;

    @ApiModelProperty("目的库存操作明细体")
    private List<InvStkCommonOperateBodyDTO> targetBodyList;

}