package com.elitesland.yst.production.inv.infr.dto;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;


@Data
@EqualsAndHashCode(callSuper = true)
public class InvStkSsDTO extends BaseModelVO implements Serializable {
    private static final long serialVersionUID = -3701539560410913611L;

    @ApiModelProperty("ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    private String ouCode;
    private String ouName;

    @ApiModelProperty("异构ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long variId;

    @ApiModelProperty("品项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("品项编号")
    private String itemCode;

    @ApiModelProperty("品项名称")
    private String itemName;

    @ApiModelProperty("品类")
    private String itemCateCode;

    private String deter2Type;

    @ApiModelProperty("保质期天数")
    private Integer expireDays;

    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("仓库类型 [UDC]INV:WH_TYPE")
    private String whType;

    @ApiModelProperty(value = "仓库类型名称")
    @SysCode(sys = "yst-inv",mod = "WH_TYPE")
    private String whTypeName;

    @ApiModelProperty(value = "仓库类型编码")
    private String whCode;

    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    private String deter1;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    private String deter2;

    @ApiModelProperty("功能区名称（暂时使用）")
    private String deter2Name;

    @ApiModelProperty("客户标识")
    private String deter3;

    @ApiModelProperty("现有量")
    private BigDecimal ohQty;

    @ApiModelProperty("现有量2")
    private BigDecimal ohQty2;

    @ApiModelProperty("SO硬承诺量 SO已配货")
    private BigDecimal rsvQty;

    @ApiModelProperty("RO预留量 未配货的可用预留量")
    private BigDecimal rsvQty2;

    @ApiModelProperty("预留量4")
    private BigDecimal rsvQty4;

    @ApiModelProperty("锁定量 因各种原因锁定的量，如低于成本时防止过量销售，或是调拨中，或是做为活动预留，或是因不良、损坏")
    private BigDecimal lockQty;

    @ApiModelProperty("锁定量2")
    private BigDecimal lockQty2;

    @ApiModelProperty("锁定量3")
    private BigDecimal lockQty3;

    @ApiModelProperty("锁定量4")
    private BigDecimal lockQty4;

    @ApiModelProperty("在途量")
    private BigDecimal owQty;

    @ApiModelProperty("在途量2")
    private BigDecimal owQty2;

    @ApiModelProperty("在途量3")
    private BigDecimal owQty3;

    @ApiModelProperty("在途量4")
    private BigDecimal owQty4;

    @ApiModelProperty("可用量 根据本行适用策略计算的速取数，策略如现有量-预留量-锁定量+在途量=可用量")
    private BigDecimal avalQty;

    @ApiModelProperty("可用量2")
    private BigDecimal avalQty2;

    @ApiModelProperty("金额")
    private BigDecimal amt;

    @ApiModelProperty("单位")
    private String uom;

    @ApiModelProperty("单位名称")
    private String uomName;

    @ApiModelProperty("单位2")
    private String uom2;

    @ApiModelProperty("单位转换率")
    private BigDecimal uomRatio;

    @ApiModelProperty("单位转换率2")
    private Double uomRatio2;

    @ApiModelProperty("库存合作伙伴编码")
    private String pCode;

    @ApiModelProperty("库存合作伙伴名称")
    private String pName;

    @ApiModelProperty("库存合作伙伴类型")
    @SysCode(sys = "yst-inv", mod = "PARTNER_TYPE")
    private String pType;
    @ApiModelProperty("库存合作伙伴类型名称")
    private String pTypeName;

    @ApiModelProperty("品牌")
    private String brand;
    private String brandName;

    @ApiModelProperty("供应商编码")
    private String suppCode;

    @ApiModelProperty("供应商名称")
    private String suppName;

    @ApiModelProperty("包装规格")
    private String packageSpec;

    @ApiModelProperty("商品SKU条码")
    private String barCode;

    @ApiModelProperty("品项类型 [UDC]ITM:ITEM_TYPE")
    String itemType;

    String itemTypeName;

    @ApiModelProperty("库存总重")
    private Double stkWeight;

    @ApiModelProperty("库存总体积")
    private Double stkVolume;

    @ApiModelProperty("箱毛重")
    private Float pkgGrossWeight;

    @ApiModelProperty("箱高")
    private Float pkgHeight;

    @ApiModelProperty("箱宽")
    private Float pkgWidth;

    @ApiModelProperty("箱长")
    private Float pkgLength;

    @ApiModelProperty("货架")
    private String goodShelve;

    @ApiModelProperty("创建人")
    private String creator;

    @ApiModelProperty("创建人")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long createUserId;

    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @ApiModelProperty("品类")
    private List<String> itemCatePathName;

    @ApiModelProperty("权限id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long secBuId;

    @ApiModelProperty("数据归属账号id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long secUserId;

    @ApiModelProperty("数据归属公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long secOuId;

    @ApiModelProperty("货位")
    private String whPosi;

    @ApiModelProperty("limit1")
    private String limit1;

    @ApiModelProperty("limit2")
    private String limit2;

    @ApiModelProperty("limit3")
    private String limit3;


    @ApiModelProperty("BUID")
    Long buId;

    @ApiModelProperty("限定4")
    String deter4;

    @ApiModelProperty("限定5")
    String deter5;

    @ApiModelProperty("限定6")
    String deter6;

    @ApiModelProperty("限定7")
    String deter7;

    @ApiModelProperty("限定8")
    String deter8;

    @ApiModelProperty("库位")
    String whLoc;

    @ApiModelProperty("批次号")
    String lotNo;

    @ApiModelProperty("序列号")
    String snNo;

    @ApiModelProperty("入库日期")
    LocalDateTime inDate;

    @ApiModelProperty("剩余效期天数 每天自动计算")
    Integer untilExpireDays;

    @ApiModelProperty("新鲜度 每天自动计算。[UDC]COM:FRESS_TYPE")
    String fressType;

    @ApiModelProperty("预留量3")
    BigDecimal rsvQty3;

    @ApiModelProperty("体积")
    BigDecimal volume;

    @ApiModelProperty("净重")
    BigDecimal netWeight;

    @ApiModelProperty("毛重")
    BigDecimal grossWeight;

    @ApiModelProperty("重量")
    BigDecimal weight;

    @ApiModelProperty("重量单位")
    String weightUomCode;

    @ApiModelProperty("重量转换率")
    Double weightRatio;

    @ApiModelProperty("库存描述")
    String stkDesc;

    @ApiModelProperty("库存描述2")
    String stkDesc2;

    @ApiModelProperty("来源单据类别")
    String srcDocCls;

    @ApiModelProperty("来源单据ID")
    Long srcDocId;

    @ApiModelProperty("来源单据明细ID")
    Long srcDocDid;

    @ApiModelProperty("来源单据类别2")
    String srcDocCls2;

    @ApiModelProperty("来源单据ID2")
    Long srcDocId2;

    @ApiModelProperty("来源单据明细ID2")
    Long srcDocDid2;

    @ApiModelProperty("ES1")
    String es1;

    @ApiModelProperty("ES2")
    String es2;

    @ApiModelProperty("ES3")
    String es3;

    @ApiModelProperty("ES4")
    String es4;

    @ApiModelProperty("ES5")
    String es5;

    @ApiModelProperty("库存快照时间")
    LocalDateTime stkSsTime;




}
