package com.elitesland.yst.production.inv.infr.dto;

import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author lvqf
 * @Date 2021/2/26
 * @Description
 */
@Data
@ApiModel(value = "inv_trn_resp", description = "库存转移")
public class InvTrnDTO extends BaseModelVO implements Serializable {

    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long ouId;

    @ApiModelProperty("公司编码")
    String ouCode;

    @ApiModelProperty("公司名称")
    String ouName;

    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long buId;

    @ApiModelProperty("单据编号")
    String docNo;

    @ApiModelProperty("转移类型 [UDC]INV:TRN_TYPE")
    @SysCode(sys = "yst-inv", mod = "TRN_TYPE")
    String docType;
    String docTypeName;

    @ApiModelProperty("转移单状态 [UDC]INV:TRN_STATUS")
    @SysCode(sys = "yst-inv", mod = "TRN_STATUS")
    String docStatus;
    String docStatusName;


    @ApiModelProperty("审批时间")
    LocalDateTime apprTime;

    @ApiModelProperty("审批人ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long apprUserId;

    @ApiModelProperty("审批意见")
    String apprComment;

    @ApiModelProperty("申请人员工ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long applyEmpId;

    @ApiModelProperty("申请日期")
    LocalDateTime applyDate;

    @ApiModelProperty("申请描述")
    String applyDesc;

    @ApiModelProperty("交易日期 实际出入库日期")
    LocalDateTime ioDate;

    @ApiModelProperty("从公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long oOuId;

    @ApiModelProperty("从仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long oWhId;
    String oWhCode;
    String oWhName;

    @ApiModelProperty("从温层 [UDC]INV:TEMP_TYPE")
    @SysCode(sys = "yst-inv", mod = "TEMP_TYPE")
    String oDeter1;
    String oDeter1Name;

    @ApiModelProperty("从功能区 [UDC]INV:FUNC_TYPE")
    @SysCode(sys = "yst-inv", mod = "FUNC_TYPE")
    String oDeter2;
    String oDeter2Name;

    @ApiModelProperty("从客户标识")
    String oDeter3;

    @ApiModelProperty("从限定4")
    String oDeter4;

    @ApiModelProperty("从限定5")
    String oDeter5;

    @ApiModelProperty("从限定6")
    String oDeter6;

    @ApiModelProperty("从限定7")
    String oDeter7;

    @ApiModelProperty("从限定8")
    String oDeter8;

    @ApiModelProperty("到公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long iOuId;

    @ApiModelProperty("到仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long iWhId;
    String iWhCode;
    String iWhName;

    @ApiModelProperty("到温层 [UDC]INV:TEMP_TYPE")
    @SysCode(sys = "yst-inv", mod = "TEMP_TYPE")
    String iDeter1;
    String iDeter1Name;

    @ApiModelProperty("到功能区 [UDC]INV:FUNC_TYPE")
    @SysCode(sys = "yst-inv", mod = "FUNC_TYPE")
    String iDeter2;
    String iDeter2Name;

    @ApiModelProperty("到客户标识")
    String iDeter3;

    @ApiModelProperty("到限定4")
    String iDeter4;

    @ApiModelProperty("到限定5")
    String iDeter5;

    @ApiModelProperty("到限定6")
    String iDeter6;

    @ApiModelProperty("到限定7")
    String iDeter7;

    @ApiModelProperty("到限定8")
    String iDeter8;

    @ApiModelProperty("总数量")
    BigDecimal qty;

    @ApiModelProperty("数量单位")
    String qtyUom;

    @ApiModelProperty("税额")
    Float taxAmt;

    @ApiModelProperty("含税金额")
    Float amt;

    @ApiModelProperty("不含税金额")
    Float netAmt;

    @ApiModelProperty("记账币种")
    String homeCurr;

    @ApiModelProperty("交易币种")
    String currCode;

    @ApiModelProperty("汇率")
    Float currRate;

    @ApiModelProperty("外币不含税金额")
    Float currNetAmt;

    @ApiModelProperty("外币含税金额")
    Float currAmt;

    @ApiModelProperty("成本金额")
    Float costAmt;

    @ApiModelProperty("关联单据类别 如RMA。[UDC]COM:DOC_CLS")
    @SysCode(sys = "COM", mod = "DOC_CLS")
    String relateDocCls;
    String relateDocClsName;

    @ApiModelProperty("关联单据类型")
    String relateDocType;

    @ApiModelProperty("关联单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long relateDocId;

    @ApiModelProperty("关联单据编号")
    String relateDocNo;

    @ApiModelProperty("关联ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long relateId;

    @ApiModelProperty("关联编号")
    String relateNo;

    @ApiModelProperty("关联2ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long relate2Id;

    @ApiModelProperty("关联2编号")
    String relate2No;

    @ApiModelProperty("原因码 [UDC]COM:REASON_CODE")
    String reasonCode;

    @ApiModelProperty("是否走接口")
    Integer intfFlag;

    /**
     * 工作流字段
     */
    @ApiModelProperty("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程实例状态")
    private ProcInstStatus procInstStatus;


    public String getProcInstStatusName() {
        return procInstStatus != null ? procInstStatus.getDesc() : null;
    }

    @ApiModelProperty(value = "提交时间")
    private LocalDateTime submitTime;

    @ApiModelProperty(value = "审批通过时间")
    private LocalDateTime approvedTime;

    /**
     * 审批状态 [UDC]COM:APPR_STATUS
     */
    @ApiModelProperty("审批状态 [UDC]COM:APPR_STATUS")
    @SysCode(sys = "COM", mod = "APPR_STATUS")
    private String apprStatus;
    @ApiModelProperty("审批状态名称")
    private String apprStatusName;

    @ApiModelProperty("从包")
    String olimit1;

    @ApiModelProperty("到包")
    String ilimit1;
    @ApiModelProperty("单据类别")
    private String docCls;

}
