package com.elitesland.yst.production.inv.infr.repo;

import com.elitesland.yst.production.inv.application.facade.vo.InvAsmAllQueryParam;
import com.elitesland.yst.production.inv.application.facade.vo.InvAsmAndAsmDRespVO;
import com.elitesland.yst.production.inv.domain.entity.QInvAsmDDO;
import com.elitesland.yst.production.inv.domain.entity.QInvAsmDO;
import com.elitesland.yst.production.inv.infr.dto.InvAsmDTO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * @author lu.wang
 * @date 2020-08-11 17:07
 * Desc:
 */
@Component
@AllArgsConstructor
public class InvAsmRepoProc {
    private final JPAQueryFactory jpaQueryFactory;

    public Predicate where(List<Long> ids) {
        val jpaQDO = QInvAsmDO.invAsmDO;
        Predicate predicate = jpaQDO.isNotNull().or(jpaQDO.isNotNull());
        if (!StringUtils.isEmpty(ids) && ids.size() > 0) {
            predicate = ExpressionUtils.and(predicate, jpaQDO.id.in(ids));
        }
        return predicate;
    }
}
