package com.elitesland.yst.production.inv.infr.repo;

import com.elitesland.yst.production.inv.application.facade.vo.invTrn.InvTrnAllQueryParamVO;
import com.elitesland.yst.production.inv.domain.entity.invwh.QInvWhAreaDO;
import com.elitesland.yst.production.inv.domain.entity.invwh.QInvWhDO;
import com.elitesland.yst.production.inv.entity.QInvTrnDDO;
import com.elitesland.yst.production.inv.entity.QInvTrnDO;
import com.elitesland.yst.production.inv.infr.dto.InvTrnAndTrnDTO;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;


/**
 * @author jeesie.jiang
 * @date 2022-03-17 11:52
 * Desc:
 */
@Component
@AllArgsConstructor
public class InvTrnDRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    public JPAQuery<InvTrnAndTrnDTO> selectH(InvTrnAllQueryParamVO param) {
        val invTrnDO = QInvTrnDO.invTrnDO;
        val invTrnDDO = QInvTrnDDO.invTrnDDO;
        QInvWhAreaDO invWhAreaDO = QInvWhAreaDO.invWhAreaDO;

        return jpaQueryFactory.select(
                Projections.bean(
                        InvTrnAndTrnDTO.class,
                        invTrnDDO.id,
                        invTrnDDO.masId,
                        invTrnDDO.lotNo,
                        invTrnDDO.itemId,
                        invTrnDDO.qty,
                        invTrnDDO.uom,
                        invTrnDDO.oDeter1,
                        invTrnDDO.oDeter2,
                        invTrnDDO.iDeter1,
                        invTrnDDO.iDeter2,
                        invTrnDDO.lineNo,
                        invTrnDDO.oWhId,
                        invTrnDDO.oWhCode,
                        invTrnDDO.iWhCode,
                        invTrnDDO.iWhId,
                        invTrnDDO.relateDocNo,
                        invTrnDDO.remark,
                        invTrnDDO.iPType.as("IPType"),
                        invTrnDDO.iPCode.as("IPCode"),
                        invTrnDDO.oPType.as("OPType"),
                        invTrnDDO.oPCode.as("OPCode"),
                        invTrnDDO.outerNo,
                        invTrnDDO.outerLineno,
                        invTrnDDO.outerOu,
                        invTrnDDO.outerType,

                        invTrnDO.docNo,
                        invTrnDO.docStatus,
                        invTrnDO.ouId,
                        invTrnDO.docType,
                        invTrnDO.apprStatus,
                        invTrnDO.procInstId,
                        invTrnDO.procInstStatus,
                        invTrnDO.submitTime,
                        invTrnDO.approvedTime,
                        invTrnDO.applyDate,
                        invTrnDO.ioDate,
                        invTrnDO.reasonCode,
                        invTrnDO.createUserId,
                        invTrnDO.creator,
                        invTrnDO.createTime,
                        invTrnDO.docCls,


                        invTrnDDO.costAmt,
                        invTrnDDO.costPrice,
                        invTrnDDO.olimit1,
                        invTrnDDO.ilimit1,
                        invTrnDO.jdPoOrderNo

                )
        )
                .from(invTrnDDO)
                .leftJoin(invTrnDO).on(invTrnDDO.masId.eq(invTrnDO.id))
                .where(where(param));
    }

    public JPAQuery<InvTrnAndTrnDTO> selectD(InvTrnAllQueryParamVO param) {
        val invTrnDO = QInvTrnDO.invTrnDO;
        val invTrnDDO = QInvTrnDDO.invTrnDDO;

        return jpaQueryFactory.select(
                Projections.bean(
                        InvTrnAndTrnDTO.class,
                        invTrnDDO.id,
                        invTrnDDO.masId,
                        invTrnDDO.lotNo,
                        invTrnDDO.itemId,
                        invTrnDDO.remark,
                        invTrnDDO.qty,
                        invTrnDDO.uom,
                        invTrnDDO.costPrice,
                        invTrnDDO.costAmt,
                        invTrnDDO.relateDocNo,
                        invTrnDDO.iPType.as("IPType"),
                        invTrnDDO.iPCode.as("IPCode"),
                        invTrnDDO.oPType.as("OPType"),
                        invTrnDDO.oPCode.as("OPCode"),
                        invTrnDDO.oWhId,
                        invTrnDDO.oWhCode,
                        invTrnDDO.oDeter1,
                        invTrnDDO.oDeter2,

                        invTrnDDO.iWhId,
                        invTrnDDO.iWhCode,
                        invTrnDDO.iDeter1,
                        invTrnDDO.iDeter2,
                        invTrnDDO.outerNo,
                        invTrnDDO.outerLineno,
                        invTrnDDO.outerOu,
                        invTrnDDO.outerType,
                        invTrnDDO.secBuId.as("secdBuId"),
                        invTrnDDO.secOuId.as("secdOuId"),
                        invTrnDDO.secUserId.as("secdUserId"),

                        invTrnDO.docCls,
                        invTrnDO.docNo,
                        invTrnDO.docStatus,
                        invTrnDO.ouId,
                        invTrnDO.ouCode,
                        invTrnDO.docType,
                        invTrnDO.apprStatus,
                        invTrnDO.procInstId,
                        invTrnDO.procInstStatus,
                        invTrnDO.submitTime,
                        invTrnDO.reasonCode,
                        invTrnDO.approvedTime,
                        invTrnDO.secBuId,
                        invTrnDO.secOuId,
                        invTrnDO.secUserId,
                        invTrnDDO.lineNo,
                        invTrnDDO.olimit1,
                        invTrnDDO.ilimit1
                )
        ).from(invTrnDDO)
                .leftJoin(invTrnDO).on(invTrnDDO.masId.eq(invTrnDO.id))
                .where(where2(param));
    }

    public Predicate where(InvTrnAllQueryParamVO param) {
        val jpaQDO = QInvTrnDO.invTrnDO;
        val jpaQDDO = QInvTrnDDO.invTrnDDO;
        Predicate predicate = jpaQDO.isNotNull().or(jpaQDDO.isNotNull());
        if ((param.getMasId() != null)) {
            predicate = ExpressionUtils.and(predicate, jpaQDDO.masId.eq(param.getMasId()));
        }
        if (param.getCreateTimeStart() != null && param.getCreateTimeEnd() != null) {
            predicate = ExpressionUtils.and(predicate, jpaQDO.createTime.between(param.getCreateTimeStart(), param.getCreateTimeEnd()));
        }
        if (!StringUtils.isEmpty(param.getDocNo())) {
            predicate = ExpressionUtils.and(predicate, jpaQDO.docNo.like("%" + param.getDocNo() + "%"));
        }
        if (!StringUtils.isEmpty(param.getOWhIds()) && param.getOWhIds().size() > 0) {
            predicate = ExpressionUtils.and(predicate, jpaQDDO.oWhId.in(param.getOWhIds()));
        }
        if (!StringUtils.isEmpty(param.getIWhIds()) && param.getIWhIds().size() > 0) {
            predicate = ExpressionUtils.and(predicate, jpaQDDO.iWhId.in(param.getIWhIds()));
        }
        if (!StringUtils.isEmpty(param.getDeter1())) {
            predicate = ExpressionUtils.and(predicate, (jpaQDO.oDeter1.eq(param.getDeter1())).or(jpaQDO.iDeter1.eq(param.getDeter1())));
        }

        if (!CollectionUtils.isEmpty(param.getODeter2s())){
            predicate = ExpressionUtils.and(predicate,jpaQDDO.oDeter2.in(param.getODeter2s()));
        }
        if (!CollectionUtils.isEmpty(param.getIDeter2s())){
            predicate = ExpressionUtils.and(predicate,jpaQDDO.iDeter2.in(param.getIDeter2s()));
        }
        if(!CollectionUtils.isEmpty(param.getCreateUserIds())){
            predicate = ExpressionUtils.and(predicate,jpaQDO.createUserId.in(param.getCreateUserIds()));
        }
        //公司
        if (!StringUtils.isEmpty(param.getOuIds()) && param.getOuIds().size() > 0) {
            predicate = ExpressionUtils.and(predicate, jpaQDO.ouId.in(param.getOuIds()));
        }

        //品牌
        if (!StringUtils.isEmpty(param.getItemIds()) && param.getItemIds().size() > 0) {
            predicate = ExpressionUtils.and(predicate, jpaQDDO.itemId.in(param.getItemIds()));
        }

        if (!StringUtils.isEmpty(param.getReasonCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDO.reasonCode.eq(param.getReasonCode()));
        }
        if (!StringUtils.isEmpty(param.getDocStatus())) {
            predicate = ExpressionUtils.and(predicate, jpaQDO.docStatus.eq(param.getDocStatus()));
        }
        if (param.getProcInstStatus() != null) {
            predicate = ExpressionUtils.and(predicate, jpaQDO.procInstStatus.eq(param.getProcInstStatus()));
        }
        if (!StringUtils.isEmpty(param.getIoDates()) && param.getIoDates().size() > 0) {
            predicate = ExpressionUtils.and(predicate, jpaQDO.ioDate.between(param.getIoDates().get(0), param.getIoDates().get(1)));
        }
        if (!StringUtils.isEmpty(param.getCreateUserId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDDO.createUserId.eq(param.getCreateUserId()));
        }
        if (!StringUtils.isEmpty(param.getOuterNo())) {
            predicate = ExpressionUtils.and(predicate, jpaQDDO.outerNo.like("%" + param.getOuterNo() + "%"));
        }
        if (!StringUtils.isEmpty(param.getOPCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDDO.oPCode.eq(param.getOPCode()));
        }
        if (!StringUtils.isEmpty(param.getIPCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDDO.iPCode.eq(param.getIPCode()));
        }
        if (!StringUtils.isEmpty(param.getLotNo())) {
            predicate = ExpressionUtils.and(predicate, jpaQDDO.lotNo.like("%" + param.getLotNo() + "%"));
        }
        /**数据权限*/
        try {
            Predicate   predicateAuth=   DataAuthJpaUtil.dataAuthJpaPredicate(jpaQDO.getMetadata());
            predicate=  ExpressionUtils.and(predicate,predicateAuth);
        } catch (Exception e) {
            throw new BusinessException(ApiCode.FAIL,"数据权限异常");
        }
        return predicate;
    }

    public Predicate where2(InvTrnAllQueryParamVO param) {
        val jpaQDO = QInvTrnDO.invTrnDO;
        val jpaQDDO = QInvTrnDDO.invTrnDDO;
        Predicate predicate = jpaQDO.isNotNull().or(jpaQDDO.isNotNull());
        if ((param.getMasId() != null)) {
            predicate = ExpressionUtils.and(predicate, jpaQDDO.masId.eq(param.getMasId()));
        }
        if (!StringUtils.isEmpty(param.getDocNo())) {
            predicate = ExpressionUtils.and(predicate, jpaQDO.docNo.like("%" + param.getDocNo() + "%"));
        }
        if (!StringUtils.isEmpty(param.getOWhIds()) && param.getOWhIds().size() > 0) {
            predicate = ExpressionUtils.and(predicate, jpaQDDO.oWhId.in(param.getOWhIds()));
        }
        if (!StringUtils.isEmpty(param.getIWhIds()) && param.getIWhIds().size() > 0) {
            predicate = ExpressionUtils.and(predicate, jpaQDDO.iWhId.in(param.getIWhIds()));
        }
        if (!StringUtils.isEmpty(param.getDeter1())) {
            predicate = ExpressionUtils.and(predicate, (jpaQDO.oDeter1.eq(param.getDeter1())).or(jpaQDO.iDeter1.eq(param.getDeter1())));
        }

        if (!CollectionUtils.isEmpty(param.getODeter2s())){
            predicate = ExpressionUtils.and(predicate,jpaQDDO.oDeter2.in(param.getODeter2s()));
        }
        if (!CollectionUtils.isEmpty(param.getIDeter2s())){
            predicate = ExpressionUtils.and(predicate,jpaQDDO.iDeter2.in(param.getIDeter2s()));
        }
        if(!CollectionUtils.isEmpty(param.getCreateUserIds())){
            predicate = ExpressionUtils.and(predicate,jpaQDO.createUserId.in(param.getCreateUserIds()));
        }
        //公司
        if (!StringUtils.isEmpty(param.getOuIds()) && param.getOuIds().size() > 0) {
            predicate = ExpressionUtils.and(predicate, jpaQDDO.ouId.in(param.getOuIds()));
        }
        //品牌
        if (!StringUtils.isEmpty(param.getItemIds()) && param.getItemIds().size() > 0) {
            predicate = ExpressionUtils.and(predicate, jpaQDDO.itemId.in(param.getItemIds()));
        }
        if (!StringUtils.isEmpty(param.getReasonCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDO.reasonCode.eq(param.getReasonCode()));
        }
        if (!StringUtils.isEmpty(param.getDocStatus())) {
            predicate = ExpressionUtils.and(predicate, jpaQDO.docStatus.eq(param.getDocStatus()));
        }
        if (!StringUtils.isEmpty(param.getIoDates()) && param.getIoDates().size() > 0) {
            predicate = ExpressionUtils.and(predicate, jpaQDO.ioDate.between(param.getIoDates().get(0), param.getIoDates().get(1)));
        }
        if (!StringUtils.isEmpty(param.getCreateUserId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDDO.createUserId.eq(param.getCreateUserId()));
        }
        if (!StringUtils.isEmpty(param.getOuterNo())) {
            predicate = ExpressionUtils.and(predicate, jpaQDDO.outerNo.like("%" + param.getOuterNo() + "%"));
        }
        if (!StringUtils.isEmpty(param.getProcInstStatus())) {
            predicate = ExpressionUtils.and(predicate, jpaQDO.procInstStatus.eq(param.getProcInstStatus()));
        }
        if (!StringUtils.isEmpty(param.getOPCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDDO.oPCode.eq(param.getOPCode()));
        }
        if (!StringUtils.isEmpty(param.getIPCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDDO.iPCode.eq(param.getIPCode()));
        }
        return predicate;
    }




}
