package com.elitesland.yst.production.inv.infr.repo.invwh;

import com.elitesland.yst.production.inv.application.facade.vo.invwh.*;

import com.elitesland.yst.production.inv.dto.invwh.InvWhRpcDtoParam;
import com.elitesland.yst.production.inv.domain.entity.despatch.QInvDespatchConfigDO;
import com.elitesland.yst.production.inv.domain.entity.invwh.QInvWhAreaDO;
import com.elitesland.yst.production.inv.domain.entity.invwh.QInvWhDO;
import com.elitesland.yst.production.inv.domain.entity.invwh.QInvWhDeliveryDO;
import com.elitesland.yst.production.inv.dto.invwh.InvWhDeliveryRpcDTO;
import com.elitesland.yst.production.inv.dto.invwh.InvWhDetailRpcDTO;
import com.elitesland.yst.production.inv.dto.invwh.InvWhRpcDTO;
import com.elitesland.yst.production.inv.infr.dto.invwh.*;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import com.querydsl.core.types.*;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import com.elitesland.yst.production.inv.dto.invwh.InvWhDeliveryRpcDtoParam;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author liuqi
 * @since 2020-07-16 14:00:14
 */
@Component
@AllArgsConstructor
public class InvWhRepoProc implements JpaQueryProcInterface {

    private final JPAQueryFactory jpaQueryFactory;
    private final QInvWhDeliveryDO whDeliveryDO = QInvWhDeliveryDO.invWhDeliveryDO;
    private final QInvWhDO jpaQDo = QInvWhDO.invWhDO;

    /**
     * 查询字段
     */
    public JPAQuery<InvWhRespVO> searchTree() {
        Predicate predicate = jpaQDo.isNotNull();
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvWhRespVO.class,
                jpaQDo.id,
                jpaQDo.whCode,
                jpaQDo.whName,
                jpaQDo.whAbbr,
                jpaQDo.whType,
                jpaQDo.whStatus,
                jpaQDo.sortNo,
                jpaQDo.pid,
                jpaQDo.level,
                jpaQDo.desCode,
                jpaQDo.desId
        )).from(jpaQDo);
        jpaQuery.where(predicate, jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        return jpaQuery;
    }

    /**
     * 查询字段
     */
    public JPAQuery<InvWhRespVO> select(InvWhParamVO param) {
        Predicate predicate = jpaQDo.isNotNull();
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvWhRespVO.class,
                jpaQDo.id,
                jpaQDo.ouId,
                jpaQDo.relateOuCode,
                jpaQDo.relateOuId,
                jpaQDo.buId,
                jpaQDo.secBuId,
                jpaQDo.secUserId,
                jpaQDo.secOuId,
                jpaQDo.ownerAddrNo,
                jpaQDo.whCode,
                jpaQDo.whName,
                jpaQDo.whName2,
                jpaQDo.whAbbr,
                jpaQDo.whType,
                jpaQDo.whType2,
                jpaQDo.whType3,
                jpaQDo.whStatus,
                jpaQDo.whStatus2,
                jpaQDo.thirdplFlag,
                jpaQDo.physicalWhCode,
                jpaQDo.businessCode,
                jpaQDo.erpCode,
                jpaQDo.delivery,
                jpaQDo.deliveryArea,
                jpaQDo.addrNo,
                jpaQDo.addressId,
                jpaQDo.pid,
                jpaQDo.whPath,
                jpaQDo.es1,
                jpaQDo.tenantId,
                jpaQDo.remark,
                jpaQDo.createUserId,
                jpaQDo.createTime,
                jpaQDo.modifyUserId,
                jpaQDo.modifyTime,
                jpaQDo.deleteFlag,
                jpaQDo.auditDataVersion,
                jpaQDo.area,
                jpaQDo.structure,
                jpaQDo.fixedAssets,
                jpaQDo.plateformFlag,
                jpaQDo.fileCode,
                jpaQDo.jdbadFlag,
                jpaQDo.jdrelateCode,
                jpaQDo.jdsybCode,
                jpaQDo.jdwhCode,
                jpaQDo.tuihuoFlag,
                jpaQDo.otherWhType,
                jpaQDo.otherWhCode,
                jpaQDo.belongBuId,
                jpaQDo.belongBuType,
                jpaQDo.desId,
                jpaQDo.desCode
        )).from(jpaQDo);
        if (param != null) {
            jpaQuery.where(where(param));
        }
        jpaQuery.where(predicate, jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        return jpaQuery;
    }

    public InvWhRespVO findSecBuInfoByWhId(Long whId) {
        Predicate predicate = jpaQDo.isNotNull();
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvWhRespVO.class,
                jpaQDo.secBuId,
                jpaQDo.secUserId,
                jpaQDo.secOuId
        )).from(jpaQDo);
        jpaQuery.where(predicate, jpaQDo.id.eq(whId), jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        return jpaQuery.fetchOne();

    }


    public InvWhRespVO findByWhId(Long whId) {
        Predicate predicate = jpaQDo.isNotNull();
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvWhRespVO.class,
                jpaQDo.id,
                jpaQDo.desId,
                jpaQDo.desCode,
                jpaQDo.ouId,
                jpaQDo.relateOuCode,
                jpaQDo.relateOuId,
                jpaQDo.buId,
                jpaQDo.secBuId,
                jpaQDo.secUserId,
                jpaQDo.secOuId,
                jpaQDo.ownerAddrNo,
                jpaQDo.whCode,
                jpaQDo.whName,
                jpaQDo.whName2,
                jpaQDo.whAbbr,
                jpaQDo.whType,
                jpaQDo.whType2,
                jpaQDo.whType3,
                jpaQDo.whStatus,
                jpaQDo.whStatus2,
                jpaQDo.thirdplFlag,
                jpaQDo.physicalWhCode,
                jpaQDo.businessCode,
                jpaQDo.erpCode,
                jpaQDo.delivery,
                jpaQDo.deliveryArea,
                jpaQDo.addrNo,
                jpaQDo.addressId,
                jpaQDo.pid,
                jpaQDo.whPath,
                jpaQDo.es1,
                jpaQDo.tenantId,
                jpaQDo.remark,
                jpaQDo.createUserId,
                jpaQDo.createTime,
                jpaQDo.modifyUserId,
                jpaQDo.modifyTime,
                jpaQDo.deleteFlag,
                jpaQDo.auditDataVersion,
                jpaQDo.area,
                jpaQDo.structure,
                jpaQDo.fixedAssets,
                jpaQDo.plateformFlag,
                jpaQDo.fileCode,
                jpaQDo.jdbadFlag,
                jpaQDo.jdrelateCode,
                jpaQDo.jdsybCode,
                jpaQDo.jdwhCode,
                jpaQDo.tuihuoFlag,
                jpaQDo.otherWhType,
                jpaQDo.otherWhCode,
                jpaQDo.belongBuId,
                jpaQDo.belongBuType
        )).from(jpaQDo);
        jpaQuery.where(predicate, jpaQDo.id.eq(whId), jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        return jpaQuery.fetchOne();

    }

    public List<InvWhRespVO> findWhByRelateOuId(Long relateOuId) {
        Predicate predicate = jpaQDo.isNotNull();
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvWhRespVO.class,
                jpaQDo.id,
                jpaQDo.ouId,
                jpaQDo.relateOuId,
                jpaQDo.relateOuCode,
                jpaQDo.buId,
                jpaQDo.whCode,
                jpaQDo.whName,
                jpaQDo.whType,
                jpaQDo.whStatus,
                jpaQDo.thirdplFlag,
                jpaQDo.addrNo,
                jpaQDo.addressId,
                jpaQDo.erpCode,
                jpaQDo.es1,
                jpaQDo.businessCode,
                jpaQDo.delivery,
                jpaQDo.region,
                jpaQDo.jdbadFlag,
                jpaQDo.jdrelateCode,
                jpaQDo.jdsybCode,
                jpaQDo.jdwhCode,
                jpaQDo.tuihuoFlag,
                jpaQDo.belongBuId,
                jpaQDo.belongBuType

        )).from(jpaQDo);
        return jpaQuery.where(predicate,
                jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()),
                jpaQDo.relateOuId.eq(relateOuId))
                .fetch();
    }


    public List<InvWhDetailRpcDTO> findWhRpcDTOByParam(InvWhRpcDtoParam param) {
        Predicate predicate = jpaQDo.isNotNull();
        val invWhAreaDO = QInvWhAreaDO.invWhAreaDO;
        val despatchConfigDO = QInvDespatchConfigDO.invDespatchConfigDO;
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvWhDetailRpcDTO.class,
                jpaQDo.id,
                jpaQDo.ouId,
                jpaQDo.relateOuId,
                jpaQDo.relateOuCode,
                jpaQDo.buId,
                jpaQDo.secBuId,
                jpaQDo.whCode,
                jpaQDo.whName,
                jpaQDo.whType,
                jpaQDo.whStatus,
                jpaQDo.thirdplFlag,
                jpaQDo.addrNo,
                jpaQDo.addressId,
                jpaQDo.erpCode,
                jpaQDo.es1,
                jpaQDo.businessCode,
                jpaQDo.delivery,
                jpaQDo.region,
                jpaQDo.desCode,
                jpaQDo.desId,
                despatchConfigDO.desName,
                invWhAreaDO.deter2,
                invWhAreaDO.deter2Name,
                invWhAreaDO.deter2Type
        )).from(jpaQDo)
                .innerJoin(invWhAreaDO).on(jpaQDo.id.eq(invWhAreaDO.whId))
                .leftJoin(despatchConfigDO).on(jpaQDo.desId.eq(despatchConfigDO.id));
        if (param != null) {
            jpaQuery.where(where(param));
        }
        return jpaQuery.where(predicate, jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()))
                .fetch();

    }

    public List<InvWhRpcDTO> findWhRpcDTOByIdBatch(List<Long> ids) {
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvWhRpcDTO.class,
                jpaQDo.id,
                jpaQDo.ouId,
                jpaQDo.relateOuCode,
                jpaQDo.relateOuId,
                jpaQDo.buId,
                jpaQDo.secBuId,
                jpaQDo.whCode,
                jpaQDo.whName,
                jpaQDo.whType,
                jpaQDo.whStatus,
                jpaQDo.thirdplFlag,
                jpaQDo.addrNo,
                jpaQDo.addressId,
                jpaQDo.erpCode,
                jpaQDo.es1,
                jpaQDo.businessCode,
                jpaQDo.delivery,
                jpaQDo.region,
                jpaQDo.desId,
                jpaQDo.desCode

        )).from(jpaQDo);
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        predicates.add(jpaQDo.id.in(ids));
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        return jpaQuery.fetch();
    }

    public List<InvWhRespVO> selectWhByWhIds(List<Long> whIds) {
        Predicate predicate = jpaQDo.isNotNull();
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvWhRespVO.class,
                jpaQDo.id,
                jpaQDo.ouId,
                jpaQDo.buId,
                jpaQDo.relateOuId,
                jpaQDo.relateOuCode,
                jpaQDo.secBuId,
                jpaQDo.secUserId,
                jpaQDo.secOuId,
                jpaQDo.whCode,
                jpaQDo.whName,
                jpaQDo.whType,
                jpaQDo.whStatus,
                jpaQDo.thirdplFlag,
                jpaQDo.addrNo,
                jpaQDo.addressId,
                jpaQDo.erpCode,
                jpaQDo.es1,
                jpaQDo.jdbadFlag,
                jpaQDo.jdrelateCode,
                jpaQDo.jdsybCode,
                jpaQDo.jdwhCode,
                jpaQDo.tuihuoFlag,
                jpaQDo.belongBuId,
                jpaQDo.belongBuType,
                jpaQDo.desId,
                jpaQDo.desCode
        )).from(jpaQDo).where(jpaQDo.id.in(whIds));
        return jpaQuery.where(predicate, jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()))
                .fetch();

    }

    public InvWhRespVO selectWhByWhId(Long whId) {
        Predicate predicate = jpaQDo.isNotNull();
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvWhRespVO.class,
                jpaQDo.id,
                jpaQDo.ouId,
                jpaQDo.buId,
                jpaQDo.relateOuId,
                jpaQDo.relateOuCode,
                jpaQDo.secBuId,
                jpaQDo.secUserId,
                jpaQDo.secOuId,
                jpaQDo.whCode,
                jpaQDo.whName,
                jpaQDo.whType,
                jpaQDo.whStatus,
                jpaQDo.thirdplFlag,
                jpaQDo.addrNo,
                jpaQDo.addressId,
                jpaQDo.erpCode,
                jpaQDo.es1,
                jpaQDo.jdbadFlag,
                jpaQDo.jdrelateCode,
                jpaQDo.jdsybCode,
                jpaQDo.jdwhCode,
                jpaQDo.tuihuoFlag,
                jpaQDo.belongBuId,
                jpaQDo.belongBuType,
                jpaQDo.desId,
                jpaQDo.desCode
        )).from(jpaQDo).where(jpaQDo.id.eq(whId));
        return jpaQuery.where(predicate, jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()))
                .fetchOne();
    }


    public List<InvWhRespVO> selectWhByBusinessCode(String businessCode) {
        Predicate predicate = jpaQDo.isNotNull();
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvWhRespVO.class,
                jpaQDo.id,
                jpaQDo.whCode
        )).from(jpaQDo).where(jpaQDo.businessCode.eq(businessCode).and(jpaQDo.whStatus.eq(UdcEnum.COM_STATUS_ACTIVEORNO_ACTIVE.getValueCode())));
        return jpaQuery.where(predicate, jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()))
                .fetch();

    }

    public List<InvWhRespVO> selectWhByOuIdAndEs1(Long ouId, String es1) {
        Predicate predicate = jpaQDo.isNotNull();
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvWhRespVO.class,
                jpaQDo.id,
                jpaQDo.whCode
        )).from(jpaQDo).where(jpaQDo.ouId.eq(ouId).and(jpaQDo.es1.eq(UdcEnum.INV_WH_PROP_AFTERSAL.getValueCode())));
        return jpaQuery.where(predicate, jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()))
                .fetch();

    }

    public List<InvWhRespVO> selectWhByOuIdAndTuihuoFlag(Long ouId, Integer tuihuoFlag) {
        Predicate predicate = jpaQDo.isNotNull();
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvWhRespVO.class,
                jpaQDo.id,
                jpaQDo.whCode
        )).from(jpaQDo).where(jpaQDo.ouId.eq(ouId).and(jpaQDo.tuihuoFlag.eq(tuihuoFlag)));
        return jpaQuery.where(predicate, jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()))
                .fetch();

    }


    public List<InvWhRpcDTO> findWhPartRpcDTOByParam(InvWhRpcDtoParam param) {
        Predicate predicate = jpaQDo.isNotNull();
        QInvWhAreaDO invWhAreaDO = QInvWhAreaDO.invWhAreaDO;
        QInvDespatchConfigDO despatchConfigDO = QInvDespatchConfigDO.invDespatchConfigDO;
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvWhRpcDTO.class,
                jpaQDo.id,
                jpaQDo.ouId,
                jpaQDo.relateOuCode,
                jpaQDo.relateOuId,
                jpaQDo.secBuId,
                jpaQDo.whCode,
                jpaQDo.whName,
                jpaQDo.whType,
                jpaQDo.whStatus,
                jpaQDo.addrNo,
                jpaQDo.thirdplFlag,
                jpaQDo.erpCode,
                jpaQDo.es1,
                jpaQDo.desCode,
                jpaQDo.desId,
                jpaQDo.businessCode,
                jpaQDo.jdbadFlag,
                jpaQDo.jdrelateCode,
                jpaQDo.jdsybCode,
                jpaQDo.jdwhCode,
                jpaQDo.belongBuId,
                jpaQDo.belongBuType,
                despatchConfigDO.desName
        )).from(jpaQDo)
                .leftJoin(despatchConfigDO).on(jpaQDo.desId.eq(despatchConfigDO.id))
                .leftJoin(invWhAreaDO).on(jpaQDo.id.eq(invWhAreaDO.whId));
        jpaQuery.where(predicate, jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        if (param != null) {
            jpaQuery.where(where(param));
        }
        jpaQuery.groupBy(jpaQDo.id);
        return jpaQuery.fetch();


    }

    /**
     * 查询字段
     *
     * @param param
     */
    public List<InvWhDeliveryRpcDTO> findWhRpcDTOByDelivery(InvWhDeliveryRpcDtoParam param) {
        QInvWhDeliveryDO whDeliveryDO = QInvWhDeliveryDO.invWhDeliveryDO;
        QInvWhDO invWhDO = QInvWhDO.invWhDO;
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvWhDeliveryRpcDTO.class,
                whDeliveryDO.id,
                whDeliveryDO.whId,
                whDeliveryDO.ouId,
                whDeliveryDO.secBuId,
                whDeliveryDO.allArea,
                whDeliveryDO.pCode,
                whDeliveryDO.cCode,
                whDeliveryDO.aCode,
                whDeliveryDO.sCode,
                whDeliveryDO.pName,
                whDeliveryDO.cName,
                whDeliveryDO.aName,
                whDeliveryDO.sName,
                invWhDO.whType,
                invWhDO.whCode,
                invWhDO.relateOuId,
                invWhDO.relateOuCode,
                invWhDO.whName,
                invWhDO.addrNo,
                invWhDO.es1,
                invWhDO.thirdplFlag,
                invWhDO.erpCode,
                invWhDO.jdbadFlag,
                invWhDO.jdrelateCode,
                invWhDO.jdsybCode,
                invWhDO.jdwhCode,
                invWhDO.belongBuId,
                invWhDO.belongBuType
        )).from(whDeliveryDO).innerJoin(invWhDO).on(whDeliveryDO.whId.eq(invWhDO.id));
        List<Predicate> predicates = new ArrayList<>();
        if (param != null) {
            predicates = where(param, predicates);
        }
        predicates.add(whDeliveryDO.deleteFlag.eq(0).or(whDeliveryDO.deleteFlag.isNull()));
        jpaQuery.where(ExpressionUtils.allOf(predicates)).orderBy(new OrderSpecifier(Order.DESC, whDeliveryDO.createTime));
        return jpaQuery.fetch();

    }

    public List<InvWhDeliveryRpcDTO> findWhRpcDTOByAllArea(InvWhDeliveryRpcDtoParam param) {
        QInvWhDeliveryDO whDeliveryDO = QInvWhDeliveryDO.invWhDeliveryDO;
        Predicate predicate = whDeliveryDO.isNotNull();
        QInvWhDO invWhDO = QInvWhDO.invWhDO;
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvWhDeliveryRpcDTO.class,
                whDeliveryDO.id,
                whDeliveryDO.whId,
                whDeliveryDO.ouId,
                whDeliveryDO.secBuId,
                whDeliveryDO.allArea,
                whDeliveryDO.pCode,
                whDeliveryDO.cCode,
                whDeliveryDO.aCode,
                whDeliveryDO.sCode,
                whDeliveryDO.pName,
                whDeliveryDO.cName,
                whDeliveryDO.aName,
                whDeliveryDO.sName,
                invWhDO.whType,
                invWhDO.whCode,
                invWhDO.whName,
                invWhDO.addrNo,
                invWhDO.relateOuCode,
                invWhDO.relateOuId,
                invWhDO.es1,
                invWhDO.thirdplFlag,
                invWhDO.erpCode,
                invWhDO.jdbadFlag,
                invWhDO.jdrelateCode,
                invWhDO.jdsybCode,
                invWhDO.jdwhCode,
                invWhDO.belongBuId,
                invWhDO.belongBuType

        )).from(whDeliveryDO).from(whDeliveryDO).innerJoin(invWhDO).on(whDeliveryDO.whId.eq(invWhDO.id));
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(whDeliveryDO.allArea.eq(1));
        if (param != null) {
            predicates = whereAllWharea(param, predicates);
            if (!CollectionUtils.isEmpty(param.getWhIds())) {
                predicates.add(whDeliveryDO.whId.in(param.getWhIds()));
            }
        }
        predicates.add(whDeliveryDO.deleteFlag.eq(0).or(whDeliveryDO.deleteFlag.isNull()));
        jpaQuery.where(ExpressionUtils.allOf(predicates)).orderBy(new OrderSpecifier(Order.DESC, whDeliveryDO.createTime));
        return jpaQuery.fetch();

    }


    /**
     * 查询字段只查询id、code、name 前端下拉组件专用
     */
    public JPAQuery<InvWhRespVO> list(String keyword) {
        Predicate predicate = jpaQDo.isNotNull();
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvWhRespVO.class,
                jpaQDo.id,
                jpaQDo.ouId,
                jpaQDo.relateOuId,
                jpaQDo.relateOuCode,
                jpaQDo.whCode,
                jpaQDo.secBuId,
                jpaQDo.secOuId,
                jpaQDo.secUserId,
                jpaQDo.physicalWhCode,
                jpaQDo.whName,
                jpaQDo.addrNo,
                jpaQDo.region,
                jpaQDo.whAbbr,
                jpaQDo.area,
                jpaQDo.structure,
                jpaQDo.fixedAssets,
                jpaQDo.plateformFlag,
                jpaQDo.fileCode,
                jpaQDo.jdbadFlag,
                jpaQDo.jdrelateCode,
                jpaQDo.jdsybCode,
                jpaQDo.jdwhCode,
                jpaQDo.tuihuoFlag,
                jpaQDo.belongBuId,
                jpaQDo.belongBuType,
                jpaQDo.desId,
                jpaQDo.desCode
        )).from(jpaQDo);
        if (!StringUtils.isEmpty(keyword)) {
            predicate = ExpressionUtils.and(predicate,
                    ExpressionUtils.or(jpaQDo.whCode.like("%" + keyword + "%"),
                            jpaQDo.whName.like("%" + keyword + "%")));
        }
        jpaQuery.where(predicate, jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        return jpaQuery;
    }

    public List<InvWhRespVO> findWhByIdBatch(List<Long> ids) {
        QInvDespatchConfigDO despatchConfigDO = QInvDespatchConfigDO.invDespatchConfigDO;
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvWhRespVO.class,
                jpaQDo.id,
                jpaQDo.ouId,
                jpaQDo.whCode,
                jpaQDo.whName,
                jpaQDo.addrNo,
                jpaQDo.desId,
                despatchConfigDO.desCode,
                despatchConfigDO.desName
        )).from(jpaQDo).leftJoin(despatchConfigDO).on(jpaQDo.desId.eq(despatchConfigDO.id));
        Predicate predicate1 = jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull());
        Predicate predicate2 = jpaQDo.id.in(ids);
        jpaQuery.where(ExpressionUtils.allOf(predicate1,predicate2));
        return jpaQuery.fetch();
    }

    public List<InvWhRespVO> findByWhNameCode(String whCodeName){
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvWhRespVO.class,
                jpaQDo.id,
                jpaQDo.whCode,
                jpaQDo.whName
        )).from(jpaQDo);
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(ExpressionUtils.or(
                jpaQDo.whCode.like("%" + whCodeName + "%"),
                jpaQDo.whName.like("%" + whCodeName + "%")
        ));
        predicates.add(jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        return jpaQuery.fetch();
    }

    /**
     * 查询字段只查询id、code、name 前端下拉组件专用
     */
    public JPAQuery<InvWhRespVO> listWhType(String keyword) {
        Predicate predicate = jpaQDo.isNotNull();
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvWhRespVO.class,
                jpaQDo.id,
                jpaQDo.ouId,
                jpaQDo.relateOuCode,
                jpaQDo.relateOuId,
                jpaQDo.whCode,
                jpaQDo.secBuId,
                jpaQDo.secUserId,
                jpaQDo.secOuId,
                jpaQDo.physicalWhCode,
                jpaQDo.whName,
                jpaQDo.addrNo,
                jpaQDo.region,
                jpaQDo.whAbbr,
                jpaQDo.whType,
                jpaQDo.area,
                jpaQDo.structure,
                jpaQDo.fixedAssets,
                jpaQDo.plateformFlag,
                jpaQDo.fileCode,
                jpaQDo.jdbadFlag,
                jpaQDo.jdrelateCode,
                jpaQDo.jdsybCode,
                jpaQDo.jdwhCode,
                jpaQDo.tuihuoFlag,
                jpaQDo.belongBuId,
                jpaQDo.belongBuType
        )).from(jpaQDo);
        predicate = ExpressionUtils.and(predicate, jpaQDo.whType.eq("PHYSICAL"));
        if (!StringUtils.isEmpty(keyword)) {
            predicate = ExpressionUtils.and(predicate,
                    ExpressionUtils.or(jpaQDo.whCode.like("%" + keyword + "%"),
                            jpaQDo.whName.like("%" + keyword + "%")));
        }

        jpaQuery.where(predicate, jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        return jpaQuery;
    }

    /**
     * 查询字段只查询id、code、name 前端下拉组件专用
     */
    public JPAQuery<InvWhRespVO> listGroup(String keyword) {
        Predicate predicate = jpaQDo.isNotNull();
        predicate = ExpressionUtils.and(predicate, jpaQDo.whType.ne(UdcEnum.INV_WH_TYPE_LOGICAL.getValueCode()));
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvWhRespVO.class,
                jpaQDo.id,
                jpaQDo.ouId,
                jpaQDo.relateOuId,
                jpaQDo.relateOuCode,
                jpaQDo.secBuId,
                jpaQDo.secOuId,
                jpaQDo.secUserId,
                jpaQDo.whCode,
                jpaQDo.physicalWhCode,
                jpaQDo.whName,
                jpaQDo.addrNo,
                jpaQDo.whAbbr,
                jpaQDo.region,
                jpaQDo.area,
                jpaQDo.structure,
                jpaQDo.fixedAssets,
                jpaQDo.plateformFlag,
                jpaQDo.fileCode,
                jpaQDo.jdbadFlag,
                jpaQDo.jdrelateCode,
                jpaQDo.jdsybCode,
                jpaQDo.jdwhCode,
                jpaQDo.tuihuoFlag,
                jpaQDo.belongBuId,
                jpaQDo.belongBuType
        )).from(jpaQDo);
        if (!StringUtils.isEmpty(keyword)) {
            predicate = ExpressionUtils.and(predicate,
                    ExpressionUtils.or(jpaQDo.whCode.like("%" + keyword + "%"),
                            jpaQDo.whName.like("%" + keyword + "%")));
        }
        jpaQuery.where(predicate, jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        return jpaQuery;
    }


    public JPAQuery<InvWhSalListRespVO> searchSalWh(String keyword) {
        Predicate predicate = jpaQDo.isNotNull();
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvWhSalListRespVO.class,
                jpaQDo.id,
                jpaQDo.ouId,
                jpaQDo.relateOuCode,
                jpaQDo.relateOuId,
                jpaQDo.secBuId,
                jpaQDo.whCode,
                jpaQDo.physicalWhCode,
                jpaQDo.whName,
                jpaQDo.addrNo,
                jpaQDo.region,
                jpaQDo.fileCode,
                jpaQDo.jdbadFlag,
                jpaQDo.jdrelateCode,
                jpaQDo.jdsybCode,
                jpaQDo.jdwhCode,
                jpaQDo.belongBuId,
                jpaQDo.belongBuType
        )).from(jpaQDo);
        if (!StringUtils.isEmpty(keyword)) {
            predicate = ExpressionUtils.and(predicate,
                    ExpressionUtils.or(jpaQDo.whCode.like("%" + keyword + "%"),
                            jpaQDo.whName.like("%" + keyword + "%")));
        }
        jpaQuery.where(predicate, jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        return jpaQuery;
    }


    public JPAQuery<InvWhKeywordRespVO> findByKeyword(InvWhKeywordParamVO param) {
        val jpaQDo = QInvWhDO.invWhDO;
        QInvWhAreaDO qOrgWhAreaDO = QInvWhAreaDO.invWhAreaDO;
        JPAQuery<InvWhKeywordRespVO> jpaQuery = jpaQueryFactory.select(
                Projections.bean(
                        InvWhKeywordRespVO.class,
                        jpaQDo.id,
                        jpaQDo.ouId,
                        jpaQDo.buId,
                        jpaQDo.whCode,
                        jpaQDo.whName,
                        jpaQDo.whType,
                        qOrgWhAreaDO.whArea,
                        qOrgWhAreaDO.deter3,
                        qOrgWhAreaDO.outerCode,
                        qOrgWhAreaDO.outerCode2,
                        jpaQDo.belongBuId,
                        jpaQDo.belongBuType
                )).from(jpaQDo).leftJoin(qOrgWhAreaDO).on(jpaQDo.id.eq(qOrgWhAreaDO.whId));
        Predicate predicate = jpaQDo.deleteFlag.isNull().or(jpaQDo.deleteFlag.eq(0));
        if (!StringUtils.isEmpty(param.getDeterType()) && !("All").equals(param.getDeterType())) {
            if ("Good".equals(param.getDeterType())) {
                predicate = ExpressionUtils.and(predicate, qOrgWhAreaDO.whArea.in("GD", "GD-TF", "ON", "EC", "PKG", "SIN"));
            } else if (param.getDeterType().equals("Bad")) {
                predicate = ExpressionUtils.and(predicate, qOrgWhAreaDO.whArea.notIn("GD", "GD-TF", "ON", "EC", "PKG", "SIN"));
            }
        }
        // 仓库类型
        if (!StringUtils.isEmpty(param.getWhType()) && !"All".equals(param.getWhType())) {
            if ("PHYSICAL".equals(param.getWhType())) {
                predicate = ExpressionUtils.and(predicate, jpaQDo.whType.eq("PHYSICAL"));
            } else if ("CONSIGMENT".equals(param.getWhType())) {
                predicate = ExpressionUtils.and(predicate, jpaQDo.whType.eq("CONSIGMENT"));
            }
        }
        if (!StringUtils.isEmpty(param.getMultiKeywords())) {
            predicate = ExpressionUtils.and(
                    predicate, ExpressionUtils.anyOf(
                            jpaQDo.whCode.like('%' + param.getMultiKeywords() + '%'),
                            jpaQDo.whName.like('%' + param.getMultiKeywords() + '%'),
                            qOrgWhAreaDO.outerCode.like('%' + param.getMultiKeywords() + '%')
                    ));
        }
        return jpaQuery.where(predicate);
    }


    public JPAQuery<InvWhRespVO> listBuId(InvWhListParamVO param) {
        val jpaQDo = QInvWhDO.invWhDO;
        Predicate predicate = jpaQDo.isNotNull();
        val jpaQuery = jpaQueryFactory.select(Projections.bean(InvWhRespVO.class,
                jpaQDo.id,
                jpaQDo.whCode,
                jpaQDo.secBuId,
                jpaQDo.physicalWhCode,
                jpaQDo.whName,
                jpaQDo.addrNo,
                jpaQDo.region,
                jpaQDo.fileCode
        )).from(jpaQDo);
        if (param != null && !StringUtils.isEmpty(param.getKeyword())) {
            predicate = ExpressionUtils.and(predicate,
                    ExpressionUtils.or(jpaQDo.whCode.like("%" + param.getKeyword() + "%"),
                            jpaQDo.whName.like("%" + param.getKeyword() + "%")));
        }
        if (param != null && Objects.nonNull(param.getBuId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.buId.eq(param.getBuId()));
        }
        jpaQuery.where(predicate, jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        return jpaQuery;
    }


    /**
     * 根据主键查询
     *
     * @param id 主键
     */
    public Predicate where(Long id) {
        val jpaQDo = QInvWhDO.invWhDO;
        Predicate predicate = jpaQDo.isNotNull().or(jpaQDo.isNull());
        ExpressionUtils.and(predicate, jpaQDo.id.eq(id));
        return predicate;
    }

    public Predicate searchWhere(InvWhParamVO param) {
        val jpaQDo = QInvWhDO.invWhDO;
        Predicate predicate = jpaQDo.isNotNull().or(jpaQDo.isNull());
        /**数据权限*/
        try {
            Predicate predicateAuth = DataAuthJpaUtil.dataAuthJpaPredicate(jpaQDo.getMetadata());
            predicate = ExpressionUtils.and(predicate, predicateAuth);
        } catch (Exception e) {
            throw new BusinessException(ApiCode.FAIL, "数据权限异常");
        }
        //仓库id,销售订单，订单明细专用，roman.zhang add at 2020.12.9 start
        if (Objects.nonNull(param.getId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.id.eq(param.getId()));
        }
        //仓库id,销售订单，订单明细专用，roman.zhang add at 2020.12.9 end
        if (Objects.nonNull(param.getOuId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ouId.eq(param.getOuId()));
        }
        if (!StringUtils.isEmpty(param.getBelongBuId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.belongBuId.eq(param.getBelongBuId()));
        }
        if (!StringUtils.isEmpty(param.getEs1())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.es1.eq(param.getEs1()));
        }
        if (!CollectionUtils.isEmpty(param.getOuIds())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ouId.in(param.getOuIds()));
        }
        if (!StringUtils.isEmpty(param.getWhType())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whType.eq(param.getWhType()));
        }
        if (!StringUtils.isEmpty(param.getWhType2())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whType2.eq(param.getWhType2()));
        }
        if (!StringUtils.isEmpty(param.getKeyword())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whCode.like("%" + param.getKeyword() + "%").or(jpaQDo.whName.like("%" + param.getKeyword() + "%")));
        }
        if (!StringUtils.isEmpty(param.getWhCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whCode.like("%" + param.getWhCode() + "%"));
        }
        if (!StringUtils.isEmpty(param.getWhName())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whName.like("%" + param.getWhName() + "%"));
        }
        if (!StringUtils.isEmpty(param.getOtherWhCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.otherWhCode.like("%" + param.getOtherWhCode() + "%"));
        }
        if (!StringUtils.isEmpty(param.getOtherWhType())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.otherWhType.like("%" + param.getOtherWhType() + "%"));
        }
        if (!StringUtils.isEmpty(param.getWhStatus())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whStatus.eq(param.getWhStatus()));
        }
        if (!StringUtils.isEmpty(param.getBusinessCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.businessCode.like("%" + param.getBusinessCode() + "%"));
        }
        if (!StringUtils.isEmpty(param.getDesCode())) {
            predicate = ExpressionUtils.and(predicate, Expressions.booleanTemplate("FIND_IN_SET({0},{1}) >0", param.getDesCode(), jpaQDo.desCode));
        }
        if (!CollectionUtils.isEmpty(param.getDesCodeList())) {
            for (String desCode : param.getDesCodeList()) {
                predicate = StringUtils.isEmpty(desCode) ? predicate :
                        ExpressionUtils.and(predicate, Expressions.booleanTemplate("FIND_IN_SET({0},{1}) >0", desCode, jpaQDo.desCode));
            }
        }
        /** 处理关键字为 仓库名称+温层 或 仓库名称 仓库编码 仓库类型 的查询情况  */
        //添加仓库id，用于area反查
        if (!CollectionUtils.isEmpty(param.getWhIds()) && param.getWhIds().size() > 0) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.id.in(param.getWhIds()));
        }
        if (!StringUtils.isEmpty(param.getMultiKeywords())) {
            //判断关键字是否为拼接条件
            String[] s = param.getMultiKeywords().split(" ");
            if (s.length == 2) {
                String whName = s[0];
                predicate = ExpressionUtils.and(predicate, jpaQDo.whName.like("%" + whName + "%"));
            } else {
                //当关键字为仓库类型时
                if (!CollectionUtils.isEmpty(param.getWhTypes())) {
                    predicate = ExpressionUtils.and(predicate, ExpressionUtils.or(
                            jpaQDo.whCode.like("%" + param.getMultiKeywords() + "%"),
                            ExpressionUtils.or(jpaQDo.whName.like("%" + param.getMultiKeywords() + "%"), jpaQDo.whType2.in(param.getWhTypes()))
                    ));
                } else {
                    //当关键字为仓库名称和编码
                    predicate = ExpressionUtils.and(predicate, ExpressionUtils.or(
                            jpaQDo.whCode.like("%" + param.getMultiKeywords() + "%"),
                            jpaQDo.whName.like("%" + param.getMultiKeywords() + "%")
                    ));
                }
            }
            /** 处理关键字为仓库名称+温层的查询情况 shihaodong 2021/1/12 end */
        }
        return predicate;
    }

    /**
     * 条件查询
     *
     * @param param 查询条件
     */
    public Predicate where(InvWhParamVO param) {
        val jpaQDo = QInvWhDO.invWhDO;
        Predicate predicate = jpaQDo.isNotNull().or(jpaQDo.isNull());
        if (Objects.nonNull(param.getId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.id.eq(param.getId()));
        }
        if (Objects.nonNull(param.getOuId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ouId.eq(param.getOuId()));
        }
        if (Objects.nonNull(param.getBuId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.buId.eq(param.getBuId()));
        }
        if (Objects.nonNull(param.getOwnerAddrNo())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ownerAddrNo.eq(param.getOwnerAddrNo()));
        }
        if (!StringUtils.isEmpty(param.getRelateOuCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.relateOuCode.eq(param.getRelateOuCode()));
        }

        if (Objects.nonNull(param.getRelateOuId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.relateOuId.eq(param.getRelateOuId()));
        }

        if (!CollectionUtils.isEmpty(param.getWhTypes())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whType.in(param.getWhTypes()));
        }
        if (!StringUtils.isEmpty(param.getWhCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whCode.eq(param.getWhCode()));
        }
        if (!StringUtils.isEmpty(param.getWhName())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whName.eq(param.getWhName()));
        }
        if (!StringUtils.isEmpty(param.getWhName2())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whName2.eq(param.getWhName2()));
        }
        if (!StringUtils.isEmpty(param.getWhAbbr())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whAbbr.eq(param.getWhAbbr()));
        }
        if (!StringUtils.isEmpty(param.getWhType())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whType.eq(param.getWhType()));
        }
        if (!StringUtils.isEmpty(param.getWhType2())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whType2.eq(param.getWhType2()));
        }
        if (!StringUtils.isEmpty(param.getWhType3())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whType3.eq(param.getWhType3()));
        }
        if (!StringUtils.isEmpty(param.getWhStatus())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whStatus.eq(param.getWhStatus()));
        }
        if (!StringUtils.isEmpty(param.getWhStatus2())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whStatus2.eq(param.getWhStatus2()));
        }
        if (Objects.nonNull(param.getThirdplFlag())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.thirdplFlag.eq(param.getThirdplFlag()));
        }
        if (!StringUtils.isEmpty(param.getPhysicalWhCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.physicalWhCode.eq(param.getPhysicalWhCode()));
        }
        if (Objects.nonNull(param.getAddrNo())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.addrNo.eq(param.getAddrNo()));
        }
        if (Objects.nonNull(param.getAddressId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.addressId.eq(param.getAddressId()));
        }
        if (Objects.nonNull(param.getPid())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.pid.eq(param.getPid()));
        }
        if (!StringUtils.isEmpty(param.getWhPath())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whPath.eq(param.getWhPath()));
        }
        if (!StringUtils.isEmpty(param.getRegion())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.region.eq(param.getRegion()));
        }
        if (!StringUtils.isEmpty(param.getEs1())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.es1.eq(param.getEs1()));
        }
        if (!StringUtils.isEmpty(param.getEs2())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.es2.eq(param.getEs2()));
        }
        if (!StringUtils.isEmpty(param.getEs3())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.es3.eq(param.getEs3()));
        }
        if (!StringUtils.isEmpty(param.getEs4())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.es4.eq(param.getEs4()));
        }
        if (!StringUtils.isEmpty(param.getEs5())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.es5.eq(param.getEs5()));
        }
        if (!StringUtils.isEmpty(param.getEs6())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.es6.eq(param.getEs6()));
        }
        if (!StringUtils.isEmpty(param.getEs7())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.es7.eq(param.getEs7()));
        }
        if (!StringUtils.isEmpty(param.getEs8())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.es8.eq(param.getEs8()));
        }
        if (!StringUtils.isEmpty(param.getEs9())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.es9.eq(param.getEs9()));
        }
        if (!StringUtils.isEmpty(param.getEs10())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.es10.eq(param.getEs10()));
        }
        if (!StringUtils.isEmpty(param.getEe1())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ee1.eq(param.getEe1()));
        }
        if (!StringUtils.isEmpty(param.getEe2())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ee2.eq(param.getEe2()));
        }
        if (!StringUtils.isEmpty(param.getEe3())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ee3.eq(param.getEe3()));
        }
        if (Objects.nonNull(param.getTenantId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.tenantId.eq(param.getTenantId()));
        }
        if (!StringUtils.isEmpty(param.getRemark())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.remark.eq(param.getRemark()));
        }
        if (Objects.nonNull(param.getCreateUserId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.createUserId.eq(param.getCreateUserId()));
        }
        if (Objects.nonNull(param.getCreateTime())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.createTime.eq(param.getCreateTime()));
        }
        if (Objects.nonNull(param.getModifyUserId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.modifyUserId.eq(param.getModifyUserId()));
        }
        if (Objects.nonNull(param.getModifyTime())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.modifyTime.eq(param.getModifyTime()));
        }
        if (Objects.nonNull(param.getDeleteFlag())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.deleteFlag.eq(param.getDeleteFlag()));
        }
        if (Objects.nonNull(param.getAuditDataVersion())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.auditDataVersion.eq(param.getAuditDataVersion()));
        }
        /*if (!CollectionUtils.isEmpty(param.getDesCodeList())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.desCode.in(param.getDesCodeList()));
        }
        if (!StringUtils.isEmpty(param.getDesCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.desCode.eq(param.getDesCode()));
        }*/
        if (!StringUtils.isEmpty(param.getDesCode())) {
            predicate = ExpressionUtils.and(predicate, Expressions.booleanTemplate("FIND_IN_SET({0},{1}) >0", param.getDesCode(), jpaQDo.desCode));
        }
        if (!CollectionUtils.isEmpty(param.getDesCodeList())) {
            for (String desCode : param.getDesCodeList()) {
                predicate = StringUtils.isEmpty(desCode) ? predicate :
                        ExpressionUtils.and(predicate, Expressions.booleanTemplate("FIND_IN_SET({0},{1}) >0", desCode, jpaQDo.desCode));
            }
        }
        return predicate;
    }

    /**
     * 条件查询
     *
     * @param param 查询条件
     */
    public Predicate where(InvWhRpcDtoParam param) {
        val jpaQDo = QInvWhDO.invWhDO;
        QInvWhAreaDO invWhAreaDO = QInvWhAreaDO.invWhAreaDO;
        Predicate predicate = jpaQDo.isNotNull().or(jpaQDo.isNull());

        if(Objects.nonNull(param.getDesId())){
            predicate = ExpressionUtils.and(predicate, jpaQDo.desId.eq(param.getDesId()));
        }
        if (!StringUtils.isEmpty(param.getWhCode()) && !param.getWhCode().equals("")) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whCode.eq(param.getWhCode()));
        }
        if (!StringUtils.isEmpty(param.getWhName()) && !param.getWhName().equals("")) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whName.eq(param.getWhName()));
        }
        if(!CollectionUtils.isEmpty(param.getDeter2s())){
            predicate = ExpressionUtils.and(predicate, invWhAreaDO.deter2.in(param.getDeter2s()));
        }
        if (StringUtils.isNotEmpty(param.getDeter2Type())) {
            predicate = ExpressionUtils.and(predicate, invWhAreaDO.deter2Type.eq(param.getDeter2Type()));
        }
        if (!CollectionUtils.isEmpty(param.getWhCodes())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whCode.in(param.getWhCodes()));
        }
        if (!StringUtils.isEmpty(param.getWhType()) && !param.getWhType().equals("")) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whType.eq(param.getWhType()));
        }
        if (!StringUtils.isEmpty(param.getErpCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.erpCode.eq(param.getErpCode()));
        }
        if (!StringUtils.isEmpty(param.getEs1())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.es1.eq(param.getEs1()));
        }
        if (Objects.nonNull(param.getThirdplFlag())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.thirdplFlag.eq(param.getThirdplFlag()));
        }

        if (Objects.nonNull(param.getJdbadFlag())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.jdbadFlag.eq(param.getJdbadFlag()));
        }
        if (!StringUtils.isEmpty(param.getJdrelateCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.jdrelateCode.eq(param.getJdrelateCode()));
        }
        if (!StringUtils.isEmpty(param.getJdsybCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.jdsybCode.eq(param.getJdsybCode()));
        }
        if (!StringUtils.isEmpty(param.getJdwhCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.jdwhCode.eq(param.getJdwhCode()));
        }

        if (!CollectionUtils.isEmpty(param.getWhTypes())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.whType.in(param.getWhTypes()));
        }
        if (!CollectionUtils.isEmpty(param.getWhIds())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.id.in(param.getWhIds()));
        }

        if (!CollectionUtils.isEmpty(param.getOuIds())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ouId.in(param.getOuIds()));
        }

        if (Objects.nonNull(param.getOuId()) && !param.getOuId().toString().equals("")) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ouId.eq(param.getOuId()));
        }

        if (Objects.nonNull(param.getRelateOuId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.relateOuId.eq(param.getRelateOuId()));
        }

        if (!StringUtils.isEmpty(param.getRelateOuCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.relateOuCode.eq(param.getRelateOuCode()));
        }

        if (Objects.nonNull(param.getWhId()) && !param.getWhId().toString().equals("")) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.id.eq(param.getWhId()));
        }


        return predicate;
    }

    /**
     * 条件查询
     *
     * @param param 查询条件
     */
    public List<Predicate> where(InvWhDeliveryRpcDtoParam param, List<Predicate> predicates) {
        if (Objects.nonNull(param.getOuId()) && !param.getOuId().toString().equals("") && param.getOuId() != 0) {
            predicates.add(whDeliveryDO.ouId.eq(param.getOuId()));
        }
        if (Objects.nonNull(param.getWhId())) {
            predicates.add(jpaQDo.id.eq(param.getWhId()));
        }

        if (!StringUtils.isEmpty(param.getWhCode())) {
            predicates.add(jpaQDo.whCode.eq(param.getWhCode()));
        }
        if (!CollectionUtils.isEmpty(param.getWhIds())) {
            predicates.add(jpaQDo.id.in(param.getWhIds()));
        }
        if (Objects.nonNull(param.getThirdplFlag())) {
            predicates.add(jpaQDo.thirdplFlag.eq(param.getThirdplFlag()));
        }
        if (!StringUtils.isEmpty(param.getErpCode())) {
            predicates.add(jpaQDo.erpCode.eq(param.getErpCode()));
        }
        if (!StringUtils.isEmpty(param.getEs1())) {
            predicates.add(jpaQDo.es1.eq(param.getEs1()));
        }
        if (Objects.nonNull(param.getAllArea())) {
            predicates.add(whDeliveryDO.allArea.eq(param.getAllArea()));
        }

        if (!StringUtils.isEmpty(param.getRelateOuCode())) {
            predicates.add(jpaQDo.relateOuCode.eq(param.getRelateOuCode()));
        }
        if (!StringUtils.isEmpty(param.getRelateOuCode())) {
            predicates.add(jpaQDo.relateOuId.eq(param.getRelateOuId()));
        }

        if (!StringUtils.isEmpty(param.getPcode()) && !param.getPcode().equals("")) {
            predicates.add(whDeliveryDO.pCode.eq(param.getPcode()));
        }

        if (!StringUtils.isEmpty(param.getCcode()) && !param.getCcode().equals("")) {
            predicates.add(whDeliveryDO.cCode.eq(param.getCcode()));
        }

        if (!StringUtils.isEmpty(param.getAcode()) && !param.getAcode().equals("")) {
            predicates.add(whDeliveryDO.aCode.eq(param.getAcode()));
        }

        if (!StringUtils.isEmpty(param.getScode()) && !param.getScode().equals("")) {
            predicates.add(whDeliveryDO.sCode.eq(param.getScode()));
        }

        return predicates;
    }


    public List<Predicate> whereAllWharea(InvWhDeliveryRpcDtoParam param, List<Predicate> predicates) {
        if (Objects.nonNull(param.getOuId()) && !param.getOuId().toString().equals("") && param.getOuId() != 0) {
            predicates.add(whDeliveryDO.ouId.eq(param.getOuId()));
        }
        if (Objects.nonNull(param.getWhId())) {
            predicates.add(jpaQDo.id.eq(param.getWhId()));
        }

        if (!StringUtils.isEmpty(param.getWhCode())) {
            predicates.add(jpaQDo.whCode.eq(param.getWhCode()));
        }
        if (!CollectionUtils.isEmpty(param.getWhIds())) {
            predicates.add(jpaQDo.id.in(param.getWhIds()));
        }

        if (!StringUtils.isEmpty(param.getRelateOuCode())) {
            predicates.add(jpaQDo.relateOuCode.eq(param.getRelateOuCode()));
        }
        if (!StringUtils.isEmpty(param.getRelateOuCode())) {
            predicates.add(jpaQDo.relateOuId.eq(param.getRelateOuId()));
        }
        return predicates;
    }


    public Predicate interfaceWhere(Long whId) {
        val jpaQDo = QInvWhDO.invWhDO;
        Predicate predicate = jpaQDo.isNotNull().or(jpaQDo.isNull());
        predicate = ExpressionUtils.and(predicate, jpaQDo.whType.ne(UdcEnum.INV_WH_TYPE_LOGICAL.getValueCode()));
        predicate = ExpressionUtils.and(predicate, jpaQDo.thirdplFlag.eq(1));
        if (Objects.nonNull(whId)) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.id.eq(whId));
        }
        return predicate;
    }

    public List<StorageDTO> findStorageList(List<Long> idList) {
        val jpaQDo = QInvWhDO.invWhDO;
        Predicate predicate = jpaQDo.isNotNull();
        predicate = jpaQDo.deleteFlag.isNull().or(jpaQDo.deleteFlag.eq(0));
        JPAQuery<StorageDTO> jpaQuery = jpaQueryFactory.select(Projections.bean(StorageDTO.class,
                jpaQDo.id,
                jpaQDo.whCode,
                jpaQDo.whName,
                jpaQDo.whType,
                jpaQDo.ouId,
                jpaQDo.belongBuId,
                jpaQDo.belongBuType,
                jpaQDo.whStatus,
                jpaQDo.addrNo,
                jpaQDo.businessCode,
                jpaQDo.thirdplFlag,
                jpaQDo.jdwhCode
        )).from(jpaQDo);
        if (!CollectionUtils.isEmpty(idList)) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.id.in(idList));
        }
        List<StorageDTO> storageDTOS = jpaQuery.where(predicate).fetch();
        return storageDTOS;
    }

    public List<StorageDTO> findStorageIds(Long whId) {
        val jpaQDo = QInvWhDO.invWhDO;
        Predicate predicate = jpaQDo.isNotNull();
        predicate = jpaQDo.deleteFlag.isNull().or(jpaQDo.deleteFlag.eq(0));
        JPAQuery<StorageDTO> jpaQuery = jpaQueryFactory.select(Projections.bean(StorageDTO.class,
                jpaQDo.id,
                jpaQDo.whCode,
                jpaQDo.whName,
                jpaQDo.whType,
                jpaQDo.ouId,
                jpaQDo.belongBuId,
                jpaQDo.belongBuType,
                jpaQDo.whStatus,
                jpaQDo.addrNo,
                jpaQDo.businessCode,
                jpaQDo.thirdplFlag
        )).from(jpaQDo);
        if (Objects.nonNull(whId)) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.id.eq(whId));
        }
        List<StorageDTO> storageDTOS = jpaQuery.where(predicate).fetch();
        return storageDTOS;
    }

    public List<InvWhPTypeRespVO> findWhPTypeList(String pType) {
        QInvWhDO invWhDO = QInvWhDO.invWhDO;
        QInvWhAreaDO invWhAreaDO = QInvWhAreaDO.invWhAreaDO;
        JPAQuery<InvWhPTypeRespVO> jpaQuery = jpaQueryFactory.select(Projections.bean(InvWhPTypeRespVO.class,
                invWhDO.id,
                invWhDO.whCode,
                invWhDO.whName,
                invWhAreaDO.pCode.as("PCode"),
                invWhAreaDO.pType.as("PType"),
                invWhDO.relateOuId,
                invWhDO.relateOuCode))
                .from(invWhDO).leftJoin(invWhAreaDO).on(invWhDO.id.eq(invWhAreaDO.whId))
                .where(invWhAreaDO.pType.eq(pType));
        return jpaQuery.fetch();
    }

    public List<InvWhRespVO> getDespatchWhByDeter2KeyWord(String deter2){
        QInvWhDO invWhDO = QInvWhDO.invWhDO;
        QInvWhAreaDO invWhAreaDO = QInvWhAreaDO.invWhAreaDO;
        JPAQuery<InvWhRespVO> jpaQuery = jpaQueryFactory.select(Projections.bean(InvWhRespVO.class,
                invWhDO.id,
                invWhDO.whCode,
                invWhDO.whName,
                invWhDO.desCode
        )).from(invWhDO)
                .leftJoin(invWhAreaDO).on(invWhDO.id.eq(invWhAreaDO.whId));
        Predicate predicate1 = invWhDO.deleteFlag.eq(0).or(invWhDO.deleteFlag.isNull());
        Predicate predicate2 = ExpressionUtils.and(predicate1, ExpressionUtils.or(
                invWhAreaDO.deter2.like("%" + deter2 + "%"),
                invWhAreaDO.deter2Name.like("%" + deter2+ "%")
        ));
        jpaQuery.where(predicate2);
        jpaQuery.groupBy(invWhDO.id,invWhDO.whCode);
        return jpaQuery.fetch();
    }


    public void enableWhhConfig(Long id, String whStatus) {
        val jpaQDo = QInvWhDO.invWhDO;
        jpaQueryFactory.update(jpaQDo).set(jpaQDo.whStatus,whStatus)
                .where(jpaQDo.id.eq(id),
                        jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull())).execute();

    }




}
