package com.elitesland.yst.production.inv.infr.repo.ioc;

import com.elitesland.yst.production.inv.application.facade.vo.ioc.InvIocParamVO;
import com.elitesland.yst.production.inv.domain.entity.ioc.QInvIocDO;
import com.elitesland.yst.production.inv.infr.dto.InvIocDTO;
import com.elitesland.yst.production.inv.infr.repo.JpaQueryProcInterface;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 功能说明:库存操作码
 * </p>
 *
 * @Author Darren
 * @Date 2022/04/19
 * @Version 1.0
 * @Content:
 */
@Component
@AllArgsConstructor
public class InvIocRepoProc implements JpaQueryProcInterface {
    private final JPAQueryFactory jpaQueryFactory;

    public PagingVO<InvIocDTO> search(InvIocParamVO param) {
        val jpaQDo = QInvIocDO.invIocDO;
        val jpaQuery = jpaQueryFactory.select(
                Projections.bean(
                        InvIocDTO.class,
                        jpaQDo.id,
                        jpaQDo.ioCode,
                        jpaQDo.ioName,
                        jpaQDo.ioType,
                        jpaQDo.status,
                        jpaQDo.remark,
                        jpaQDo.createUserId,
                        jpaQDo.creator,
                        jpaQDo.createTime,
                        jpaQDo.modifyUserId,
                        jpaQDo.updater,
                        jpaQDo.modifyTime,
                        jpaQDo.deleteFlag,
                        jpaQDo.tenantId,
                        jpaQDo.auditDataVersion
                )
        ).from(jpaQDo);
        if (param != null) {
            jpaQuery.where(where(param));
            param.fillOrders(jpaQuery, jpaQDo);
            param.setPaging(jpaQuery);
        }
        jpaQuery.where(jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        return PagingVO.<InvIocDTO>builder()
                .total(jpaQuery.fetchCount())
                .records(jpaQuery.fetch())
                .build();
    }

    public JPAQuery<InvIocDTO> select(InvIocParamVO param) {
        val jpaQDo = QInvIocDO.invIocDO;
        val jpaQuery = jpaQueryFactory.select(
                Projections.bean(
                        InvIocDTO.class,
                        jpaQDo.id,
                        jpaQDo.ioCode,
                        jpaQDo.ioName,
                        jpaQDo.ioType,
                        jpaQDo.status,
                        jpaQDo.remark,
                        jpaQDo.createUserId,
                        jpaQDo.creator,
                        jpaQDo.createTime,
                        jpaQDo.modifyUserId,
                        jpaQDo.updater,
                        jpaQDo.modifyTime,
                        jpaQDo.deleteFlag,
                        jpaQDo.tenantId,
                        jpaQDo.auditDataVersion
                )
        ).from(jpaQDo);
        if (Objects.nonNull(param)) {
            jpaQuery.where(where(param));
            if (!CollectionUtils.isEmpty(param.getOrders())) {
                param.fillOrders(jpaQuery, jpaQDo);
            }
        }
        jpaQuery.where(jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));
        return jpaQuery;
    }

    public Predicate where(InvIocParamVO param) {
        val jpaQDo = QInvIocDO.invIocDO;
        Predicate predicate = jpaQDo.isNotNull();
        // predicate = ExpressionUtils.and(predicate, jpaQDo.deleteFlag.eq(0).or(jpaQDo.deleteFlag.isNull()));


        if (!StringUtils.isEmpty(param.getId())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.id.eq(param.getId()));
        }
        if (!CollectionUtils.isEmpty(param.getIdList())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.id.in(param.getIdList()));
        }
        if (!StringUtils.isEmpty(param.getKeyword())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ioCode.like("%" + param.getKeyword() + "%").or(jpaQDo.ioName.like("%" + param.getKeyword() + "%")));
        }

        if (!StringUtils.isEmpty(param.getIoCode())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ioCode.eq(param.getIoCode()));
        }
        if (!CollectionUtils.isEmpty(param.getIoCodeList())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ioCode.in(param.getIoCodeList()));
        }
        if (!StringUtils.isEmpty(param.getIoName())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ioName.eq(param.getIoName()));
        }

        if (!StringUtils.isEmpty(param.getIoType())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.ioType.eq(param.getIoType()));
        }

        if (!StringUtils.isEmpty(param.getStatus())) {
            predicate = ExpressionUtils.and(predicate, jpaQDo.status.eq(param.getStatus()));
        }

        return predicate;
    }


    public JPAUpdateClause updateDeleteFlagByIds(Integer deleteFlag, List<Long> idList) {
        val jpaQDo = QInvIocDO.invIocDO;
        Predicate predicate = jpaQDo.isNotNull();
        return jpaQueryFactory.update(jpaQDo)
                .set(jpaQDo.deleteFlag, deleteFlag)
                .where(ExpressionUtils.and(predicate, jpaQDo.id.in(idList)));
    }
}
