package com.elitesland.yst.production.inv.provider;

import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.inv.Application;
import com.elitesland.yst.production.inv.domain.service.InvDespatchConfigDomainService;
import com.elitesland.yst.production.inv.dto.invDes.param.InvDespatchRpcParam;
import com.elitesland.yst.production.inv.dto.invDes.resp.InvDespatchRpcDTO;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @author jeesie
 * @description:
 * @datetime 2023年 02月 20日 2:26 下午
 * @version: 1.0
 */

@AllArgsConstructor
@Slf4j
@RestController
@RequestMapping(Application.URI_PREFIX + InvDespatchProvider.PATH)
public class InvDespatchProviderImpl implements InvDespatchProvider {

    private final InvDespatchConfigDomainService invDespatchConfigDomainService;


    @Override
    public List<InvDespatchRpcDTO> findDespatchRpcByParam(InvDespatchRpcParam param) {
        log.info("调用findDespatchRpcByParam 开始，时间：{},参数：{}", LocalDateTime.now(), JSON.toJSONString(param));
        if(param == null){
            throw new BusinessException(ApiCode.FAIL,"参数不能为空");
        }
        return invDespatchConfigDomainService.findDespatchRpcByParam(param);
    }
}
