package com.elitesland.yst.production.inv.utils;

/**
 * @ProjectName: yst-dch-score
 * @Package: com.elitesland.common
 * @ClassName: UdcEnum
 * @Author: chen
 * @Description: udc枚举
 * @Date: 2020/7/7 15:22
 * @Version: 1.0
 */
public enum InvUdcEnum {
    //数据库sql拼接：SELECT CONCAT(domain_code,'_',udc_code,'_',udc_val,'("',domain_code,'","',udc_code,'","',udc_name,'","',udc_val,'","',val_desc,'"),') FROM sys_udc ORDER BY domain_code,udc_name
    /**
     * 商品转换系数刘起说暂时固定1
     */
    INV_FUNC_TYPE_15("yst-inv","FUNC_TYPE","功能区","15","网格个人仓"),

    INV_WH_TYPE1_1("yst-inv","WH_TYPE","仓库类型","1","总仓"),
    INV_WH_TYPE1_2("yst-inv","WH_TYPE","仓库类型","2","分仓"),
    INV_WH_TYPE1_3("yst-inv","WH_TYPE","仓库类型","3","网格仓"),
    INV_WH_TYPE1_4("yst-inv","WH_TYPE","仓库类型","4","个人仓"),
    INV_WH_TYPE1_5("yst-inv","WH_TYPE","仓库类型","5","京云仓"),
    INV_WH_TYPE_1("yst-inv","WH_TYPE","仓库类型","1","总仓"),
    INV_WH_TYPE_2("yst-inv","WH_TYPE","仓库类型","2","分仓"),
    INV_WH_TYPE_3("yst-inv","WH_TYPE","仓库类型","3","前置仓"),
    INV_WH_TYPE_LOGICAL("yst-inv","WH_TYPE","仓库类型","LOGICAL","逻辑仓"),
    INV_EMP_SETTING_TEST("yst-inv","EMP_SETTING_TEST","售后师傅员工编号","20211028","售后师傅员工编号"),

    WH_STATUS_ACTIVE("yst-inv","WH_STATUS","仓库状态","ACTIVE","启用"),
    WH_STATUS_CLOSED("yst-inv","WH_STATUS","仓库状态","CLOSED","禁用"),
    /**根据和前端确认，此处越库标示比较特殊，0表示为越库，1为不越库**/
    INV_CROSSWH_FLAG_0("yst-inv","CROSSWH_FLAG","越库标识","0","是"),
    INV_CROSSWH_FLAG_1("yst-inv","CROSSWH_FLAG","越库标识","1","否"),
    PUR_SUPP_TYPE2_INNER("PUR", "SUPP_TYPE2", "供应商类型2", "INNER", "集团内供应商"),
    PUR_SUPP_TYPE2_OUTER("PUR", "SUPP_TYPE2", "供应商类型2", "OUTER", "外部供应商"),
    INV_CARR_STATUS_DR("yst-inv","CARR_STATUS","承运商配送单","DR","草稿"),
    INV_CARR_STATUS_SUBMIT("yst-inv","CARR_STATUS","承运商配送单","SUBMIT","已提交承运"),
    INV_CARR_STATUS_SIGN("yst-inv","CARR_STATUS","承运商配送单","SIGN","承运商已签收"),
    INV_CARR_STATUS_DONE("yst-inv","CARR_STATUS","承运商配送单","DONE","收货完成"),

    INV_ACTIVE_STATUS_ACTIVE("yst-inv","ACTIVE_STATUS","库存域启用/禁用状态","ACTIVE","启用"),
    INV_ACTIVE_STATUS_CLOSED("yst-inv","ACTIVE_STATUS","库存域启用/禁用状态","CLOSED","禁用"),

    INV_IO_TYPE_I("yst-inv","IO_TYPE","操作码类型","I","入库"),
    INV_IO_TYPE_O("yst-inv","IO_TYPE","操作码类型","O","出库"),
    INV_IO_TYPE_T("yst-inv","IO_TYPE","操作码类型","T","锁定"),
    INV_IO_TYPE_R("yst-inv","IO_TYPE","操作码类型","R","释放"),

   /* INV_P_TYPE_CUST("yst-inv","P_TYPE","合作伙伴类型","CUST","客户"),
    INV_P_TYPE_SUPP("yst-inv","P_TYPE","合作伙伴类型","SUPP","供应商"),
    INV_P_TYPE_EMP("yst-inv","P_TYPE","合作伙伴类型","EMP","员工"),*/

    INV_BUSINESS_CHOOSE_Y("yst-inv","BUSINESS_CHOOSE","建仓前端是否可选","1","是"),
    INV_BUSINESS_CHOOSE_N("yst-inv","BUSINESS_CHOOSE","建仓前端是否可选","0","否"),
    INV_ZERO_WH_Y("yst-inv","ZERO_WH","是否零价库","1","是"),
    INV_ZERO_WH_N("yst-inv","ZERO_WH","是否零价库","0","否"),
    ;
    private final String model;
    private final String code;
    private final String codeName;
    private final String valueCode;
    private final String valueCodeName;

    InvUdcEnum(final String model, final String code, final String codeName, final String valueCode, final String valueCodeName) {
        this.model = model;
        this.code = code;
        this.codeName = codeName;
        this.valueCode = valueCode;
        this.valueCodeName = valueCodeName;
    }


    public String getValueCode() {
        return valueCode;
    }

    public String getMsg() {
        return valueCodeName;
    }

    public String getModel() {
        return model;
    }

    public String getCode() {
        return code;
    }

    public String getValueCodeName() {
        return valueCodeName;
    }
}
