/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.application.service.impl;

import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysUserVO;
import com.elitesland.yst.production.inv.application.facade.vo.InvAjAndInvAjDDownloadRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.InvAjAndInvAjDRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.InvAjDQueryAllParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.InvAjDSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.InvLotStkCommon24InSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.OrgRespVO;
import com.elitesland.yst.production.inv.application.out.ItmOutService;
import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvAjDService;
import com.elitesland.yst.production.inv.application.service.InvWhAreaService;
import com.elitesland.yst.production.inv.domain.convert.InvAjConvert;
import com.elitesland.yst.production.inv.domain.service.InvAjDDomainService;
import com.elitesland.yst.production.inv.domain.service.InvAjDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhDomainService;
import com.elitesland.yst.production.inv.infr.dto.InvAjDTO;
import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.elitesland.yst.production.inv.utils.InvPTypeEnum;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class InvAjDServiceImpl
implements InvAjDService {
    private static final Logger log = LoggerFactory.getLogger(InvAjDServiceImpl.class);
    private final InvAjDDomainService invAjDDomainService;
    private final InvAjDomainService invAjDomainService;
    private final SystemService systemService;
    private final ItmOutService itmOutService;
    private final OrgOutService orgOutService;
    private final InvWhDomainService invWhDomainService;
    private final InvWhAreaService invWhAreaService;

    @Override
    @SysCodeProc
    public PagingVO<InvAjAndInvAjDRespVO> searchAll(InvAjDQueryAllParamVO param) {
        PagingVO<InvAjAndInvAjDRespVO> pagingVO;
        List<String> brands = param.getBrands();
        if (!CollectionUtils.isEmpty(brands)) {
            List itemIds = null;
            ItmItemRpcDtoParam itmItemPartParam = new ItmItemRpcDtoParam();
            itmItemPartParam.setBrands(brands);
            List<ItmItemRpcDTO> itmItemPartDTOS = this.itmOutService.findItemRpcDtoByParam(itmItemPartParam);
            if (!CollectionUtils.isEmpty(itmItemPartDTOS)) {
                itemIds = itmItemPartDTOS.stream().map(ItmItemRpcDTO::getId).collect(Collectors.toList());
            }
            if (param.getItemIds() != null) {
                param.getItemIds().addAll(itemIds);
            } else {
                param.setItemIds(itemIds);
            }
        }
        if (CollectionUtils.isEmpty((Collection)(pagingVO = this.invAjDDomainService.invAjSearch(param)).getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        List ajAndInvAjDRespVOS = pagingVO.getRecords();
        this.fillUpNameList(ajAndInvAjDRespVOS);
        return PagingVO.builder().total(pagingVO.getTotal()).records(ajAndInvAjDRespVOS).build();
    }

    @Override
    public List<Long> updateInvAjDList(List<InvAjDSaveVO> list) {
        LinkedList<InvLotStkCommon24InSaveVO> inVOList = new LinkedList<InvLotStkCommon24InSaveVO>();
        Iterator<InvAjDSaveVO> it = list.iterator();
        while (it.hasNext()) {
            InvLotStkCommon24InSaveVO inVo = new InvLotStkCommon24InSaveVO();
            InvAjDSaveVO current = it.next();
            inVo.setItemId(current.getItemId());
            inVo.setVariId(current.getVariId());
            inVo.setWhId(current.getWhId());
            inVo.setDeter1(current.getDeter1());
            inVo.setDeter2(current.getDeter2());
            inVo.setLotNo(current.getLotNo());
            inVOList.add(inVo);
        }
        LinkedList<InvAjDSaveVO> validatedList = new LinkedList<InvAjDSaveVO>();
        validatedList.addAll(list.stream().filter(v -> v.getDestroyFlag() != null && v.getDestroyFlag() != false && !validatedList.contains(v)).collect(Collectors.toList()));
        InvAjDTO invAjDTO = this.invAjDomainService.findById(list.stream().findAny().map(InvAjDSaveVO::getMasId).orElseThrow());
        List<Long> ret = this.invAjDDomainService.updateInBatch(validatedList);
        return ret;
    }

    @Override
    public List<InvAjAndInvAjDDownloadRespVO> findInvAjAndInvAjDDownloadVOs(InvAjDQueryAllParamVO param) {
        param.setSize(20000);
        PagingVO<InvAjAndInvAjDRespVO> ret = this.searchAll(param);
        List list = ret.getRecords();
        List<InvAjAndInvAjDDownloadRespVO> invAjAndInvAjDDownloadRespVOS = list.stream().map(i -> {
            InvAjAndInvAjDDownloadRespVO downloadVO = InvAjConvert.INSTANCE.invAjAndAjdRespVOToInvAjAndInvAjDDownloadVO((InvAjAndInvAjDRespVO)i);
            downloadVO.setPartnerCode(i.getPCode());
            downloadVO.setPartnerName(i.getPName());
            downloadVO.setPartnerTypeName(i.getPTypeName());
            return downloadVO;
        }).collect(Collectors.toList());
        return invAjAndInvAjDDownloadRespVOS;
    }

    private void fillUpNameList(List<InvAjAndInvAjDRespVO> vos) {
        Map<String, String> ajStatusMap = this.systemService.sysUdcGetCodeMap(UdcEnum.INV_AJ_STATUS_DR.getModel(), UdcEnum.INV_AJ_STATUS_DR.getCode());
        Map<String, String> docTypeMap = this.systemService.sysUdcGetCodeMap(UdcEnum.INV_AJ_TYPE_LOT.getModel(), UdcEnum.INV_AJ_TYPE_LOT.getCode());
        Map<String, String> reasonMap = this.systemService.sysUdcGetCodeMap(UdcEnum.INV_REASON_CODE_SKAJ.getModel(), UdcEnum.INV_REASON_CODE_SKAJ.getCode());
        Map<String, String> uomMap = this.systemService.sysUdcGetCodeMap(UdcEnum.COM_UOM_BG.getModel(), UdcEnum.COM_UOM_BG.getCode());
        Map<String, String> pTypeMap = this.systemService.sysUdcGetCodeMap(UdcEnum.INV_PARTNER_TYPE_CUST.getModel(), UdcEnum.INV_PARTNER_TYPE_CUST.getCode());
        List itemIds = vos.stream().filter(f -> f.getItemId() != null).map(InvAjAndInvAjDRespVO::getItemId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        List<Long> ouIds = vos.stream().map(InvAjAndInvAjDRespVO::getOuId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        List<String> pSuppCodes = vos.stream().filter(i -> UdcEnum.INV_PARTNER_TYPE_SUPP.getValueCode().equals(i.getPType())).map(InvAjAndInvAjDRespVO::getPCode).distinct().collect(Collectors.toList());
        List pCustCodes = vos.stream().filter(i -> UdcEnum.INV_PARTNER_TYPE_CUST.getValueCode().equals(i.getPType())).map(InvAjAndInvAjDRespVO::getPCode).distinct().collect(Collectors.toList());
        List<String> pEmpCodes = vos.stream().filter(i -> UdcEnum.INV_PARTNER_TYPE_EMP.getValueCode().equals(i.getPType())).map(InvAjAndInvAjDRespVO::getPCode).distinct().collect(Collectors.toList());
        List<OrgRespVO> suppList = this.orgOutService.findcodeAndNameList(InvPTypeEnum.INV_PARTNER_TYPE_SUPP, pSuppCodes);
        List<OrgRespVO> empList = this.orgOutService.findcodeAndNameList(InvPTypeEnum.INV_PARTNER_TYPE_EMP, pEmpCodes);
        List<Long> createUserIds = vos.stream().map(BaseModelVO::getCreateUserId).distinct().collect(Collectors.toList());
        List<SysUserVO> sysUserDOS = this.systemService.findAllEmpsByIdIn(createUserIds);
        ItmItemRpcDtoParam itmItemPartParam = new ItmItemRpcDtoParam();
        itmItemPartParam.setItemIds(itemIds);
        List<ItmItemRpcDTO> itmItemPartDTOS = this.itmOutService.findItemRpcDtoByParam(itmItemPartParam);
        List<OrgOuRpcDTO> orgOuVOS = this.orgOutService.findOuByIds(ouIds);
        vos.forEach(vo -> {
            Optional<ItmItemRpcDTO> itmItemVO;
            if (!CollectionUtils.isEmpty((Collection)sysUserDOS)) {
                sysUserDOS.stream().filter(v -> v.getId() != null && v.getId().equals(vo.getCreateUserId())).findFirst().ifPresent(empVo -> vo.setCreator(empVo.getUsername()));
            }
            Optional<OrgOuRpcDTO> orgOuVO = orgOuVOS.stream().filter(v -> v.getId().equals(vo.getOuId())).findFirst();
            if (!CollectionUtils.isEmpty((Collection)itmItemPartDTOS) && (itmItemVO = itmItemPartDTOS.stream().filter(v -> v.getId().equals(vo.getItemId())).findFirst()).isPresent()) {
                ItmItemRpcDTO itemVO = itmItemVO.get();
                vo.setItemCode(itemVO.getItemCode());
                vo.setItemName(itemVO.getItemName());
                vo.setBrand(itemVO.getBrand());
                vo.setLotFlag(itemVO.getLotFlag());
            }
            if (orgOuVO.isPresent()) {
                OrgOuRpcDTO ouVO = orgOuVO.get();
                vo.setOuName(ouVO.getOuName());
                vo.setOuCode(ouVO.getOuCode());
            }
            if (!CollectionUtils.isEmpty((Map)ajStatusMap) && ajStatusMap.containsKey(vo.getDocStatus())) {
                vo.setDocStatusName((String)ajStatusMap.get(vo.getDocStatus()));
            }
            if (!CollectionUtils.isEmpty((Map)docTypeMap) && docTypeMap.containsKey(vo.getDocType())) {
                vo.setDocTypeName((String)docTypeMap.get(vo.getDocType()));
            }
            if (!CollectionUtils.isEmpty((Map)reasonMap) && reasonMap.containsKey(vo.getReasonCode())) {
                vo.setReasonCodeName((String)reasonMap.get(vo.getReasonCode()));
            }
            if (!CollectionUtils.isEmpty((Map)uomMap) && uomMap.containsKey(vo.getUom())) {
                vo.setUomName((String)uomMap.get(vo.getUom()));
            }
            if (!CollectionUtils.isEmpty((Map)pTypeMap) && pTypeMap.containsKey(vo.getPType())) {
                vo.setPTypeName((String)pTypeMap.get(vo.getPType()));
            }
            if (vo.getPCode() != null && UdcEnum.INV_PARTNER_TYPE_SUPP.getValueCode().equals(vo.getPType())) {
                suppList.stream().filter(s -> s.getCode().equals(vo.getPCode())).findAny().ifPresent(o -> vo.setPName(o.getName()));
            }
            if (vo.getPCode() != null && UdcEnum.INV_PARTNER_TYPE_EMP.getValueCode().equals(vo.getPType())) {
                empList.stream().filter(s -> s.getCode().equals(vo.getPCode())).findAny().ifPresent(o -> vo.setPName(o.getName()));
            }
        });
    }

    public InvAjDServiceImpl(InvAjDDomainService invAjDDomainService, InvAjDomainService invAjDomainService, SystemService systemService, ItmOutService itmOutService, OrgOutService orgOutService, InvWhDomainService invWhDomainService, InvWhAreaService invWhAreaService) {
        this.invAjDDomainService = invAjDDomainService;
        this.invAjDomainService = invAjDomainService;
        this.systemService = systemService;
        this.itmOutService = itmOutService;
        this.orgOutService = orgOutService;
        this.invWhDomainService = invWhDomainService;
        this.invWhAreaService = invWhAreaService;
    }
}

