/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.application.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysUserVO;
import com.elitesland.yst.production.inv.application.facade.vo.InvParentParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.base.InvBaseModel;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkDQueryParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkDRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkGroupBatchParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkGroupBatchRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkGroupRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkItemQueryParam;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkQueryGroupParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkQueryParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkUpdateSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.ItmInvStkItemRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.ItmInvStkShareRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.OrgRespVO;
import com.elitesland.yst.production.inv.application.out.ItmOutService;
import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvStkService;
import com.elitesland.yst.production.inv.application.service.InvWhService;
import com.elitesland.yst.production.inv.domain.convert.invstk.InvStkConvert;
import com.elitesland.yst.production.inv.domain.entity.invstk.InvStkDO;
import com.elitesland.yst.production.inv.domain.entity.invstk.QInvStkDO;
import com.elitesland.yst.production.inv.domain.service.InvStkDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhAreaDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhDomainService;
import com.elitesland.yst.production.inv.infr.dto.InvStkDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkFullDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkGroupDTO;
import com.elitesland.yst.production.inv.infr.repo.InvStkRepo;
import com.elitesland.yst.production.inv.infr.repo.InvStkRepoProc;
import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.elitesland.yst.production.inv.utils.BeanCopyUtil;
import com.elitesland.yst.production.inv.utils.InvPTypeEnum;
import com.elitesland.yst.production.inv.utils.InvUdcEnum;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitesland.yst.production.inv.utils.ValidationUtil;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.dto.OrgEmpRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.yst.production.support.provider.org.param.OrgEmpRpcDtoParam;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class InvStkServiceImpl
implements InvStkService {
    private static final Logger log = LoggerFactory.getLogger(InvStkServiceImpl.class);
    private final InvStkRepo invStkRepo;
    private final InvStkRepoProc invStkRepoProc;
    private final InvWhService invWhService;
    private final InvWhAreaDomainService invWhAreaDomainService;
    private final SystemService systemService;
    private final ItmOutService itmOutService;
    private final OrgOutService outouService;
    private final InvWhDomainService invWhDomainService;
    private final InvStkDomainService invStkDomainService;

    @Override
    public InvStkGroupRespVO getInvStkGroupByParam(InvBaseModel queryParam) {
        InvStkGroupRespVO results = null;
        this.paramCheckIn(queryParam);
        if (queryParam.getLotNo() != null && !queryParam.getLotNo().equals("")) {
            List fetch = ((JPAQuery)this.invStkRepoProc.select(null).where(this.getPredicate(QInvStkDO.invStkDO, queryParam))).fetch();
            if (!ObjectUtils.isEmpty((Object)fetch) && fetch.size() > 0) {
                results = InvStkConvert.INSTANCE.stkDTOToGroupRespVO((InvStkDTO)fetch.get(0));
                return results;
            }
        } else {
            List<InvStkGroupRespVO> fetch = this.selectInvStkGroupByInvBaseModel(queryParam);
            if (!ObjectUtils.isEmpty(fetch) && fetch.size() > 0) {
                results = fetch.get(0);
            }
        }
        return results;
    }

    @Override
    @SysCodeProc
    public List<InvStkGroupRespVO> selectInvStkGroupByInvBaseModel(InvBaseModel param) {
        List<InvStkGroupDTO> invStkGroupDTOList = this.invStkDomainService.selectInvStkGroupByInvBaseModel(param);
        if (CollectionUtils.isEmpty(invStkGroupDTOList)) {
            return Collections.EMPTY_LIST;
        }
        List<InvStkGroupRespVO> invStkGroupRespVOList = StreamSupport.stream(invStkGroupDTOList.spliterator(), false).map(InvStkConvert.INSTANCE::groupDtoToRespVo).collect(Collectors.toList());
        return invStkGroupRespVOList;
    }

    @Override
    public List<InvStkGroupBatchRespVO> getInvStkGroupBatchByParam(InvStkGroupBatchParamVO param) {
        List<InvBaseModel> invStkQueryParamList = param.getInvStkQueryParamList();
        if (!CollectionUtils.isEmpty(invStkQueryParamList)) {
            ArrayList<InvStkGroupBatchRespVO> arrayList = new ArrayList<InvStkGroupBatchRespVO>();
            invStkQueryParamList.forEach(i -> {
                this.paramCheckIn((InvBaseModel)i);
                List<InvStkGroupBatchRespVO> vos = this.invStkRepoProc.selectInvStkGroupBatchByParam((InvBaseModel)i);
                if (!ObjectUtils.isEmpty(vos) && vos.size() > 0) {
                    arrayList.add(vos.get(0));
                }
            });
            return arrayList;
        }
        throw new BusinessException(ApiCode.FAIL, "\u53c2\u6570\u4e3a\u7a7a\u8bf7\u68c0\u67e5\uff01");
    }

    @Override
    @SysCodeProc
    public PagingVO<InvStkRespVO> search(InvStkQueryParamVO param) {
        PagingVO pagingVO = this.invStkRepoProc.useSelect(param);
        List records = pagingVO.getRecords();
        this.udcChange(null, records);
        return pagingVO;
    }

    @Override
    public PagingVO<InvStkDRespVO> searchLot(InvStkDQueryParamVO param) {
        PagingVO pagingVO;
        List invStkDResults;
        if (!CollectionUtils.isEmpty(param.getBrands())) {
            ItmItemRpcDtoParam itmItemPartParam = new ItmItemRpcDtoParam();
            itmItemPartParam.setBrands(param.getBrands());
            itmItemPartParam.setItemIds(param.getItemIds());
            List<Long> brandItemIds = this.itmOutService.findItemRpcDtoByParam(itmItemPartParam).stream().map(ItmItemRpcDTO::getId).collect(Collectors.toList());
            if (brandItemIds.size() > 0) {
                param.setItemIds(brandItemIds);
            } else {
                return PagingVO.builder().total(0L).records(new ArrayList()).build();
            }
        }
        if (CollectionUtils.isEmpty((Collection)(invStkDResults = (pagingVO = this.invStkRepoProc.selectLot(param)).getRecords()))) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        this.results(invStkDResults);
        this.udcChange(invStkDResults, null);
        return PagingVO.builder().total(pagingVO.getTotal()).records(invStkDResults).build();
    }

    @Override
    @SysCodeProc
    public PagingVO<ItmInvStkItemRespVO> searchInvStkItem(InvStkItemQueryParam queryParam) {
        if (queryParam.getSuppCode() != null || Boolean.TRUE.equals(queryParam.getLotFlag())) {
            ItmItemRpcDtoParam param = new ItmItemRpcDtoParam();
            ArrayList<String> suppCodes = new ArrayList<String>();
            suppCodes.add(queryParam.getSuppCode());
            param.setSuppCodes(suppCodes);
            List<ItmItemRpcDTO> itemRpcDtoByParam = this.itmOutService.findItemRpcDtoByParam(param);
            if (CollectionUtils.isEmpty(itemRpcDtoByParam)) {
                return PagingVO.builder().total(0L).records(new ArrayList()).build();
            }
            List<Long> itemIds = itemRpcDtoByParam.stream().map(ItmItemRpcDTO::getId).distinct().collect(Collectors.toList());
            queryParam.setItemIds(itemIds);
        }
        List<ItmInvStkItemRespVO> stkItemRespVOS = this.invStkRepoProc.selectInvStkItem(queryParam);
        ArrayList invStkItemRespVOS = stkItemRespVOS.stream().filter(stkItemRespVO -> stkItemRespVO.getAvalQty().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ItmInvStkItemRespVO>(Comparator.comparing(f -> f.getItemCode() + f.getId()))), ArrayList::new));
        this.translateInvStkItem(stkItemRespVOS);
        return PagingVO.builder().total(Long.valueOf(invStkItemRespVOS.size()).longValue()).records((List)invStkItemRespVOS).build();
    }

    @Override
    public List<ItmInvStkItemRespVO> getInvStkItemByParam(InvStkItemQueryParam queryParam) {
        List<ItmInvStkItemRespVO> stkItemRespVOS = this.invStkRepoProc.selectInvStkItem(queryParam);
        ArrayList invStkItemRespVOS = stkItemRespVOS.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<ItmInvStkItemRespVO>(Comparator.comparing(f -> f.getItemCode() + f.getId()))), ArrayList::new));
        this.translateInvStkItem(invStkItemRespVOS);
        return invStkItemRespVOS;
    }

    @Override
    public List<ItmInvStkItemRespVO> selectInvStkItemByDesIds(List<Long> desIds) {
        if (CollectionUtils.isEmpty(desIds)) {
            return new ArrayList<ItmInvStkItemRespVO>();
        }
        return this.invStkRepoProc.selectInvStkItemByDesIds(desIds);
    }

    public void udcChange(List<InvStkDRespVO> invStkDRespVOS, List<InvStkRespVO> invStkRespVOS) {
        Map<String, String> udcItemType = this.systemService.sysUdcGetCodeMap(UdcEnum.ITM_ITEM_TYPE1_ITM_CENTER.getModel(), UdcEnum.ITM_ITEM_TYPE1_ITM_CENTER.getCode());
        Map<String, String> udcQcStatus = this.systemService.sysUdcGetCodeMap(UdcEnum.INV_LOT_QC_STATUS_LOCK.getModel(), UdcEnum.INV_LOT_QC_STATUS_LOCK.getCode());
        Map<String, String> udcFressType = this.systemService.sysUdcGetCodeMap(UdcEnum.COM_FRESS_TYPE_1.getModel(), UdcEnum.COM_FRESS_TYPE_1.getCode());
        Map<String, String> udcDeter1 = this.systemService.sysUdcGetCodeMap(UdcEnum.INV_TEMP_TYPE_RT.getModel(), UdcEnum.INV_TEMP_TYPE_RT.getCode());
        Map<String, String> udcUom = this.systemService.sysUdcGetCodeMap(UdcEnum.COM_UOM_BG.getModel(), UdcEnum.COM_UOM_BG.getCode());
        Map<String, String> udcWhtype = this.systemService.sysUdcGetCodeMap(InvUdcEnum.INV_WH_TYPE1_1.getModel(), InvUdcEnum.INV_WH_TYPE1_1.getCode());
        Map<String, String> udcItmeStatus = this.systemService.sysUdcGetCodeMap(UdcEnum.ITM_ITEM_STATUS_INVALID.getModel(), UdcEnum.ITM_ITEM_STATUS_INVALID.getCode());
        if (!CollectionUtils.isEmpty(invStkDRespVOS)) {
            invStkDRespVOS.stream().forEach(Stk -> {
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)Stk.getItemType()) && !MapUtils.isEmpty((Map)udcItemType)) {
                    Stk.setItemTypeName((String)udcItemType.get(Stk.getItemType()));
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)Stk.getQcStatus()) && !MapUtils.isEmpty((Map)udcQcStatus)) {
                    Stk.setQcStatusName((String)udcQcStatus.get(Stk.getQcStatus()));
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)Stk.getFressType()) && !MapUtils.isEmpty((Map)udcFressType)) {
                    Stk.setFressTypeName((String)udcFressType.get(Stk.getFressType()));
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)Stk.getDeter1()) && !MapUtils.isEmpty((Map)udcDeter1)) {
                    Stk.setDeter1Name((String)udcDeter1.get(Stk.getDeter1()));
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)Stk.getUom()) && !MapUtils.isEmpty((Map)udcUom)) {
                    Stk.setUomName((String)udcUom.get(Stk.getUom()));
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)Stk.getWhType()) && !MapUtils.isEmpty((Map)udcWhtype)) {
                    Stk.setWhTypeName((String)udcWhtype.get(Stk.getWhType()));
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)Stk.getItemStatus()) && !MapUtils.isEmpty((Map)udcItmeStatus)) {
                    Stk.setItemStatusName((String)udcItmeStatus.get(Stk.getItemStatus()));
                }
            });
        }
    }

    public void udcGroupChange(List<InvStkGroupRespVO> invStkGroupResults) {
        Map<String, String> udcUom = this.systemService.sysUdcGetCodeMap(UdcEnum.COM_UOM_BG.getModel(), UdcEnum.COM_UOM_BG.getCode());
        Map<String, String> udcWhtype = this.systemService.sysUdcGetCodeMap(InvUdcEnum.INV_WH_TYPE1_1.getModel(), InvUdcEnum.INV_WH_TYPE1_1.getCode());
        if (!CollectionUtils.isEmpty(invStkGroupResults)) {
            invStkGroupResults.stream().forEach(Stk -> {
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)Stk.getUom()) && !MapUtils.isEmpty((Map)udcUom)) {
                    Stk.setUomName((String)udcUom.get(Stk.getUom()));
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)Stk.getWhType()) && !MapUtils.isEmpty((Map)udcWhtype)) {
                    Stk.setWhTypeName((String)udcWhtype.get(Stk.getWhType()));
                }
            });
        }
    }

    @Override
    @SysCodeProc
    public List<InvStkGroupRespVO> selectInvStkGroupByParam(InvStkQueryGroupParamVO param) {
        List<InvStkGroupDTO> invStkGroupDTOList = this.invStkDomainService.selectInvStkGroupByParam(param);
        if (CollectionUtils.isEmpty(invStkGroupDTOList)) {
            return Collections.EMPTY_LIST;
        }
        List<InvStkGroupRespVO> invStkGroupRespVOList = StreamSupport.stream(invStkGroupDTOList.spliterator(), false).map(InvStkConvert.INSTANCE::groupDtoToRespVo).collect(Collectors.toList());
        return invStkGroupRespVOList;
    }

    @Override
    @SysCodeProc
    public PagingVO<InvStkGroupRespVO> searchD(InvStkQueryGroupParamVO param) {
        PagingVO<InvStkGroupDTO> pagingVo;
        if (!(CollectionUtils.isEmpty(param.getBrands()) && StringUtils.isEmpty((Object)param.getItemType()) && StringUtils.isEmpty((Object)param.getItemType2()))) {
            ItmItemRpcDtoParam itmItemPartParam = new ItmItemRpcDtoParam();
            itmItemPartParam.setBrands(param.getBrands());
            itmItemPartParam.setItemType(param.getItemType());
            itmItemPartParam.setItemType2(param.getItemType2());
            List<Long> brandItemIds = this.itmOutService.findItemIdByParam(itmItemPartParam).stream().collect(Collectors.toList());
            if (brandItemIds.size() > 0) {
                param.setItemIds(brandItemIds);
            } else {
                return PagingVO.builder().total(0L).records(new ArrayList()).build();
            }
        }
        if (CollectionUtils.isEmpty((Collection)(pagingVo = this.invStkDomainService.invStkGroupSearch(param)).getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        List vos = pagingVo.getRecords();
        List<InvStkGroupRespVO> pageResults = vos.stream().map(InvStkConvert.INSTANCE::groupDtoToRespVo).collect(Collectors.toList());
        this.stkGroupResults(pageResults);
        this.udcGroupChange(pageResults);
        return PagingVO.builder().total(pagingVo.getTotal()).records(pageResults).build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @SysCodeProc
    public PagingVO<InvStkGroupRespVO> fullSearch(InvStkQueryGroupParamVO param) {
        if (!(CollectionUtils.isEmpty(param.getBrands()) && StringUtils.isEmpty((Object)param.getItemType()) && StringUtils.isEmpty((Object)param.getItemType2()))) {
            ItmItemRpcDtoParam itmItemPartParam = new ItmItemRpcDtoParam();
            itmItemPartParam.setBrands(param.getBrands());
            itmItemPartParam.setItemType(param.getItemType());
            itmItemPartParam.setItemType2(param.getItemType2());
            List<Long> brandItemIds = this.itmOutService.findItemIdByParam(itmItemPartParam).stream().collect(Collectors.toList());
            if (brandItemIds.size() <= 0) return PagingVO.builder().total(0L).records(new ArrayList()).build();
            param.setItemIds(brandItemIds);
        }
        if (!StringUtils.isEmpty((Object)param.getWhType())) {
            InvWhParamVO invWhParamVO = new InvWhParamVO();
            invWhParamVO.setWhType(param.getWhType());
            invWhParamVO.setWhIds(param.getWhIds());
            invWhParamVO.setOuIds(param.getOuIds());
            List<InvWhRespVO> invWhRespVOS = this.invWhService.searchWhBaseByParam(invWhParamVO);
            if (CollectionUtils.isEmpty(invWhRespVOS)) return PagingVO.builder().total(0L).records(new ArrayList()).build();
            List<Long> collect = invWhRespVOS.stream().map(BaseModelVO::getId).distinct().collect(Collectors.toList());
            if (collect.size() <= 0) return PagingVO.builder().total(0L).records(new ArrayList()).build();
            param.setWhIds(collect);
        }
        PagingVO<InvStkFullDTO> pagingVo = this.invStkDomainService.fullSearch(param);
        List vos = pagingVo.getRecords();
        List<InvStkGroupRespVO> invStkFullRespVOList = vos.stream().map(InvStkConvert.INSTANCE::fullDtoToGroupRespVo).collect(Collectors.toList());
        this.stkGroupResults(invStkFullRespVOList);
        this.udcGroupChange(invStkFullRespVOList);
        return PagingVO.builder().total(pagingVo.getTotal()).records(invStkFullRespVOList).build();
    }

    public void results(List<InvStkDRespVO> invStkDResults) {
        List<String> deter2List = invStkDResults.stream().map(InvStkDRespVO::getDeter2).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<Long> whIds = invStkDResults.stream().map(InvStkDRespVO::getWhId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<Object> invWhAreaRespVOS = new ArrayList();
        if (!CollectionUtils.isEmpty(deter2List) && !CollectionUtils.isEmpty(whIds)) {
            InvWhAreaParamVO paramVO = new InvWhAreaParamVO();
            paramVO.setWhIds(whIds);
            paramVO.setDeter2s(deter2List);
            invWhAreaRespVOS = this.invWhAreaDomainService.findWhAreasByParam(paramVO);
        }
        ArrayList finalInvWhAreaRespVOS = invWhAreaRespVOS;
        invStkDResults.stream().forEach(v -> {
            if (!CollectionUtils.isEmpty((Collection)finalInvWhAreaRespVOS)) {
                finalInvWhAreaRespVOS.stream().filter(a -> Objects.equals(a.getDeter2(), v.getDeter2()) && Objects.equals(a.getWhId(), v.getWhId())).findAny().ifPresent(m -> v.setDeter2Name(m.getDeter2Name()));
            }
            if (!StringUtils.isEmpty((Object)v.getPType())) {
                InvParentParamVO orgQueryParamVO = new InvParentParamVO();
                orgQueryParamVO.setType(v.getPType());
                orgQueryParamVO.setCode(v.getPCode());
                List<OrgRespVO> vos = this.outouService.findcodeAndName(orgQueryParamVO);
                if (!CollectionUtils.isEmpty(vos)) {
                    vos.stream().filter(m -> Objects.equals(m.getCode(), v.getPCode())).findFirst().ifPresent(n -> {
                        v.setPName(n.getName());
                        v.setPName(v.getPName());
                    });
                }
            }
        });
        List userIds = invStkDResults.stream().map(BaseModelVO::getCreateUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        ItmItemRpcDtoParam itmItemPartParam = new ItmItemRpcDtoParam();
        itmItemPartParam.setItemIds(invStkDResults.stream().map(InvStkDRespVO::getItemId).filter(Objects::nonNull).distinct().collect(Collectors.toList()));
        List<ItmItemRpcDTO> itmItemResults = this.itmOutService.findItemRpcDtoByParam(itmItemPartParam);
        List<InvWhRespVO> invWhRespVOS = this.invWhDomainService.findIdBatch(invStkDResults.stream().map(InvStkDRespVO::getWhId).collect(Collectors.toList()));
        List<OrgOuRpcDTO> orgOuResults = this.outouService.findOuByIds(invStkDResults.stream().map(InvStkDRespVO::getOuId).collect(Collectors.toList()));
        Map<String, String> pTypeMap = this.systemService.sysUdcGetCodeMap(UdcEnum.INV_PARTNER_TYPE_EMP.getModel(), UdcEnum.INV_PARTNER_TYPE_EMP.getCode());
        List PCodeList = invStkDResults.stream().filter(v -> !StringUtils.isEmpty((Object)v.getPCode())).map(InvStkDRespVO::getPCode).collect(Collectors.toList());
        OrgEmpRpcDtoParam orgEmpRpcDtoParam = new OrgEmpRpcDtoParam();
        orgEmpRpcDtoParam.setEmpCodes(PCodeList);
        List<OrgEmpRpcDTO> dtoByParam = this.outouService.findEmpDtoByParam(orgEmpRpcDtoParam);
        invStkDResults.stream().forEach(i -> {
            Optional<OrgEmpRpcDTO> empRpcDTO;
            if (!CollectionUtils.isEmpty((Collection)dtoByParam) && (empRpcDTO = dtoByParam.stream().filter(v2 -> Objects.equals(v2.getEmpCode(), i.getPCode())).findFirst()).isPresent()) {
                i.setPName(empRpcDTO.get().getEmpName());
                if (MapUtils.isNotEmpty((Map)pTypeMap)) {
                    i.setPTypeName((String)pTypeMap.get(i.getPType()));
                }
            }
            invWhRespVOS.stream().filter(v -> Objects.equals(v.getId(), i.getWhId())).findAny().ifPresent(m -> {
                i.setWhName(m.getWhName());
                i.setWhCode(m.getWhCode());
                i.setWhType(m.getWhType());
            });
            itmItemResults.stream().filter(v -> Objects.equals(v.getId(), i.getItemId())).findAny().ifPresent(m -> {
                i.setItemCode(m.getItemCode());
                i.setItemName(m.getItemName());
                i.setBrand(m.getBrand());
                i.setPackageSpec(m.getPackageSpec());
                i.setItemType(m.getItemType());
                i.setBrandName(m.getBrandName());
                i.setVolume(m.getVolume() == null ? null : Double.valueOf(m.getVolume().doubleValue()));
                i.setGrossWeight(m.getGrossWeight() == null ? null : Double.valueOf(m.getGrossWeight().doubleValue()));
                i.setNetWeight(m.getNetWeight() == null ? null : Double.valueOf(m.getNetWeight().doubleValue()));
                i.setItemOuterCode(m.getOuterCode());
                i.setBarCode(m.getBarCode());
                i.setItemStatus(m.getItemStatus());
                i.setSuppName(m.getSuppName());
                i.setBrandName(m.getBrandName());
            });
            orgOuResults.stream().filter(o -> Objects.equals(o.getId(), i.getOuId())).findAny().ifPresent(m -> {
                i.setOuCode(m.getOuCode());
                i.setOuName(m.getOuName());
            });
        });
    }

    public void stkGroupResults(List<InvStkGroupRespVO> invStkGroupResults) {
        List deter2s = invStkGroupResults.stream().map(InvStkGroupRespVO::getDeter2).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List itemIds = invStkGroupResults.stream().map(InvStkGroupRespVO::getItemId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        ItmItemRpcDtoParam itmItemPartParam = new ItmItemRpcDtoParam();
        itmItemPartParam.setItemIds(itemIds);
        List<ItmItemRpcDTO> itmItemResults = this.itmOutService.findItemRpcDtoByParam(itmItemPartParam);
        List<Long> userIds = invStkGroupResults.stream().map(InvStkGroupRespVO::getCreateUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<SysUserVO> empsByIdIn = this.systemService.findAllEmpsByIdIn(userIds);
        List<Long> ouIds = invStkGroupResults.stream().map(InvStkGroupRespVO::getOuId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<OrgOuRpcDTO> orgOuResults = this.outouService.findOuByIds(ouIds);
        Map<String, String> itmMap = this.systemService.sysUdcGetCodeMap(UdcEnum.ITM_ITEM_TYPE1_ITM_CENTER.getModel(), UdcEnum.ITM_ITEM_TYPE1_ITM_CENTER.getCode());
        Map<String, String> itm2Map = this.systemService.sysUdcGetCodeMap(UdcEnum.ITM_ITEM_TYPE2_10.getModel(), UdcEnum.ITM_ITEM_TYPE2_10.getCode());
        invStkGroupResults.stream().forEach(i -> {
            if (!CollectionUtils.isEmpty((Collection)empsByIdIn)) {
                empsByIdIn.stream().filter(e -> e.getId().equals(i.getCreateUserId())).findAny().ifPresent(v -> i.setCreator(v.getUsername()));
            }
            itmItemResults.stream().filter(v -> v.getId().equals(i.getItemId())).findAny().ifPresent(m -> {
                i.setItemCode(m.getItemCode());
                i.setItemName(m.getItemName());
                i.setBrand(m.getBrand());
                i.setPackageSpec(m.getPackageSpec());
                i.setSpec(m.getSpec());
                i.setItemType(m.getItemType());
                i.setItemType2(m.getItemType2());
                i.setBrandName(m.getBrandName());
                i.setBarCode(m.getBarCode());
                i.setSuppCode(m.getSuppCode());
                i.setSuppName(m.getSuppName());
                i.setItemCatePathName(m.getItemCatePathName());
                if (!StringUtils.isEmpty((Object)m.getGuaranteeDays())) {
                    i.setExpireDays(m.getGuaranteeDays());
                }
            });
            if (!StringUtils.isEmpty((Object)i.getItemType()) && !MapUtils.isEmpty((Map)itmMap)) {
                i.setItemTypeName((String)itmMap.get(i.getItemType()));
            }
            if (!StringUtils.isEmpty((Object)i.getItemType2()) && !MapUtils.isEmpty((Map)itm2Map)) {
                i.setItemType2Name((String)itm2Map.get(i.getItemType2()));
            }
            orgOuResults.stream().filter(o -> o.getId().equals(i.getOuId())).findAny().ifPresent(m -> {
                i.setOuCode(m.getOuCode());
                i.setOuName(m.getOuName());
            });
            if (!StringUtils.isEmpty((Object)i.getPCode()) && !StringUtils.isEmpty((Object)i.getPType())) {
                InvParentParamVO paramVO = new InvParentParamVO();
                paramVO.setCode(i.getPCode());
                paramVO.setType(i.getPType());
                List<OrgRespVO> vos = this.outouService.findcodeAndName(paramVO);
                if (!CollectionUtils.isEmpty(vos)) {
                    i.setPName(vos.get(0).getName());
                }
            }
        });
    }

    @Override
    @SysCodeProc
    public Optional<InvStkRespVO> findIdOne(Long id) {
        return this.invStkDomainService.getInvStkById(id).map(DO -> (InvStkRespVO)BeanUtil.copyProperties((Object)DO, InvStkRespVO.class, (String[])new String[0]));
    }

    @Override
    @Transactional
    public void update(InvStkUpdateSaveVO objDo) {
        Optional<InvStkDO> optional = this.invStkDomainService.getInvStkById(objDo.getId());
        if (!optional.isPresent()) {
            throw new BusinessException(ApiCode.FAIL, "\u4fee\u6539\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728" + objDo.getId());
        }
        BeanCopyUtil.beanCopyWithIngore(objDo, (Serializable)optional.get(), BeanCopyUtil.getNullPropertyNames(objDo));
        this.invStkDomainService.saveInvStk(optional.get());
    }

    @Override
    @Transactional
    public Long createOne(InvStkDO invStkDO) {
        return ((InvStkDO)this.invStkRepo.save(invStkDO)).getId();
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public Long createInvStk(InvStkDO invStkDO) {
        return ((InvStkDO)this.invStkRepo.save(invStkDO)).getId();
    }

    @Override
    @Transactional
    public int updateStkQty(InvStkDO invStkDO) {
        log.info("\u4fee\u6539\u5e93\u5b58sql \u5f00\u59cb\uff0c\u53c2\u6570\uff1a{}", (Object)invStkDO);
        return this.invStkRepo.updateStkQty(invStkDO);
    }

    @Override
    @Transactional
    public void deleteBatch(List<Long> list) {
        list.forEach(id -> this.invStkRepo.deleteById(id));
    }

    @Override
    public InvStkRespVO getInvStk(InvBaseModel queryParam) {
        this.paramCheckIn(queryParam);
        InvStkDTO invStkDTO = this.invStkDomainService.getInvStk(queryParam);
        if (invStkDTO != null) {
            InvStkRespVO invStkRespVO = InvStkConvert.INSTANCE.dtoToRespVo(invStkDTO);
            return invStkRespVO;
        }
        return null;
    }

    @Override
    public InvStkDO getInvStkDo(InvBaseModel queryParam) {
        this.paramCheckIn(queryParam);
        List fetch = ((JPAQuery)this.invStkRepoProc.selectDO(null).where(this.getPredicate(QInvStkDO.invStkDO, queryParam))).fetch();
        if (!ObjectUtils.isEmpty((Object)fetch) && fetch.size() > 0) {
            return (InvStkDO)fetch.get(0);
        }
        return null;
    }

    private void translateInvShareStk(List<ItmInvStkShareRespVO> stkShareRespVOS) {
        if (!CollectionUtils.isEmpty(stkShareRespVOS)) {
            List<Long> whIds = stkShareRespVOS.stream().filter(Objects::nonNull).map(ItmInvStkShareRespVO::getWhId).distinct().collect(Collectors.toList());
            List<Long> ouIds = stkShareRespVOS.stream().filter(Objects::nonNull).map(ItmInvStkShareRespVO::getOuId).distinct().collect(Collectors.toList());
            List<OrgOuRpcDTO> ouRpcDTOS = this.outouService.findOuByIds(ouIds);
            List<InvWhRespVO> whRespVOS = this.invWhDomainService.findIdBatch(whIds);
            Map<String, String> udcUom = this.systemService.sysUdcGetCodeMap(UdcEnum.COM_UOM_BG.getModel(), UdcEnum.COM_UOM_BG.getCode());
            Map<String, String> shareTypeMap = this.systemService.sysUdcGetCodeMap(UdcEnum.INV_PLN_SHARE_TYPE_D.getModel(), UdcEnum.INV_PLN_SHARE_TYPE_D.getCode());
            Map<String, String> itmMap = this.systemService.sysUdcGetCodeMap(UdcEnum.ITM_ITEM_TYPE1_ITM_CENTER.getModel(), UdcEnum.ITM_ITEM_TYPE1_ITM_CENTER.getCode());
            Map<String, String> whTypeMap = this.systemService.sysUdcGetCodeMap(UdcEnum.INV_WH_TYPE_1.getModel(), UdcEnum.INV_WH_TYPE_1.getCode());
            List itemIds = stkShareRespVOS.stream().map(ItmInvStkShareRespVO::getItemId).collect(Collectors.toList());
            List<String> pSuppCodes = stkShareRespVOS.stream().filter(i -> UdcEnum.INV_PARTNER_TYPE_SUPP.getValueCode().equals(i.getPType())).map(ItmInvStkShareRespVO::getPCode).distinct().collect(Collectors.toList());
            List<String> pEmpCodes = stkShareRespVOS.stream().filter(i -> UdcEnum.INV_PARTNER_TYPE_EMP.getValueCode().equals(i.getPType())).map(ItmInvStkShareRespVO::getPCode).distinct().collect(Collectors.toList());
            List<OrgRespVO> suppList = this.outouService.findcodeAndNameList(InvPTypeEnum.INV_PARTNER_TYPE_SUPP, pSuppCodes);
            List<OrgRespVO> empList = this.outouService.findcodeAndNameList(InvPTypeEnum.INV_PARTNER_TYPE_EMP, pEmpCodes);
            ItmItemRpcDtoParam itemRpcDtoParam = new ItmItemRpcDtoParam();
            itemRpcDtoParam.setItemIds(itemIds);
            List<ItmItemRpcDTO> itmItemRpcDTOS = this.itmOutService.findItemRpcDtoByParam(itemRpcDtoParam);
            if (!CollectionUtils.isEmpty(itmItemRpcDTOS)) {
                stkShareRespVOS.stream().forEach(s -> {
                    if (s.getPCode() != null && UdcEnum.INV_PARTNER_TYPE_SUPP.getValueCode().equals(s.getPType())) {
                        suppList.stream().filter(i -> i.getCode().equals(s.getPCode())).findAny().ifPresent(o -> s.setPName(o.getName()));
                    }
                    if (s.getPCode() != null && UdcEnum.INV_PARTNER_TYPE_EMP.getValueCode().equals(s.getPType())) {
                        empList.stream().filter(i -> i.getCode().equals(s.getPCode())).findAny().ifPresent(o -> s.setPName(o.getName()));
                    }
                    itmItemRpcDTOS.stream().filter(i -> i.getId().equals(s.getItemId())).findAny().ifPresent(v -> {
                        s.setTaxCode(v.getTaxCode());
                        s.setTaxRate(v.getTaxRate());
                        s.setItemName(v.getItemName());
                        s.setPackageSpec(v.getPackageSpec());
                        s.setBrand(v.getBrand());
                        s.setBrandName(v.getBrandName());
                    });
                    whRespVOS.stream().filter(v -> v.getId().equals(s.getWhId())).findAny().ifPresent(m -> {
                        s.setWhName(m.getWhName());
                        s.setWhCode(m.getWhCode());
                        s.setWhType(m.getWhType());
                    });
                    ouRpcDTOS.stream().filter(v -> v.getId().equals(s.getOuId())).findAny().ifPresent(m -> {
                        s.setOuCode(m.getOuCode());
                        s.setOuName(m.getOuName());
                    });
                    if (s.getShareType() != null && !MapUtils.isEmpty((Map)shareTypeMap)) {
                        s.setShareTypeName((String)shareTypeMap.get(s.getShareType()));
                    }
                    if (s.getUom() != null && !MapUtils.isEmpty((Map)udcUom)) {
                        s.setUomName((String)udcUom.get(s.getUom()));
                    }
                    if (s.getItemType() != null && !MapUtils.isEmpty((Map)itmMap)) {
                        s.setItemTypeName((String)itmMap.get(s.getItemType()));
                    }
                    if (s.getWhType() != null && !MapUtils.isEmpty((Map)whTypeMap)) {
                        s.setWhTypeName((String)whTypeMap.get(s.getWhType()));
                    }
                });
            }
        }
    }

    private void translateInvStkItem(List<ItmInvStkItemRespVO> stkItemRespVOS) {
        if (CollectionUtils.isEmpty(stkItemRespVOS)) {
            return;
        }
        List itemIds = stkItemRespVOS.stream().filter(Objects::nonNull).map(BaseModelVO::getId).distinct().collect(Collectors.toList());
        List<Long> whIds = stkItemRespVOS.stream().filter(Objects::nonNull).map(ItmInvStkItemRespVO::getWhId).distinct().collect(Collectors.toList());
        List<String> deter2s = stkItemRespVOS.stream().filter(Objects::nonNull).map(ItmInvStkItemRespVO::getDeter2).distinct().collect(Collectors.toList());
        List<Long> ouIds = stkItemRespVOS.stream().filter(Objects::nonNull).map(ItmInvStkItemRespVO::getOuId).distinct().collect(Collectors.toList());
        List<Object> invWhAreaRespVOS = new ArrayList();
        if (!CollectionUtils.isEmpty(whIds) && !CollectionUtils.isEmpty(deter2s)) {
            InvWhAreaParamVO paramVO = new InvWhAreaParamVO();
            paramVO.setWhIds(whIds);
            paramVO.setDeter2s(deter2s);
            invWhAreaRespVOS = this.invWhAreaDomainService.findWhAreasByParam(paramVO);
        }
        List<InvWhRespVO> whRespVOS = this.invWhDomainService.findIdBatch(whIds);
        ItmItemRpcDtoParam itemRpcDtoParam = new ItmItemRpcDtoParam();
        itemRpcDtoParam.setItemIds(itemIds);
        List<ItmItemRpcDTO> itmItemRpcDTOS = this.itmOutService.findItemRpcDtoByParam(itemRpcDtoParam);
        List<OrgOuRpcDTO> ouRpcDTOS = this.outouService.findOuByIds(ouIds);
        Map<String, String> udcUom = this.systemService.sysUdcGetCodeMap(UdcEnum.COM_UOM_BG.getModel(), UdcEnum.COM_UOM_BG.getCode());
        Map<String, String> itmMap = this.systemService.sysUdcGetCodeMap(UdcEnum.ITM_ITEM_TYPE1_ITM_CENTER.getModel(), UdcEnum.ITM_ITEM_TYPE1_ITM_CENTER.getCode());
        Map<String, String> allocTypeMap = this.systemService.sysUdcGetCodeMap(UdcEnum.ITM_ALLOC_TYPE_SUPP.getModel(), UdcEnum.ITM_ALLOC_TYPE_SUPP.getCode());
        List<Object> finalInvWhAreaRespVOS = invWhAreaRespVOS;
        stkItemRespVOS.stream().forEach(i -> {
            i.setItemId(i.getId());
            whRespVOS.stream().filter(v -> v.getId().equals(i.getWhId())).findAny().ifPresent(m -> {
                i.setWhName(m.getWhName());
                i.setWhCode(m.getWhCode());
            });
            itmItemRpcDTOS.stream().filter(v -> v.getId().equals(i.getId())).findAny().ifPresent(m -> {
                i.setItemName(m.getItemName());
                i.setPackageSpec(m.getPackageSpec());
                i.setItemSpec(m.getSpec());
                i.setExpireDays(m.getGuaranteeDays());
                i.setBrand(m.getBrand());
                i.setBrandName(m.getBrandName());
                i.setItemType(m.getItemType());
                i.setLotFlag(m.getLotFlag());
                i.setAllocType(m.getAllocType());
            });
            ouRpcDTOS.stream().filter(v -> v.getId().equals(i.getOuId())).findAny().ifPresent(m -> {
                i.setOuCode(m.getOuCode());
                i.setOuName(m.getOuName());
            });
            if (CollectionUtils.isEmpty((Collection)finalInvWhAreaRespVOS)) {
                finalInvWhAreaRespVOS.stream().filter(d -> d.getDeter2().equals(i.getDeter2()) && d.getWhId().equals(i.getWhId())).findAny().ifPresent(m -> i.setDeter2Name(m.getDeter2Name()));
            }
            if (i.getUom() != null && !MapUtils.isEmpty((Map)udcUom)) {
                i.setUomName((String)udcUom.get(i.getUom()));
            }
            if (i.getItemType() != null && !MapUtils.isEmpty((Map)itmMap)) {
                i.setItemTypeName((String)itmMap.get(i.getItemType()));
            }
            if (i.getAllocType() != null && !MapUtils.isEmpty((Map)allocTypeMap)) {
                i.setAllocTypeName((String)allocTypeMap.get(i.getAllocType()));
            }
        });
    }

    public void paramCheckIn(InvBaseModel queryParam) {
        ValidationUtil.ValidResult validResult = ValidationUtil.validate(queryParam);
        if (validResult.isError()) {
            throw new BusinessException("\u4e3b\u6570\u636e\u53c2\u6570\u9519\u8bef\uff0c\u5546\u54c1\u3001\u4ed3\u5e93\u3001\u529f\u80fd\u533a \u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private Predicate getPredicate(QInvStkDO jpaQDo, InvBaseModel queryParam) {
        BooleanExpression predicate1 = queryParam.getItemId() != null ? jpaQDo.itemId.eq((Object)queryParam.getItemId()) : null;
        BooleanExpression predicate2 = queryParam.getVariId() != null && queryParam.getVariId() != 0L ? jpaQDo.variId.eq((Object)queryParam.getVariId()) : null;
        BooleanExpression predicate3 = !StringUtils.isEmpty((Object)queryParam.getLotNo()) ? jpaQDo.lotNo.eq((Object)queryParam.getLotNo()) : null;
        BooleanExpression predicate4 = queryParam.getWhId() != null ? jpaQDo.whId.eq((Object)queryParam.getWhId()) : null;
        BooleanExpression predicate5 = !StringUtils.isEmpty((Object)queryParam.getDeter1()) ? jpaQDo.deter1.eq((Object)queryParam.getDeter1()) : null;
        BooleanExpression predicate6 = !StringUtils.isEmpty((Object)queryParam.getDeter2()) ? jpaQDo.deter2.eq((Object)queryParam.getDeter2()) : null;
        BooleanExpression predicate7 = !StringUtils.isEmpty((Object)queryParam.getUom()) ? jpaQDo.uom.eq((Object)queryParam.getUom()) : null;
        BooleanExpression predicate8 = !StringUtils.isEmpty((Object)queryParam.getPType()) ? jpaQDo.pType.eq((Object)queryParam.getPType()) : null;
        BooleanExpression predicate9 = !StringUtils.isEmpty((Object)queryParam.getPCode()) ? jpaQDo.pCode.eq((Object)queryParam.getPCode()) : null;
        BooleanExpression predicate10 = !StringUtils.isEmpty((Object)queryParam.getLimit1()) ? jpaQDo.limit1.eq((Object)queryParam.getLimit1()) : null;
        BooleanExpression predicate11 = !StringUtils.isEmpty((Object)queryParam.getLimit2()) ? jpaQDo.limit2.eq((Object)queryParam.getLimit2()) : null;
        return ExpressionUtils.allOf((Predicate[])new Predicate[]{predicate1, predicate2, predicate3, predicate4, predicate5, predicate6, predicate7, predicate8, predicate9, predicate10, predicate11});
    }

    private void checkInvBaseModelParam(InvBaseModel queryParam) {
        if (!(!StringUtils.isEmpty((Object)queryParam.getDeter1()) && !StringUtils.isEmpty((Object)queryParam.getDeter2()) && StringUtils.isEmpty((Object)queryParam.getDeter3()) || StringUtils.isEmpty((Object)queryParam.getDeter1()) && StringUtils.isEmpty((Object)queryParam.getDeter2()) && !StringUtils.isEmpty((Object)queryParam.getDeter3()))) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "\u53c2\u6570\u9519\u8bef\uff0c[\u6e29\u5c42\u3001\u529f\u80fd\u5e93\u533a]\u3001\u5ba2\u6237\u53f7 \u4e09\u8005\u4e0d\u80fd\u540c\u65f6\u5b58\u5728\u6216\u4e0d\u5b58\u5728");
        }
    }

    public InvStkServiceImpl(InvStkRepo invStkRepo, InvStkRepoProc invStkRepoProc, InvWhService invWhService, InvWhAreaDomainService invWhAreaDomainService, SystemService systemService, ItmOutService itmOutService, OrgOutService outouService, InvWhDomainService invWhDomainService, InvStkDomainService invStkDomainService) {
        this.invStkRepo = invStkRepo;
        this.invStkRepoProc = invStkRepoProc;
        this.invWhService = invWhService;
        this.invWhAreaDomainService = invWhAreaDomainService;
        this.systemService = systemService;
        this.itmOutService = itmOutService;
        this.outouService = outouService;
        this.invWhDomainService = invWhDomainService;
        this.invStkDomainService = invStkDomainService;
    }
}

