/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.inv.infr.repo;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import com.elitesland.yst.production.inv.application.facade.vo.InvIoSearchBatchParam;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvIoStkAcctRespVO;
import com.elitesland.yst.production.inv.domain.entity.invstk.QInvIoDO;
import com.elitesland.yst.production.inv.domain.entity.invwh.QInvWhAreaDO;
import com.elitesland.yst.production.inv.domain.entity.invwh.QInvWhDO;
import com.elitesland.yst.production.inv.infr.repo.JpaQueryProcInterface;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class InvIoRepoProc
implements JpaQueryProcInterface {
    private final JPAQueryFactory jpaQueryFactory;

    public JPAQuery<InvIoStkAcctRespVO> searchStkAcct(InvIoSearchBatchParam param) {
        QInvIoDO invIoDO = QInvIoDO.invIoDO;
        QInvWhDO invWhDO = QInvWhDO.invWhDO;
        QInvWhAreaDO invWhAreaDO = QInvWhAreaDO.invWhAreaDO;
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(InvIoStkAcctRespVO.class, (Expression[])new Expression[]{invIoDO.docNo, invIoDO.id, invIoDO.lotNo, invIoDO.itemId, invIoDO.whId, invWhDO.whName, invWhDO.whCode, invIoDO.stkId, invIoDO.deter1, invIoDO.deter2, invWhAreaDO.deter2Type, invWhAreaDO.deter2Name, invIoDO.deter3, invIoDO.itemCateCode, invIoDO.brand, invIoDO.itemCode, invIoDO.qty, invIoDO.uom, invIoDO.snNo, invIoDO.limit1, invIoDO.limit2, invIoDO.limit3, invIoDO.ioDate, invIoDO.ioCode, invIoDO.reasonCode, invIoDO.srcDocCls, invIoDO.srcDocNo, invIoDO.srcDocNo2, invIoDO.sceneCode, invIoDO.ouId, invIoDO.pType.as("PType"), invIoDO.pCode.as("PCode"), invIoDO.createTime, invIoDO.creator, invIoDO.createUserId, invIoDO.modifyTime, invIoDO.updater, invIoDO.modifyUserId})).from((EntityPath)invIoDO)).leftJoin((EntityPath)invWhDO)).on((Predicate)invIoDO.whId.eq(invWhDO.id))).leftJoin((EntityPath)invWhAreaDO)).on((Predicate)invIoDO.deter2.eq((Expression)invWhAreaDO.deter2))).where(new Predicate[]{this.where(param), invIoDO.deleteFlag.eq((Object)0).or((Predicate)invIoDO.deleteFlag.isNull())});
        jpaQuery.groupBy(invIoDO.id);
        return jpaQuery;
    }

    Predicate where(InvIoSearchBatchParam param) {
        QInvIoDO invIoDO = QInvIoDO.invIoDO;
        QInvWhDO invWhDO = QInvWhDO.invWhDO;
        QInvWhAreaDO invWhAreaDO = QInvWhAreaDO.invWhAreaDO;
        BooleanExpression predicate = Expressions.ONE.eq((Expression)Expressions.ONE);
        try {
            Predicate predicateAuth = DataAuthJpaUtil.dataAuthJpaPredicate((PathMetadata)invIoDO.getMetadata());
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)predicateAuth);
        }
        catch (Exception e) {
            throw new BusinessException(ApiCode.FAIL, "\u6570\u636e\u6743\u9650\u5f02\u5e38");
        }
        if (StringUtils.hasLength((String)param.getDeter2KeyWord())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)ExpressionUtils.or((Predicate)invWhAreaDO.deter2.like("%" + param.getDeter2KeyWord() + "%"), (Predicate)invWhAreaDO.deter2Name.like("%" + param.getDeter2KeyWord() + "%")));
        }
        if (!CollectionUtils.isEmpty(param.getWhIds())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)invIoDO.whId.in(param.getWhIds()));
        }
        if (!StringUtils.isEmpty((Object)param.getDocNo())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)invIoDO.docNo.eq((Object)param.getDocNo()));
        }
        if (StringUtils.hasLength((String)param.getDeter2Type())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)invWhAreaDO.deter2Type.eq((Object)param.getDeter2Type()));
        }
        if (StringUtils.hasLength((String)param.getDeter2KeyWord())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)ExpressionUtils.or((Predicate)invWhAreaDO.deter2.like("%" + param.getDeter2KeyWord() + "%"), (Predicate)invWhAreaDO.deter2Name.like("%" + param.getDeter2KeyWord() + "%")));
        }
        if (!StringUtils.isEmpty((Object)param.getDeter1())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)invIoDO.deter1.eq((Object)param.getDeter1()));
        }
        if (!StringUtils.isEmpty((Object)param.getCreateUserId())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)invIoDO.createUserId.eq((Object)param.getCreateUserId()));
        }
        if (!CollectionUtils.isEmpty(param.getDeter2s())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)invIoDO.deter2.in(param.getDeter2s()));
        }
        if (!StringUtils.isEmpty((Object)param.getSrcDocNo())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)invIoDO.srcDocNo.in((Object[])new String[]{param.getSrcDocNo()}));
        }
        if (!StringUtils.isEmpty((Object)param.getSrcDocNo2())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)invIoDO.srcDocNo2.in((Object[])new String[]{param.getSrcDocNo2()}));
        }
        if (!CollectionUtils.isEmpty(param.getItemIds())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)invIoDO.itemId.in(param.getItemIds()));
        }
        if (!CollectionUtils.isEmpty(param.getLotNos())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)invIoDO.lotNo.in(param.getLotNos()));
        }
        if (!StringUtils.isEmpty((Object)param.getLotNo())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)invIoDO.lotNo.like("%" + param.getLotNo() + "%"));
        }
        if (!StringUtils.isEmpty((Object)param.getIoCode())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)invIoDO.ioCode.eq((Object)param.getIoCode()));
        }
        if (!CollectionUtils.isEmpty(param.getIoCodes())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)invIoDO.ioCode.in(param.getIoCodes()));
        }
        if (!StringUtils.isEmpty((Object)param.getIoDate())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)invIoDO.ioDate.between((Comparable)LocalDateTime.of(param.getIoDate().toLocalDate(), LocalTime.MIN), (Comparable)LocalDateTime.of(param.getIoDate().toLocalDate(), LocalTime.of(23, 59, 59))));
        }
        if (!CollectionUtils.isEmpty(param.getOuIds())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)invIoDO.ouId.in(param.getOuIds()));
        }
        if (!StringUtils.isEmpty((Object)param.getSrcDocCls())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)invIoDO.srcDocCls.eq((Object)param.getSrcDocCls()));
        }
        if (!StringUtils.isEmpty((Object)param.getSrcDocNo())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)invIoDO.srcDocNo.like("%" + param.getSrcDocNo() + "%"));
        }
        if (!StringUtils.isEmpty((Object)param.getNoStk()) && param.getNoStk().equals(true)) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)invIoDO.qty.ne((Object)BigDecimal.ZERO));
        }
        if (!CollectionUtils.isEmpty(param.getSrcDocClsList())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)invIoDO.srcDocCls.in(param.getSrcDocClsList()));
        }
        if (!StringUtils.isEmpty((Object)param.getCreateUserId())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)invIoDO.createUserId.eq((Object)param.getCreateUserId()));
        }
        if (!StringUtils.isEmpty((Object)param.getPtype())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)invIoDO.pType.eq((Object)param.getPtype()));
        }
        if (!Objects.isNull(param.getPcode()) && !StringUtils.isEmpty((Object)param.getPcode().getPcode())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)invIoDO.pCode.eq((Object)param.getPcode().getPcode()));
        }
        if (!CollectionUtils.isEmpty(param.getCreateTime())) {
            List<String> createTime = param.getCreateTime();
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)invIoDO.createTime.after((Comparable)LocalDate.parse(createTime.get(0), dateTimeFormatter).atStartOfDay()).and((Predicate)invIoDO.createTime.before((Comparable)LocalDate.parse(createTime.get(1), dateTimeFormatter).atStartOfDay())));
        }
        if (!StringUtils.isEmpty((Object)param.getCreateTimeFrom())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)invIoDO.createTime.after((Comparable)param.getCreateTimeFrom()).or((Predicate)invIoDO.createTime.eq((Object)param.getCreateTimeFrom())));
        }
        if (!StringUtils.isEmpty((Object)param.getCreateTimeTo())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)invIoDO.createTime.before((Comparable)param.getCreateTimeTo()).or((Predicate)invIoDO.createTime.eq((Object)param.getCreateTimeTo())));
        }
        return predicate;
    }

    public InvIoRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

