package com.elitesland.yst.production.inv.application.facade.vo;

import com.elitescloud.cloudt.common.annotation.SysCode;
import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @author jeesie.jiang
 * @Date 2022/5/6
 * @Description
 */
@Data
public class InvAjDRespVO extends BaseModelVO implements Serializable {

    private static final long serialVersionUID = 7581968018534499993L;
    @ApiModelProperty("主表ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long masId;

    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    String deter1;
    String deter1Name;

    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    String deter2;
    String deter2Name;

    @ApiModelProperty("调整数量")
    BigDecimal qty;

    @ApiModelProperty("可供量")
    BigDecimal avalQty;

    @ApiModelProperty("行号")
    Double lineNo;

    @ApiModelProperty("行状态")
    String lineStatus;

    @ApiModelProperty("行类型")
    String lineType;

    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long whId;

    @ApiModelProperty("单位")
    String uom;
    String uomName;

    @ApiModelProperty("生产日期 修改批次信息时，要联动修改批次主档中的信息，可能变批次号，要检查此批次没有过出入记录才行")
    LocalDateTime manuDate;

    LocalDate manuDate2;

    @ApiModelProperty("失效日期")
    LocalDateTime expireDate;
    LocalDate expireDate2;

    @ApiModelProperty("批次")
    String lotNo;

    @ApiModelProperty("是否默认启用批次")
    Boolean lotFlag;

    @ApiModelProperty("新批次号")
    String toLotNo;

    @ApiModelProperty("备注")
    String remark;
    @ApiModelProperty("客户标识")
    String deter3;

    @ApiModelProperty("限定4")
    String deter4;

    @ApiModelProperty("限定5")
    String deter5;

    @ApiModelProperty("限定6")
    String deter6;

    @ApiModelProperty("限定7")
    String deter7;

    @ApiModelProperty("限定8")
    String deter8;

    @ApiModelProperty("商品ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long itemId;
    @ApiModelProperty("商品编码")
    String itemCode;
    @ApiModelProperty("商品名称")
    String itemName;
    String brand;
    @ApiModelProperty("异构ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long variId;

    @ApiModelProperty("序列号")
    String snNo;


    @ApiModelProperty("调整数量2")
    BigDecimal qty2;

    @ApiModelProperty("单位2")
    String uom2;

    @ApiModelProperty("单位转换率")
    Double uomRatio;

    @ApiModelProperty("单位转换率2")
    Double uomRatio2;

    @ApiModelProperty("生产批次")
    String menuLotNo;

    @ApiModelProperty("实物是否销毁")
    Boolean destroyFlag;

    @ApiModelProperty("销毁日期")
    LocalDateTime destroyDate;

    @ApiModelProperty("销毁登记员工ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long destroyEmpId;

    @ApiModelProperty("承运商供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long carrierSuppId;

    @ApiModelProperty("承运商")
    String carrier;

    @ApiModelProperty("含税金额")
    BigDecimal amt;

    @ApiModelProperty("不含税金额")
    BigDecimal netAmt;

    @ApiModelProperty("记账币种")
    String homeCurr;

    @ApiModelProperty("交易币种")
    String currCode;

    @ApiModelProperty("汇率")
    Double currRate;

    @ApiModelProperty("外币不含税金额")
    BigDecimal currNetAmt;

    @ApiModelProperty("外币含税金额")
    BigDecimal currAmt;

    @ApiModelProperty("单位成本")
    BigDecimal costPrice;

    @ApiModelProperty("成本金额")
    BigDecimal costAmt;

    @ApiModelProperty("关联单据类别 如RMA，盘点单。[UDC]COM:DOC_CLS")
    String relateDocCls;
    String relateDocClsName;

    @ApiModelProperty("关联单据类型")
    String relateDocType;

    @ApiModelProperty("关联单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long relateDocId;

    @ApiModelProperty("关联单据编号")
    String relateDocNo;

    @ApiModelProperty("关联单据明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    Long relateDocDid;

    @ApiModelProperty("关联单据行号")
    Double relateDocLineno;

    @ApiModelProperty("原因码 [UDC]INV:REASON_CODE")
    @SysCode(sys = "yst-inv", mod = "REASON_CODE_STKAJ")
    String reasonCode;
    String reasonCodeName;

    @ApiModelProperty("外部单据公司")
    String outerOu;
    @ApiModelProperty("外部单据类型")
    String outerType;
    @ApiModelProperty("外部单据编号")
    String outerNo;
    @ApiModelProperty("外部单据行号")
    String outerLineno;

    @ApiModelProperty("合作伙伴类型")
    String pType;

    @ApiModelProperty("合作伙伴类型名称")
    String pTypeName;

    @ApiModelProperty("合作伙伴名称")
    String pName;

    @ApiModelProperty("合作伙伴编码")
    String pCode;

    @ApiModelProperty("保质期天数")
    private Integer expireDays;

    @ApiModelProperty("调整金额")
    private BigDecimal ajAmt;

    @ApiModelProperty("限定字段1")
    private String limit1;

    @ApiModelProperty("限定字段1")
    private String limit1Name;

    @ApiModelProperty("限定字段编码名称")
    private String limit1CodeName;

    @ApiModelProperty("限定字段2")
    private String limit2;

    @ApiModelProperty("限定字段2")
    private String limit2Name;

    @ApiModelProperty("限定字段3")
    private String limit3;

    @ApiModelProperty("销售金额")
    private BigDecimal sellAmt;

    @ApiModelProperty("销售单价")
    private BigDecimal sellPrice;

    @ApiModelProperty("商品类型")
    private String itemType2;

    @ApiModelProperty("商品类型")
    private String itemType2Name;

    @ApiModelProperty("配件类型")
    private String itemType3;

    @ApiModelProperty("配件类型")
    private String itemType3Name;


}
