package com.elitesland.yst.production.inv.application.facade.vo;

import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 库存调整(InvAj)实体类
 *
 * @author zhao_qiao_gong
 * @since 2020-09-17 15:13:58
 */

@Data
@ApiModel(value = "inv_aj", description = "库存调整")
public class InvAjSaveVO extends BaseModelVO implements Serializable {
    private static final long serialVersionUID = -95877006080526194L;
    /**
     * 唯一编号ID
     */
    @ApiModelProperty("唯一编号ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    /**
     * 公司编码
     */
    @ApiModelProperty("公司code")
    private String ouCode;
    /**
     * BUID
     */
    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;

    private String buName;
    /**
     * 单据编号
     */
    @ApiModelProperty("单据编号")
    private String docNo;
    /**
     * 调整类型 [UDC]INV:AJ_TYPE
     */
    @ApiModelProperty("调整类型 [UDC]INV:AJ_TYPE")
    private String docType;
    /**
     * 调整单状态 [UDC]INV:AJ_STATUS
     */
    @ApiModelProperty("调整单状态 [UDC]INV:AJ_STATUS")
    private String docStatus;
    /**
     * 调整原因 [UDC]INV:AJ_REASON
     */
    @ApiModelProperty("调整原因 [UDC]INV:AJ_REASON")
    private String docReason;
    /**
     * 审批状态 [UDC]COM:APPR_STATUS
     */
    @ApiModelProperty("审批状态 [UDC]COM:APPR_STATUS")
    private String apprStatus;
    /**
     * 审批时间
     */
    @ApiModelProperty("审批时间")
    private LocalDateTime apprTime;
    /**
     * 审批人ID
     */
    @ApiModelProperty("审批人ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long apprUserId;
    /**
     * 审批意见
     */
    @ApiModelProperty("审批意见")
    private String apprComment;
    /**
     * 申请人员工ID
     */
    @ApiModelProperty("申请人员工ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long applyEmpId;

    @ApiModelProperty("申请人员工编号")
    private String applyEmpCode;

    /**
     * 申请日期
     */
    @ApiModelProperty("申请日期")
    private LocalDateTime applyDate;
    /**
     * 申请描述
     */
    @ApiModelProperty("申请描述")
    private String applyDesc;
    /**
     * 交易日期 实际出入库日期
     */
    @ApiModelProperty("交易日期 实际出入库日期")
    private LocalDateTime ioDate;
    /**
     * 仓库ID
     */
    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("仓库编码")
    private String whCode;

    /**
     * 温层 [UDC]INV:TEMP_TYPE
     */
    @ApiModelProperty("温层 [UDC]INV:TEMP_TYPE")
    private String deter1;
    /**
     * 功能区 [UDC]INV:FUNC_TYPE
     */
    @ApiModelProperty("功能区 [UDC]INV:FUNC_TYPE")
    private String deter2;
    /**
     * 客户标识
     */
    @ApiModelProperty("客户标识")
    private String deter3;
    /**
     * 限定4
     */
    @ApiModelProperty("限定4")
    private String deter4;
    /**
     * 限定5
     */
    @ApiModelProperty("限定5")
    private String deter5;
    /**
     * 限定6
     */
    @ApiModelProperty("限定6")
    private String deter6;
    /**
     * 限定7
     */
    @ApiModelProperty("限定7")
    private String deter7;
    /**
     * 限定8
     */
    @ApiModelProperty("限定8")
    private String deter8;
    /**
     * 总数量
     */
    @ApiModelProperty("总数量")
    private BigDecimal qty;
    /**
     * 数量单位
     */
    @ApiModelProperty("数量单位")
    private String qtyUom;
    /**
     * 税额
     */
    @ApiModelProperty("税额")
    private BigDecimal taxAmt;
    /**
     * 含税金额
     */
    @ApiModelProperty("含税金额")
    private BigDecimal amt;
    /**
     * 不含税金额
     */
    @ApiModelProperty("不含税金额")
    private BigDecimal netAmt;
    /**
     * 记账币种
     */
    @ApiModelProperty("记账币种")
    private String homeCurr;
    /**
     * 交易币种
     */
    @ApiModelProperty("交易币种")
    private String currCode;
    /**
     * 汇率
     */
    @ApiModelProperty("汇率")
    private Double currRate;
    /**
     * 外币不含税金额
     */
    @ApiModelProperty("外币不含税金额")
    private BigDecimal currNetAmt;
    /**
     * 外币含税金额
     */
    @ApiModelProperty("外币含税金额")
    private BigDecimal currAmt;
    /**
     * 成本金额
     */
    @ApiModelProperty("成本金额")
    private BigDecimal costAmt;
    /**
     */
    @ApiModelProperty("单据来源标示：1为外部过来单据")
    private Integer sourceFlag;

    /**
     * 关联单据类别 [UDC]如RMA单，盘点单。COM:DOC_CLS
     */
    @ApiModelProperty("关联单据类别 [UDC]如RMA单，盘点单。COM:DOC_CLS")
    private String relateDocCls;
    /**
     * 关联单据类型
     */
    @ApiModelProperty("关联单据类型")
    private String relateDocType;
    /**
     * 关联单据ID
     */
    @ApiModelProperty("关联单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateDocId;
    /**
     * 关联单据编号
     */
    @ApiModelProperty("关联单据编号")
    private String relateDocNo;
    /**
     * 关联ID
     */
    @ApiModelProperty("关联ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateId;
    /**
     * 关联编号 外部单据号
     */
    @ApiModelProperty("关联编号 外部单据号")
    private String relateNo;
    /**
     * 关联2ID
     */
    @ApiModelProperty("关联2ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relate2Id;
    /**
     * 关联2编号
     */
    @ApiModelProperty("关联2编号")
    private String relate2No;

    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;

    /**
     * 原因码 [UDC]COM:REASON_CODE
     */
    @ApiModelProperty("原因码 [UDC]COM:REASON_CODE")
    private String reasonCode;

    /**
     * 文件服务器编码
     */
    @ApiModelProperty("文件服务器编码")
    private String fileCode;

    @ApiModelProperty("库存调整明细")
    private List<InvAjDSaveVO> invAjDSaveVOList;

    @ApiModelProperty("是否默认启用工作流")
    boolean lotFlag;

    @ApiModelProperty("权限id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long secBuId;

    @ApiModelProperty("数据归属公司id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long secOuId;

    @ApiModelProperty("数据归属账号id")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long secUserId;
    @ApiModelProperty("单据类别")
    private String docCls;

    @ApiModelProperty("客户编码")
    private String limit1;

    @ApiModelProperty("库存类型")
    private String limit2;



}
