package com.elitesland.yst.production.inv.application.facade.vo;

import com.alibaba.excel.annotation.ExcelIgnoreUnannotated;
import com.alibaba.excel.annotation.ExcelProperty;
import com.elitescloud.cloudt.common.annotation.SysCode;
import io.swagger.annotations.ApiModel;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author lu.wang
 * @date 2020-08-12 08:16
 * Desc: 库内组装单及明细VO
 */
@Data
@ExcelIgnoreUnannotated
@ApiModel(value = "INV_ASM_ASMD", description = "库内组装单及明细VO")
public class InvAsmAndAsmDDownloadRespVO implements Serializable {
    private static final long serialVersionUID = 2917363253371374900L;

    @ExcelProperty("组装单号")
    String docNo;
//    @ExcelProperty(value = "外部单据编号")
//    String outerNo;
    @SysCode(sys = "yst-inv", mod = "TRN_STATUS")
    String docStatus;
    @ExcelProperty("状态")
    String docStatusName;
    @ExcelProperty("公司")
    String ouName;
    @SysCode(sys = "ITM", mod = "ITEM_GROUP")
    String brand;
    @ExcelProperty("品牌")
    String brandName;
    @ExcelProperty("商品编码")
    String itemCode;
    @ExcelProperty("商品名称")
    String itemName;
    @ExcelProperty("规格")
    String packageSpec;

    @SysCode(sys = "COM", mod = "IO")
    String lineType;
    @ExcelProperty("出/入")
    String lineTypeName;
    @ExcelProperty("数量")
    BigDecimal qty;

    @ExcelProperty("批次")
    String lotNo;


    @SysCode(sys = "COM", mod = "REASON_CODE")
    String reasonCode;
    @ExcelProperty("原因")
    String reasonCodeName;
    @ExcelProperty("仓库")
    String whCode;
    @ExcelProperty("仓库名称")
    String whName;

    @SysCode(sys = "yst-inv", mod = "TEMP_TYPE")
    String deter1;
//    @ExcelProperty("温层")
//    String deter1Name;

    @SysCode(sys = "yst-inv", mod = "FUNC_TYPE")
    String deter2;
    @ExcelProperty("功能库区")
    String deter2Name;

    @SysCode(sys = "COM", mod = "UOM")
    String uom;
    @ExcelProperty("单位")
    String uomName;
    @ExcelProperty(value = "组装备注")
    private String remark;
    @ExcelProperty("申请日期")
    LocalDateTime applyDate;
    @ExcelProperty("交易日期")
    LocalDateTime ioDate;

//    @ExcelProperty("成本单价")
//    @NumberFormat(value = "#,###.##")
//    BigDecimal costPrice;
//    @ExcelProperty("成本金额")
//    @NumberFormat(value = "#,###.##")
//    BigDecimal costAmt;
//
//    @ExcelProperty(value = "外部单据公司")
//    private String outerOu;
//
//    @ExcelIgnore
//    @ExcelProperty(value = "外部单据类型")
//    private String outerType;
//
//    @ExcelProperty(value = "外部单据行号")
//    private String outerLineno;




}
