package com.elitesland.yst.production.inv.application.facade.vo;

import com.elitescloud.boot.model.entity.BaseModel;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 库存成本业务配置
 *
 * @author : JS
 * @date 2021/07/14 16:18
 */
@Data
@ApiModel(value = "INV_COST_CONFIG", description = "库存成本业务配置")
public class InvCostConfigRespVO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -2187455690791759331L;

    @ApiModelProperty("业务配置编码(UDC:BUSINESS_CONFIG_CODE)")
    String businessConfigCode;

    @ApiModelProperty("业务配置编码描述(UDC:BUSINESS_CONFIG_CODE)")
    String businessConfigCodeName;

    @ApiModelProperty("业务配置类型 01 有此业务 参与计算  02有此业务 不参与计算 03.无此业务(UDC:BUSINESS_CONFIG_TYPE)")
    String businessConfigType;

    @ApiModelProperty("业务配置类型描述 01 有此业务 参与计算  02有此业务 不参与计算 03.无此业务(UDC:BUSINESS_CONFIG_TYPE)")
    String businessConfigTypeName;

    @ApiModelProperty("当前配置版本号")
    @JsonSerialize(using = ToStringSerializer.class)
    Integer configVersion;

}