package com.elitesland.yst.production.inv.application.facade.vo;

import com.elitesland.yst.production.inv.application.facade.vo.base.InvBaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>
 * 批次库存查询（公共方法24入参）
 * </p>
 *
 * @author ssy
 * @since 2020-08-12
 */
@Data
@ApiModel(value = "批次库存查询（公共方法24入参）", description = "批次库存查询（公共方法24入参）")
public class InvLotStkCommon24InSaveVO extends InvBaseModel implements Serializable {

    private static final long serialVersionUID = -2819295843495675610L;

//    @ApiModelProperty("商品编号")
//    private String itemCode;

//    @ApiModelProperty("仓库编码")
//    private String whCode;

    // 20201013 朱亮 不完全是批次主数据的sinStatus。0：无卫检要求；1：全部卫检；
    // 0什么都不控制   1，用sinQty判断，sinStatus 是all或part
    @ApiModelProperty("卫检状态:")
    private String sinStatus;

    @ApiModelProperty("批次限定个数")
    private Integer maxLotNum;

    @ApiModelProperty("要求数量")
    private Double demandNum;

    @ApiModelProperty("[锁定标识]锁定/非锁定决定 质量状态为锁定/非锁定的批次号")
    private String qcStatus;

    @ApiModelProperty("新鲜度要求(最低允收期天数))")
    private Double fressTypeDays;

    @ApiModelProperty("调整天数")
    private Double adjustDays;

    @ApiModelProperty("最早批次号")
    private String firstLotNo;

    @ApiModelProperty("整箱标识：0：可整可散，1：可整")
    private Integer fclFlag;

    @ApiModelProperty("整箱箱装数")
    private Double fclNum;

    @ApiModelProperty("批次状态 允许的出入库类型,0,可以出，1不可以出")
    private String lotStatus;

}
