package com.elitesland.yst.production.inv.application.facade.vo.invstk;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * <p>
 * 库存结存明细(InvStk)实体类
 * </p>
 *
 * @author ssy
 * @since 2020-08-04 10:58:10
 */
@Data
@ApiModel(value = "库存结存明细模糊搜索参数", description = "库存结存明细模糊搜索参数")
public class InvStkLikeParamVO extends AbstractOrderQueryParam {
    private static final long serialVersionUID = 3349428939173608158L;
//
//    @ApiModelProperty("模糊搜索批次关键字")
//    private String keyWord;

    @NotNull(message = "仓库信息不能为空")
    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("仓库id")
    private Long whId;

    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("仓库名称")
    private String whName;

    @ApiModelProperty("温层")
    private String deter1;

    @ApiModelProperty("温层名称")
    private String deter1Name;

    @ApiModelProperty("功能区")
    private String deter2;

    @ApiModelProperty("功能区名称")
    private String deter2Name;

    @ApiModelProperty("客户标识")
    private String deter3;
    @ApiModelProperty("客户标识名称")
    private String deter3Name;

    @NotNull(message = "商品编码不能为空")
    @ApiModelProperty("商品编码")
    private String itemCode;

    @ApiModelProperty("商品名称")
    private String itemName;

}
