package com.elitesland.yst.production.inv.application.facade.vo.invstk;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 共享库存查询实体类
 * </p >
 *
 * @author jeesie.jiang
 * @date 2021/9/26
 */
@Data
public class InvStkShareQueryParam extends AbstractOrderQueryParam implements Serializable{

    private static final long serialVersionUID = -3545957298623198833L;


    @ApiModelProperty("仓库编码")
    private String whCode;

    @ApiModelProperty("仓库ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long whId;

    @ApiModelProperty("仓库ID集合")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> whIds;


    @ApiModelProperty("功能区")
    private String deter2;

    @ApiModelProperty("功能区集合")
    private  List<String>  deter2s;

    @ApiModelProperty("库存合作伙伴类型")
    private String pType;

    @ApiModelProperty("库存合作伙伴名称")
    private String pCode;

    @ApiModelProperty("库存合作伙伴名")
    private String pName;

    @ApiModelProperty("共享类型")
    private String shareType;


    @ApiModelProperty("公司")
    private String ouCode;

    @ApiModelProperty("公司")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    @ApiModelProperty("公司ID集合")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> ouIds;

    @ApiModelProperty("商品")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;

    @ApiModelProperty("商品集合")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> itemIds;

    @ApiModelProperty("商品品类")
    private String itemCateCode;

    @ApiModelProperty("批次号")
    private String lotNo;





}
