package com.elitesland.yst.production.inv.application.facade.vo.invwh;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

@Data
@ApiModel(value = "inv_wh", description = "仓库")
public class InvWhParamVO extends AbstractOrderQueryParam {
    private static final long serialVersionUID = 736305377479670725L;
    /**
     * 唯一编号ID
     */
    @ApiModelProperty("唯一编号ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;

    /**
     * 公司ID
     */
    @ApiModelProperty("公司集合")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> ouIds;
    @ApiModelProperty("所属组织")
    private String belongBuId;
    /**
     * BUID
     */
    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;
    /**
     * 所有者地址号 用于寄售库和VMI库，DCH不用
     */
    @ApiModelProperty("所有者地址号 用于寄售库和VMI库，DCH不用")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ownerAddrNo;

    @ApiModelProperty("供应商合作公司")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long relateOuId;

    @ApiModelProperty("供应商合作公司编码")
    private String relateOuCode;
    /**
     * 仓库编号
     */
    @ApiModelProperty("仓库编号")
    private String whCode;
    /**
     * 仓库名称
     */
    @ApiModelProperty("仓库名称")
    private String whName;
    /**
     * 仓库名称2
     */
    @ApiModelProperty("仓库名称2")
    private String whName2;
    /**
     * 简称
     */
    @ApiModelProperty("简称")
    private String whAbbr;
    /**
     * 仓库类型 [UDC]INV:WH_TYPE
     */
    @ApiModelProperty("仓库类型 [UDC]INV:WH_TYPE")
    private String whType;
    /**
     * 仓库类型2
     */
    @ApiModelProperty("仓库类型2")
    private String whType2;
    /**
     * 仓库类型3
     */
    @ApiModelProperty("仓库类型3")
    private String whType3;
    /**
     * 仓库状态
     */
    @ApiModelProperty("仓库状态")
    private String whStatus;

    /**
     * 营业厅编码
     */
    @ApiModelProperty("营业厅编码")
    private String businessCode;

    /**
     * 仓库状态2
     */
    @ApiModelProperty("仓库状态2")
    private String whStatus2;
    /**
     * 是否3PL仓库
     */
    @ApiModelProperty("是否3PL仓库")
    private Integer thirdplFlag;
    /**
     * 物理仓编号
     */
    @ApiModelProperty("物理仓编号")
    private String physicalWhCode;
    /**
     * 地址号 仓库本身的地址号
     */
    @ApiModelProperty("地址号 仓库本身的地址号")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long addrNo;
    /**
     * 地址ID 仓库的物理地址，维护仓库的地址时根据规则回写。指向 addr_address.
     */
    @ApiModelProperty("地址ID 仓库的物理地址，维护仓库的地址时根据规则回写。指向 addr_address.")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long addressId;
    /**
     * 上级ID
     */
    @ApiModelProperty("上级ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long pid;
    /**
     * 路径
     */
    @ApiModelProperty("路径")
    private String whPath;
    /**
     * 区域
     */
    @ApiModelProperty("区域")
    private String region;
    /**
     * ES1
     */
    @ApiModelProperty("ES1")
    private String es1;
    /**
     * ES2
     */
    @ApiModelProperty("ES2")
    private String es2;
    /**
     * ES3
     */
    @ApiModelProperty("ES3")
    private String es3;
    /**
     * ES4
     */
    @ApiModelProperty("ES4")
    private String es4;
    /**
     * ES5
     */
    @ApiModelProperty("ES5")
    private String es5;
    /**
     * ES6
     */
    @ApiModelProperty("ES6")
    private String es6;
    /**
     * ES7
     */
    @ApiModelProperty("ES7")
    private String es7;
    /**
     * ES8
     */
    @ApiModelProperty("ES8")
    private String es8;
    /**
     * ES9
     */
    @ApiModelProperty("ES9")
    private String es9;
    /**
     * ES10
     */
    @ApiModelProperty("ES10")
    private String es10;
    /**
     * 采购仓库/销售仓库
     */
    @ApiModelProperty("采购仓库/销售仓库")
    private String ee1;
    /**
     * 是否有WMS
     */
    @ApiModelProperty("是否有WMS")
    private String ee2;
    /**
     * EE3
     */
    @ApiModelProperty("EE3")
    private String ee3;
    /**
     * 租户ID
     */
    @ApiModelProperty("租户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long tenantId;
    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;
    /**
     * 记录创建者ID
     */
    @ApiModelProperty("记录创建者ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long createUserId;
    /**
     * 记录创建时间
     */
    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;
    /**
     * 记录最后更新者ID
     */
    @ApiModelProperty("记录最后更新者ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long modifyUserId;
    /**
     * 记录最后更新时间
     */
    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;
    /**
     * 逻辑删除，0：未删除，1：已删除
     */
    @ApiModelProperty("逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;
    /**
     * 版本信息，前端不用传
     */
    @ApiModelProperty("版本信息，前端不用传")
    private Integer auditDataVersion;

    /**
     * lu.wang 2020-11-07 13:24:28
     * 前端可输可选组件多字段查询关键字
     */
    @ApiModelProperty("多字段查询关键字")
    String multiKeywords;

    private List<Long> whIds;

    /**
     * 石浩冬 2021/1/13
     * 用于收集模糊查询出的仓库类型
     */
    @ApiModelProperty("仓库类型")
    private List<String> whTypes;

    @ApiModelProperty("外部系统仓库编码")
    private String otherWhCode;

    @ApiModelProperty("外部仓库类型")
    private String otherWhType;

    @ApiModelProperty("销售组织编码")
    private String desCode;
    @ApiModelProperty("销售组织编码集合")
    private List<String> desCodeList;
}
