package com.elitesland.yst.production.inv.application.facade.vo.lot;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel("批次查询")
public class InvLotCombineParam extends AbstractOrderQueryParam {
    private static final long serialVersionUID = 4520691595825514631L;

    @ApiModelProperty("批次号")
    String lotNo;

    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    List<Long> ouIds;

    @ApiModelProperty("销售订单ID")
    @JsonSerialize(using = ToStringSerializer.class)
    List<Long> buIds;

    @ApiModelProperty("品项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    List<Long> itemIds;

    @ApiModelProperty("首次入库日期")
    List<LocalDateTime> firstInDates;

    @ApiModelProperty("首次入库日期")
    LocalDateTime firstInDate;

    @ApiModelProperty("单据类型")
    String srcDocCls;

    @ApiModelProperty("来源单据号")
    String srcDocNo;

    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    List<Long> suppIds;

    @ApiModelProperty("生产日期")
    List<LocalDateTime> manuDates;

    @ApiModelProperty("生产日期")
    LocalDateTime manuDate;

    @ApiModelProperty("生产批次")
    String menuLotNo;

    @ApiModelProperty("质量状态")
    String qcStatus;

    @ApiModelProperty("失效日期")
    List<LocalDateTime> expireDates;

    @ApiModelProperty("失效日期")
    LocalDateTime expireDate;



}
