package com.elitesland.yst.production.inv.application.facade.vo.lot;

import com.elitesland.yst.production.inv.utils.BaseModelVO;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.sun.istack.NotNull;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 批次库存分配变更（公共方法26入参）
 * </p>
 *
 * @author ssy
 * @since 2020-08-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "批次库存分配变更（公共方法26入参）", description = "批次库存分配变更（公共方法26入参）")
public class InvLotCommon26InSaveVO extends BaseModelVO implements Serializable {

    private static final long serialVersionUID = 4570088290063168518L;

    @ApiModelProperty("预留单ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long roId;

    @ApiModelProperty("预留单明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long roDid;

    @ApiModelProperty("库存ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long invStkId;

    @NotNull
    @ApiModelProperty("行号")
    private Double lineNo;
    @NotNull
    @ApiModelProperty("退回数量（正数）")
    private BigDecimal returnQty;

    /**
     * 来源单据类别
     */
    @NotEmpty
    @ApiModelProperty("来源单据类别")
    private String srcDocCls;
    /**
     * 来源单据ID
     */
    @NotNull
    @ApiModelProperty("来源单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long srcDocId;
    /**
     * 来源单据编号
     */
    @NotEmpty
    @ApiModelProperty("来源单据编号")
    private String srcDocNo;
    /**
     * 来源单据明细ID
     */
    @NotNull
    @ApiModelProperty("来源单据明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long srcDocDid;

    @NotEmpty
    @ApiModelProperty("单据类型【RO：预留单、STK：库存】")
    private String orderType;

}
