package com.elitesland.yst.production.inv.application.facade.vo.lot;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * 批次主档(InvLot)实体类
 * </p>
 *
 * @author ssy
 * @since 2020-07-30 15:08:02
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "inv_lot", description = "批次主档")
public class InvLotParam extends AbstractOrderQueryParam {
    private static final long serialVersionUID = -48948029368476863L;
    /**
     * 唯一编号ID
     */
    @ApiModelProperty("唯一编号ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;
    /**
     * 公司ID
     */
    @ApiModelProperty("公司ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ouId;
    /**
     * BUID
     */
    @ApiModelProperty("BUID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long buId;
    /**
     * 品项ID
     */
    @ApiModelProperty("品项ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long itemId;
    /**
     * 异构ID
     */
    @ApiModelProperty("异构ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long variId;

    /**
     * 交易单价 折扣后，不含税
     */
    @ApiModelProperty("交易单价 折扣后，不含税")
    private BigDecimal transPrice;
    /**
     * 交易单价 折扣后，含税
     */
    @ApiModelProperty("交易单价 折扣后，不含税")
    private BigDecimal tranPrice;


    @ApiModelProperty("税率")
    private Double taxRate;
    /**
     * 品项编号
     */
    @ApiModelProperty("品项编号")
    private String itemCode;
    /**
     * 批次号
     */
    @ApiModelProperty("批次号")
    private String lotNo;
    /**
     * 批次说明
     */
    @ApiModelProperty("批次说明")
    private String lotDesc;
    /**
     * 批次状态 允许的出入库类型，0,可以出，1不可以出
     */
    @ApiModelProperty("批次状态 允许的出入库类型，0,可以出，1不可以出")
    private String lotStatus;
    /**
     * 批次状态2 备用
     */
    @ApiModelProperty("批次状态2 备用")
    private String lotStatus2;
    /**
     * 批次状态3 备用
     */
    @ApiModelProperty("批次状态3 备用")
    private String lotStatus3;
    /**
     * 质量状态
     */
    @ApiModelProperty("质量状态")
    private String qcStatus;
    /**
     * 卫检状态
     */
    @ApiModelProperty("卫检状态")
    private String sinStatus;
    /**
     * 锁定原因
     */
    @ApiModelProperty("锁定原因")
    private String lockReason;
    /**
     * 已卫检数量
     */
    @ApiModelProperty("已卫检数量")
    private BigDecimal sinQty;
    /**
     * 保质期天数
     */
    @ApiModelProperty("保质期天数")
    private Integer expireDays;
    /**
     * 生产日期
     */
    @ApiModelProperty("生产日期")
    private LocalDateTime manuDate;
    /**
     * 生产批次
     */
    @ApiModelProperty("生产批次")
    private String menuLotNo;
    /**
     * 整批号
     */
    @ApiModelProperty("整批号")
    private String batchNo;
    /**
     * 失效日期
     */
    @ApiModelProperty("失效日期")
    private LocalDateTime expireDate;
    /**
     * 剩余效期天数 每天自动计算
     */
    @ApiModelProperty("剩余效期天数 每天自动计算")
    private Integer untilExpireDays;
    /**
     * 新鲜度 每天自动计算。[UDC]COM:FRESS_TYPE
     */
    @ApiModelProperty("新鲜度 每天自动计算。[UDC]COM:FRESS_TYPE")
    private String fressType;
    /**
     * 首次入库日期
     */
    @ApiModelProperty("首次入库日期")
    private LocalDateTime firstInDate;
    /**
     * 最后出库日期
     */
    @ApiModelProperty("最后出库日期")
    private LocalDateTime lastOutDate;
    /**
     * 销售截止日期
     */
    @ApiModelProperty("销售截止日期")
    private LocalDateTime maxSaleDate;
    /**
     * 原产国
     */
    @ApiModelProperty("原产国")
    private String menuCountry;
    /**
     * 产地描述
     */
    @ApiModelProperty("产地描述")
    private String menuDesc;
    /**
     * 产地证明编号
     */
    @ApiModelProperty("产地证明编号")
    private String menuDocNo;
    /**
     * 制造商ID
     */
    @ApiModelProperty("制造商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long manuerId;
    /**
     * 制造商编号
     */
    @ApiModelProperty("制造商编号")
    private String manuerCode;
    /**
     * 制造商名称
     */
    @ApiModelProperty("制造商名称")
    private String manuerName;
    /**
     * 供应商ID
     */
    @ApiModelProperty("供应商ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long suppId;
    /**
     * 默认卫检单ID
     */
    @ApiModelProperty("默认卫检单ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long sinId;
    /**
     * 默认卫检单编号
     */
    @ApiModelProperty("默认卫检单编号")
    private String sinNo;
    /**
     * 卫检日期
     */
    @ApiModelProperty("卫检日期")
    private LocalDateTime sinDate;
    /**
     * 货主类型 供应商/客户，DCH不用
     */
    @ApiModelProperty("货主类型 供应商/客户，DCH不用")
    private String ownerType;
    /**
     * 货主ID DCH不用
     */
    @ApiModelProperty("货主ID DCH不用")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long ownerId;
    /**
     * 货主编码 DCH不用
     */
    @ApiModelProperty("货主编码 DCH不用")
    private String ownerCode;
    /**
     * 来源单据类别
     */
    @ApiModelProperty("来源单据类别")
    private String srcDocCls;
    /**
     * 来源单据ID
     */
    @ApiModelProperty("来源单据ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long srcDocId;
    /**
     * 来源单据编号
     */
    @ApiModelProperty("来源单据编号")
    private String srcDocNo;
    /**
     * 来源单据明细ID
     */
    @ApiModelProperty("来源单据明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long srcDocDid;
    /**
     * 采购单ID
     */
    @ApiModelProperty("采购单ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long poId;
    /**
     * 采购单号
     */
    @ApiModelProperty("采购单号")
    private String poNo;
    /**
     * 采购单类型
     */
    @ApiModelProperty("采购单类型")
    private String poType;
    /**
     * 采购单明细ID
     */
    @ApiModelProperty("采购单明细ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long poDId;
    /**
     * ES1
     */
    @ApiModelProperty("ES1")
    private String es1;
    /**
     * ES2
     */
    @ApiModelProperty("ES2")
    private String es2;
    /**
     * ES3
     */
    @ApiModelProperty("ES3")
    private String es3;
    /**
     * ES4
     */
    @ApiModelProperty("ES4")
    private String es4;
    /**
     * ES5
     */
    @ApiModelProperty("ES5")
    private String es5;
    /**
     * 租户ID
     */
    @ApiModelProperty("租户ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long tenantId;
    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;
    /**
     * 记录创建者ID
     */
    @ApiModelProperty("记录创建者ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long createUserId;
    /**
     * 记录创建时间
     */
    @ApiModelProperty("记录创建时间")
    private LocalDateTime createTime;
    /**
     * 记录最后更新者ID
     */
    @ApiModelProperty("记录最后更新者ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long modifyUserId;
    /**
     * 记录最后更新时间
     */
    @ApiModelProperty("记录最后更新时间")
    private LocalDateTime modifyTime;
    /**
     * 逻辑删除，0：未删除，1：已删除
     */
    @ApiModelProperty("逻辑删除，0：未删除，1：已删除")
    private Integer deleteFlag;
    /**
     * 版本信息，前端不用传
     */
    @ApiModelProperty("版本信息，前端不用传")
    private Integer auditDataVersion;


}
