package com.elitesland.yst.production.inv.application.facade.vo.whAreaSetting;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.List;

/**
 * <p>
 * 功能说明:功能区配置
 * </p>
 *
 * @Author Darren
 * @Date 2022/04/19
 * @Version 1.0
 * @Content:
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class InvWhAreaSettingParamVO extends AbstractOrderQueryParam implements Serializable {
    private static final long serialVersionUID = -374682536552039943L;

    @ApiModelProperty("ID")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long id;

    @ApiModelProperty("功能区ID集合")
    @JsonSerialize(using = ToStringSerializer.class)
    private List<Long> idList;

    @ApiModelProperty("功能区编码")
    private String deter2;

    @ApiModelProperty("功能区编码集合")
    private List<String> deter2List;

    @ApiModelProperty("功能区名称")
    private String deter2Name;

    @ApiModelProperty("合作伙伴类型 [UDC]INV:PARTNER_TYPE")
    private String pType;

    @ApiModelProperty("可使用仓库类型编码、可多选、逗号分隔存储")
    private String whType;

    @ApiModelProperty("可使用仓库类型编码、可多选、逗号分隔存储")
    private List<String> whTypes;

    @ApiModelProperty("建仓前端是否可选 [UDC]INV:BUSINESS_CHOOSE")
    private Boolean businessChoose;

    @ApiModelProperty("是否零价库 [UDC]INV:ZERO_WH")
    private Boolean isZeroWh;

    @ApiModelProperty("是否启用，默认为启用 [UDC]INV:ACTIVE_STATUS")
    private String status;

    @ApiModelProperty("功能区类型")
    private String deter2Type;

    @ApiModelProperty("功能区类型名")
    private String deter2TypeName;

    @ApiModelProperty("关键字查询")
    private String keyWords;

}
