package com.elitesland.yst.production.inv.application.out;

import com.elitescloud.cloudt.system.dto.resp.SysCurrencyRespDTO;
import com.elitesland.yst.production.inv.application.facade.vo.InvParentParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.OrgRespVO;
import com.elitesland.yst.production.inv.utils.InvPTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.support.provider.org.dto.*;
import com.elitesland.yst.production.support.provider.org.param.*;

import java.util.List;
import java.util.Optional;


/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author zhao_qiao_gong
 * @date 2020/7/2
 */
public interface OrgOutService {
    /**
     * 查询公司
     *
     * @param ouId 公司id
     * @return 公司
     */
    OrgOuRpcDTO findOuById(Long ouId);

    /**
     * 查询公司
     *
     * @param ouCode 公司编码
     * @return 公司编码
     */
    OrgOuRpcDTO findOuByOuCode(String ouCode);

    /**
     * 根据id集合查询公司集
     *
     * @param ouIds 公司id集
     * @return 公司集
     */
    List<OrgOuRpcDTO> findOuByIds(List<Long> ouIds);

    /**
     * 根据公司编号集合查询公司集
     *
     * @param ouCodes 公司编号集
     * @return 公司集
     */
    List<OrgOuRpcDTO> findOuByCodes(List<String> ouCodes);

    List<OrgOuRpcDTO> selectBaseByOuCodes(List<String> ouCodes);

    /**
     * 查找员工表
     *
     * @param empId 员工id
     * @return 员工
     */
    OrgEmpRpcDTO findEmpById(Long empId);


    /**
     * 2
     * 获取员工信息列表，该接口一般应用与如下场景
     * 1. 第三方通过id或者code获取一些基本信息，用于后端处理
     * 2. 检查数据是否存在，存在则会返回数据，不存在则不会返回数据
     * <p>
     * 如果传入的查询参数均为空，则不返回任何数据，防止获取全部数据
     * <p>
     * 注意接口返回数据没有上限控制，请合理使用，保证效能
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param param dto 查询条件，每个条件使用 and 关联
     * @return dto
     */
    List<OrgEmpRpcDTO> findEmpDtoByParam(OrgEmpRpcDtoParam param);

    /**
     * 1
     * 获取公司信息列表，该接口一般应用与如下场景
     * 1. 第三方通过id或者code获取一些基本信息，用于后端处理
     * 2. 检查数据是否存在，存在则会返回数据，不存在则不会返回数据
     * <p>
     * 如果传入的查询参数均为空，则不返回任何数据，防止获取全部数据
     * <p>
     * 注意接口返回数据没有上限控制，请合理使用，保证效能
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param param dto 查询条件，每个条件使用 and 关联
     * @return dto
     */
    List<OrgOuRpcDTO> findOuDtoByParam(OrgOuRpcDtoParam param);


    /**
     * 3
     * 通过userId获取所属即下级所有组织id
     * 组织第一条数据为当前用户所属组织ID，之后的数据为拥有权限的组织ID
     *
     * @param userId 用户ID
     * @return 组织ID列表
     */
    List<Long> findBuIdsByUserId(Long userId);

    /**
     * 4
     * 通过username获取所属即下级所有组织id
     * 组织第一条数据为当前用户所属组织ID，之后的数据为拥有权限的组织ID
     *
     * @param username 用户名
     * @return 组织ID列表
     */
    List<Long> findBuIdsByUsername(String username);

    /**
     * 查询部门组织
     * @param param
     * @return
     */

    List<OrgBuRpcDTO> findBuIdsByUsername(OrgBuRpcDtoParam param);

    /**
     * 5
     * 新增/编辑 组织信息
     * 接口会附带创建地址薄信息，请不要额外调用地址薄创建接口，否则会出现两个地址薄信息
     *
     * @param param 保存参数
     * @return 保存结果
     */
    OrgBuRpcSaveResult orgBuRpcSaveOrUpdate(OrgBuRpcSaveParam param);

    /**
     * 6
     * 根据组织ID获取组织详情信息
     *
     * @param id 组织ID
     * @return 组织详情DTO
     */
    ApiResult<OrgBuDetailsRpcDTO> findDetailDtoById(Long id);

    /**
     * 1
     * 新增或修改地址薄信息
     * <p>
     * 该接口用于创建或者编辑现有的地址薄信息，所有的子信息为全删全插操作
     * 如果使用该接口，则请不要使用创建组织的接口，否则会创建两个地址薄信息
     * 该接口判断传入的ID是否为null来决定是新增还是编辑，返回的结果是地址号 addrNo，而不是ID
     * <p>
     * 如果接口调用失败，ApiResult 中的 data 返回将为 null，success 为 false，错误信息会保存在 message 中
     *
     * @param param 参数
     * @return 调用结果，如果成功，data 中保存的是 addrNo，而不是id
     */
    ApiResult<Long> orgAddrSaveOrUpdateReturnAddrNo(OrgAddrRpcSaveParam param);

    /**
     * 2
     * 根据地址号获取地址薄详情
     *
     * @param addrNo 地址号
     * @return 地址薄详情
     */
    OrgAddrDetailsRpcDTO findRpcDtoByAddrNo(Long addrNo);

    /**
     * 3
     * 软删除地址薄信息
     *
     * @param addrNo 地址号
     */
    void softDeleteOrgAddrByAddrNo(Long addrNo);

    List<OrgAddressRpcDTO> findRpcDtoByBatchAddrNos(OrgAddressRpcDtoParam param );

    /**
     * 根据id集合查询组织集
     *
     * @param buIds 组织id集
     * @return 组织集
     */
    List<OrgBuRpcDTO> findBuByIds(List<Long> buIds);

    List<OrgBuRpcDTO> findBuByCodes(List<String> buCodes);


    Optional<OrgBuRpcDTO> findBuById(Long buId);
    /**
     * 币种查询
     */
    List<SysCurrencyRespDTO> findRpcDtoByParam(List<String> currCodes);


    /**
     * 模糊搜索供应商/客户/员工
     *
     * @param param code=code/name
     * @return 供应商/客户/员工的code和name
     */
    List<OrgRespVO> findcodeAndName(InvParentParamVO param);

    /**
     * 批量查询供应商/客户/员工
     *
     * @param type，codes
     * @return 供应商/客户/员工的code和name
     */
    List<OrgRespVO> findcodeAndNameList(InvPTypeEnum type, List<String> codes);
}
