package com.elitesland.yst.production.inv.application.service;


import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotCommon21FilterParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotCommon21InVO;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotCommonSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotParam;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotSaveVO;
import com.elitescloud.cloudt.common.base.ApiResult;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 批次（共通方法）
 * </p >
 *
 * @author ssy
 * @date 2020/7/30
 */
public interface InvLotCommonService {

    /**
     * 批次主信息 查询（共通方法21）
     * <pre>
     *  参数校验：无（当无入参时，查询全部）
     *  当数据 保质期疑似错误时，记录信息，依然进行数据保存
     *  返回值：
     *      说明：key   为入参的index
     *           value 为查询的全部数据
     *      有入参:
     *      无入参：key 默认为0
     * </pre>
     *
     * @param inVOList
     * @return
     */
    Map<Integer, List<InvLotRespVO>> getInvLotVOList(List<InvLotCommon21InVO> inVOList);

    Map<String, List<InvLotRespVO>> getInvLotVOListByKey(List<String> inVOList);


    List<InvLotRespVO> getInvLotVOListByParam(InvLotParam queryParam);

    /**
     * 过滤 批次主信息（范围过滤）
     *
     * @param source   批次主信息 数据源
     * @param filterVO 范围过滤的 参数
     * @return
     */
    List<InvLotRespVO> getInvLotCheckedList(List<InvLotRespVO> source, InvLotCommon21FilterParamVO filterVO);


    /**
     * 批次主信息	新增（共通方法22）
     * <pre>
     *  参数校验：失败，抛出异常
     *  当数据 保质期疑似错误时，记录信息，依然进行数据保存
     *  返回值：
     *      success: true，
     *      code 分两种情况：
     *          1.当code 为0 时，说明 全部正常保存成功。
     *          2.当code 为1 时，说明 存在部分数据被锁定。
     *      data: 全部的批次数据
     *      msg: 信息提示
     * </pre>
     *
     * @param source
     * @return ApiResult
     */
    ApiResult createInvLotInfo(List<InvLotSaveVO> source);

    /**
     * 批次主信息	修改（共通方法23）
     * <pre>
     *  参数校验：失败，抛出异常
     *  当数据 保质期疑似错误时，记录信息，依然进行数据保存
     *  返回值：
     *      success: true，
     *      code 分两种情况：
     *          1.当code 为0 时，说明 全部正常保存成功。
     *          2.当code 为1 时，说明 存在部分数据被锁定。
     *      data: 全部的批次数据
     *      msg: 信息提示
     * </pre>
     *
     * @param source
     * @return ApiResult
     */
    ApiResult updateInvLotInfo(List<InvLotCommonSaveVO> source);

}
