package com.elitesland.yst.production.inv.application.service;

import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkRespDVO;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotAllRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotCombineParam;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotParam;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotSaveVO;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvStkDParam;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;
import java.util.Optional;


/**
 * <p>
 * 批次主档
 * </p>
 *
 * @author ssy
 * @since 2020-07-30 15:07:59
 */
public interface InvLotService {
    /**
     * 根据商品id lonDo 获取数据 roman.zhang
     *
     * @param itmIdNo
     * @return
     */
    List<InvLotRespVO> findByAndItemIdAndLotNo(List<String> itmIdNo);


    /**
     * 根据商品id 商品编码查询批次
     *
     * @param itmIdNo
     * @return
     */
    List<InvLotRespVO> findListByAndItemIdAndLotNo(List<String> itmIdNo);

    /**
     * 根据 ITEM_ID + VARI_ID + LOT_NO，在批次表 INV_LOT 中取值
     * <p>
     * 1、生产日期：INV_LOT表中 MANU_DATE；
     * <p>
     * 2、失效日期：INV_LOT表中 EXPIRE_DATE；
     *
     * @param itmIdNo
     * @return
     */
    List<InvLotRespVO> findByAndItemIdAndLotNoList(List<String> itmIdNo);

    /**
     * 不抛出异常
     * 根据商品id lonDo 获取数据 roman.zhang
     *
     * @param itmIdNo
     * @return
     */
    List<InvLotRespVO> findByAndItemIdAndLotNo2(List<String> itmIdNo);


    /**
     * 根据id查询
     *
     * @param id
     * @return
     */
    Optional<InvLotAllRespVO> findInvLotAllOne(Long id);

    /**
     * 分页查询
     *
     * @param param
     * @return 对象
     */
    PagingVO<InvLotRespVO> findCombine(InvLotCombineParam param);


    /**
     * 根据条件查询批次主数据
     *
     * @param queryParam
     * @return
     */
    List<InvLotRespVO> findByParams(InvLotParam queryParam);


    /**
     * 添加已卫检数
     *
     * @param lotNo     批次号
     * @param itemId    商品id
     * @param sinQty    卫检数
     * @param sinStatus 卫检状态
     * @param sinNo     卫检单号
     */
    void addSinQty(String lotNo, Long itemId, Double sinQty, String sinStatus, String sinNo);


    /**
     * 批次主档关联库存余额
     *
     * @param param
     * @return
     */
    PagingVO<InvStkRespDVO> searchD(InvStkDParam param);


    /**
     * 检索
     *
     * @param queryParam 分类查询、分页和排序对象
     * @return 分页结果集
     */
    PagingVO<InvLotRespVO> search(InvLotParam queryParam);

    List<String> findLotNoByManuLot(String manuLot);

    /**
     * 根据关键字段，返回对应的vo
     * @param   code
     * @return 对象
     */
    // Optional<InvLotRespVO> findCodeOne(String code);

    /**
     * 根据ID查询批次信息，返回对应的ApiResult
     *
     * @param id ID
     * @return 对象
     */
    ApiResult<InvLotRespVO> findLotById(Long id);

    /**
     * 根据ID查询批次信息
     *
     * @param id ID
     * @return 对象
     */
    Optional<InvLotRespVO> findIdOne(Long id);

    /**
     * 创建
     *
     * @param objVo
     * @return 保存对象的ID
     */
    Long createOne(InvLotSaveVO objVo);

    /**
     * 根据关键字段，返回对应的
     *
     * @param idList ID集合
     * @return 对象
     */
    List<InvLotRespVO> findIdBatch(List<Long> idList);

    /**
     * 创建
     *
     * @param list 对象集合
     * @return 库存批次id
     */
    List<Long> createBatch(List<InvLotSaveVO> list);

    /**
     * 更新
     *
     * @param objDo 对象
     */
    void update(InvLotSaveVO objDo);

    /**
     * 删除
     *
     * @param id 对象
     */
    void deleteOne(Long id);

    /**
     * 删除
     *
     * @param idList 对象集合
     */
    void deleteBatch(List<Long> idList);


    /**
     * 更新删除标识
     *
     * @param id id
     */
    void updateDeleteFlag(Long id);

    List<InvLotRespVO> findByQueryParam(List<String> queryParam);
}
