package com.elitesland.yst.production.inv.application.service;

import com.elitesland.yst.production.inv.application.facade.vo.scene.InvSceneConfigPageVO;
import com.elitesland.yst.production.inv.application.facade.vo.scene.InvSceneConfigQueryVO;
import com.elitesland.yst.production.inv.application.facade.vo.scene.param.InvSceneConfigQueryParam;
import com.elitesland.yst.production.inv.application.facade.vo.scene.param.InvSceneConfigSaveParam;
import com.elitesland.yst.production.inv.infr.dto.InvSceneConfigDTO;
import com.elitescloud.cloudt.common.base.PagingVO;


/**
 * @author sushiqi
 */
public interface InvSceneConfigBizService {
    /**
     * 分页查询
     * @param param
     * @return
     */
    PagingVO<InvSceneConfigPageVO> searchPage(InvSceneConfigQueryParam param);

    /**
     * 保存/更新
     * @param param
     */
    Long saveOrUpdate(InvSceneConfigSaveParam param);

    /**
     * 删除主+明细信息
     * @param id
     */
    void del(Long id);

    /**
     * 详情信息
     * @param masId
     * @return
     */
    InvSceneConfigQueryVO detail(Long masId);

    /**
     * 根据场景码获取库存场景操作配置，优先缓存
     * @param sceneCode
     * @return
     */
    InvSceneConfigDTO getBySceneCode(String sceneCode);
}
