package com.elitesland.yst.production.inv.application.service;


import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhDeliveryParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhDeliveryRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhDeliverySaveVO;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;
import java.util.Optional;


/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author jeesie.jiang
 * @since 2021-05-29 14:00:15
 */
public interface InvWhDeliveryService {

    Optional<InvWhDeliveryRespVO> findIdOne(Long id);
    /**
     * 检索
     * @param param 分类查询、分页和排序对象
     * @return 分页结果集
     */
    PagingVO<InvWhDeliveryRespVO> search(InvWhDeliveryParamVO param);

    /**
     * 根据仓库id查询配送范围
     *
     * @param whId 仓库id
     * @return 库区
     */
    List<InvWhDeliveryRespVO> findByWhId(Long whId);

    /**
     * 创建
     *
     * @param  objVo
     */
    Long createOne(InvWhDeliverySaveVO objVo);

    /**
     * 创建
     *
     * @param list 对象集合
     */
    List<Long> createBatch(List<InvWhDeliverySaveVO> list);
}
