package com.elitesland.yst.production.inv.application.service.impl;


import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysUserVO;
import com.elitesland.yst.production.inv.application.facade.vo.*;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.OrgRespVO;
import com.elitesland.yst.production.inv.application.out.ItmOutService;
import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvAjDService;
import com.elitesland.yst.production.inv.application.service.InvWhAreaService;
import com.elitesland.yst.production.inv.domain.convert.InvAjConvert;
import com.elitesland.yst.production.inv.domain.service.InvAjDDomainService;
import com.elitesland.yst.production.inv.domain.service.InvAjDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhDomainService;
import com.elitesland.yst.production.inv.infr.dto.InvAjDTO;
import com.elitesland.yst.production.inv.utils.InvPTypeEnum;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;


/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author lvqf
 * @date 2021/2/1
 */

@Service
@AllArgsConstructor
@Slf4j
public class InvAjDServiceImpl implements InvAjDService {
    private final InvAjDDomainService invAjDDomainService;
    private final InvAjDomainService invAjDomainService;
    private final SystemService systemService;
    private final ItmOutService itmOutService;
    private final OrgOutService orgOutService;
    private final InvWhDomainService invWhDomainService;
    private final InvWhAreaService invWhAreaService;



    @Override
    @SysCodeProc
    public PagingVO<InvAjAndInvAjDRespVO> searchAll(InvAjDQueryAllParamVO param) {
        List<String> brands = param.getBrands();
        if (!CollectionUtils.isEmpty(brands)) {
            List<Long> itemIds = null;
            ItmItemRpcDtoParam itmItemPartParam = new ItmItemRpcDtoParam();
            itmItemPartParam.setBrands(brands);
            List<ItmItemRpcDTO> itmItemPartDTOS = itmOutService.findItemRpcDtoByParam(itmItemPartParam);
            if (!CollectionUtils.isEmpty(itmItemPartDTOS)) {
                itemIds = itmItemPartDTOS.stream().map(ItmItemRpcDTO::getId).collect(Collectors.toList());
            }
            if (param.getItemIds() != null) {
                param.getItemIds().addAll(itemIds);
            } else {
                param.setItemIds(itemIds);
            }
        }
        val pagingVO = invAjDDomainService.invAjSearch(param);
        if (CollectionUtils.isEmpty(pagingVO.getRecords())) {
            return PagingVO.<InvAjAndInvAjDRespVO>builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        val ajAndInvAjDRespVOS = pagingVO.getRecords();
        this.fillUpNameList(ajAndInvAjDRespVOS);
        return PagingVO.<InvAjAndInvAjDRespVO>builder()
                .total(pagingVO.getTotal())
                .records(ajAndInvAjDRespVOS)
                .build();
    }


    @Override
    public List<Long> updateInvAjDList(List<InvAjDSaveVO> list) {
        //调用共同方法24
        List<InvLotStkCommon24InSaveVO> inVOList = new LinkedList<>();
        Iterator<InvAjDSaveVO> it = list.iterator();
        //转换VO类型至Common24InVO
        while (it.hasNext()) {
            InvLotStkCommon24InSaveVO inVo = new InvLotStkCommon24InSaveVO();
            InvAjDSaveVO current = it.next();
            inVo.setItemId(current.getItemId());
            inVo.setVariId(current.getVariId());
            inVo.setWhId(current.getWhId());
            inVo.setDeter1(current.getDeter1());
            inVo.setDeter2(current.getDeter2());
            inVo.setLotNo(current.getLotNo());
            inVOList.add(inVo);
        }
        //根据共同方法返回值筛选有效细节表单
        List<InvAjDSaveVO> validatedList = new LinkedList<>();
        validatedList.addAll(list.stream().filter(v -> v.getDestroyFlag() != null && v.getDestroyFlag() && !validatedList.contains(v)).collect(Collectors.toList()));
        InvAjDTO invAjDTO = invAjDomainService.findById(list.stream().findAny().map(InvAjDSaveVO::getMasId).orElseThrow());
        val ret = invAjDDomainService.updateInBatch(validatedList);
        return ret;
    }

    @Override
    public List<InvAjAndInvAjDDownloadRespVO> findInvAjAndInvAjDDownloadVOs(InvAjDQueryAllParamVO param) {
        param.setSize(20000);
        val ret = searchAll(param);
        List<InvAjAndInvAjDRespVO> list = ret.getRecords();
        List<InvAjAndInvAjDDownloadRespVO> invAjAndInvAjDDownloadRespVOS = list.stream().map(i -> {
            InvAjAndInvAjDDownloadRespVO downloadVO = InvAjConvert.INSTANCE.invAjAndAjdRespVOToInvAjAndInvAjDDownloadVO(i);
            downloadVO.setPartnerCode(i.getPCode());
            downloadVO.setPartnerName(i.getPName());
            downloadVO.setPartnerTypeName(i.getPTypeName());
            return downloadVO;
        }).collect(Collectors.toList());
        return invAjAndInvAjDDownloadRespVOS;
    }

    /**
     * 填充反查数据
     *
     * @param vos 查询结果
     */
    private void fillUpNameList(List<InvAjAndInvAjDRespVO> vos) {
        Map<String, String> ajStatusMap = systemService.sysUdcGetCodeMap(UdcEnum.INV_AJ_STATUS_DR.getModel(), UdcEnum.INV_AJ_STATUS_DR.getCode());
        Map<String, String> docTypeMap = systemService.sysUdcGetCodeMap(UdcEnum.INV_AJ_TYPE_LOT.getModel(), UdcEnum.INV_AJ_TYPE_LOT.getCode());
        Map<String, String> reasonMap = systemService.sysUdcGetCodeMap(UdcEnum.INV_REASON_CODE_SKAJ.getModel(), UdcEnum.INV_REASON_CODE_SKAJ.getCode());
        Map<String, String> uomMap = systemService.sysUdcGetCodeMap(UdcEnum.COM_UOM_BG.getModel(), UdcEnum.COM_UOM_BG.getCode());
        Map<String, String> pTypeMap = systemService.sysUdcGetCodeMap(UdcEnum.INV_PARTNER_TYPE_CUST.getModel(), UdcEnum.INV_PARTNER_TYPE_CUST.getCode());
        List<Long> itemIds = vos.stream().filter(f -> f.getItemId() != null).map(InvAjAndInvAjDRespVO::getItemId).distinct()
                .filter(Objects::nonNull).collect(Collectors.toList());
        List<Long> ouIds = vos.stream().map(InvAjAndInvAjDRespVO::getOuId).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        List<String> pSuppCodes = vos.stream().filter(i -> UdcEnum.INV_PARTNER_TYPE_SUPP.getValueCode().equals(i.getPType()))
                .map(InvAjAndInvAjDRespVO::getPCode).distinct().collect(Collectors.toList());
        List<String> pCustCodes = vos.stream().filter(i -> UdcEnum.INV_PARTNER_TYPE_CUST.getValueCode().equals(i.getPType()))
                .map(InvAjAndInvAjDRespVO::getPCode).distinct().collect(Collectors.toList());
        List<String> pEmpCodes = vos.stream().filter(i -> UdcEnum.INV_PARTNER_TYPE_EMP.getValueCode().equals(i.getPType()))
                .map(InvAjAndInvAjDRespVO::getPCode).distinct().collect(Collectors.toList());
        //调用pur外部接口暂时没有，先注释
        List<OrgRespVO> suppList = orgOutService.findcodeAndNameList(InvPTypeEnum.INV_PARTNER_TYPE_SUPP, pSuppCodes);
        List<OrgRespVO> empList = orgOutService.findcodeAndNameList(InvPTypeEnum.INV_PARTNER_TYPE_EMP, pEmpCodes);
        List<Long> createUserIds = vos.stream().map(InvAjAndInvAjDRespVO::getCreateUserId).distinct().collect(Collectors.toList());
        List<SysUserVO> sysUserDOS = systemService.findAllEmpsByIdIn(createUserIds);
        ItmItemRpcDtoParam itmItemPartParam = new ItmItemRpcDtoParam();
        itmItemPartParam.setItemIds(itemIds);
        List<ItmItemRpcDTO> itmItemPartDTOS = itmOutService.findItemRpcDtoByParam(itmItemPartParam);
        List<OrgOuRpcDTO> orgOuVOS = orgOutService.findOuByIds(ouIds);
        vos.forEach(vo->{
            if (!CollectionUtils.isEmpty(sysUserDOS)) {
                sysUserDOS.stream().filter(v -> v.getId() != null && v.getId().equals(vo.getCreateUserId()))
                        .findFirst()
                        .ifPresent(empVo -> vo.setCreator(empVo.getUsername()));
            }
            Optional<OrgOuRpcDTO> orgOuVO = orgOuVOS.stream().filter(v -> v.getId().equals(vo.getOuId())).findFirst();
            if (!CollectionUtils.isEmpty(itmItemPartDTOS)) {
                Optional<ItmItemRpcDTO> itmItemVO = itmItemPartDTOS.stream().filter(v -> v.getId().equals(vo.getItemId())).findFirst();
                if (itmItemVO.isPresent()) {
                    ItmItemRpcDTO itemVO = itmItemVO.get();
                    vo.setItemCode(itemVO.getItemCode());
                    vo.setItemName(itemVO.getItemName());
                    vo.setBrand(itemVO.getBrand());
                    vo.setLotFlag(itemVO.getLotFlag());
                }
            }
            if (orgOuVO.isPresent()) {
                OrgOuRpcDTO ouVO = orgOuVO.get();
                vo.setOuName(ouVO.getOuName());
                vo.setOuCode(ouVO.getOuCode());
            }
            if (!CollectionUtils.isEmpty(ajStatusMap) && ajStatusMap.containsKey(vo.getDocStatus())) {
                vo.setDocStatusName(ajStatusMap.get(vo.getDocStatus()));
            }
            if (!CollectionUtils.isEmpty(docTypeMap) && docTypeMap.containsKey(vo.getDocType())) {
                vo.setDocTypeName(docTypeMap.get(vo.getDocType()));
            }
            if (!CollectionUtils.isEmpty(reasonMap) && reasonMap.containsKey(vo.getReasonCode())) {
                vo.setReasonCodeName(reasonMap.get(vo.getReasonCode()));
            }
            if (!CollectionUtils.isEmpty(uomMap) && uomMap.containsKey(vo.getUom())) {
                vo.setUomName(uomMap.get(vo.getUom()));
            }
            if (!CollectionUtils.isEmpty(pTypeMap) && pTypeMap.containsKey(vo.getPType())) {
                vo.setPTypeName(pTypeMap.get(vo.getPType()));
            }
            //暂时注释，这里pur外部接口没有提供
            // 合作伙伴名称转换
            if(vo.getPCode() != null && UdcEnum.INV_PARTNER_TYPE_SUPP.getValueCode().equals(vo.getPType())){
                suppList.stream().filter(s -> s.getCode().equals(vo.getPCode())).findAny()
                        .ifPresent(o -> vo.setPName(o.getName()));
            }
            if(vo.getPCode() != null && UdcEnum.INV_PARTNER_TYPE_EMP.getValueCode().equals(vo.getPType())){
                empList.stream().filter(s -> s.getCode().equals(vo.getPCode())).findAny()
                        .ifPresent(o -> vo.setPName(o.getName()));
            }
        });
    }

}
