package com.elitesland.yst.production.inv.application.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.*;
import com.elitesland.yst.production.inv.domain.service.InvWhAreaDomainService;
import com.elitesland.yst.production.inv.utils.BeanCopyUtil;
import com.elitesland.yst.production.inv.application.facade.vo.InvParentParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.base.InvBaseModel;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.*;
import com.elitesland.yst.production.inv.application.facade.vo.lot.InvLotRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.whAreaSetting.InvWhAreaSettingRespVO;
import com.elitesland.yst.production.inv.application.out.ItmOutService;
import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.application.out.SystemService;
import com.elitesland.yst.production.inv.application.service.InvStkService;
import com.elitesland.yst.production.inv.application.service.InvWhAreaService;
import com.elitesland.yst.production.inv.application.service.InvWhAreaSettingService;
import com.elitesland.yst.production.inv.application.service.InvWhService;
import com.elitesland.yst.production.inv.domain.convert.invstk.InvStkConvert;
import com.elitesland.yst.production.inv.domain.entity.invstk.InvStkDO;
import com.elitesland.yst.production.inv.domain.entity.invstk.QInvStkDO;
import com.elitesland.yst.production.inv.domain.service.InvStkDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhDomainService;
import com.elitesland.yst.production.inv.infr.dto.InvStkCommonOperateBodyDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkDTO;
import com.elitesland.yst.production.inv.infr.dto.InvStkGroupDTO;
import com.elitesland.yst.production.inv.infr.dto.ItmItemDTO;
import com.elitesland.yst.production.inv.infr.repo.InvStkRepo;
import com.elitesland.yst.production.inv.infr.repo.InvStkRepoProc;
import com.elitesland.yst.production.inv.utils.InvPTypeEnum;
import com.elitesland.yst.production.inv.utils.InvUdcEnum;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitesland.yst.production.inv.utils.ValidationUtil;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.system.vo.SysUserVO;
import com.elitesland.yst.production.support.provider.item.dto.ItmItemRpcDTO;
import com.elitesland.yst.production.support.provider.item.param.ItmItemRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.dto.OrgEmpRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.yst.production.support.provider.org.param.OrgEmpRpcDtoParam;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.apache.commons.collections4.MapUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author ssy
 * @since 2020-08-04 10:58:07
 */
@Service
@Slf4j
@AllArgsConstructor
public class InvStkServiceImpl implements InvStkService {

    private final InvStkRepo invStkRepo;
    private final InvStkRepoProc invStkRepoProc;
    private final InvWhService invWhService;
    private final InvWhAreaDomainService invWhAreaDomainService;
    private final SystemService systemService;
    private final ItmOutService itmOutService;
    private final OrgOutService outouService;
    private final InvWhDomainService invWhDomainService;
    private final InvStkDomainService invStkDomainService;


    @Override
    public InvStkGroupRespVO getInvStkGroupByParam(InvBaseModel queryParam) {
        InvStkGroupRespVO results = null;
        //校验必填参数
        this.paramCheckIn(queryParam);
        //校验批次
        if (queryParam.getLotNo() != null && !queryParam.getLotNo().equals("")) {
            List<InvStkDTO> fetch = invStkRepoProc.select(null)
                    .where(getPredicate(QInvStkDO.invStkDO, queryParam)).fetch();
            if (!ObjectUtils.isEmpty(fetch) && fetch.size() > 0) {
                results = InvStkConvert.INSTANCE.stkDTOToGroupRespVO(fetch.get(0));
                return results;
            }
        } else {
            //查询功能区、仓库、商品分组后的数量
            //  List<InvStkGroupRespVO> fetch = invStkRepoProc.selectInvStkGroupByParam(null).where(getPredicate(QInvStkDO.invStkDO, queryParam)).fetch();
            List<InvStkGroupRespVO> fetch = this.selectInvStkGroupByInvBaseModel(queryParam);
            if (!ObjectUtils.isEmpty(fetch) && fetch.size() > 0) {
                results = fetch.get(0);
            }
        }
        return results;
    }

    @Override
    @SysCodeProc
    public List<InvStkGroupRespVO> selectInvStkGroupByInvBaseModel(InvBaseModel param) {
        List<InvStkGroupDTO> invStkGroupDTOList = invStkDomainService.selectInvStkGroupByInvBaseModel(param);
        if (CollectionUtils.isEmpty(invStkGroupDTOList)) {
            return Collections.EMPTY_LIST;
        }
        List<InvStkGroupRespVO> invStkGroupRespVOList = StreamSupport.stream(invStkGroupDTOList.spliterator(), false)
                .map(InvStkConvert.INSTANCE::groupDtoToRespVo).collect(Collectors.toList());
        return invStkGroupRespVOList;
    }

    /**
     * 批量查询仓库
     *
     * @param param
     * @return
     */
    @Override
    public List<InvStkGroupBatchRespVO> getInvStkGroupBatchByParam(InvStkGroupBatchParamVO param) {
        List<InvBaseModel> invStkQueryParamList = param.getInvStkQueryParamList();
        if (!CollectionUtils.isEmpty(invStkQueryParamList)) {
            ArrayList<InvStkGroupBatchRespVO> arrayList = new ArrayList<>();
            invStkQueryParamList.forEach(i -> {
                this.paramCheckIn(i);
                //查询功能区、仓库、商品分组后的数量
                List<InvStkGroupBatchRespVO> vos = invStkRepoProc.selectInvStkGroupBatchByParam(i);
                if (!ObjectUtils.isEmpty(vos) && vos.size() > 0) {
                    arrayList.add(vos.get(0));
                }
            });
            return arrayList;
        } else {
            throw new BusinessException(ApiCode.FAIL, "参数为空请检查！");
        }

    }


    @Override
    @SysCodeProc
    public PagingVO<InvStkRespVO> search(InvStkQueryParamVO param) {
        PagingVO pagingVO = invStkRepoProc.useSelect(param);
        //UDC转换
        List records = pagingVO.getRecords();
        udcChange(null, records);
        return pagingVO;
    }

    @Override
    public PagingVO<InvStkDRespVO> searchLot(InvStkDQueryParamVO param) {
        if (!CollectionUtils.isEmpty(param.getBrands())) {
            //商品数据查询
            ItmItemRpcDtoParam itmItemPartParam = new ItmItemRpcDtoParam();
            itmItemPartParam.setBrands(param.getBrands());
            itmItemPartParam.setItemIds(param.getItemIds());
            List<Long> brandItemIds = itmOutService.findItemRpcDtoByParam(itmItemPartParam).stream().map(ItmItemRpcDTO::getId).collect(Collectors.toList());
            //1.brandItemIds长度为0说明没有数据,所以直接返回空 ; 2.长度不为0说明有数据,放入param进行查询
            if (brandItemIds.size() > 0) {
                param.setItemIds(brandItemIds);
            } else {
                return PagingVO.<InvStkDRespVO>builder()
                        .total(0L)
                        .records(new ArrayList<>())
                        .build();
            }
        }

        PagingVO pagingVO = invStkRepoProc.selectLot(param);
        List<InvStkDRespVO> invStkDResults = (List<InvStkDRespVO>) pagingVO.getRecords();
        if (org.springframework.util.CollectionUtils.isEmpty(invStkDResults)) {
            return PagingVO.<InvStkDRespVO>builder().total(0L).records(Collections.EMPTY_LIST).build();
        }

        // 应对前端参数为空情况
        results(invStkDResults);
        //udc转换
        udcChange(invStkDResults, null);
        return PagingVO.<InvStkDRespVO>builder()
                .total(pagingVO.getTotal())
                .records(invStkDResults)
                .build();
    }

    @Override
    @SysCodeProc
    public PagingVO<ItmInvStkItemRespVO> searchInvStkItem(InvStkItemQueryParam queryParam) {
        if (queryParam.getSuppCode() != null || Boolean.TRUE.equals(queryParam.getLotFlag())) {
            ItmItemRpcDtoParam param = new ItmItemRpcDtoParam();
            ArrayList<String> suppCodes = new ArrayList<>();
            suppCodes.add(queryParam.getSuppCode());
            param.setSuppCodes(suppCodes);
            List<ItmItemRpcDTO> itemRpcDtoByParam = itmOutService.findItemRpcDtoByParam(param);
            if (CollectionUtils.isEmpty(itemRpcDtoByParam)) {
                return PagingVO.<ItmInvStkItemRespVO>builder()
                        .total(0L)
                        .records(new ArrayList<>())
                        .build();
            } else {
                List<Long> itemIds = itemRpcDtoByParam.stream().map(ItmItemRpcDTO::getId).distinct().collect(Collectors.toList());
                queryParam.setItemIds(itemIds);
            }
        }
        List<ItmInvStkItemRespVO> stkItemRespVOS = invStkRepoProc.selectInvStkItem(queryParam);
        ArrayList<ItmInvStkItemRespVO> invStkItemRespVOS = stkItemRespVOS.stream()
                .filter(stkItemRespVO -> stkItemRespVO.getAvalQty().compareTo(BigDecimal.ZERO) > 0)
                .collect(Collectors.collectingAndThen(Collectors.toCollection(() ->
                        new TreeSet<>(Comparator.comparing(f -> f.getItemCode() + f.getId()))), ArrayList::new));
        translateInvStkItem(stkItemRespVOS);
        return PagingVO.<ItmInvStkItemRespVO>builder()
                .total(Long.valueOf(invStkItemRespVOS.size()))
                .records(invStkItemRespVOS)
                .build();

    }

    @Override
    public List<ItmInvStkItemRespVO> getInvStkItemByParam(InvStkItemQueryParam queryParam) {
        List<ItmInvStkItemRespVO> stkItemRespVOS = invStkRepoProc.selectInvStkItem(queryParam);
        ArrayList<ItmInvStkItemRespVO> invStkItemRespVOS = stkItemRespVOS.stream()
                .collect(Collectors.collectingAndThen(Collectors.toCollection(() ->
                        new TreeSet<>(Comparator.comparing(f -> f.getItemCode() + f.getId()))), ArrayList::new));
        translateInvStkItem(invStkItemRespVOS );
        return invStkItemRespVOS;
    }

    @Override
    public List<ItmInvStkItemRespVO> selectInvStkItemByDesIds(List<Long> desIds) {
        if(CollectionUtils.isEmpty(desIds)){
            return new ArrayList<>();
        }
        return invStkRepoProc.selectInvStkItemByDesIds(desIds);
    }

    /**
     * UDC转换
     *
     * @param invStkDRespVOS
     * @param invStkRespVOS
     */
    public void udcChange(List<InvStkDRespVO> invStkDRespVOS, List<InvStkRespVO> invStkRespVOS) {
        //进行UDC转换(udcEnum只使用model，code)
        Map<String, String> udcItemType = systemService.sysUdcGetCodeMap(UdcEnum.ITM_ITEM_TYPE1_ITM_CENTER.getModel(), UdcEnum.ITM_ITEM_TYPE1_ITM_CENTER.getCode()); //商品类型
        Map<String, String> udcQcStatus = systemService.sysUdcGetCodeMap(UdcEnum.INV_LOT_QC_STATUS_LOCK.getModel(), UdcEnum.INV_LOT_QC_STATUS_LOCK.getCode());//批次质量状态
        Map<String, String> udcFressType = systemService.sysUdcGetCodeMap(UdcEnum.COM_FRESS_TYPE_1.getModel(), UdcEnum.COM_FRESS_TYPE_1.getCode());//新鲜度类型
        Map<String, String> udcDeter1 = systemService.sysUdcGetCodeMap(UdcEnum.INV_TEMP_TYPE_RT.getModel(), UdcEnum.INV_TEMP_TYPE_RT.getCode());//温层
        Map<String, String> udcUom = systemService.sysUdcGetCodeMap(UdcEnum.COM_UOM_BG.getModel(), UdcEnum.COM_UOM_BG.getCode());//单位
        Map<String, String> udcWhtype = systemService.sysUdcGetCodeMap(InvUdcEnum.INV_WH_TYPE1_1.getModel(), InvUdcEnum.INV_WH_TYPE1_1.getCode());//仓库类型
        Map<String, String> udcItmeStatus = systemService.sysUdcGetCodeMap(UdcEnum.ITM_ITEM_STATUS_INVALID.getModel(), UdcEnum.ITM_ITEM_STATUS_INVALID.getCode());//商品状态
        if (!CollectionUtils.isEmpty(invStkDRespVOS)) {
            invStkDRespVOS.stream().forEach(Stk -> {
                if (org.apache.commons.lang3.StringUtils.isNotBlank(Stk.getItemType()) && !MapUtils.isEmpty(udcItemType)) {
                    Stk.setItemTypeName(udcItemType.get(Stk.getItemType()));
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank(Stk.getQcStatus()) && !MapUtils.isEmpty(udcQcStatus)) {
                    Stk.setQcStatusName(udcQcStatus.get(Stk.getQcStatus()));
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank(Stk.getFressType()) && !MapUtils.isEmpty(udcFressType)) {
                    Stk.setFressTypeName(udcFressType.get(Stk.getFressType()));
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank(Stk.getDeter1()) && !MapUtils.isEmpty(udcDeter1)) {
                    Stk.setDeter1Name(udcDeter1.get(Stk.getDeter1()));
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank(Stk.getUom()) && !MapUtils.isEmpty(udcUom)) {
                    Stk.setUomName(udcUom.get(Stk.getUom()));
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank(Stk.getWhType()) && !MapUtils.isEmpty(udcWhtype)) {
                    Stk.setWhTypeName(udcWhtype.get(Stk.getWhType()));
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank(Stk.getItemStatus()) && !MapUtils.isEmpty(udcItmeStatus)) {
                    Stk.setItemStatusName(udcItmeStatus.get(Stk.getItemStatus()));
                }
            });
        }

    }

    /**
     * UDC转换
     *
     * @param invStkGroupResults
     */
    public void udcGroupChange(List<InvStkGroupRespVO> invStkGroupResults) {
        //进行UDC转换(udcEnum只使用model，code)
        Map<String, String> udcUom = systemService.sysUdcGetCodeMap(UdcEnum.COM_UOM_BG.getModel(), UdcEnum.COM_UOM_BG.getCode());//单位
        Map<String, String> udcWhtype = systemService.sysUdcGetCodeMap(InvUdcEnum.INV_WH_TYPE1_1.getModel(), InvUdcEnum.INV_WH_TYPE1_1.getCode());//仓库类型
        //  Map<String, String> udcItmeStatus = systemService.sysUdcGetCodeMap(UdcEnum.ITM_ITEM_STATUS_INVALID.getModel(), UdcEnum.ITM_ITEM_STATUS_INVALID.getCode());//商品状态
        if (!CollectionUtils.isEmpty(invStkGroupResults)) {
            invStkGroupResults.stream().forEach(Stk -> {
                if (org.apache.commons.lang3.StringUtils.isNotBlank(Stk.getUom()) && !MapUtils.isEmpty(udcUom)) {
                    Stk.setUomName(udcUom.get(Stk.getUom()));
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank(Stk.getWhType()) && !MapUtils.isEmpty(udcWhtype)) {
                    Stk.setWhTypeName(udcWhtype.get(Stk.getWhType()));
                }

            });
        }

    }

    @Override
    @SysCodeProc
    public List<InvStkGroupRespVO> selectInvStkGroupByParam(InvStkQueryGroupParamVO param) {
        List<InvStkGroupDTO> invStkGroupDTOList = invStkDomainService.selectInvStkGroupByParam(param);
        if (CollectionUtils.isEmpty(invStkGroupDTOList)) {
            return Collections.EMPTY_LIST;
        }
        List<InvStkGroupRespVO> invStkGroupRespVOList = StreamSupport.stream(invStkGroupDTOList.spliterator(), false)
                .map(InvStkConvert.INSTANCE::groupDtoToRespVo).collect(Collectors.toList());
        return invStkGroupRespVOList;
    }

    @Override
    @SysCodeProc
    public PagingVO<InvStkGroupRespVO> searchD(InvStkQueryGroupParamVO param) {
        if (!CollectionUtils.isEmpty(param.getBrands()) || !StringUtils.isEmpty(param.getItemType())
                || !StringUtils.isEmpty(param.getItemType2())) {
            //商品数据查询
            ItmItemRpcDtoParam itmItemPartParam = new ItmItemRpcDtoParam();
            itmItemPartParam.setBrands(param.getBrands());
            itmItemPartParam.setItemType(param.getItemType());
            itmItemPartParam.setItemType2(param.getItemType2());
            List<Long> brandItemIds = itmOutService.findItemIdByParam(itmItemPartParam).stream().collect(Collectors.toList());
            //1.brandItemIds长度为0说明没有数据,所以直接返回空 ; 2.长度不为0说明有数据,放入param进行查询
            if (brandItemIds.size() > 0) {
                param.setItemIds(brandItemIds);
            } else {
                return PagingVO.<InvStkGroupRespVO>builder()
                        .total(0L)
                        .records(new ArrayList<>())
                        .build();
            }
        }
        //仓库类型入参查询
        val pagingVo = invStkDomainService.invStkGroupSearch(param);
        if (CollectionUtils.isEmpty(pagingVo.getRecords())) {
            return PagingVO.<InvStkGroupDTO>builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        val vos = pagingVo.getRecords();
        List<InvStkGroupRespVO> pageResults = vos.stream().map(InvStkConvert.INSTANCE::groupDtoToRespVo).collect(Collectors.toList());
        // 应对前端参数为空情况
        stkGroupResults(pageResults);
        //UDC转换
        udcGroupChange(pageResults);
        return PagingVO.<InvStkGroupRespVO>builder()
                .total(pagingVo.getTotal())
                .records(pageResults)
                .build();
    }

    /**
     * 全量库存分页查询
     *
     * @param param 分类查询、分页和排序对象
     * @return 库存多条数据
     */
    @Override
    @SysCodeProc
    public PagingVO<InvStkGroupRespVO> fullSearch(InvStkQueryGroupParamVO param) {
        if (!CollectionUtils.isEmpty(param.getBrands()) || !StringUtils.isEmpty(param.getItemType())
                || !StringUtils.isEmpty(param.getItemType2())) {
            //商品数据查询
            ItmItemRpcDtoParam itmItemPartParam = new ItmItemRpcDtoParam();
            itmItemPartParam.setBrands(param.getBrands());
            itmItemPartParam.setItemType(param.getItemType());
            itmItemPartParam.setItemType2(param.getItemType2());
            List<Long> brandItemIds = itmOutService.findItemIdByParam(itmItemPartParam).stream().collect(Collectors.toList());
            //1.brandItemIds长度为0说明没有数据,所以直接返回空 ; 2.长度不为0说明有数据,放入param进行查询
            if (brandItemIds.size() > 0) {
                param.setItemIds(brandItemIds);
            } else {
                return PagingVO.<InvStkGroupRespVO>builder().total(0L).records(new ArrayList<>()).build();
            }
        }

        //仓库类型入参查询
        if (!StringUtils.isEmpty(param.getWhType())) {
            InvWhParamVO invWhParamVO = new InvWhParamVO();
            invWhParamVO.setWhType(param.getWhType());
            invWhParamVO.setWhIds(param.getWhIds());
            invWhParamVO.setOuIds(param.getOuIds());
            List<InvWhRespVO> invWhRespVOS = invWhService.searchWhBaseByParam(invWhParamVO);
            if (!CollectionUtils.isEmpty(invWhRespVOS)) {
                List<Long> collect = invWhRespVOS.stream().map(InvWhRespVO::getId).distinct().collect(Collectors.toList());
                if (collect.size() > 0) {
                    param.setWhIds(collect);
                } else {
                    return PagingVO.<InvStkGroupRespVO>builder().total(0L).records(new ArrayList<>()).build();
                }
            } else {
                return PagingVO.<InvStkGroupRespVO>builder().total(0L).records(new ArrayList<>()).build();
            }

        }
        val pagingVo = invStkDomainService.fullSearch(param);
        val vos = pagingVo.getRecords();
        List<InvStkGroupRespVO> invStkFullRespVOList = vos.stream().map(
                InvStkConvert.INSTANCE::fullDtoToGroupRespVo).collect(Collectors.toList());

        // 应对前端参数为空情况
        stkGroupResults(invStkFullRespVOList);
        //UDC转换
        udcGroupChange(invStkFullRespVOList);
        return PagingVO.<InvStkGroupRespVO>builder()
                .total(pagingVo.getTotal())
                .records(invStkFullRespVOList)
                .build();

    }

    /**
     * searchD方法中应对前端参数为空情况
     *
     * @param invStkDResults
     */
    public void results(List<InvStkDRespVO> invStkDResults) {
        List<String> deter2List = invStkDResults.stream().map(InvStkDRespVO::getDeter2).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<Long> whIds = invStkDResults.stream().map(InvStkDRespVO::getWhId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<InvWhAreaRespVO> invWhAreaRespVOS = new ArrayList<>();
        if(!CollectionUtils.isEmpty(deter2List) && !CollectionUtils.isEmpty(whIds)){
            InvWhAreaParamVO paramVO = new InvWhAreaParamVO();
            paramVO.setWhIds(whIds);
            paramVO.setDeter2s(deter2List);
            invWhAreaRespVOS = invWhAreaDomainService.findWhAreasByParam(paramVO);
        }
        //调用接口查询库存合作伙伴等字段
        List<InvWhAreaRespVO> finalInvWhAreaRespVOS = invWhAreaRespVOS;
        invStkDResults.stream().forEach(v -> {
            if (!CollectionUtils.isEmpty(finalInvWhAreaRespVOS)) {
                finalInvWhAreaRespVOS.stream().filter(a -> Objects.equals(a.getDeter2(), v.getDeter2()) &&
                        Objects.equals(a.getWhId(),v.getWhId()))
                        .findAny().ifPresent(m -> {
                    v.setDeter2Name(m.getDeter2Name());
                });
            }
            if (!StringUtils.isEmpty(v.getPType())) {
                InvParentParamVO orgQueryParamVO = new InvParentParamVO();
                orgQueryParamVO.setType(v.getPType());
                orgQueryParamVO.setCode(v.getPCode());
                List<OrgRespVO> vos = outouService.findcodeAndName(orgQueryParamVO);
                if (!CollectionUtils.isEmpty(vos)) {
                    vos.stream().filter(m -> Objects.equals(m.getCode(), v.getPCode())).findFirst().ifPresent(n -> {
                        v.setPName(n.getName());
                        v.setPName(v.getPName());
                    });
                }
            }

        });
        List<Long> userIds = invStkDResults.stream().map(InvStkDRespVO::getCreateUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
//        List<SysUserVO> empsByIdIn = outService.findAllEmpsByIdIn(userIds);
        ItmItemRpcDtoParam itmItemPartParam = new ItmItemRpcDtoParam();

        itmItemPartParam.setItemIds(invStkDResults.stream().map(InvStkDRespVO::getItemId).filter(Objects::nonNull).distinct().collect(Collectors.toList()));
        val itmItemResults = itmOutService.findItemRpcDtoByParam(itmItemPartParam);
        val invWhRespVOS = invWhDomainService.findIdBatch(invStkDResults.stream().map(InvStkDRespVO::getWhId).collect(Collectors.toList()));
        val orgOuResults = outouService.findOuByIds(invStkDResults.stream().map(InvStkDRespVO::getOuId).collect(Collectors.toList()));
        //获取库存合作伙伴UDC
        Map<String, String> pTypeMap = systemService.sysUdcGetCodeMap(UdcEnum.INV_PARTNER_TYPE_EMP.getModel(), UdcEnum.INV_PARTNER_TYPE_EMP.getCode());

        //获取Pcode
        List<String> PCodeList = invStkDResults.stream().filter(v -> !StringUtils.isEmpty(v.getPCode())).map(InvStkDRespVO::getPCode).collect(Collectors.toList());
        OrgEmpRpcDtoParam orgEmpRpcDtoParam = new OrgEmpRpcDtoParam();
        orgEmpRpcDtoParam.setEmpCodes(PCodeList);
        List<OrgEmpRpcDTO> dtoByParam = outouService.findEmpDtoByParam(orgEmpRpcDtoParam);

        //填入数据
        invStkDResults.stream().forEach(i -> {

            //设置库存合作伙伴类型
            if (!CollectionUtils.isEmpty(dtoByParam)) {
                Optional<OrgEmpRpcDTO> empRpcDTO = dtoByParam.stream().filter(v2 -> Objects.equals(v2.getEmpCode(), i.getPCode())).findFirst();
                if (empRpcDTO.isPresent()) {
                    i.setPName(empRpcDTO.get().getEmpName());
                    if (MapUtils.isNotEmpty(pTypeMap)) {
                        i.setPTypeName(pTypeMap.get(i.getPType()));
                    }
                }
            }

            invWhRespVOS.stream().filter(v -> Objects.equals(v.getId(), i.getWhId()))
                    .findAny().ifPresent(m -> {
                i.setWhName(m.getWhName());
                i.setWhCode(m.getWhCode());
                i.setWhType(m.getWhType());
            });
            itmItemResults.stream().filter(v -> Objects.equals(v.getId(), i.getItemId()))
                    .findAny().ifPresent(m -> {
                i.setItemCode(m.getItemCode());
                i.setItemName(m.getItemName());
                i.setBrand(m.getBrand());
                i.setPackageSpec(m.getPackageSpec());
                i.setItemType(m.getItemType());
                i.setBrandName(m.getBrandName());
                i.setVolume(m.getVolume() == null ? null : m.getVolume().doubleValue());
                i.setGrossWeight(m.getGrossWeight() == null ? null : m.getGrossWeight().doubleValue());
                i.setNetWeight(m.getNetWeight() == null ? null : m.getNetWeight().doubleValue());
                //E1商品编码
                i.setItemOuterCode(m.getOuterCode());
                i.setBarCode(m.getBarCode());
                i.setItemStatus(m.getItemStatus());
                i.setSuppName(m.getSuppName());
                i.setBrandName(m.getBrandName());

            });

            orgOuResults.stream().filter(o -> Objects.equals(o.getId(), i.getOuId()))
                    .findAny().ifPresent(m -> {
                i.setOuCode(m.getOuCode());
                i.setOuName(m.getOuName());
            });
            /*invItmPkgResults.stream().filter(v -> v.getItemId().equals(i.getItemId()) && v.getPkgType().equals(SMALL))
                    .findAny().ifPresent(m -> {
                i.setPkgGrossWeight(m.getGrossWeight());
                i.setPkgHeight(m.getDimHeight());
                i.setPkgLength(m.getDimLen());
                i.setPkgWidth(m.getDimWeight());
                if (i.getOhQty() != null && m.getGrossWeight() != null) {
                    i.setStkWeight(i.getOhQty().doubleValue() * m.getGrossWeight());
                }
                if (i.getOhQty() != null && m.getVolume() != null) {
                    i.setStkVolume(i.getOhQty().doubleValue() * m.getVolume());
                }
            });*/
        });
    }

    /**
     * searchGroup方法中应对前端参数为空情况
     *
     * @param invStkGroupResults
     */
    public void stkGroupResults(List<InvStkGroupRespVO> invStkGroupResults) {
        List<String> deter2s = invStkGroupResults.stream().map(InvStkGroupRespVO::getDeter2).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<Long> itemIds = invStkGroupResults.stream().map(InvStkGroupRespVO::getItemId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        ItmItemRpcDtoParam itmItemPartParam = new ItmItemRpcDtoParam();
        itmItemPartParam.setItemIds(itemIds);
        val itmItemResults = itmOutService.findItemRpcDtoByParam(itmItemPartParam);
        List<Long> userIds = invStkGroupResults.stream().map(InvStkGroupRespVO::getCreateUserId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<SysUserVO> empsByIdIn = systemService.findAllEmpsByIdIn(userIds);
        List<Long> ouIds = invStkGroupResults.stream().map(InvStkGroupRespVO::getOuId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        val orgOuResults = outouService.findOuByIds(ouIds);
        Map<String, String> itmMap = systemService.sysUdcGetCodeMap(UdcEnum.ITM_ITEM_TYPE1_ITM_CENTER.getModel(), UdcEnum.ITM_ITEM_TYPE1_ITM_CENTER.getCode());
        Map<String, String> itm2Map = systemService.sysUdcGetCodeMap(UdcEnum.ITM_ITEM_TYPE2_10.getModel(), UdcEnum.ITM_ITEM_TYPE2_10.getCode());
        invStkGroupResults.stream().forEach(i -> {
            if (!CollectionUtils.isEmpty(empsByIdIn)) {
                empsByIdIn.stream().filter(e -> e.getId().equals(i.getCreateUserId())).findAny().ifPresent(v -> {
                    i.setCreator(v.getUsername());
                });
            }
            itmItemResults.stream().filter(v -> v.getId().equals(i.getItemId()))
                    .findAny().ifPresent(m -> {
                i.setItemCode(m.getItemCode());
                i.setItemName(m.getItemName());
                i.setBrand(m.getBrand());
                i.setPackageSpec(m.getPackageSpec());
                i.setSpec(m.getSpec());
                i.setItemType(m.getItemType());
                i.setItemType2(m.getItemType2());
                i.setBrandName(m.getBrandName());
                i.setBarCode(m.getBarCode());
                i.setSuppCode(m.getSuppCode());
                i.setSuppName(m.getSuppName());
                i.setItemCatePathName(m.getItemCatePathName());
                if (!StringUtils.isEmpty(m.getGuaranteeDays())) {
                    i.setExpireDays(m.getGuaranteeDays());
                }

            });
            if (!StringUtils.isEmpty(i.getItemType()) && !MapUtils.isEmpty(itmMap)) {
                i.setItemTypeName(itmMap.get(i.getItemType()));
            }
            if (!StringUtils.isEmpty(i.getItemType2()) && !MapUtils.isEmpty(itm2Map)) {
                i.setItemType2Name(itm2Map.get(i.getItemType2()));
            }

            orgOuResults.stream().filter(o -> o.getId().equals(i.getOuId()))
                    .findAny().ifPresent(m -> {
                i.setOuCode(m.getOuCode());
                i.setOuName(m.getOuName());
            });
            if (!StringUtils.isEmpty(i.getPCode()) && !StringUtils.isEmpty(i.getPType())) {
                InvParentParamVO paramVO = new InvParentParamVO();
                paramVO.setCode(i.getPCode());
                paramVO.setType(i.getPType());
                List<OrgRespVO> vos = outouService.findcodeAndName(paramVO);
                if (!CollectionUtils.isEmpty(vos)) {
                    i.setPName(vos.get(0).getName());
                }
            }
        });
    }


    @Override
    @SysCodeProc
    public Optional<InvStkRespVO> findIdOne(Long id) {
        return invStkDomainService.getInvStkById(id).map(DO -> BeanUtil.copyProperties(DO, InvStkRespVO.class));
    }

    @Override
    @Transactional
    public void update(InvStkUpdateSaveVO objDo) {
        Optional<InvStkDO> optional = invStkDomainService.getInvStkById(objDo.getId());
        if (optional.isPresent()) {
            BeanCopyUtil.beanCopyWithIngore(objDo, optional.get(), BeanCopyUtil.getNullPropertyNames(objDo));
            invStkDomainService.saveInvStk(optional.get());
        } else {
            throw new BusinessException(ApiCode.FAIL, "修改失败，数据不存在" + objDo.getId());
        }
    }

    @Override
    @Transactional
    public Long createOne(InvStkDO invStkDO) {
        return invStkRepo.save(invStkDO).getId();
    }

    @Override
    @Transactional(propagation = Propagation.REQUIRES_NEW, rollbackFor = Exception.class)
    public Long createInvStk(InvStkDO invStkDO) {
        return invStkRepo.save(invStkDO).getId();
    }

    @Override
    @Transactional
    public int updateStkQty(InvStkDO invStkDO) {
        log.info("修改库存sql 开始，参数：{}", invStkDO);
        return invStkRepo.updateStkQty(invStkDO);
    }


    @Override
    @Transactional
    public void deleteBatch(List<Long> list) {
        list.forEach(id -> invStkRepo.deleteById(id));
    }


    @Override
    public InvStkRespVO getInvStk(InvBaseModel queryParam) {
        paramCheckIn(queryParam);
        InvStkDTO invStkDTO = invStkDomainService.getInvStk(queryParam);
        if (invStkDTO != null) {
            InvStkRespVO invStkRespVO = InvStkConvert.INSTANCE.dtoToRespVo(invStkDTO);
            return invStkRespVO;
        }
        return null;
    }

    @Override
    public InvStkDO getInvStkDo(InvBaseModel queryParam) {
        paramCheckIn(queryParam);
        List<InvStkDO> fetch = invStkRepoProc.selectDO(null).where(getPredicate(QInvStkDO.invStkDO, queryParam)).fetch();
        if (!ObjectUtils.isEmpty(fetch) && fetch.size() > 0) {
            return fetch.get(0);
        }
        return null;
    }

    private void translateInvShareStk(List<ItmInvStkShareRespVO> stkShareRespVOS) {
        if (!CollectionUtils.isEmpty(stkShareRespVOS)) {
            List<Long> whIds = stkShareRespVOS.stream().filter(Objects::nonNull)
                    .map(ItmInvStkShareRespVO::getWhId)
                    .distinct().collect(Collectors.toList());
            List<Long> ouIds = stkShareRespVOS.stream().filter(Objects::nonNull)
                    .map(ItmInvStkShareRespVO::getOuId)
                    .distinct().collect(Collectors.toList());
            List<OrgOuRpcDTO> ouRpcDTOS = outouService.findOuByIds(ouIds);
            List<InvWhRespVO> whRespVOS = invWhDomainService.findIdBatch(whIds);
            Map<String, String> udcUom = systemService.sysUdcGetCodeMap(UdcEnum.COM_UOM_BG.getModel(), UdcEnum.COM_UOM_BG.getCode());//单位
            Map<String, String> shareTypeMap = systemService.sysUdcGetCodeMap(UdcEnum.INV_PLN_SHARE_TYPE_D.getModel(), UdcEnum.INV_PLN_SHARE_TYPE_D.getCode());
            Map<String, String> itmMap = systemService.sysUdcGetCodeMap(UdcEnum.ITM_ITEM_TYPE1_ITM_CENTER.getModel(), UdcEnum.ITM_ITEM_TYPE1_ITM_CENTER.getCode());
            Map<String, String> whTypeMap = systemService.sysUdcGetCodeMap(UdcEnum.INV_WH_TYPE_1.getModel(), UdcEnum.INV_WH_TYPE_1.getCode());
            List<Long> itemIds = stkShareRespVOS.stream().map(ItmInvStkShareRespVO::getItemId).collect(Collectors.toList());
            List<String> pSuppCodes = stkShareRespVOS.stream().filter(i -> UdcEnum.INV_PARTNER_TYPE_SUPP.getValueCode().equals(i.getPType()))
                    .map(ItmInvStkShareRespVO::getPCode).distinct().collect(Collectors.toList());
            List<String> pEmpCodes = stkShareRespVOS.stream().filter(i -> UdcEnum.INV_PARTNER_TYPE_EMP.getValueCode().equals(i.getPType()))
                    .map(ItmInvStkShareRespVO::getPCode).distinct().collect(Collectors.toList());

            List<OrgRespVO> suppList = outouService.findcodeAndNameList(InvPTypeEnum.INV_PARTNER_TYPE_SUPP, pSuppCodes);
            List<OrgRespVO> empList = outouService.findcodeAndNameList(InvPTypeEnum.INV_PARTNER_TYPE_EMP, pEmpCodes);
            ItmItemRpcDtoParam itemRpcDtoParam = new ItmItemRpcDtoParam();
            itemRpcDtoParam.setItemIds(itemIds);
            List<ItmItemRpcDTO> itmItemRpcDTOS = itmOutService.findItemRpcDtoByParam(itemRpcDtoParam);
            if (!CollectionUtils.isEmpty(itmItemRpcDTOS)) {
                stkShareRespVOS.stream().forEach(s -> {

                    // 合作伙伴名称转换
                    if (s.getPCode() != null && UdcEnum.INV_PARTNER_TYPE_SUPP.getValueCode().equals(s.getPType())) {
                        suppList.stream().filter(i -> i.getCode().equals(s.getPCode())).findAny()
                                .ifPresent(o -> s.setPName(o.getName()));
                    }
                    if (s.getPCode() != null && UdcEnum.INV_PARTNER_TYPE_EMP.getValueCode().equals(s.getPType())) {
                        empList.stream().filter(i -> i.getCode().equals(s.getPCode())).findAny()
                                .ifPresent(o -> s.setPName(o.getName()));
                    }

                    itmItemRpcDTOS.stream().filter(i -> i.getId().equals(s.getItemId())).findAny().ifPresent(v -> {
                        s.setTaxCode(v.getTaxCode());
                        s.setTaxRate(v.getTaxRate());
                        s.setItemName(v.getItemName());
                        s.setPackageSpec(v.getPackageSpec());
                        s.setBrand(v.getBrand());
                        s.setBrandName(v.getBrandName());
                    });

                    whRespVOS.stream().filter(v -> v.getId().equals(s.getWhId()))
                            .findAny().ifPresent(m -> {
                        s.setWhName(m.getWhName());
                        s.setWhCode(m.getWhCode());
                        s.setWhType(m.getWhType());
                    });

                    ouRpcDTOS.stream().filter(v -> v.getId().equals(s.getOuId()))
                            .findAny().ifPresent(m -> {
                        s.setOuCode(m.getOuCode());
                        s.setOuName(m.getOuName());
                    });
                    if (s.getShareType() != null && !MapUtils.isEmpty(shareTypeMap)) {
                        s.setShareTypeName(shareTypeMap.get(s.getShareType()));
                    }
                    if (s.getUom() != null && !MapUtils.isEmpty(udcUom)) {
                        s.setUomName(udcUom.get(s.getUom()));
                    }
                    if (s.getItemType() != null && !MapUtils.isEmpty(itmMap)) {
                        s.setItemTypeName(itmMap.get(s.getItemType()));
                    }
                    if (s.getWhType() != null && !MapUtils.isEmpty(whTypeMap)) {
                        s.setWhTypeName(whTypeMap.get(s.getWhType()));
                    }

                });
            }
        }
    }

    private void translateInvStkItem(List<ItmInvStkItemRespVO> stkItemRespVOS) {
        if(CollectionUtils.isEmpty(stkItemRespVOS)){
            return;
        }
        List<Long> itemIds = stkItemRespVOS.stream().filter(Objects::nonNull)
                .map(ItmInvStkItemRespVO::getId)
                .distinct().collect(Collectors.toList());
        List<Long> whIds = stkItemRespVOS.stream().filter(Objects::nonNull)
                .map(ItmInvStkItemRespVO::getWhId)
                .distinct().collect(Collectors.toList());
        List<String> deter2s = stkItemRespVOS.stream().filter(Objects::nonNull)
                .map(ItmInvStkItemRespVO::getDeter2)
                .distinct().collect(Collectors.toList());

        List<Long> ouIds = stkItemRespVOS.stream().filter(Objects::nonNull)
                .map(ItmInvStkItemRespVO::getOuId)
                .distinct().collect(Collectors.toList());
        List<InvWhAreaRespVO> invWhAreaRespVOS = new ArrayList<>();
        if(!CollectionUtils.isEmpty(whIds) && !CollectionUtils.isEmpty(deter2s)){
            InvWhAreaParamVO paramVO = new InvWhAreaParamVO();
            paramVO.setWhIds(whIds);
            paramVO.setDeter2s(deter2s);
            invWhAreaRespVOS = invWhAreaDomainService.findWhAreasByParam(paramVO);
        }
        List<InvWhRespVO> whRespVOS = invWhDomainService.findIdBatch(whIds);
        ItmItemRpcDtoParam itemRpcDtoParam = new ItmItemRpcDtoParam();
        itemRpcDtoParam.setItemIds(itemIds);
        List<ItmItemRpcDTO> itmItemRpcDTOS = itmOutService.findItemRpcDtoByParam(itemRpcDtoParam);
        List<OrgOuRpcDTO> ouRpcDTOS = outouService.findOuByIds(ouIds);
        Map<String, String> udcUom = systemService.sysUdcGetCodeMap(UdcEnum.COM_UOM_BG.getModel(), UdcEnum.COM_UOM_BG.getCode());//单位
        Map<String, String> itmMap = systemService.sysUdcGetCodeMap(UdcEnum.ITM_ITEM_TYPE1_ITM_CENTER.getModel(), UdcEnum.ITM_ITEM_TYPE1_ITM_CENTER.getCode());
        Map<String, String> allocTypeMap = systemService.sysUdcGetCodeMap(UdcEnum.ITM_ALLOC_TYPE_SUPP.getModel(), UdcEnum.ITM_ALLOC_TYPE_SUPP.getCode());

        List<InvWhAreaRespVO> finalInvWhAreaRespVOS = invWhAreaRespVOS;
        stkItemRespVOS.stream().forEach(i -> {
            i.setItemId(i.getId());
            whRespVOS.stream().filter(v -> v.getId().equals(i.getWhId()))
                    .findAny().ifPresent(m -> {
                i.setWhName(m.getWhName());
                i.setWhCode(m.getWhCode());
            });
            itmItemRpcDTOS.stream().filter(v -> v.getId().equals(i.getId()))
                    .findAny().ifPresent(m -> {
                i.setItemName(m.getItemName());
                i.setPackageSpec(m.getPackageSpec());
                i.setItemSpec(m.getSpec());
                i.setExpireDays(m.getGuaranteeDays());
                i.setBrand(m.getBrand());
                i.setBrandName(m.getBrandName());
                i.setItemType(m.getItemType());
                i.setLotFlag(m.getLotFlag());
                i.setAllocType(m.getAllocType());
            });
            ouRpcDTOS.stream().filter(v -> v.getId().equals(i.getOuId()))
                    .findAny().ifPresent(m -> {
                i.setOuCode(m.getOuCode());
                i.setOuName(m.getOuName());
            });
            if (CollectionUtils.isEmpty(finalInvWhAreaRespVOS)) {
                finalInvWhAreaRespVOS.stream().filter(d -> d.getDeter2().equals(i.getDeter2()) &&
                        d.getWhId().equals(i.getWhId())).findAny().ifPresent(m ->{
                    i.setDeter2Name(m.getDeter2Name());
                });
            }
            if (i.getUom() != null && !MapUtils.isEmpty(udcUom)) {
                i.setUomName(udcUom.get(i.getUom()));
            }
            if (i.getItemType() != null && !MapUtils.isEmpty(itmMap)) {
                i.setItemTypeName(itmMap.get(i.getItemType()));
            }
            if (i.getAllocType() != null && !MapUtils.isEmpty(allocTypeMap)) {
                i.setAllocTypeName(allocTypeMap.get(i.getAllocType()));
            }
        });


    }

    /**
     * 参数校验
     *
     * @param queryParam
     */
    public void paramCheckIn(InvBaseModel queryParam) {
        //校验必填参数
        ValidationUtil.ValidResult validResult = ValidationUtil.validate(queryParam);
        if (validResult.isError()) {
            throw new BusinessException("主数据参数错误，商品、仓库、功能区 不能为空");
        }
    }

    /**
     * 封装 查询条件
     *
     * @param jpaQDo
     * @param queryParam
     * @return
     */
    private Predicate getPredicate(QInvStkDO jpaQDo, InvBaseModel queryParam) {
        Predicate predicate1 = queryParam.getItemId() != null ? jpaQDo.itemId.eq(queryParam.getItemId()) : null;
        Predicate predicate2 = queryParam.getVariId() != null && queryParam.getVariId() != 0 ? jpaQDo.variId.eq(queryParam.getVariId()) : null;
        //批次号
        Predicate predicate3 = !StringUtils.isEmpty(queryParam.getLotNo()) ? jpaQDo.lotNo.eq(queryParam.getLotNo()) : null;
        Predicate predicate4 = queryParam.getWhId() != null ? jpaQDo.whId.eq(queryParam.getWhId()) : null;
        Predicate predicate5 = !StringUtils.isEmpty(queryParam.getDeter1()) ? jpaQDo.deter1.eq(queryParam.getDeter1()) : null;
        Predicate predicate6 = !StringUtils.isEmpty(queryParam.getDeter2()) ? jpaQDo.deter2.eq(queryParam.getDeter2()) : null;
        Predicate predicate7 = !StringUtils.isEmpty(queryParam.getUom()) ? jpaQDo.uom.eq(queryParam.getUom()) : null;
        Predicate predicate8 = !StringUtils.isEmpty(queryParam.getPType()) ? jpaQDo.pType.eq(queryParam.getPType()) : null;
        Predicate predicate9 = !StringUtils.isEmpty(queryParam.getPCode()) ? jpaQDo.pCode.eq(queryParam.getPCode()) : null;
        Predicate predicate10 = !StringUtils.isEmpty(queryParam.getLimit1()) ? jpaQDo.limit1.eq(queryParam.getLimit1()) : null;
        Predicate predicate11 = !StringUtils.isEmpty(queryParam.getLimit2()) ? jpaQDo.limit2.eq(queryParam.getLimit2()) : null;
        return ExpressionUtils.allOf(predicate1, predicate2, predicate3, predicate4, predicate5, predicate6, predicate7, predicate8, predicate9, predicate10, predicate11);
    }

    /**
     * 校验入参是否正确
     *
     * @param queryParam
     */
    private void checkInvBaseModelParam(InvBaseModel queryParam) {
        if (!(
                (!StringUtils.isEmpty(queryParam.getDeter1()) && !StringUtils.isEmpty(queryParam.getDeter2())
                        && StringUtils.isEmpty(queryParam.getDeter3())) ||
                        (StringUtils.isEmpty(queryParam.getDeter1()) && StringUtils.isEmpty(queryParam.getDeter2())
                                && !StringUtils.isEmpty(queryParam.getDeter3()))
        )) {
            throw new BusinessException(ApiCode.PARAMETER_EXCEPTION, "参数错误，[温层、功能库区]、客户号 三者不能同时存在或不存在");
        }
    }
}
