package com.elitesland.yst.production.inv.application.service.impl;


import cn.hutool.core.collection.CollectionUtil;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.InvDespatchConfigPageVO;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.InvDespatchConfigRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.InvDespatchConfigWhPageVO;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.param.InvDespatchConfigDtlQueryParam;
import com.elitesland.yst.production.inv.application.facade.vo.despatch.param.InvDespatchConfigQueryParam;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhAreaRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhRespVO;
import com.elitesland.yst.production.inv.application.facade.vo.invwh.InvWhSaveVO;
import com.elitesland.yst.production.inv.application.out.OrgOutService;
import com.elitesland.yst.production.inv.application.service.InvDespatchConfigService;
import com.elitesland.yst.production.inv.application.service.InvWhTreeService;
import com.elitesland.yst.production.inv.domain.convert.invwh.InvWhConvert;
import com.elitesland.yst.production.inv.domain.service.InvDespatchConfigDomainService;
import com.elitesland.yst.production.inv.domain.service.InvWhDomainService;
import com.elitesland.yst.production.inv.infr.repo.invwh.InvWhAreaRepoProc;
import com.elitesland.yst.production.inv.infr.repo.invwh.InvWhRepo;
import com.elitesland.yst.production.inv.infr.repo.invwh.InvWhRepoProc;
import com.elitesland.yst.production.inv.utils.InvStringUtil;
import com.elitesland.yst.production.inv.utils.TreeUtils;
import com.elitesland.yst.production.inv.utils.UdcEnum;
import com.elitesland.yst.production.support.provider.org.dto.OrgBuRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;


@Service("InvWhTreeService")
@AllArgsConstructor
public class InvWhTreeServiceImpl implements InvWhTreeService {


    private final InvDespatchConfigService invDespatchConfigService;
    private final InvDespatchConfigDomainService invDespatchConfigDomainService;
    private final InvWhRepoProc invWhRepoProc;
    private final InvWhRepo invWhRepo;
    private final InvWhDomainService invWhDomainService;
    private final InvWhAreaRepoProc invWhAreaRepoProc;
    private final OrgOutService orgOutService;

    @Override
    public List<InvWhRespVO> searchTree() {
        InvWhAreaParamVO invWhAreaParamVO = new InvWhAreaParamVO();
        //查询所有仓库
        List<InvWhRespVO> whRespVOS = invWhRepoProc.searchTree().fetch();
        for (InvWhRespVO invWhRespVO : whRespVOS) {

            //检验类型字符串转换为编码集合,以逗号分隔的字符串形式
            List<String> codeStrList = InvStringUtil.transitionStrToCodes(invWhRespVO.getDesCode());
            invWhRespVO.setDesCodeList(codeStrList);
        }
        //销售组织
        List<String> desCodeAllList = whRespVOS.stream().flatMap(vo -> vo.getDesCodeList().stream()).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<OrgBuRpcDTO> orgBuRpcAllDTOS = orgOutService.findBuByCodes(desCodeAllList);
        Map<String,OrgBuRpcDTO> ouMap = CollectionUtil.isEmpty(orgBuRpcAllDTOS) ? new HashMap<>() : orgBuRpcAllDTOS.stream().collect(Collectors.toMap(OrgBuRpcDTO::getBuCode, t -> t, (t1, t2) -> t1));
        whRespVOS.forEach(vo -> {
            List<String> desCodeList = vo.getDesCodeList();
            List<String> desCodeNameList = new ArrayList<>();

            if (CollectionUtil.isNotEmpty(desCodeList)){
                for (String desCode : desCodeList) {
                    OrgBuRpcDTO orgBuRpcDTO = ouMap.get(desCode);
                    if (Objects.nonNull(orgBuRpcDTO)){
                        desCodeNameList.add(orgBuRpcDTO.getBuName());
                    }
                }
            }
            String desCodeName = desCodeNameList.stream().map(String::valueOf).collect(Collectors.joining("、"));
            vo.setDesCodeName(desCodeName);

        });

        //组装发运地与仓库的层级关系
        List<InvWhRespVO> invWhRespVOList = this.desConvertInvWh(whRespVOS);

        //查询所有仓库下的功能库区
        invWhAreaParamVO.setWhIds(whRespVOS.stream().map(InvWhRespVO::getId).collect(Collectors.toList()));
        List<InvWhAreaRespVO> fetch = invWhAreaRepoProc.select(invWhAreaParamVO).fetch();
        //组装仓库与功能区的层级关系
        List<InvWhRespVO> invWhRespVOS = this.invWhareaConvertInvWh(whRespVOS, fetch);

        //
        invWhRespVOS.addAll(whRespVOS);
        invWhRespVOS.addAll(invWhRespVOList);
        //调用工具整理数据为树形接口
        return TreeUtils.buildTree(null, true, invWhRespVOS);
    }

    @Override
    public Long createTreeOne(InvWhSaveVO invWhSaveVO) {
        // ============= 校验 编号不能重复 =============
        if(invWhSaveVO.getId() ==null){
            if (invWhRepo.existsByWhCode(invWhSaveVO.getWhCode())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "仓库编码已存在");
            }
            // ============= 校验 相同父类下名称不能重复 =============
            if (invWhRepo.existsByWhCodeAndPid(invWhSaveVO.getWhCode(), invWhSaveVO.getPid())) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "仓库名称已存在");
            }
        }
        invWhSaveVO.setWhStatus(invWhSaveVO.getWhStatus() == null ? UdcEnum.OU_STATUS_ACTIVE.getValueCode() : invWhSaveVO.getWhStatus());

        //检验类型数据库里以逗号分隔的字符串形式保存
        if (!CollectionUtils.isEmpty(invWhSaveVO.getDesCodeList())) {
            String codeString = InvStringUtil.transitionCodesToStr(invWhSaveVO.getDesCodeList());
            invWhSaveVO.setDesCode(codeString);
        }
        // ============= 构建 do 并保存 =============
        var invWhDO = InvWhConvert.INSTANCE.respVOToDO(invWhSaveVO);
        //如果入参父类编码为null，默认为一级分类
        var isRoot = false;
        if(invWhSaveVO.getPid() == null || invWhSaveVO.getPid() == 0L){
            invWhDO.setPid(0L);
            invWhDO.setLevel(2);
            isRoot = true;
        }



        // 第一次保存数据
        val result = invWhRepo.save(invWhDO);

        // 数据保存之后，拿到id，再更新路径
        if (isRoot) {
            result.setCodePath(result.getWhCode());
        } else {
            var pCodeOptional = invWhRepo.findById(invWhSaveVO.getPid());
            if (pCodeOptional.isEmpty()) {
                throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "数据异常，未找到指定上级品类");
            }
            var pCode = pCodeOptional.get();
            result.setCodePath(pCode.getCodePath() + "/" + result.getWhCode());
            result.setLevel(pCode.getLevel() + 1);
        }
        // 再保存一次，更新路径
        Long id = invWhRepo.save(result).getId();
        return id;
    }

    @Override
    public Optional<InvWhRespVO> findTreeOne(Long id) {
        if(id == null){
            return Optional.empty();
        }
        InvWhRespVO invWhRespVO = invWhRepoProc.findByWhId(id);
        //查询发运地名称
        if (Objects.nonNull(invWhRespVO.getDesId())){
            InvDespatchConfigRespVO despOne = invDespatchConfigService.findIdOne(invWhRespVO.getDesId());
            invWhRespVO.setDesName(despOne.getDesName());
        }

        OrgOuRpcDTO ouById = orgOutService.findOuById(invWhRespVO.getOuId());
        invWhRespVO.setOuName(ouById.getOuName());
        invWhRespVO.setOuCode(ouById.getOuCode());

        //检验类型字符串转换为编码集合,以逗号分隔的字符串形式
        List<String> codeStrList = InvStringUtil.transitionStrToCodes(invWhRespVO.getDesCode());
        invWhRespVO.setDesCodeList(codeStrList);

        List<OrgBuRpcDTO> orgBuRpcAllDTOS = orgOutService.findBuByCodes(codeStrList);
        Map<String,OrgBuRpcDTO> ouMap = CollectionUtil.isEmpty(orgBuRpcAllDTOS) ? new HashMap<>() : orgBuRpcAllDTOS.stream().collect(Collectors.toMap(OrgBuRpcDTO::getBuCode, t -> t, (t1, t2) -> t1));
        List<String> desCodeList = invWhRespVO.getDesCodeList();
        List<String> desCodeNameList = new ArrayList<>();
        if (CollectionUtil.isNotEmpty(desCodeList)){
            for (String desCode : desCodeList) {
                OrgBuRpcDTO orgBuRpcDTO = ouMap.get(desCode);
                if (Objects.nonNull(orgBuRpcDTO)){
                    desCodeNameList.add(orgBuRpcDTO.getBuName());
                }
            }
        }
        String desCodeName = desCodeNameList.stream().map(String::valueOf).collect(Collectors.joining("、"));
        invWhRespVO.setDesCodeName(desCodeName);

        return Optional.of(invWhRespVO);
    }

    @Override
    public Boolean enableWhhConfig(InvWhSaveVO invWhSaveVO) {
        return invWhDomainService.enableWhhConfig(invWhSaveVO.getId(),invWhSaveVO.getWhStatus());
    }

    @Override
    public List<InvWhAreaRespVO> searchArea(InvWhAreaParamVO param) {
        if(param.getWhId() == null){
            return new ArrayList<>();
        }
        //查询仓库对应的功能区
        List<InvWhAreaRespVO> fetch = invWhAreaRepoProc.select(param).fetch();
        if(CollectionUtils.isEmpty(fetch)){
            return new ArrayList<>();
        }else{
            return fetch;
        }

    }

    /**
     * 组装仓库与功能区的层级关系
     * @param whRespVOS
     * @param fetch
     * @return
     */
    public List<InvWhRespVO> invWhareaConvertInvWh(List<InvWhRespVO> whRespVOS,List<InvWhAreaRespVO> fetch){
        if(CollectionUtils.isEmpty(whRespVOS)){
            return new ArrayList<>();
        }
        List<InvWhRespVO> invWhRespVOList = new ArrayList<>();
        //循环仓库组装下级功能库区
        whRespVOS.stream().forEach(t -> {
            fetch.stream().filter(a -> a.getWhId().equals(t.getId())).forEach(area -> {
                InvWhRespVO invWhRespVO = new InvWhRespVO();
                invWhRespVO.setWhCode(area.getDeter2());
                invWhRespVO.setWhName(area.getDeter2Name());
                invWhRespVO.setPid(t.getId());
                invWhRespVO.setLevel(3);
                invWhRespVO.setId(area.getId());
                invWhRespVO.setDesCode(t.getDesCode());
                invWhRespVO.setDesName(t.getDesName());
                invWhRespVO.setDesId(t.getDesId());
                invWhRespVOList.add(invWhRespVO);
            });
        });
        return invWhRespVOList.stream().distinct().collect(Collectors.toList());
    }

    /**
     * 组装发运地与仓库的层级关系
     * @param whRespVOS
     * @return
     */
    public List<InvWhRespVO>  desConvertInvWh(List<InvWhRespVO> whRespVOS){
        List<InvWhRespVO> invWhRespVOList = new ArrayList<>();

        //查询发运地，
        List<InvDespatchConfigPageVO> records = invDespatchConfigDomainService.query(new InvDespatchConfigQueryParam());
        if(CollectionUtils.isEmpty(records)){
            return invWhRespVOList;
        }
        //循环发运地，将发运地作为仓库的上一级
        records.stream().forEach(desp -> {
            //发运地添加上一级
            InvWhRespVO invWhRespVO = new InvWhRespVO();
            invWhRespVO.setWhName(desp.getDesName());
            invWhRespVO.setWhCode(desp.getDesCode());
            invWhRespVO.setPid(0L);
            invWhRespVO.setId(desp.getId());
            invWhRespVO.setLevel(1);
            invWhRespVO.setDesCode(desp.getDesCode());
            invWhRespVO.setDesName(desp.getDesName());
            invWhRespVO.setDesId(desp.getId());
            //查询出所有的父节点仓库并且是当前发运地的仓库
            List<InvWhRespVO> collect = whRespVOS.stream().filter(tt -> tt.getDesCode() != null).filter(t -> t.getDesCode().equals(desp.getDesCode()) && t.getPid() == 0).collect(Collectors.toList());
            //将所有符合条件的仓库的pid上级替换成发运地id
            if(!CollectionUtils.isEmpty(collect)){
                collect.stream().forEach(tt -> { tt.setPid(desp.getId()); });
            }
            invWhRespVOList.add(invWhRespVO);
        });
        return invWhRespVOList;
    }
}
