package com.elitesland.yst.production.inv.application.web.controller;


import com.elitesland.yst.production.inv.application.facade.vo.InvAjSaveVO;
import com.elitesland.yst.production.inv.application.service.InvAjService;
import com.elitescloud.cloudt.common.base.ApiResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 库存调整明细
 * @author lvqf
 * @date   2021/02/1
 *
 */
@RestController
@RequestMapping("/invaj")
@Api(value = "库存调整单", tags = {"库存调整"})
@AllArgsConstructor
public class InvAjController {

    public final InvAjService invAjService;


    /**
     *
     * 根据id批量取消
     *
     * @param ids id集合
     */
    @PutMapping("/cancelBatch")
    @ApiOperation("批量取消")
    public ApiResult<Object> updateBatch(@RequestBody List<Long> ids) {
        invAjService.cancelBatch(ids);
        return ApiResult.ok();
    }

    /**
     *
     * 根据id批量审批
     *
     * @param ids id集合
     */
    @PutMapping("/approveBatch")
    @ApiOperation("批量审批通过")
    public ApiResult<Object> approveBatch(@RequestBody List<Long> ids) {
        invAjService.approveBatch(ids);
        return ApiResult.ok();
    }


    /**
     *
     * 根据id批量审批拒绝
     *
     * @param ids id集合
     */
    @PutMapping("/refuseBatch")
    @ApiOperation("批量审批拒绝")
    public ApiResult<Object> refuseBatch(@RequestBody List<Long> ids) {
        invAjService.refuseBatch(ids);
        return ApiResult.ok();
    }

    /**
     *
     * 根据id查询调整单信息(含明细)
     *
     * @param masId 主表id
     */
    @GetMapping("/findOneInvAj/{id}")
    @ApiOperation("查询调整单信息(含明细)")
    public ApiResult<?> findOneInvAj(@PathVariable("id") Long masId) {
        return ApiResult.ok(invAjService.findInvAj(masId));
    }

    /**
     *
     * 保存库存调整单
     *
     * @param invAjSaveVO 保存信息
     * @return  主表id
     */
    @PostMapping("/saveOneInvAj")
    @ApiOperation("保存调整单")
    public ApiResult<?> saveOneInvAj(@RequestBody InvAjSaveVO invAjSaveVO) {
        val id = invAjService.saveOneInvAj(invAjSaveVO);
        return ApiResult.ok(id.toString());
    }

    /**
     *
     * 提交库存调整单shen
     *
     * @param invAjSaveVO 提交信息
     * @return  主表id
     */
    @PostMapping("/submitOneInvAj")
    @ApiOperation("提交调整单")
    public ApiResult<Object> submitOneInvAj(@RequestBody InvAjSaveVO invAjSaveVO) {
        val id = invAjService.submitOneInvAj(invAjSaveVO);
        return ApiResult.ok(id.toString());
    }

    /**
     *
     * 确认调整
     *
     * @param ids 主表id
     */
    @PutMapping("/confirmInvAj")
    @ApiOperation("调整确认")
    public ApiResult<Object> confirmInvAj(@RequestBody List<Long> ids) {
        invAjService.confirmInvAj(ids);
        return ApiResult.ok();
    }

}
