package com.elitesland.yst.production.inv.application.web.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.inv.application.facade.vo.SelectOptionParam;
import com.elitesland.yst.production.inv.application.facade.vo.SelectOptionVO;
import com.elitesland.yst.production.inv.application.service.InvWhAreaService;
import com.elitesland.yst.production.inv.application.service.InvWhAreaSettingService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author jeesie
 * @description:
 * @datetime 2023年 01月 17日 10:04 上午
 * @version: 1.0
 */
@RestController
@RequestMapping("/inv/select")
@Api(value = "下拉查询", tags = {"下拉查询"})
@AllArgsConstructor
public class InvSelectController {

    private final InvWhAreaSettingService invWhAreaSettingService;

    private final InvWhAreaService invWhAreaService;

    @PostMapping("/listDeter2Type")
    @ApiOperation("功能区类型-（前端）下拉查询")
    public ApiResult<List<SelectOptionVO>> listDeter2Type(@RequestBody SelectOptionParam selectOptionParam) {
        return ApiResult.ok(invWhAreaSettingService.listDeter2Type(selectOptionParam));
    }

    @PostMapping("/listDeter2")
    @ApiOperation("功能区-（前端）下拉查询")
    public ApiResult<List<SelectOptionVO>> listDeter2(@RequestBody SelectOptionParam selectOptionParam) {
        return ApiResult.ok(invWhAreaService.listDeter2(selectOptionParam));
    }
}
