package com.elitesland.yst.production.inv.application.web.controller;

import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkSsParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkSsQueryParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invstk.InvStkSsRespVO;
import com.elitesland.yst.production.inv.application.service.InvStkSsService;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.inv.job.task.InvStkSsHandler;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;

/**
 * @description:
 * @author: lvqf
 * @create: 2022-06-17 16:22
 * @Version 1.0
 **/
@RestController
@RequestMapping("/stk/ss")
@Api(value = "库存快照", tags = {"库存快照"})
@AllArgsConstructor
public class InvStkSsController {


    private final InvStkSsService invStkSsService;

    private final InvStkSsHandler invStkSsHandler;


    @PostMapping("/findStkSsPage")
    @ApiOperation("库存快照查询")
    public ApiResult<PagingVO<InvStkSsRespVO>> findStkSsPage(@RequestBody InvStkSsQueryParamVO param){
        return ApiResult.ok(invStkSsService.findStkSsPage(param));
    }

    @PostMapping("/createStkSs")
    @ApiOperation("库存快照创建")
    public ApiResult createStkSs(@RequestBody InvStkSsParamVO invStkSsParamVO){
       // invStkSsService.createStkSs(invStkSsParamVO.getSsTime());
        invStkSsHandler.invStkSsSync("");
        return ApiResult.ok();
    }




}
