package com.elitesland.yst.production.inv.application.web.controller;

import com.elitesland.yst.production.inv.application.facade.vo.invTrn.InvTrnAllQueryParamVO;
import com.elitesland.yst.production.inv.application.facade.vo.invTrn.InvTrnAndTrnDDownloadRespVO;
import com.elitesland.yst.production.inv.application.service.InvTrnDService;
import com.elitesland.yst.production.inv.utils.ExcelWriteUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.val;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;


/**
 * @author jeesie.jiang
 * @date 2022-03-17 11:34
 * Desc: 库存转移单
 */
@RestController
@RequestMapping("/inv/invtrnd")
@Api(value = "库存转移单明细", tags = {"库存转移单"})
@AllArgsConstructor
public class InvTrnDController {

    private final InvTrnDService invTrnDService;

    /**
     * 分页查询-转移单信息
     *
     * @param param 分类查询、分页和排序对象
     * @return 多条数据
     */
    @PostMapping("/search")
    @ApiOperation("分页查询-转移单列表")
    public ApiResult<?> search(@RequestBody InvTrnAllQueryParamVO param) {
        val ret = invTrnDService.search(param);
        return ApiResult.ok(ret);
    }

    /**
     * 分页查询-转移单信息
     *
     * @param param 分类查询、分页和排序对象
     * @return 多条数据
     */
    @PostMapping("/downloadTrnAll")
    @ApiOperation("库存转移单导出")
    public void downloadTrnAll(HttpServletResponse response, @RequestBody InvTrnAllQueryParamVO param) throws IOException {
        List<InvTrnAndTrnDDownloadRespVO> invTrnAndTrnDDownloadRespVOList = invTrnDService.findInvTrnAndTrnDDownloadVOList(param);
        ExcelWriteUtil.excelWrite(response, invTrnAndTrnDDownloadRespVOList, InvTrnAndTrnDDownloadRespVO.class,"库存转移单","库存转移单");
    }

    @PostMapping("/confirm/{id}")
    @ApiOperation("移库确认")
    public ApiResult<?> confirm(@PathVariable Long id) {
        invTrnDService.confirm(id);
        return ApiResult.ok();
    }

    @PostMapping("/receiveConfirm/{id}")
    @ApiOperation("收货确认")
    public ApiResult<?> receiveConfirm(@PathVariable Long id) {
         invTrnDService.recevieConfirm(id,false);
        return ApiResult.ok();
    }


    @PostMapping("/check/{id}")
    @ApiOperation("审核通过")
    public ApiResult<?> check(@PathVariable Long id) {
        invTrnDService.check(id);
        return ApiResult.ok();
    }

    @PostMapping("/refuse/{id}")
    @ApiOperation("审核拒绝")
    public ApiResult<?> refuse(@PathVariable Long id) {
        invTrnDService.refuse(id);
        return ApiResult.ok();
    }

}
