package com.elitesland.yst.production.inv.application.web.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.redisson.api.RBucket;
import org.redisson.api.RedissonClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.concurrent.TimeUnit;

/**
 * @author Tom.su
 * @program yst-inv
 * @description Redis操作
 * @date 2022/04/29 11:28
 */
@RestController
@RequestMapping("/inv/redis")
@Api(value = "Redis操作", tags = {"Redis操作"})
@AllArgsConstructor
public class RedisController {

    private final  RedissonClient redissonClient;
    /**
     *
     * 删除redis
     *
     * @param key key
     */
    @GetMapping("/del/{key}")
    @ApiOperation("删除redis")
    public ApiResult<?> del(@PathVariable("key") String key) {
        return ApiResult.ok(redissonClient.getBucket(key).delete());
    }

    /**
     *
     * 删除redis
     *
     * @param keys keys
     */
    @GetMapping("/batchDel")
    @ApiOperation("批量删除redis")
    public ApiResult<?> batchDel(@RequestParam("keys") String[] keys) {
        for (String key : keys) {
            redissonClient.getBucket(key).delete();
        }
        return ApiResult.ok();
    }

    /**
     *
     * 获取一个值
     *
     * @param key key
     */
    @GetMapping("/get/{key}")
    @ApiOperation("获取一个值")
    public ApiResult<Object> get(@PathVariable("key") String key) {
        return ApiResult.ok(redissonClient.getBucket(key).get());
    }
    /**
     *
     * set
     *
     * @param key key
     */
    @GetMapping("/setAndExpire")
    @ApiOperation("设置一个值（毫秒）")
    public ApiResult<Boolean> setAndExpire(@RequestParam("key") String key,@RequestParam("value") String value,@RequestParam("expire") long expire) {
        RBucket<Object> bucket = redissonClient.getBucket(key);
        bucket.set(value, expire, TimeUnit.MILLISECONDS);
        return ApiResult.ok(bucket.isExists());
    }
    /**
     *
     * set
     *
     * @param key key
     */
    @GetMapping("/set")
    @ApiOperation("设置一个值（永久）")
    public ApiResult<Boolean> set(@RequestParam("key") String key,@RequestParam("value") String value) {
        RBucket<Object> bucket = redissonClient.getBucket(key);
        bucket.set(value);
        return ApiResult.ok(bucket.isExists());
    }
}